// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel.fs

import com.intellij.platform.eel.GeneratedBuilder
import com.intellij.platform.eel.channels.EelDelicateApi
import com.intellij.platform.eel.fs.EelFileSystemApi.OpenForReadingArgs
import com.intellij.platform.eel.path.EelPath
import org.jetbrains.annotations.ApiStatus
import java.nio.ByteBuffer


@GeneratedBuilder.Result
@ApiStatus.Internal
class OpenForReadingArgsBuilder(
  private var path: EelPath,
) {
  private var autoCloseAfterLastChunk: Boolean = false

  private var closeImmediatelyIfFileBiggerThan: Long? = null

  private var readFirstChunkInto: ByteBuffer? = null

  /**
   * When specified, the implementation closes its internal file descriptor
   * as soon as it internally reaches the end of the file.
   *
   * There are two ways to figure out if the file is closed after calling [openForReading] or [EelOpenedFile.Reader.read]
   * * By calling [EelOpenedFile.Reader.read], which implies an additional system call or an RPC call.
   * * By checking inexpensive but unreliable [EelOpenedFile.isClosed].
   */
  @EelDelicateApi
  fun autoCloseAfterLastChunk(arg: Boolean): OpenForReadingArgsBuilder = apply {
    this.autoCloseAfterLastChunk = arg
  }

  /**
   * An optimization suitable for reading into memory.
   * It allows aborting the reading fast if the whole file content
   * won't fit into some buffer.
   *
   * If it happens, [readFile] returns [FileReaderError.FileBiggerThanRequested].
   */
  @EelDelicateApi
  fun closeImmediatelyIfFileBiggerThan(arg: Long?): OpenForReadingArgsBuilder = apply {
    this.closeImmediatelyIfFileBiggerThan = arg
  }

  fun path(arg: EelPath): OpenForReadingArgsBuilder = apply {
    this.path = arg
  }

  /**
   * When specified, data from the file MAY be written into this buffer.
   * [ByteBuffer.position] and [ByteBuffer.limit] are always changed.
   * The buffer is prepared for reading after the call,
   * so the caller SHOULD NOT call [ByteBuffer.flip] after calling [openForReading].
   *
   * If some data is written into this buffer,
   * the first call of [EelOpenedFile.Reader.read] reads the data following this buffer.
   */
  @EelDelicateApi
  fun readFirstChunkInto(arg: ByteBuffer?): OpenForReadingArgsBuilder = apply {
    this.readFirstChunkInto = arg
  }

  fun build(): OpenForReadingArgs =
    OpenForReadingArgsImpl(
      autoCloseAfterLastChunk = autoCloseAfterLastChunk,
      closeImmediatelyIfFileBiggerThan = closeImmediatelyIfFileBiggerThan,
      path = path,
      readFirstChunkInto = readFirstChunkInto,
    )
}

@GeneratedBuilder.Result
internal class OpenForReadingArgsImpl(
  override val autoCloseAfterLastChunk: Boolean,
  override val closeImmediatelyIfFileBiggerThan: Long?,
  override val path: EelPath,
  override val readFirstChunkInto: ByteBuffer?,
) : OpenForReadingArgs