/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\t@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/eel/EelSharedSecrets;", "", "<init>", "()V", "filesImpl", "Lcom/intellij/platform/eel/EelSharedSecrets$EelFilesAccessor;", "getFilesImpl", "()Lcom/intellij/platform/eel/EelSharedSecrets$EelFilesAccessor;", "platformUtilImpl", "Lcom/intellij/platform/eel/EelSharedSecrets$PlatformUtilAccessor;", "getPlatformUtilImpl", "()Lcom/intellij/platform/eel/EelSharedSecrets$PlatformUtilAccessor;", "setPlatformUtilImpl", "(Lcom/intellij/platform/eel/EelSharedSecrets$PlatformUtilAccessor;)V", "platformUtilAccessors", "", "EelFilesAccessor", "PlatformUtilAccessor", "intellij.platform.eel"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEelSharedSecrets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelSharedSecrets.kt\ncom/intellij/platform/eel/EelSharedSecrets\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n2045#2,14:79\n*S KotlinDebug\n*F\n+ 1 EelSharedSecrets.kt\ncom/intellij/platform/eel/EelSharedSecrets\n*L\n24#1:79,14\n*E\n"})
public final class EelSharedSecrets {
    @NotNull
    public static final EelSharedSecrets INSTANCE;
    @NotNull
    private static final EelFilesAccessor filesImpl;
    @NotNull
    private static PlatformUtilAccessor platformUtilImpl;

    private EelSharedSecrets() {
    }

    @NotNull
    public final EelFilesAccessor getFilesImpl() {
        return filesImpl;
    }

    @NotNull
    public final PlatformUtilAccessor getPlatformUtilImpl() {
        return platformUtilImpl;
    }

    @TestOnly
    public final void setPlatformUtilImpl(@NotNull PlatformUtilAccessor platformUtilAccessor) {
        Intrinsics.checkNotNullParameter((Object)platformUtilAccessor, (String)"<set-?>");
        platformUtilImpl = platformUtilAccessor;
    }

    @NotNull
    public final Iterable<PlatformUtilAccessor> platformUtilAccessors() {
        ServiceLoader<PlatformUtilAccessor> serviceLoader = ServiceLoader.load(PlatformUtilAccessor.class, EelSharedSecrets.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        return serviceLoader;
    }

    /*
     * WARNING - void declaration
     */
    static {
        PlatformUtilAccessor platformUtilAccessor;
        PlatformUtilAccessor platformUtilAccessor2;
        INSTANCE = new EelSharedSecrets();
        ServiceLoader<EelFilesAccessor> serviceLoader = ServiceLoader.load(EelFilesAccessor.class, EelSharedSecrets.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        EelFilesAccessor eelFilesAccessor = (EelFilesAccessor)CollectionsKt.firstOrNull((Iterable)serviceLoader);
        if (eelFilesAccessor == null) {
            eelFilesAccessor = EelFilesAccessor.Default.INSTANCE;
        }
        filesImpl = eelFilesAccessor;
        Iterable<PlatformUtilAccessor> $this$maxByOrNull$iv = INSTANCE.platformUtilAccessors();
        boolean $i$f$maxByOrNull = false;
        Iterator<PlatformUtilAccessor> iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            platformUtilAccessor2 = null;
        } else {
            PlatformUtilAccessor maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                platformUtilAccessor2 = maxElem$iv;
            } else {
                void var3_3;
                PlatformUtilAccessor it = maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getPriority();
                do {
                    PlatformUtilAccessor e$iv;
                    PlatformUtilAccessor it2 = e$iv = iterator$iv.next();
                    $i$a$-maxByOrNull-EelSharedSecrets$platformUtilImpl$1 = false;
                    int v$iv = it2.getPriority();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                platformUtilAccessor2 = var3_3;
            }
        }
        if ((platformUtilAccessor = (PlatformUtilAccessor)platformUtilAccessor2) == null) {
            platformUtilAccessor = PlatformUtilAccessor.Default.INSTANCE;
        }
        platformUtilImpl = platformUtilAccessor;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\nJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/eel/EelSharedSecrets$EelFilesAccessor;", "", "readAllBytes", "", "path", "Ljava/nio/file/Path;", "readString", "", "cs", "Ljava/nio/charset/Charset;", "Default", "intellij.platform.eel"})
    public static interface EelFilesAccessor {
        @NotNull
        public byte[] readAllBytes(@NotNull Path var1) throws IOException;

        @NotNull
        public String readString(@NotNull Path var1, @NotNull Charset var2) throws IOException;

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/eel/EelSharedSecrets$EelFilesAccessor$Default;", "Lcom/intellij/platform/eel/EelSharedSecrets$EelFilesAccessor;", "<init>", "()V", "readAllBytes", "", "path", "Ljava/nio/file/Path;", "readString", "Ljava/lang/invoke/MethodHandle;", "kotlin.jvm.PlatformType", "", "cs", "Ljava/nio/charset/Charset;", "readStringObsoleteImpl", "intellij.platform.eel"})
        public static final class Default
        implements EelFilesAccessor {
            @NotNull
            public static final Default INSTANCE;
            private static final MethodHandle readString;

            private Default() {
            }

            @Override
            @NotNull
            public byte[] readAllBytes(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                byte[] byArray = Files.readAllBytes(path);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                return byArray;
            }

            @Override
            @NotNull
            public String readString(@NotNull Path path, @NotNull Charset cs) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
                return readString.invokeExact(path, cs);
            }

            @JvmStatic
            @NotNull
            public static final String readStringObsoleteImpl(@NotNull Path path, @NotNull Charset cs) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
                byte[] byArray = Files.readAllBytes(path);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                byte[] byArray2 = byArray;
                return new String(byArray2, cs);
            }

            static {
                Object object;
                INSTANCE = new Default();
                try {
                    object = new Class[]{Charset.class};
                    object = MethodHandles.publicLookup().findStatic(Files.class, "readString", MethodType.methodType(String.class, Path.class, object));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Class[] classArray = new Class[]{Charset.class};
                    object = MethodHandles.publicLookup().findStatic(EelSharedSecrets.class, "readStringObsoleteImpl", MethodType.methodType(String.class, Path.class, classArray));
                }
                readString = object;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\nJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/eel/EelSharedSecrets$PlatformUtilAccessor;", "", "priority", "", "getPriority", "()I", "deleteRecursively", "", "fileOrDirectory", "Ljava/nio/file/Path;", "Default", "intellij.platform.eel"})
    public static interface PlatformUtilAccessor {
        public int getPriority();

        public void deleteRecursively(@NotNull Path var1) throws IOException;

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/eel/EelSharedSecrets$PlatformUtilAccessor$Default;", "Lcom/intellij/platform/eel/EelSharedSecrets$PlatformUtilAccessor;", "<init>", "()V", "priority", "", "getPriority", "()I", "deleteRecursively", "", "fileOrDirectory", "Ljava/nio/file/Path;", "intellij.platform.eel"})
        public static final class Default
        implements PlatformUtilAccessor {
            @NotNull
            public static final Default INSTANCE = new Default();
            private static final int priority = Integer.MIN_VALUE;

            private Default() {
            }

            @Override
            public int getPriority() {
                return priority;
            }

            @Override
            public void deleteRecursively(@NotNull Path fileOrDirectory) {
                Intrinsics.checkNotNullParameter((Object)fileOrDirectory, (String)"fileOrDirectory");
                throw new UnsupportedOperationException("Not supported in this setup");
            }
        }
    }
}

