/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.fs;

import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.GeneratedBuilder;
import com.intellij.platform.eel.OwnedBuilder;
import com.intellij.platform.eel.channels.EelDelicateApi;
import com.intellij.platform.eel.fs.ChangeAttributesOptionsImpl;
import com.intellij.platform.eel.fs.CopyOptionsImpl;
import com.intellij.platform.eel.fs.CreateTemporaryEntryOptionsImpl;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelOpenedFile;
import com.intellij.platform.eel.fs.ListDirectoryWithAttrsArgsImpl;
import com.intellij.platform.eel.fs.MoveArgsImpl;
import com.intellij.platform.eel.fs.OpenForReadingArgsImpl;
import com.intellij.platform.eel.fs.ReadFileArgsImpl;
import com.intellij.platform.eel.fs.StatArgsImpl;
import com.intellij.platform.eel.fs.UnwatchOptionsImpl;
import com.intellij.platform.eel.fs.WalkDirectoryEntryResult;
import com.intellij.platform.eel.fs.WalkDirectoryOptionsImpl;
import com.intellij.platform.eel.fs.WatchOptionsImpl;
import com.intellij.platform.eel.fs.WriteOptionsImpl;
import com.intellij.platform.eel.path.EelPath;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0011\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u000e\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers;", "", "<init>", "()V", "ChangeAttributes", "Copy", "CreateTemporaryDirectory", "CreateTemporaryFile", "ListDirectoryWithAttrs", "Move", "OpenForReading", "ReadFile", "Stat", "Unwatch", "WalkDirectory", "AddWatchRoots", "OpenForReadingAndWriting", "OpenForWriting", "intellij.platform.eel"})
@ApiStatus.Internal
public final class EelFileSystemApiHelpers {
    @NotNull
    public static final EelFileSystemApiHelpers INSTANCE = new EelFileSystemApiHelpers();

    private EelFileSystemApiHelpers() {
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\n\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\bJ\u000e\u0010\r\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$AddWatchRoots;", "Lcom/intellij/platform/eel/OwnedBuilder;", "", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;)V", "changeTypes", "", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileChangeType;", "paths", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$WatchedPath;", "arg", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class AddWatchRoots
    implements OwnedBuilder<Boolean> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private Set<? extends EelFileSystemApi.FileChangeType> changeTypes;
        @NotNull
        private Set<EelFileSystemApi.WatchedPath> paths;

        public AddWatchRoots(@NotNull EelFileSystemApi owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
            this.changeTypes = SetsKt.emptySet();
            this.paths = SetsKt.emptySet();
        }

        @NotNull
        public final AddWatchRoots changeTypes(@NotNull Set<? extends EelFileSystemApi.FileChangeType> arg) {
            AddWatchRoots addWatchRoots;
            Intrinsics.checkNotNullParameter(arg, (String)"arg");
            AddWatchRoots $this$changeTypes_u24lambda_u240 = addWatchRoots = this;
            boolean bl = false;
            $this$changeTypes_u24lambda_u240.changeTypes = arg;
            return addWatchRoots;
        }

        @NotNull
        public final AddWatchRoots paths(@NotNull Set<EelFileSystemApi.WatchedPath> arg) {
            AddWatchRoots addWatchRoots;
            Intrinsics.checkNotNullParameter(arg, (String)"arg");
            AddWatchRoots $this$paths_u24lambda_u240 = addWatchRoots = this;
            boolean bl = false;
            $this$paths_u24lambda_u240.paths = arg;
            return addWatchRoots;
        }

        @Override
        @Nullable
        public Object eelIt(@NotNull Continuation<? super Boolean> $completion) throws UnsupportedOperationException {
            return this.owner.addWatchRoots(new WatchOptionsImpl(this.changeTypes, this.paths), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$ChangeAttributes;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ChangeAttributesError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;)V", "accessTime", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$TimeSinceEpoch;", "modificationTime", "permissions", "Lcom/intellij/platform/eel/fs/EelFileInfo$Permissions;", "arg", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class ChangeAttributes
    implements OwnedBuilder<EelResult<? extends Unit, ? extends EelFileSystemApi.ChangeAttributesError>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath path;
        @Nullable
        private EelFileSystemApi.TimeSinceEpoch accessTime;
        @Nullable
        private EelFileSystemApi.TimeSinceEpoch modificationTime;
        @Nullable
        private EelFileInfo.Permissions permissions;

        public ChangeAttributes(@NotNull EelFileSystemApi owner, @NotNull EelPath path) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.owner = owner;
            this.path = path;
        }

        @NotNull
        public final ChangeAttributes accessTime(@Nullable EelFileSystemApi.TimeSinceEpoch arg) {
            ChangeAttributes changeAttributes;
            ChangeAttributes $this$accessTime_u24lambda_u240 = changeAttributes = this;
            boolean bl = false;
            $this$accessTime_u24lambda_u240.accessTime = arg;
            return changeAttributes;
        }

        @NotNull
        public final ChangeAttributes modificationTime(@Nullable EelFileSystemApi.TimeSinceEpoch arg) {
            ChangeAttributes changeAttributes;
            ChangeAttributes $this$modificationTime_u24lambda_u240 = changeAttributes = this;
            boolean bl = false;
            $this$modificationTime_u24lambda_u240.modificationTime = arg;
            return changeAttributes;
        }

        @NotNull
        public final ChangeAttributes path(@NotNull EelPath arg) {
            ChangeAttributes changeAttributes;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            ChangeAttributes $this$path_u24lambda_u240 = changeAttributes = this;
            boolean bl = false;
            $this$path_u24lambda_u240.path = arg;
            return changeAttributes;
        }

        @NotNull
        public final ChangeAttributes permissions(@Nullable EelFileInfo.Permissions arg) {
            ChangeAttributes changeAttributes;
            ChangeAttributes $this$permissions_u24lambda_u240 = changeAttributes = this;
            boolean bl = false;
            $this$permissions_u24lambda_u240.permissions = arg;
            return changeAttributes;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.ChangeAttributesError>> $completion) {
            return this.owner.changeAttributes(new ChangeAttributesOptionsImpl(this.accessTime, this.modificationTime, this.path, this.permissions), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bJ\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$Copy;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CopyError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "source", "Lcom/intellij/platform/eel/path/EelPath;", "target", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/eel/path/EelPath;)V", "copyRecursively", "", "followLinks", "interruptible", "preserveAttributes", "replaceExisting", "arg", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class Copy
    implements OwnedBuilder<EelResult<? extends Unit, ? extends EelFileSystemApi.CopyError>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath source;
        @NotNull
        private EelPath target;
        private boolean copyRecursively;
        private boolean followLinks;
        private boolean interruptible;
        private boolean preserveAttributes;
        private boolean replaceExisting;

        public Copy(@NotNull EelFileSystemApi owner, @NotNull EelPath source, @NotNull EelPath target) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.owner = owner;
            this.source = source;
            this.target = target;
        }

        @NotNull
        public final Copy copyRecursively(boolean arg) {
            Copy copy;
            Copy $this$copyRecursively_u24lambda_u240 = copy = this;
            boolean bl = false;
            $this$copyRecursively_u24lambda_u240.copyRecursively = arg;
            return copy;
        }

        @NotNull
        public final Copy followLinks(boolean arg) {
            Copy copy;
            Copy $this$followLinks_u24lambda_u240 = copy = this;
            boolean bl = false;
            $this$followLinks_u24lambda_u240.followLinks = arg;
            return copy;
        }

        @NotNull
        public final Copy interruptible(boolean arg) {
            Copy copy;
            Copy $this$interruptible_u24lambda_u240 = copy = this;
            boolean bl = false;
            $this$interruptible_u24lambda_u240.interruptible = arg;
            return copy;
        }

        @NotNull
        public final Copy preserveAttributes(boolean arg) {
            Copy copy;
            Copy $this$preserveAttributes_u24lambda_u240 = copy = this;
            boolean bl = false;
            $this$preserveAttributes_u24lambda_u240.preserveAttributes = arg;
            return copy;
        }

        @NotNull
        public final Copy replaceExisting(boolean arg) {
            Copy copy;
            Copy $this$replaceExisting_u24lambda_u240 = copy = this;
            boolean bl = false;
            $this$replaceExisting_u24lambda_u240.replaceExisting = arg;
            return copy;
        }

        @NotNull
        public final Copy source(@NotNull EelPath arg) {
            Copy copy;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            Copy $this$source_u24lambda_u240 = copy = this;
            boolean bl = false;
            $this$source_u24lambda_u240.source = arg;
            return copy;
        }

        @NotNull
        public final Copy target(@NotNull EelPath arg) {
            Copy copy;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            Copy $this$target_u24lambda_u240 = copy = this;
            boolean bl = false;
            $this$target_u24lambda_u240.target = arg;
            return copy;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.CopyError>> $completion) {
            return this.owner.copy(new CopyOptionsImpl(this.copyRecursively, this.followLinks, this.interruptible, this.preserveAttributes, this.replaceExisting, this.source, this.target), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$CreateTemporaryDirectory;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/path/EelPath;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CreateTemporaryEntryError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;)V", "deleteOnExit", "", "parentDirectory", "prefix", "", "suffix", "arg", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class CreateTemporaryDirectory
    implements OwnedBuilder<EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> {
        @NotNull
        private final EelFileSystemApi owner;
        private boolean deleteOnExit;
        @Nullable
        private EelPath parentDirectory;
        @NotNull
        private String prefix;
        @NotNull
        private String suffix;

        public CreateTemporaryDirectory(@NotNull EelFileSystemApi owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
            this.prefix = "";
            this.suffix = "";
        }

        @NotNull
        public final CreateTemporaryDirectory deleteOnExit(boolean arg) {
            CreateTemporaryDirectory createTemporaryDirectory;
            CreateTemporaryDirectory $this$deleteOnExit_u24lambda_u240 = createTemporaryDirectory = this;
            boolean bl = false;
            $this$deleteOnExit_u24lambda_u240.deleteOnExit = arg;
            return createTemporaryDirectory;
        }

        @NotNull
        public final CreateTemporaryDirectory parentDirectory(@Nullable EelPath arg) {
            CreateTemporaryDirectory createTemporaryDirectory;
            CreateTemporaryDirectory $this$parentDirectory_u24lambda_u240 = createTemporaryDirectory = this;
            boolean bl = false;
            $this$parentDirectory_u24lambda_u240.parentDirectory = arg;
            return createTemporaryDirectory;
        }

        @NotNull
        public final CreateTemporaryDirectory prefix(@NotNull String arg) {
            CreateTemporaryDirectory createTemporaryDirectory;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            CreateTemporaryDirectory $this$prefix_u24lambda_u240 = createTemporaryDirectory = this;
            boolean bl = false;
            $this$prefix_u24lambda_u240.prefix = arg;
            return createTemporaryDirectory;
        }

        @NotNull
        public final CreateTemporaryDirectory suffix(@NotNull String arg) {
            CreateTemporaryDirectory createTemporaryDirectory;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            CreateTemporaryDirectory $this$suffix_u24lambda_u240 = createTemporaryDirectory = this;
            boolean bl = false;
            $this$suffix_u24lambda_u240.suffix = arg;
            return createTemporaryDirectory;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> $completion) {
            return this.owner.createTemporaryDirectory(new CreateTemporaryEntryOptionsImpl(this.deleteOnExit, this.parentDirectory, this.prefix, this.suffix), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\rJ\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$CreateTemporaryFile;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/path/EelPath;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$CreateTemporaryEntryError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;)V", "deleteOnExit", "", "parentDirectory", "prefix", "", "suffix", "arg", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class CreateTemporaryFile
    implements OwnedBuilder<EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> {
        @NotNull
        private final EelFileSystemApi owner;
        private boolean deleteOnExit;
        @Nullable
        private EelPath parentDirectory;
        @NotNull
        private String prefix;
        @NotNull
        private String suffix;

        public CreateTemporaryFile(@NotNull EelFileSystemApi owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
            this.prefix = "";
            this.suffix = "";
        }

        @NotNull
        public final CreateTemporaryFile deleteOnExit(boolean arg) {
            CreateTemporaryFile createTemporaryFile;
            CreateTemporaryFile $this$deleteOnExit_u24lambda_u240 = createTemporaryFile = this;
            boolean bl = false;
            $this$deleteOnExit_u24lambda_u240.deleteOnExit = arg;
            return createTemporaryFile;
        }

        @NotNull
        public final CreateTemporaryFile parentDirectory(@Nullable EelPath arg) {
            CreateTemporaryFile createTemporaryFile;
            CreateTemporaryFile $this$parentDirectory_u24lambda_u240 = createTemporaryFile = this;
            boolean bl = false;
            $this$parentDirectory_u24lambda_u240.parentDirectory = arg;
            return createTemporaryFile;
        }

        @NotNull
        public final CreateTemporaryFile prefix(@NotNull String arg) {
            CreateTemporaryFile createTemporaryFile;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            CreateTemporaryFile $this$prefix_u24lambda_u240 = createTemporaryFile = this;
            boolean bl = false;
            $this$prefix_u24lambda_u240.prefix = arg;
            return createTemporaryFile;
        }

        @NotNull
        public final CreateTemporaryFile suffix(@NotNull String arg) {
            CreateTemporaryFile createTemporaryFile;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            CreateTemporaryFile $this$suffix_u24lambda_u240 = createTemporaryFile = this;
            boolean bl = false;
            $this$suffix_u24lambda_u240.suffix = arg;
            return createTemporaryFile;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> $completion) {
            return this.owner.createTemporaryFile(new CreateTemporaryEntryOptionsImpl(this.deleteOnExit, this.parentDirectory, this.prefix, this.suffix), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002&\u0012\"\u0012 \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0004\u0012\u00020\u00070\u00020\u0001B\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J,\u0010\u0014\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0004\u0012\u00020\u00070\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$ListDirectoryWithAttrs;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "", "Lkotlin/Pair;", "", "Lcom/intellij/platform/eel/fs/EelFileInfo;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ListDirectoryError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;)V", "symlinkPolicy", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$SymlinkPolicy;", "arg", "doNotResolve", "justResolve", "resolveAndFollow", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class ListDirectoryWithAttrs
    implements OwnedBuilder<EelResult<? extends Collection<? extends Pair<? extends String, ? extends EelFileInfo>>, ? extends EelFileSystemApi.ListDirectoryError>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath path;
        @NotNull
        private EelFileSystemApi.SymlinkPolicy symlinkPolicy;

        public ListDirectoryWithAttrs(@NotNull EelFileSystemApi owner, @NotNull EelPath path) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.owner = owner;
            this.path = path;
            this.symlinkPolicy = EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE;
        }

        @NotNull
        public final ListDirectoryWithAttrs path(@NotNull EelPath arg) {
            ListDirectoryWithAttrs listDirectoryWithAttrs;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            ListDirectoryWithAttrs $this$path_u24lambda_u240 = listDirectoryWithAttrs = this;
            boolean bl = false;
            $this$path_u24lambda_u240.path = arg;
            return listDirectoryWithAttrs;
        }

        @NotNull
        public final ListDirectoryWithAttrs symlinkPolicy(@NotNull EelFileSystemApi.SymlinkPolicy arg) {
            ListDirectoryWithAttrs listDirectoryWithAttrs;
            Intrinsics.checkNotNullParameter((Object)((Object)arg), (String)"arg");
            ListDirectoryWithAttrs $this$symlinkPolicy_u24lambda_u240 = listDirectoryWithAttrs = this;
            boolean bl = false;
            $this$symlinkPolicy_u24lambda_u240.symlinkPolicy = arg;
            return listDirectoryWithAttrs;
        }

        @NotNull
        public final ListDirectoryWithAttrs doNotResolve() {
            return this.symlinkPolicy(EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE);
        }

        @NotNull
        public final ListDirectoryWithAttrs justResolve() {
            return this.symlinkPolicy(EelFileSystemApi.SymlinkPolicy.JUST_RESOLVE);
        }

        @NotNull
        public final ListDirectoryWithAttrs resolveAndFollow() {
            return this.symlinkPolicy(EelFileSystemApi.SymlinkPolicy.RESOLVE_AND_FOLLOW);
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<? extends Collection<? extends Pair<String, ? extends EelFileInfo>>, ? extends EelFileSystemApi.ListDirectoryError>> $completion) {
            return this.owner.listDirectoryWithAttrs(new ListDirectoryWithAttrsArgsImpl(this.path, this.symlinkPolicy), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$Move;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$MoveError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "source", "Lcom/intellij/platform/eel/path/EelPath;", "target", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/eel/path/EelPath;)V", "followLinks", "", "replaceExisting", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ReplaceExistingDuringMove;", "arg", "doNotReplace", "doNotReplaceDirectories", "replaceEverything", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class Move
    implements OwnedBuilder<EelResult<? extends Unit, ? extends EelFileSystemApi.MoveError>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath source;
        @NotNull
        private EelPath target;
        private boolean followLinks;
        @NotNull
        private EelFileSystemApi.ReplaceExistingDuringMove replaceExisting;

        public Move(@NotNull EelFileSystemApi owner, @NotNull EelPath source, @NotNull EelPath target) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.owner = owner;
            this.source = source;
            this.target = target;
            this.replaceExisting = EelFileSystemApi.ReplaceExistingDuringMove.REPLACE_EVERYTHING;
        }

        @NotNull
        public final Move followLinks(boolean arg) {
            Move move;
            Move $this$followLinks_u24lambda_u240 = move = this;
            boolean bl = false;
            $this$followLinks_u24lambda_u240.followLinks = arg;
            return move;
        }

        @NotNull
        public final Move replaceExisting(@NotNull EelFileSystemApi.ReplaceExistingDuringMove arg) {
            Move move;
            Intrinsics.checkNotNullParameter((Object)((Object)arg), (String)"arg");
            Move $this$replaceExisting_u24lambda_u240 = move = this;
            boolean bl = false;
            $this$replaceExisting_u24lambda_u240.replaceExisting = arg;
            return move;
        }

        @NotNull
        public final Move doNotReplace() {
            return this.replaceExisting(EelFileSystemApi.ReplaceExistingDuringMove.DO_NOT_REPLACE);
        }

        @NotNull
        public final Move doNotReplaceDirectories() {
            return this.replaceExisting(EelFileSystemApi.ReplaceExistingDuringMove.DO_NOT_REPLACE_DIRECTORIES);
        }

        @NotNull
        public final Move replaceEverything() {
            return this.replaceExisting(EelFileSystemApi.ReplaceExistingDuringMove.REPLACE_EVERYTHING);
        }

        @NotNull
        public final Move source(@NotNull EelPath arg) {
            Move move;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            Move $this$source_u24lambda_u240 = move = this;
            boolean bl = false;
            $this$source_u24lambda_u240.source = arg;
            return move;
        }

        @NotNull
        public final Move target(@NotNull EelPath arg) {
            Move move;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            Move $this$target_u24lambda_u240 = move = this;
            boolean bl = false;
            $this$target_u24lambda_u240.target = arg;
            return move;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<Unit, ? extends EelFileSystemApi.MoveError>> $completion) {
            return this.owner.move(new MoveArgsImpl(this.followLinks, this.replaceExisting, this.source, this.target), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0017\u0010\r\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bJ\u0012\u0010\u0010\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0007J\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$OpenForReading;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Reader;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileReaderError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;)V", "autoCloseAfterLastChunk", "", "closeImmediatelyIfFileBiggerThan", "", "Ljava/lang/Long;", "readFirstChunkInto", "Ljava/nio/ByteBuffer;", "arg", "(Ljava/lang/Long;)Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$OpenForReading;", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class OpenForReading
    implements OwnedBuilder<EelResult<? extends EelOpenedFile.Reader, ? extends EelFileSystemApi.FileReaderError>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath path;
        private boolean autoCloseAfterLastChunk;
        @Nullable
        private Long closeImmediatelyIfFileBiggerThan;
        @Nullable
        private ByteBuffer readFirstChunkInto;

        public OpenForReading(@NotNull EelFileSystemApi owner, @NotNull EelPath path) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.owner = owner;
            this.path = path;
        }

        @EelDelicateApi
        @NotNull
        public final OpenForReading autoCloseAfterLastChunk(boolean arg) {
            OpenForReading openForReading;
            OpenForReading $this$autoCloseAfterLastChunk_u24lambda_u240 = openForReading = this;
            boolean bl = false;
            $this$autoCloseAfterLastChunk_u24lambda_u240.autoCloseAfterLastChunk = arg;
            return openForReading;
        }

        @EelDelicateApi
        @NotNull
        public final OpenForReading closeImmediatelyIfFileBiggerThan(@Nullable Long arg) {
            OpenForReading openForReading;
            OpenForReading $this$closeImmediatelyIfFileBiggerThan_u24lambda_u240 = openForReading = this;
            boolean bl = false;
            $this$closeImmediatelyIfFileBiggerThan_u24lambda_u240.closeImmediatelyIfFileBiggerThan = arg;
            return openForReading;
        }

        @NotNull
        public final OpenForReading path(@NotNull EelPath arg) {
            OpenForReading openForReading;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            OpenForReading $this$path_u24lambda_u240 = openForReading = this;
            boolean bl = false;
            $this$path_u24lambda_u240.path = arg;
            return openForReading;
        }

        @EelDelicateApi
        @NotNull
        public final OpenForReading readFirstChunkInto(@Nullable ByteBuffer arg) {
            OpenForReading openForReading;
            OpenForReading $this$readFirstChunkInto_u24lambda_u240 = openForReading = this;
            boolean bl = false;
            $this$readFirstChunkInto_u24lambda_u240.readFirstChunkInto = arg;
            return openForReading;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<? extends EelOpenedFile.Reader, ? extends EelFileSystemApi.FileReaderError>> $completion) {
            return this.owner.openForReading(new OpenForReadingArgsImpl(this.autoCloseAfterLastChunk, this.closeImmediatelyIfFileBiggerThan, this.path, this.readFirstChunkInto), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fJ\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$OpenForReadingAndWriting;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/fs/EelOpenedFile$ReaderWriter;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileWriterError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;)V", "append", "", "creationMode", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileWriterCreationMode;", "truncateExisting", "arg", "allowCreate", "onlyCreate", "onlyOpenExisting", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class OpenForReadingAndWriting
    implements OwnedBuilder<EelResult<? extends EelOpenedFile.ReaderWriter, ? extends EelFileSystemApi.FileWriterError>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath path;
        private boolean append;
        @NotNull
        private EelFileSystemApi.FileWriterCreationMode creationMode;
        private boolean truncateExisting;

        public OpenForReadingAndWriting(@NotNull EelFileSystemApi owner, @NotNull EelPath path) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.owner = owner;
            this.path = path;
            this.creationMode = EelFileSystemApi.FileWriterCreationMode.ALLOW_CREATE;
            this.truncateExisting = true;
        }

        @NotNull
        public final OpenForReadingAndWriting append(boolean arg) {
            OpenForReadingAndWriting openForReadingAndWriting;
            OpenForReadingAndWriting $this$append_u24lambda_u240 = openForReadingAndWriting = this;
            boolean bl = false;
            $this$append_u24lambda_u240.append = arg;
            return openForReadingAndWriting;
        }

        @NotNull
        public final OpenForReadingAndWriting creationMode(@NotNull EelFileSystemApi.FileWriterCreationMode arg) {
            OpenForReadingAndWriting openForReadingAndWriting;
            Intrinsics.checkNotNullParameter((Object)((Object)arg), (String)"arg");
            OpenForReadingAndWriting $this$creationMode_u24lambda_u240 = openForReadingAndWriting = this;
            boolean bl = false;
            $this$creationMode_u24lambda_u240.creationMode = arg;
            return openForReadingAndWriting;
        }

        @NotNull
        public final OpenForReadingAndWriting allowCreate() {
            return this.creationMode(EelFileSystemApi.FileWriterCreationMode.ALLOW_CREATE);
        }

        @NotNull
        public final OpenForReadingAndWriting onlyCreate() {
            return this.creationMode(EelFileSystemApi.FileWriterCreationMode.ONLY_CREATE);
        }

        @NotNull
        public final OpenForReadingAndWriting onlyOpenExisting() {
            return this.creationMode(EelFileSystemApi.FileWriterCreationMode.ONLY_OPEN_EXISTING);
        }

        @NotNull
        public final OpenForReadingAndWriting path(@NotNull EelPath arg) {
            OpenForReadingAndWriting openForReadingAndWriting;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            OpenForReadingAndWriting $this$path_u24lambda_u240 = openForReadingAndWriting = this;
            boolean bl = false;
            $this$path_u24lambda_u240.path = arg;
            return openForReadingAndWriting;
        }

        @NotNull
        public final OpenForReadingAndWriting truncateExisting(boolean arg) {
            OpenForReadingAndWriting openForReadingAndWriting;
            OpenForReadingAndWriting $this$truncateExisting_u24lambda_u240 = openForReadingAndWriting = this;
            boolean bl = false;
            $this$truncateExisting_u24lambda_u240.truncateExisting = arg;
            return openForReadingAndWriting;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<? extends EelOpenedFile.ReaderWriter, ? extends EelFileSystemApi.FileWriterError>> $completion) {
            return this.owner.openForReadingAndWriting(new WriteOptionsImpl(this.append, this.creationMode, this.path, this.truncateExisting), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fJ\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$OpenForWriting;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Writer;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileWriterError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;)V", "append", "", "creationMode", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileWriterCreationMode;", "truncateExisting", "arg", "allowCreate", "onlyCreate", "onlyOpenExisting", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class OpenForWriting
    implements OwnedBuilder<EelResult<? extends EelOpenedFile.Writer, ? extends EelFileSystemApi.FileWriterError>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath path;
        private boolean append;
        @NotNull
        private EelFileSystemApi.FileWriterCreationMode creationMode;
        private boolean truncateExisting;

        public OpenForWriting(@NotNull EelFileSystemApi owner, @NotNull EelPath path) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.owner = owner;
            this.path = path;
            this.creationMode = EelFileSystemApi.FileWriterCreationMode.ALLOW_CREATE;
            this.truncateExisting = true;
        }

        @NotNull
        public final OpenForWriting append(boolean arg) {
            OpenForWriting openForWriting;
            OpenForWriting $this$append_u24lambda_u240 = openForWriting = this;
            boolean bl = false;
            $this$append_u24lambda_u240.append = arg;
            return openForWriting;
        }

        @NotNull
        public final OpenForWriting creationMode(@NotNull EelFileSystemApi.FileWriterCreationMode arg) {
            OpenForWriting openForWriting;
            Intrinsics.checkNotNullParameter((Object)((Object)arg), (String)"arg");
            OpenForWriting $this$creationMode_u24lambda_u240 = openForWriting = this;
            boolean bl = false;
            $this$creationMode_u24lambda_u240.creationMode = arg;
            return openForWriting;
        }

        @NotNull
        public final OpenForWriting allowCreate() {
            return this.creationMode(EelFileSystemApi.FileWriterCreationMode.ALLOW_CREATE);
        }

        @NotNull
        public final OpenForWriting onlyCreate() {
            return this.creationMode(EelFileSystemApi.FileWriterCreationMode.ONLY_CREATE);
        }

        @NotNull
        public final OpenForWriting onlyOpenExisting() {
            return this.creationMode(EelFileSystemApi.FileWriterCreationMode.ONLY_OPEN_EXISTING);
        }

        @NotNull
        public final OpenForWriting path(@NotNull EelPath arg) {
            OpenForWriting openForWriting;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            OpenForWriting $this$path_u24lambda_u240 = openForWriting = this;
            boolean bl = false;
            $this$path_u24lambda_u240.path = arg;
            return openForWriting;
        }

        @NotNull
        public final OpenForWriting truncateExisting(boolean arg) {
            OpenForWriting openForWriting;
            OpenForWriting $this$truncateExisting_u24lambda_u240 = openForWriting = this;
            boolean bl = false;
            $this$truncateExisting_u24lambda_u240.truncateExisting = arg;
            return openForWriting;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<? extends EelOpenedFile.Writer, ? extends EelFileSystemApi.FileWriterError>> $completion) {
            return this.owner.openForWriting(new WriteOptionsImpl(this.append, this.creationMode, this.path, this.truncateExisting), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000eH\u0007J\u0015\u0010\u000f\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u000eH\u0007J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\bJ\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$ReadFile;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ReadFileResult;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileReaderError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;)V", "buffer", "Ljava/nio/ByteBuffer;", "failFastIfBeyondLimit", "", "limit", "", "Ljava/lang/Integer;", "mayReturnSameBuffer", "arg", "(Ljava/lang/Integer;)Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$ReadFile;", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class ReadFile
    implements OwnedBuilder<EelResult<? extends EelFileSystemApi.ReadFileResult, ? extends EelFileSystemApi.FileReaderError>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath path;
        @Nullable
        private ByteBuffer buffer;
        private boolean failFastIfBeyondLimit;
        @Nullable
        private Integer limit;
        private boolean mayReturnSameBuffer;

        public ReadFile(@NotNull EelFileSystemApi owner, @NotNull EelPath path) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.owner = owner;
            this.path = path;
            this.mayReturnSameBuffer = true;
        }

        @EelDelicateApi
        @NotNull
        public final ReadFile buffer(@Nullable ByteBuffer arg) {
            ReadFile readFile;
            ReadFile $this$buffer_u24lambda_u240 = readFile = this;
            boolean bl = false;
            $this$buffer_u24lambda_u240.buffer = arg;
            return readFile;
        }

        @EelDelicateApi
        @NotNull
        public final ReadFile failFastIfBeyondLimit(boolean arg) {
            ReadFile readFile;
            ReadFile $this$failFastIfBeyondLimit_u24lambda_u240 = readFile = this;
            boolean bl = false;
            $this$failFastIfBeyondLimit_u24lambda_u240.failFastIfBeyondLimit = arg;
            return readFile;
        }

        @NotNull
        public final ReadFile limit(@Nullable Integer arg) {
            ReadFile readFile;
            ReadFile $this$limit_u24lambda_u240 = readFile = this;
            boolean bl = false;
            $this$limit_u24lambda_u240.limit = arg;
            return readFile;
        }

        @EelDelicateApi
        @NotNull
        public final ReadFile mayReturnSameBuffer(boolean arg) {
            ReadFile readFile;
            ReadFile $this$mayReturnSameBuffer_u24lambda_u240 = readFile = this;
            boolean bl = false;
            $this$mayReturnSameBuffer_u24lambda_u240.mayReturnSameBuffer = arg;
            return readFile;
        }

        @NotNull
        public final ReadFile path(@NotNull EelPath arg) {
            ReadFile readFile;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            ReadFile $this$path_u24lambda_u240 = readFile = this;
            boolean bl = false;
            $this$path_u24lambda_u240.path = arg;
            return readFile;
        }

        @Override
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<? extends EelFileSystemApi.ReadFileResult, ? extends EelFileSystemApi.FileReaderError>> $completion) {
            return this.owner.readFile(new ReadFileArgsImpl(this.buffer, this.failFastIfBeyondLimit, this.limit, this.mayReturnSameBuffer, this.path), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0000J\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0097@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$Stat;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/fs/EelFileInfo;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$StatError;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;)V", "symlinkPolicy", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$SymlinkPolicy;", "arg", "doNotResolve", "justResolve", "resolveAndFollow", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class Stat
    implements OwnedBuilder<EelResult<? extends EelFileInfo, ? extends EelFileSystemApi.StatError>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath path;
        @NotNull
        private EelFileSystemApi.SymlinkPolicy symlinkPolicy;

        public Stat(@NotNull EelFileSystemApi owner, @NotNull EelPath path) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.owner = owner;
            this.path = path;
            this.symlinkPolicy = EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE;
        }

        @NotNull
        public final Stat path(@NotNull EelPath arg) {
            Stat stat;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            Stat $this$path_u24lambda_u240 = stat = this;
            boolean bl = false;
            $this$path_u24lambda_u240.path = arg;
            return stat;
        }

        @NotNull
        public final Stat symlinkPolicy(@NotNull EelFileSystemApi.SymlinkPolicy arg) {
            Stat stat;
            Intrinsics.checkNotNullParameter((Object)((Object)arg), (String)"arg");
            Stat $this$symlinkPolicy_u24lambda_u240 = stat = this;
            boolean bl = false;
            $this$symlinkPolicy_u24lambda_u240.symlinkPolicy = arg;
            return stat;
        }

        @NotNull
        public final Stat doNotResolve() {
            return this.symlinkPolicy(EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE);
        }

        @NotNull
        public final Stat justResolve() {
            return this.symlinkPolicy(EelFileSystemApi.SymlinkPolicy.JUST_RESOLVE);
        }

        @NotNull
        public final Stat resolveAndFollow() {
            return this.symlinkPolicy(EelFileSystemApi.SymlinkPolicy.RESOLVE_AND_FOLLOW);
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super EelResult<? extends EelFileInfo, ? extends EelFileSystemApi.StatError>> $completion) {
            return this.owner.stat(new StatArgsImpl(this.path, this.symlinkPolicy), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$Unwatch;", "Lcom/intellij/platform/eel/OwnedBuilder;", "", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;)V", "arg", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class Unwatch
    implements OwnedBuilder<Boolean> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath path;

        public Unwatch(@NotNull EelFileSystemApi owner, @NotNull EelPath path) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.owner = owner;
            this.path = path;
        }

        @NotNull
        public final Unwatch path(@NotNull EelPath arg) {
            Unwatch unwatch;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            Unwatch $this$path_u24lambda_u240 = unwatch = this;
            boolean bl = false;
            $this$path_u24lambda_u240.path = arg;
            return unwatch;
        }

        @Override
        @Nullable
        public Object eelIt(@NotNull Continuation<? super Boolean> $completion) throws UnsupportedOperationException {
            return this.owner.unwatch(new UnwatchOptionsImpl(this.path), $completion);
        }
    }

    @GeneratedBuilder.Result
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000bJ\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0097@\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/eel/fs/EelFileSystemApiHelpers$WalkDirectory;", "Lcom/intellij/platform/eel/OwnedBuilder;", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/platform/eel/fs/WalkDirectoryEntryResult;", "owner", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileSystemApi;Lcom/intellij/platform/eel/path/EelPath;)V", "entryOrder", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$WalkDirectoryOptions$WalkDirectoryEntryOrder;", "fileContentsHash", "", "maxDepth", "", "readMetadata", "traversalOrder", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$WalkDirectoryOptions$WalkDirectoryTraversalOrder;", "yieldDirectories", "yieldOtherFileTypes", "yieldRegularFiles", "yieldSymlinks", "arg", "alphabetical", "random", "bfs", "dfs", "eelIt", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel"})
    @ApiStatus.Internal
    public static final class WalkDirectory
    implements OwnedBuilder<Flow<? extends WalkDirectoryEntryResult>> {
        @NotNull
        private final EelFileSystemApi owner;
        @NotNull
        private EelPath path;
        @NotNull
        private EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryEntryOrder entryOrder;
        private boolean fileContentsHash;
        private int maxDepth;
        private boolean readMetadata;
        @NotNull
        private EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryTraversalOrder traversalOrder;
        private boolean yieldDirectories;
        private boolean yieldOtherFileTypes;
        private boolean yieldRegularFiles;
        private boolean yieldSymlinks;

        public WalkDirectory(@NotNull EelFileSystemApi owner, @NotNull EelPath path) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.owner = owner;
            this.path = path;
            this.entryOrder = EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryEntryOrder.RANDOM;
            this.maxDepth = -1;
            this.traversalOrder = EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryTraversalOrder.DFS;
            this.yieldDirectories = true;
            this.yieldOtherFileTypes = true;
            this.yieldRegularFiles = true;
            this.yieldSymlinks = true;
        }

        @NotNull
        public final WalkDirectory entryOrder(@NotNull EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryEntryOrder arg) {
            WalkDirectory walkDirectory;
            Intrinsics.checkNotNullParameter((Object)((Object)arg), (String)"arg");
            WalkDirectory $this$entryOrder_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$entryOrder_u24lambda_u240.entryOrder = arg;
            return walkDirectory;
        }

        @NotNull
        public final WalkDirectory alphabetical() {
            return this.entryOrder(EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryEntryOrder.ALPHABETICAL);
        }

        @NotNull
        public final WalkDirectory random() {
            return this.entryOrder(EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryEntryOrder.RANDOM);
        }

        @NotNull
        public final WalkDirectory fileContentsHash(boolean arg) {
            WalkDirectory walkDirectory;
            WalkDirectory $this$fileContentsHash_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$fileContentsHash_u24lambda_u240.fileContentsHash = arg;
            return walkDirectory;
        }

        @NotNull
        public final WalkDirectory maxDepth(int arg) {
            WalkDirectory walkDirectory;
            WalkDirectory $this$maxDepth_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$maxDepth_u24lambda_u240.maxDepth = arg;
            return walkDirectory;
        }

        @NotNull
        public final WalkDirectory path(@NotNull EelPath arg) {
            WalkDirectory walkDirectory;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            WalkDirectory $this$path_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$path_u24lambda_u240.path = arg;
            return walkDirectory;
        }

        @NotNull
        public final WalkDirectory readMetadata(boolean arg) {
            WalkDirectory walkDirectory;
            WalkDirectory $this$readMetadata_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$readMetadata_u24lambda_u240.readMetadata = arg;
            return walkDirectory;
        }

        @NotNull
        public final WalkDirectory traversalOrder(@NotNull EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryTraversalOrder arg) {
            WalkDirectory walkDirectory;
            Intrinsics.checkNotNullParameter((Object)((Object)arg), (String)"arg");
            WalkDirectory $this$traversalOrder_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$traversalOrder_u24lambda_u240.traversalOrder = arg;
            return walkDirectory;
        }

        @NotNull
        public final WalkDirectory bfs() {
            return this.traversalOrder(EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryTraversalOrder.BFS);
        }

        @NotNull
        public final WalkDirectory dfs() {
            return this.traversalOrder(EelFileSystemApi.WalkDirectoryOptions.WalkDirectoryTraversalOrder.DFS);
        }

        @NotNull
        public final WalkDirectory yieldDirectories(boolean arg) {
            WalkDirectory walkDirectory;
            WalkDirectory $this$yieldDirectories_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$yieldDirectories_u24lambda_u240.yieldDirectories = arg;
            return walkDirectory;
        }

        @NotNull
        public final WalkDirectory yieldOtherFileTypes(boolean arg) {
            WalkDirectory walkDirectory;
            WalkDirectory $this$yieldOtherFileTypes_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$yieldOtherFileTypes_u24lambda_u240.yieldOtherFileTypes = arg;
            return walkDirectory;
        }

        @NotNull
        public final WalkDirectory yieldRegularFiles(boolean arg) {
            WalkDirectory walkDirectory;
            WalkDirectory $this$yieldRegularFiles_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$yieldRegularFiles_u24lambda_u240.yieldRegularFiles = arg;
            return walkDirectory;
        }

        @NotNull
        public final WalkDirectory yieldSymlinks(boolean arg) {
            WalkDirectory walkDirectory;
            WalkDirectory $this$yieldSymlinks_u24lambda_u240 = walkDirectory = this;
            boolean bl = false;
            $this$yieldSymlinks_u24lambda_u240.yieldSymlinks = arg;
            return walkDirectory;
        }

        @Override
        @CheckReturnValue
        @Nullable
        public Object eelIt(@NotNull Continuation<? super Flow<? extends WalkDirectoryEntryResult>> $completion) {
            return this.owner.walkDirectory(new WalkDirectoryOptionsImpl(this.entryOrder, this.fileContentsHash, this.maxDepth, this.path, this.readMetadata, this.traversalOrder, this.yieldDirectories, this.yieldOtherFileTypes, this.yieldRegularFiles, this.yieldSymlinks), $completion);
        }
    }
}

