/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.fs;

import com.intellij.platform.eel.EelSharedSecrets;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/eel/fs/EelFiles;", "", "<init>", "()V", "readAllBytes", "", "path", "Ljava/nio/file/Path;", "readString", "", "cs", "Ljava/nio/charset/Charset;", "intellij.platform.eel"})
@ApiStatus.Experimental
public final class EelFiles {
    @NotNull
    public static final EelFiles INSTANCE = new EelFiles();

    private EelFiles() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] readAllBytes(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return EelSharedSecrets.INSTANCE.getFilesImpl().readAllBytes(path);
    }

    @JvmStatic
    @NotNull
    public static final String readString(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return EelFiles.readString(path, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String readString(@NotNull Path path, @NotNull Charset cs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        return EelSharedSecrets.INSTANCE.getFilesImpl().readString(path, cs);
    }
}

