// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel

import com.intellij.platform.eel.EelTunnelsApi.Connection
import com.intellij.platform.eel.channels.EelDelicateApi
import org.jetbrains.annotations.ApiStatus


@GeneratedBuilder.Result
@ApiStatus.Experimental
class EelTunnelsApiRunProxyOptsBuilder {
  private var _acceptorInfo: Pair<EelTunnelsApi, Any?>? = null

  private var _connectorInfo: Pair<EelTunnelsApi, Any?>? = null

  private var _fakeProxyPossible: Boolean = true

  private var acceptorFactory: @ThrowsChecked(
    exceptionClasses = [EelConnectionError::class]
  ) (suspend () -> EelTunnelsApi.ConnectionAcceptor) = { error("Forgot to set localAcceptor") }

  private var connectionFactory: @ThrowsChecked(exceptionClasses = [EelConnectionError::class]) (suspend () -> Connection) =
    { error("Forgot to set remoteConnectionFactory") }

  private var debugLabel: String? = null

  private var onConnection: ((Connection) -> Unit)? = null

  private var onConnectionClosed: ((Connection) -> Unit)? = null

  private var onConnectionError: ((EelConnectionError) -> Unit)? = null

  /**
   * For internal use inside Eel only.
   */
  @Suppress("PropertyName")
  @ApiStatus.Internal
  fun _acceptorInfo(arg: Pair<EelTunnelsApi, Any?>?): EelTunnelsApiRunProxyOptsBuilder = apply {
    this._acceptorInfo = arg
  }

  /**
   * For internal use inside Eel only.
   */
  @Suppress("PropertyName")
  @ApiStatus.Internal
  fun _connectorInfo(arg: Pair<EelTunnelsApi, Any?>?): EelTunnelsApiRunProxyOptsBuilder = apply {
    this._connectorInfo = arg
  }

  /**
   * For internal use inside Eel only.
   */
  @Suppress("PropertyName")
  @ApiStatus.Internal
  fun _fakeProxyPossible(arg: Boolean): EelTunnelsApiRunProxyOptsBuilder = apply {
    this._fakeProxyPossible = arg
  }

  /**
   * This function is called exactly once. Its result is stored in [EelProxy.acceptor].
   */
  fun acceptorFactory(
    arg: @ThrowsChecked(
      exceptionClasses = [EelConnectionError::class]
    ) (suspend () -> EelTunnelsApi.ConnectionAcceptor)
  ): EelTunnelsApiRunProxyOptsBuilder = apply {
    this.acceptorFactory = arg
  }

  /**
   * This function is called every time the acceptor gets a new connection.
   *
   * See also [onConnection], [onConnectionClosed], [onConnectionError]
   */
  fun connectionFactory(
    arg: @ThrowsChecked(
      exceptionClasses = [EelConnectionError::class]
    ) (suspend () -> Connection)
  ): EelTunnelsApiRunProxyOptsBuilder = apply {
    this.connectionFactory = arg
  }

  /**
   * Some text that may be visible in logs and thread dumps.
   */
  fun debugLabel(arg: String?): EelTunnelsApiRunProxyOptsBuilder = apply {
    this.debugLabel = arg
  }

  /**
   * Receives connections instantiated by [connectionFactory].
   *
   * The function is called before transferring any data.
   * It must work as fast as possible. Otherwise, it may prevent accepting new connections.
   *
   * The handler is not supposed to close the connection. If it happens, the behavior is undefined.
   */
  @EelDelicateApi
  fun onConnection(arg: ((Connection) -> Unit)?): EelTunnelsApiRunProxyOptsBuilder = apply {
    this.onConnection = arg
  }

  /**
   * Called when the connection is closed.
   */
  fun onConnectionClosed(arg: ((Connection) -> Unit)?): EelTunnelsApiRunProxyOptsBuilder = apply {
    this.onConnectionClosed = arg
  }

  /**
   * Receives errors thrown by [connectionFactory].
   *
   * It must work as fast as possible. Otherwise, it may prevent accepting new connections.
   */
  @EelDelicateApi
  fun onConnectionError(arg: ((EelConnectionError) -> Unit)?): EelTunnelsApiRunProxyOptsBuilder = apply {
    this.onConnectionError = arg
  }

  fun build(): EelTunnelsApiRunProxyOpts =
    EelTunnelsApiRunProxyOptsImpl(
      _acceptorInfo = _acceptorInfo,
      _connectorInfo = _connectorInfo,
      _fakeProxyPossible = _fakeProxyPossible,
      acceptorFactory = acceptorFactory,
      connectionFactory = connectionFactory,
      debugLabel = debugLabel,
      onConnection = onConnection,
      onConnectionClosed = onConnectionClosed,
      onConnectionError = onConnectionError,
    )
}

@GeneratedBuilder.Result
internal class EelTunnelsApiRunProxyOptsImpl(
  override val _acceptorInfo: Pair<EelTunnelsApi, Any?>?,
  override val _connectorInfo: Pair<EelTunnelsApi, Any?>?,
  override val _fakeProxyPossible: Boolean,
  override val acceptorFactory: @ThrowsChecked(
    exceptionClasses = [EelConnectionError::class]
  ) (suspend () -> EelTunnelsApi.ConnectionAcceptor),
  override val connectionFactory: @ThrowsChecked(exceptionClasses = [EelConnectionError::class]) (suspend () -> Connection),
  override val debugLabel: String?,
  override val onConnection: ((Connection) -> Unit)?,
  override val onConnectionClosed: ((Connection) -> Unit)?,
  override val onConnectionError: ((EelConnectionError) -> Unit)?,
) : EelTunnelsApiRunProxyOpts