// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel

import com.intellij.platform.eel.EelExecApi.EnvironmentVariablesOptions
import org.jetbrains.annotations.ApiStatus


@GeneratedBuilder.Result
@ApiStatus.Experimental
class EnvironmentVariablesOptionsBuilder {
  private var onlyActual: Boolean = false

  /**
   * The implementation MAY cache the environment variables by default because they rarely change in real life.
   * By setting this value to `true`, the cache will be refreshed, and the result will contain the freshest environment variables.
   *
   * Makes sense only for remote Eels (via IJent)
   * or with such [EelExecPosixApi.PosixEnvironmentVariablesOptions.mode] that invoke a shell.
   * In other cases this option has no effect.
   */
  fun onlyActual(arg: Boolean): EnvironmentVariablesOptionsBuilder = apply {
    this.onlyActual = arg
  }

  fun build(): EnvironmentVariablesOptions =
    EnvironmentVariablesOptionsImpl(
      onlyActual = onlyActual,
    )
}

@GeneratedBuilder.Result
internal class EnvironmentVariablesOptionsImpl(override val onlyActual: Boolean) : EnvironmentVariablesOptions