// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel

import com.intellij.platform.eel.*
import com.intellij.platform.eel.EelTunnelsApi.Connection
import com.intellij.platform.eel.channels.EelDelicateApi
import org.jetbrains.annotations.ApiStatus


/**
 * A generic function for setting up a proxy server using Eel.
 * It's not obligatory to use it for proxying, but it can save time and simplify the code.
 * 
 * A general usage example:
 * ```kotlin
 * val proxy = try {
 *   eelProxy()
 *     .localAcceptorFactory { ... }
 *     .remoteConnectionFactory { ... }
 *     .eelIt()
 * }
 * catch (e: EelConnectionError) { ... }
 * 
 * println("Proxy server is running on ${proxy.localAcceptor.hostAddress}")
 * val job = launch {
 *   proxy.runForever()
 * }
 * ...
 * job.cancel()  // When the proxy is no longer needed. All connections get closed.
 * ```
 * 
 * See also [com.intellij.platform.eel.provider.utils.acceptOnTcpPort] and [com.intellij.platform.eel.provider.utils.connectToTcpPort],
 * they help to set up a proxy server that listens on a local machine and forwards requests to a remote machine:
 * 
 * An example of a proxy server that listens locally (i.e., where the IDE runs) and forwards connections remotely:
 * ```kotlin
 * eelProxy()
 *   .acceptOnTcpPort(localEel, port = 1234u)
 *   .connectToTcpPort(remoteEel, port = 5678u)
 *   .eelIt()
 * ```
 * 
 * An example of a proxy server that accepts connections remotely and forwards them to a local machine:
 * ```kotlin
 * eelProxy()
 *   .acceptOnTcpPort(remoteEel, port = 1234u)
 *   .connectToTcpPort(localEel, port = 5678u)
 *   .eelIt()
 * ```
 * 
 * @throws EelConnectionError on a failure to create the acceptor.
 */
@GeneratedBuilder.Result
@ApiStatus.Experimental
fun eelProxy(): eelProxyKtHelpers.EelProxy =
  eelProxyKtHelpers.EelProxy(

  )

@ApiStatus.Experimental
object eelProxyKtHelpers {
  /**
   * Create it via [eelProxy].
   */
  @GeneratedBuilder.Result
  @ApiStatus.Experimental
  class EelProxy : OwnedBuilder<com.intellij.platform.eel.EelProxy> {
    private var _acceptorInfo: Pair<EelTunnelsApi, Any?>? = null

    private var _connectorInfo: Pair<EelTunnelsApi, Any?>? = null

    private var _fakeProxyPossible: Boolean = true

    private var acceptorFactory: @ThrowsChecked(
      exceptionClasses = [EelConnectionError::class]
    ) (suspend () -> EelTunnelsApi.ConnectionAcceptor) = { error("Forgot to set localAcceptor") }

    private var connectionFactory: @ThrowsChecked(exceptionClasses = [EelConnectionError::class]) (suspend () -> Connection) =
      { error("Forgot to set remoteConnectionFactory") }

    private var debugLabel: String? = null

    private var onConnection: ((Connection) -> Unit)? = null

    private var onConnectionClosed: ((Connection) -> Unit)? = null

    private var onConnectionError: ((EelConnectionError) -> Unit)? = null

    /**
     * For internal use inside Eel only.
     */
    @Suppress("PropertyName")
    @ApiStatus.Internal
    fun _acceptorInfo(arg: Pair<EelTunnelsApi, Any?>?): EelProxy = apply {
      this._acceptorInfo = arg
    }

    /**
     * For internal use inside Eel only.
     */
    @Suppress("PropertyName")
    @ApiStatus.Internal
    fun _connectorInfo(arg: Pair<EelTunnelsApi, Any?>?): EelProxy = apply {
      this._connectorInfo = arg
    }

    /**
     * For internal use inside Eel only.
     */
    @Suppress("PropertyName")
    @ApiStatus.Internal
    fun _fakeProxyPossible(arg: Boolean): EelProxy = apply {
      this._fakeProxyPossible = arg
    }

    /**
     * This function is called exactly once. Its result is stored in [EelProxy.acceptor].
     */
    fun acceptorFactory(
      arg: @ThrowsChecked(
        exceptionClasses = [EelConnectionError::class]
      ) (suspend () -> EelTunnelsApi.ConnectionAcceptor)
    ): EelProxy = apply {
      this.acceptorFactory = arg
    }

    /**
     * This function is called every time the acceptor gets a new connection.
     *
     * See also [onConnection], [onConnectionClosed], [onConnectionError]
     */
    fun connectionFactory(arg: @ThrowsChecked(exceptionClasses = [EelConnectionError::class]) (suspend () -> Connection)): EelProxy =
      apply {
        this.connectionFactory = arg
      }

    /**
     * Some text that may be visible in logs and thread dumps.
     */
    fun debugLabel(arg: String?): EelProxy = apply {
      this.debugLabel = arg
    }

    /**
     * Receives connections instantiated by [connectionFactory].
     *
     * The function is called before transferring any data.
     * It must work as fast as possible. Otherwise, it may prevent accepting new connections.
     *
     * The handler is not supposed to close the connection. If it happens, the behavior is undefined.
     */
    @EelDelicateApi
    fun onConnection(arg: ((Connection) -> Unit)?): EelProxy = apply {
      this.onConnection = arg
    }

    /**
     * Called when the connection is closed.
     */
    fun onConnectionClosed(arg: ((Connection) -> Unit)?): EelProxy = apply {
      this.onConnectionClosed = arg
    }

    /**
     * Receives errors thrown by [connectionFactory].
     *
     * It must work as fast as possible. Otherwise, it may prevent accepting new connections.
     */
    @EelDelicateApi
    fun onConnectionError(arg: ((EelConnectionError) -> Unit)?): EelProxy = apply {
      this.onConnectionError = arg
    }

    /**
     * Complete the builder and call [eelProxy]
     * with an instance of [com.intellij.platform.eel.EelTunnelsApiRunProxyOpts].
     */
    @ThrowsChecked(EelConnectionError::class)
    override suspend fun eelIt(): com.intellij.platform.eel.EelProxy =
      eelProxy(
        EelTunnelsApiRunProxyOptsImpl(
          _acceptorInfo = _acceptorInfo,
          _connectorInfo = _connectorInfo,
          _fakeProxyPossible = _fakeProxyPossible,
          acceptorFactory = acceptorFactory,
          connectionFactory = connectionFactory,
          debugLabel = debugLabel,
          onConnection = onConnection,
          onConnectionClosed = onConnectionClosed,
          onConnectionError = onConnectionError,
        )
      )
  }
}