// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel.fs

import com.intellij.platform.eel.GeneratedBuilder
import com.intellij.platform.eel.fs.EelFileSystemApi.WriteOptions
import com.intellij.platform.eel.path.EelPath
import org.jetbrains.annotations.ApiStatus


@GeneratedBuilder.Result
@ApiStatus.Internal
class WriteOptionsBuilder(
  private var path: EelPath,
) {
  private var append: Boolean = false

  private var creationMode: EelFileSystemApi.FileWriterCreationMode = EelFileSystemApi.FileWriterCreationMode.ALLOW_CREATE

  private var truncateExisting: Boolean = true

  fun append(arg: Boolean): WriteOptionsBuilder = apply {
    this.append = arg
  }

  fun creationMode(arg: EelFileSystemApi.FileWriterCreationMode): WriteOptionsBuilder = apply {
    this.creationMode = arg
  }

  fun allowCreate(): WriteOptionsBuilder =
    creationMode(EelFileSystemApi.FileWriterCreationMode.ALLOW_CREATE)

  fun onlyCreate(): WriteOptionsBuilder =
    creationMode(EelFileSystemApi.FileWriterCreationMode.ONLY_CREATE)

  fun onlyOpenExisting(): WriteOptionsBuilder =
    creationMode(EelFileSystemApi.FileWriterCreationMode.ONLY_OPEN_EXISTING)

  fun path(arg: EelPath): WriteOptionsBuilder = apply {
    this.path = arg
  }

  fun truncateExisting(arg: Boolean): WriteOptionsBuilder = apply {
    this.truncateExisting = arg
  }

  fun build(): WriteOptions =
    WriteOptionsImpl(
      append = append,
      creationMode = creationMode,
      path = path,
      truncateExisting = truncateExisting,
    )
}

@GeneratedBuilder.Result
internal class WriteOptionsImpl(
  override val append: Boolean,
  override val creationMode: EelFileSystemApi.FileWriterCreationMode,
  override val path: EelPath,
  override val truncateExisting: Boolean,
) : WriteOptions