// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel.fs

import com.intellij.platform.eel.GeneratedBuilder
import com.intellij.platform.eel.fs.EelFileSystemApi.ListDirectoryWithAttrsArgs
import com.intellij.platform.eel.path.EelPath
import org.jetbrains.annotations.ApiStatus


@GeneratedBuilder.Result
@ApiStatus.Internal
class ListDirectoryWithAttrsArgsBuilder(
  private var path: EelPath,
) {
  private var symlinkPolicy: EelFileSystemApi.SymlinkPolicy = EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE

  fun path(arg: EelPath): ListDirectoryWithAttrsArgsBuilder = apply {
    this.path = arg
  }

  fun symlinkPolicy(arg: EelFileSystemApi.SymlinkPolicy): ListDirectoryWithAttrsArgsBuilder = apply {
    this.symlinkPolicy = arg
  }

  /**
   * Leaves symlinks unresolved.
   * This option makes the operation a bit more efficient if it is not interested in symlinks.
   */
  fun doNotResolve(): ListDirectoryWithAttrsArgsBuilder =
    symlinkPolicy(EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE)

  /**
   * Resolves a symlink and returns the information about the target of the symlink,
   * But does not perform anything on the target of the symlink itself.
   */
  fun justResolve(): ListDirectoryWithAttrsArgsBuilder =
    symlinkPolicy(EelFileSystemApi.SymlinkPolicy.JUST_RESOLVE)

  /**
   * Resolves a symlink, follows it, and performs the required operation on target.
   */
  fun resolveAndFollow(): ListDirectoryWithAttrsArgsBuilder =
    symlinkPolicy(EelFileSystemApi.SymlinkPolicy.RESOLVE_AND_FOLLOW)

  fun build(): ListDirectoryWithAttrsArgs =
    ListDirectoryWithAttrsArgsImpl(
      path = path,
      symlinkPolicy = symlinkPolicy,
    )
}

@GeneratedBuilder.Result
internal class ListDirectoryWithAttrsArgsImpl(
  override val path: EelPath,
  override val symlinkPolicy: EelFileSystemApi.SymlinkPolicy,
) : ListDirectoryWithAttrsArgs