// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel.fs

import com.intellij.platform.eel.GeneratedBuilder
import com.intellij.platform.eel.channels.EelDelicateApi
import com.intellij.platform.eel.fs.EelFileSystemApi.ReadFileArgs
import com.intellij.platform.eel.path.EelPath
import org.jetbrains.annotations.ApiStatus
import java.nio.ByteBuffer


@GeneratedBuilder.Result
@ApiStatus.Internal
class ReadFileArgsBuilder(
  private var path: EelPath,
) {
  private var buffer: ByteBuffer? = null

  private var failFastIfBeyondLimit: Boolean = false

  private var limit: Int? = null

  private var mayReturnSameBuffer: Boolean = true

  /**
   * Use some specific buffer for reading files instead of creating a temporary buffer.
   *
   * The implementation MAY use only a fraction of this buffer for invoking a single system or RPC call.
   *
   * The buffer is ready for reading, no need to call `flip`.
   */
  @EelDelicateApi
  fun buffer(arg: ByteBuffer?): ReadFileArgsBuilder = apply {
    this.buffer = arg
  }

  /**
   * If this flag is set, the implementation checks the file size before trying to read data,
   * and if the file is certainly bigger than [limit], no data is read.
   */
  @EelDelicateApi
  fun failFastIfBeyondLimit(arg: Boolean): ReadFileArgsBuilder = apply {
    this.failFastIfBeyondLimit = arg
  }

  /**
   * Maximal number of bytes to read.
   */
  fun limit(arg: Int?): ReadFileArgsBuilder = apply {
    this.limit = arg
  }

  /**
   * If this flag is set and [buffer] is specified, the implementation reads the whole
   * file into [buffer] and [ReadFileResult.bytes] contains a reference to [buffer]. However, if the file size is greater than the capacity of the buffer, the implementation returns a different buffer.
   *
   * If [buffer] is not specified, the value of the flag is ignored.
   */
  @EelDelicateApi
  fun mayReturnSameBuffer(arg: Boolean): ReadFileArgsBuilder = apply {
    this.mayReturnSameBuffer = arg
  }

  fun path(arg: EelPath): ReadFileArgsBuilder = apply {
    this.path = arg
  }

  fun build(): ReadFileArgs =
    ReadFileArgsImpl(
      buffer = buffer,
      failFastIfBeyondLimit = failFastIfBeyondLimit,
      limit = limit,
      mayReturnSameBuffer = mayReturnSameBuffer,
      path = path,
    )
}

@GeneratedBuilder.Result
internal class ReadFileArgsImpl(
  override val buffer: ByteBuffer?,
  override val failFastIfBeyondLimit: Boolean,
  override val limit: Int?,
  override val mayReturnSameBuffer: Boolean,
  override val path: EelPath,
) : ReadFileArgs