// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
/**
 * This file is generated by [com.intellij.platform.eel.codegen.BuildersGeneratorTest].
 */
package com.intellij.platform.eel.fs

import com.intellij.platform.eel.GeneratedBuilder
import com.intellij.platform.eel.fs.EelFileSystemApi.WalkDirectoryOptions
import com.intellij.platform.eel.path.EelPath
import org.jetbrains.annotations.ApiStatus


@GeneratedBuilder.Result
@ApiStatus.Internal
class WalkDirectoryOptionsBuilder(
  /**
   * Path to the directory that is to be traversed. If the path is not a directory, WalkDirectory will still yield just the file itself.
   */
  private var path: EelPath,
) {
  private var entryOrder: WalkDirectoryOptions.WalkDirectoryEntryOrder = WalkDirectoryOptions.WalkDirectoryEntryOrder.RANDOM

  private var fileContentsHash: Boolean = false

  private var maxDepth: Int = -1

  private var readMetadata: Boolean = false

  private var traversalOrder: WalkDirectoryOptions.WalkDirectoryTraversalOrder = WalkDirectoryOptions.WalkDirectoryTraversalOrder.DFS

  private var yieldDirectories: Boolean = true

  private var yieldOtherFileTypes: Boolean = true

  private var yieldRegularFiles: Boolean = true

  private var yieldSymlinks: Boolean = true

  /**
   * The default is RANDOM.
   */
  fun entryOrder(arg: WalkDirectoryOptions.WalkDirectoryEntryOrder): WalkDirectoryOptionsBuilder = apply {
    this.entryOrder = arg
  }

  /**
   * Yield directory entries in alphabetical order.
   */
  fun alphabetical(): WalkDirectoryOptionsBuilder =
    entryOrder(WalkDirectoryOptions.WalkDirectoryEntryOrder.ALPHABETICAL)

  /**
   * Yield directory entries in order in which they appear on the file system.
   * If you do not care for the order of the files, this is the preferable option.
   */
  fun random(): WalkDirectoryOptionsBuilder =
    entryOrder(WalkDirectoryOptions.WalkDirectoryEntryOrder.RANDOM)

  /**
   * Yield hash of the regular file's contents. Contents are hashed using xxHash. Default is false.
   */
  fun fileContentsHash(arg: Boolean): WalkDirectoryOptionsBuilder = apply {
    this.fileContentsHash = arg
  }

  /**
   * maxDepth parameter specifies how many levels deep to traverse within the given directory. A negative depth (the default is -1) means
   * the entire directory will be traversed without any depth limit. Depth of 0 will just return the directory itself.
   *
   * Example for depth = 1:
   * ```
   * a/
   * |- b/
   * |  |- c
   * |  |- d
   * |- e
   * ```
   * Returned:
   * ```
   * a
   * a/b
   * a/e
   * ```
   */
  fun maxDepth(arg: Int): WalkDirectoryOptionsBuilder = apply {
    this.maxDepth = arg
  }

  /**
   * Path to the directory that is to be traversed. If the path is not a directory, WalkDirectory will still yield just the file itself.
   */
  fun path(arg: EelPath): WalkDirectoryOptionsBuilder = apply {
    this.path = arg
  }

  /**
   * Yield permissions and timestamps. Default is false.
   */
  fun readMetadata(arg: Boolean): WalkDirectoryOptionsBuilder = apply {
    this.readMetadata = arg
  }

  /**
   * The default is DFS.
   */
  fun traversalOrder(arg: WalkDirectoryOptions.WalkDirectoryTraversalOrder): WalkDirectoryOptionsBuilder = apply {
    this.traversalOrder = arg
  }

  /**
   * Breadth-first traversal.
   * ```
   * a/
   * |- b/
   * |  |- c
   * |  |- d
   * |- e
   * ```
   * Returned:
   * ```
   * a
   * a/b
   * a/e
   * a/b/c
   * a/b/d
   * ```
   */
  fun bfs(): WalkDirectoryOptionsBuilder =
    traversalOrder(WalkDirectoryOptions.WalkDirectoryTraversalOrder.BFS)

  /**
   * Depth-first traversal, where directory entries are yielded in order they are encountered.
   * If you do not care for the manner of traversal, this is the preferable option.
   * ```
   * a/
   * |- b/
   * |  |- c
   * |  |- d
   * |- e
   * ```
   * Returned:
   * ```
   * a
   * a/b
   * a/b/c
   * a/b/d
   * a/e
   * ```
   */
  fun dfs(): WalkDirectoryOptionsBuilder =
    traversalOrder(WalkDirectoryOptions.WalkDirectoryTraversalOrder.DFS)

  /**
   * Default is true.
   */
  fun yieldDirectories(arg: Boolean): WalkDirectoryOptionsBuilder = apply {
    this.yieldDirectories = arg
  }

  /**
   * Default is true.
   */
  fun yieldOtherFileTypes(arg: Boolean): WalkDirectoryOptionsBuilder = apply {
    this.yieldOtherFileTypes = arg
  }

  /**
   * Default is true.
   */
  fun yieldRegularFiles(arg: Boolean): WalkDirectoryOptionsBuilder = apply {
    this.yieldRegularFiles = arg
  }

  /**
   * Default is true.
   */
  fun yieldSymlinks(arg: Boolean): WalkDirectoryOptionsBuilder = apply {
    this.yieldSymlinks = arg
  }

  fun build(): WalkDirectoryOptions =
    WalkDirectoryOptionsImpl(
      entryOrder = entryOrder,
      fileContentsHash = fileContentsHash,
      maxDepth = maxDepth,
      path = path,
      readMetadata = readMetadata,
      traversalOrder = traversalOrder,
      yieldDirectories = yieldDirectories,
      yieldOtherFileTypes = yieldOtherFileTypes,
      yieldRegularFiles = yieldRegularFiles,
      yieldSymlinks = yieldSymlinks,
    )
}

@GeneratedBuilder.Result
internal class WalkDirectoryOptionsImpl(
  override val entryOrder: WalkDirectoryOptions.WalkDirectoryEntryOrder,
  override val fileContentsHash: Boolean,
  override val maxDepth: Int,
  override val path: EelPath,
  override val readMetadata: Boolean,
  override val traversalOrder: WalkDirectoryOptions.WalkDirectoryTraversalOrder,
  override val yieldDirectories: Boolean,
  override val yieldOtherFileTypes: Boolean,
  override val yieldRegularFiles: Boolean,
  override val yieldSymlinks: Boolean,
) : WalkDirectoryOptions