/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleListener;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbar;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.panels.FlowLayoutWrapper;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleBase
extends AdditionalTabComponent
implements LogConsole,
LogFilterListener {
    private static final Logger LOG = Logger.getInstance(LogConsoleBase.class);
    private final JPanel mySearchComponent;
    private final JComboBox<LogFilter> myLogFilterCombo;
    private final JPanel myTextFilterWrapper;
    private volatile boolean myDisposed;
    private ConsoleView myConsole;
    private final LightProcessHandler myProcessHandler;
    private ReaderThread myReaderThread;
    private final LinkedList<String> myLogLines;
    private int myCurrentLogLength;
    private String myLineUnderSelection;
    private int myLineOffset;
    private final Project myProject;
    @NlsContexts.TabTitle
    private String myTitle;
    private boolean myWasInitialized;
    private ActionGroup myActions;
    private final boolean myBuildInActions;
    private LogFilterModel myModel;
    private final LogFormatter myFormatter;
    private final List<LogConsoleListener> myListeners;
    private final List<? extends LogFilter> myFilters;
    private FilterComponent myFilter;

    @NlsContexts.ProgressTitle
    @NotNull
    public static String getApplyingFilterTitle() {
        String string = ExecutionBundle.message((String)"progress.title.applying.filter", (Object[])new Object[0]);
        if (string == null) {
            LogConsoleBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public LogConsoleBase(@NotNull Project project, @Nullable Reader reader, @NlsContexts.TabTitle String title, boolean buildInActions, LogFilterModel model) {
        if (project == null) {
            LogConsoleBase.$$$reportNull$$$0(1);
        }
        this(project, reader, title, buildInActions, model, GlobalSearchScope.allScope((Project)project));
    }

    public LogConsoleBase(@NotNull Project project, @Nullable Reader reader, @NlsContexts.TabTitle String title, boolean buildInActions, LogFilterModel model, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            LogConsoleBase.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            LogConsoleBase.$$$reportNull$$$0(3);
        }
        this(project, reader, title, buildInActions, model, scope, new DefaultLogFormatter());
    }

    public LogConsoleBase(@NotNull Project project, @Nullable Reader reader, @NlsContexts.TabTitle String title, boolean buildInActions, LogFilterModel model, @NotNull GlobalSearchScope scope, LogFormatter formatter) {
        if (project == null) {
            LogConsoleBase.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            LogConsoleBase.$$$reportNull$$$0(5);
        }
        super((LayoutManager)new BorderLayout());
        this.myProcessHandler = new LightProcessHandler();
        this.myLogLines = new LinkedList();
        this.myCurrentLogLength = 0;
        this.myLineUnderSelection = null;
        this.myLineOffset = -1;
        this.myTitle = null;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFilter = new FilterComponent("LOG_FILTER_HISTORY", 5){

            public void filter() {
                Task.Backgroundable task2 = new Task.Backgroundable(LogConsoleBase.this.myProject, LogConsoleBase.getApplyingFilterTitle()){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LogConsoleBase.this.myModel.updateCustomFilter(this.getFilter());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/logging/LogConsoleBase$1$1", "run"));
                    }
                };
                ProgressManager.getInstance().run((Task)task2);
            }
        };
        this.myProject = project;
        this.myTitle = title;
        this.myModel = model;
        this.myFormatter = formatter;
        this.myFilters = this.myModel.getLogFilters();
        this.myReaderThread = new ReaderThread(reader);
        this.myBuildInActions = buildInActions;
        TextConsoleBuilder builder2 = TextConsoleBuilderFactory.getInstance().createBuilder(project, scope);
        builder2.setViewer(true);
        this.myConsole = builder2.getConsole();
        UIUtil.removeScrollBorder((Component)this.myConsole.getComponent());
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        this.myDisposed = false;
        this.myModel.addFilterListener((LogFilterListener)this);
        this.mySearchComponent = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myLogFilterCombo = new ComboBox();
        this.myLogFilterCombo.setOpaque(false);
        this.myTextFilterWrapper = new NonOpaquePanel();
        this.mySearchComponent.add(this.myLogFilterCombo, "West");
        this.mySearchComponent.add((Component)this.myTextFilterWrapper, "Center");
    }

    public void setFilterModel(LogFilterModel model) {
        if (this.myModel != null) {
            this.myModel.removeFilterListener((LogFilterListener)this);
        }
        this.myModel = model;
        this.myModel.addFilterListener((LogFilterListener)this);
    }

    public LogFilterModel getFilterModel() {
        return this.myModel;
    }

    @Nullable
    protected BufferedReader updateReaderIfNeeded(@Nullable BufferedReader reader) throws IOException {
        return reader;
    }

    private void registerShiftTab() {
        if (!ScreenReader.isActive()) {
            new AnAction(){
                {
                    CustomShortcutSet shiftTabShortcut = new CustomShortcutSet(KeyStroke.getKeyStroke(9, 64));
                    this.registerCustomShortcutSet((ShortcutSet)shiftTabShortcut, (JComponent)((Object)LogConsoleBase.this));
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ConsoleWithFloatingToolbar console;
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((console = (ConsoleWithFloatingToolbar)((Object)ComponentUtil.getParentOfType(ConsoleWithFloatingToolbar.class, (Component)LogConsoleBase.this.getConsoleNotNull().getComponent()))) != null) {
                        console.myFloatingToolbar.scheduleShow();
                    }
                    LogConsoleBase.this.getTextFilterComponent().requestFocusInWindow();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagnostic/logging/LogConsoleBase$2", "actionPerformed"));
                }
            };
        }
    }

    public ActionGroup getOrCreateActions() {
        AnAction[] actions;
        if (this.myActions != null) {
            return this.myActions;
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (AnAction action : actions = this.getConsoleNotNull().createConsoleActions()) {
            group2.add(action);
        }
        group2.addSeparator();
        this.myActions = group2;
        return this.myActions;
    }

    public void onFilterStateChange(@NotNull LogFilter filter) {
        if (filter == null) {
            LogConsoleBase.$$$reportNull$$$0(6);
        }
        this.filterConsoleOutput();
    }

    public void onTextFilterChange() {
        this.filterConsoleOutput();
    }

    @NotNull
    public JComponent getComponent() {
        if (!this.myWasInitialized) {
            this.myWasInitialized = true;
            JComponent console = this.getConsoleNotNull().getComponent();
            if (this.myBuildInActions) {
                JComponent search = this.getSearchComponent();
                ActionGroup group2 = this.getOrCreateActions();
                if (search != null) {
                    group2 = this.addSearchFilter(group2, search);
                }
                this.add((Component)((Object)new ConsoleWithFloatingToolbar(console, group2, (Disposable)this)), "Center");
            } else {
                this.add(console, "Center");
            }
            this.registerShiftTab();
        }
        LogConsoleBase logConsoleBase = this;
        if (logConsoleBase == null) {
            LogConsoleBase.$$$reportNull$$$0(7);
        }
        return logConsoleBase;
    }

    private ActionGroup addSearchFilter(ActionGroup origin, final @NotNull JComponent searchComponent) {
        if (searchComponent == null) {
            LogConsoleBase.$$$reportNull$$$0(8);
        }
        ToggleSearchFilterAction filterAction = new ToggleSearchFilterAction(){

            @Override
            @NotNull
            protected JComponent getSearchFilterComponent() {
                JComponent jComponent = searchComponent;
                if (jComponent == null) {
                    3.$$$reportNull$$$0(0);
                }
                return jComponent;
            }

            @Override
            protected boolean isModified(@NotNull JComponent component) {
                if (component == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (LogConsoleBase.this.myLogFilterCombo.getSelectedIndex() > 0) {
                    return true;
                }
                Component textFilterComponent = LogConsoleBase.this.getTextFilterComponent();
                if (textFilterComponent instanceof FilterComponent) {
                    String filterText = ((FilterComponent)textFilterComponent).getFilter();
                    return StringUtil.isNotEmpty((String)filterText);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diagnostic/logging/LogConsoleBase$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSearchFilterComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diagnostic/logging/LogConsoleBase$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isModified";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
        return new DefaultActionGroup(new AnAction[]{origin, filterAction});
    }

    public abstract boolean isActive();

    public void activate() {
        ReaderThread readerThread = this.myReaderThread;
        if (readerThread == null) {
            return;
        }
        if (this.isActive() && !readerThread.myRunning) {
            this.resetLogFilter();
            this.myFilter.setSelectedItem(this.myModel.getCustomFilter());
            readerThread.startRunning();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)readerThread);
        } else if (!this.isActive() && readerThread.myRunning) {
            readerThread.stopRunning();
        }
    }

    @NotNull
    public String getTabTitle() {
        String string = this.myTitle;
        if (string == null) {
            LogConsoleBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void dispose() {
        this.myModel.removeFilterListener((LogFilterListener)this);
        this.stopRunning(false);
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myConsole);
        this.myConsole = null;
        this.myFilter.dispose();
        this.myFilter = null;
    }

    private void stopRunning(boolean checkActive) {
        ReaderThread readerThread;
        if (!checkActive) {
            this.fireLoggingWillBeStopped();
        }
        if ((readerThread = this.myReaderThread) != null && readerThread.myReader != null) {
            if (!checkActive) {
                readerThread.stopRunning();
                try {
                    readerThread.myReader.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
                readerThread.myReader = null;
                this.myReaderThread = null;
            } else {
                try {
                    BufferedReader reader = readerThread.myReader;
                    while (reader.ready()) {
                        this.addMessage(reader.readLine());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stopRunning(false);
            }
        }
    }

    protected void addMessage(String text) {
        Key key;
        if (this.myDisposed) {
            return;
        }
        if (text == null) {
            return;
        }
        LogFilterModel.MyProcessingResult processingResult = this.myModel.processLine(text);
        if (processingResult.isApplicable() && (key = processingResult.getKey()) != null) {
            String messagePrefix = processingResult.getMessagePrefix();
            if (messagePrefix != null) {
                String formattedPrefix = this.myFormatter.formatPrefix(messagePrefix);
                this.myProcessHandler.notifyTextAvailable(formattedPrefix, key);
            }
            String formattedMessage = this.myFormatter.formatMessage(text);
            this.myProcessHandler.notifyTextAvailable(formattedMessage + "\n", key);
        }
        if (this.myLogLines.isEmpty() && this.getEditor() != null) {
            this.myLogLines.add(this.getEditor().getDocument().getText());
            this.myCurrentLogLength = this.myLogLines.getFirst().length();
        }
        if (ConsoleBuffer.useCycleBuffer()) {
            if (text.length() > ConsoleBuffer.getCycleBufferSize()) {
                String cutText = text.substring(text.length() - ConsoleBuffer.getCycleBufferSize());
                this.myLogLines.clear();
                this.myLogLines.add(cutText);
                this.myCurrentLogLength = cutText.length();
                return;
            }
            while (this.myCurrentLogLength + text.length() > ConsoleBuffer.getCycleBufferSize() && !this.myLogLines.isEmpty()) {
                this.myCurrentLogLength -= this.myLogLines.removeFirst().length();
            }
        }
        this.myLogLines.add(text);
        this.myCurrentLogLength += text.length();
    }

    public void attachStopLogConsoleTrackingListener(final ProcessHandler process2) {
        if (process2 != null) {
            ProcessListener stopListener = new ProcessListener(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    process2.removeProcessListener((ProcessListener)this);
                    if (EDT.isCurrentThreadEdt()) {
                        WriteIntentReadAction.run(() -> LogConsoleBase.this.stopRunning(true));
                    } else {
                        ApplicationManager.getApplication().invokeAndWait(() -> LogConsoleBase.this.stopRunning(true), ModalityState.any());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/logging/LogConsoleBase$4", "processTerminated"));
                }
            };
            process2.addProcessListener(stopListener);
        }
    }

    @Deprecated
    @Nullable
    public StringBuffer getOriginalDocument() {
        return null;
    }

    @Nullable
    private Editor getEditor() {
        ConsoleView console = this.getConsole();
        if (console == null) {
            return null;
        }
        DataContext dataContext = DataManager.getInstance().customizeDataContext(DataContext.EMPTY_CONTEXT, (Object)console);
        return (Editor)CommonDataKeys.EDITOR.getData(dataContext);
    }

    protected void filterConsoleOutput() {
        ApplicationManager.getApplication().invokeLater(() -> this.computeSelectedLineAndFilter());
    }

    private void computeSelectedLineAndFilter() {
        Editor editor = this.getEditor();
        LOG.assertTrue(editor != null);
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        this.myLineUnderSelection = null;
        this.myLineOffset = -1;
        if (caretOffset > -1 && caretOffset < document.getTextLength()) {
            int line;
            try {
                line = document.getLineNumber(caretOffset);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("document.length=" + document.getTextLength() + ", caret offset = " + caretOffset + "; " + e.getMessage(), e);
            }
            if (line > -1 && line < document.getLineCount()) {
                int startOffset = document.getLineStartOffset(line);
                this.myLineUnderSelection = document.getText().substring(startOffset, document.getLineEndOffset(line));
                this.myLineOffset = caretOffset - startOffset;
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.doFilter());
    }

    private void doFilter() {
        if (this.myDisposed) {
            return;
        }
        ConsoleView console = this.getConsoleNotNull();
        console.clear();
        this.myModel.processingStarted();
        int offset = 0;
        boolean caretPositioned = false;
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        for (String line : this.myLogLines) {
            int printed = this.printMessageToConsole(line, (text, key) -> decoder.escapeText(text, key, (chunk, attributes) -> console.print(chunk, ConsoleViewContentType.getConsoleViewType((Key)attributes))));
            if (printed <= 0 || caretPositioned) continue;
            if (Comparing.strEqual((String)this.myLineUnderSelection, (String)line)) {
                caretPositioned = true;
                offset += this.myLineOffset != -1 ? this.myLineOffset : 0;
                continue;
            }
            offset += printed;
        }
        if (caretPositioned) {
            console.scrollTo(offset);
        } else {
            console.requestScrollingToEnd();
        }
    }

    private int printMessageToConsole(@NotNull String line, @NotNull BiConsumer<? super String, ? super Key> printer) {
        Key key;
        LogFilterModel.MyProcessingResult processingResult;
        if (line == null) {
            LogConsoleBase.$$$reportNull$$$0(10);
        }
        if (printer == null) {
            LogConsoleBase.$$$reportNull$$$0(11);
        }
        if ((processingResult = this.myModel.processLine(line)).isApplicable() && (key = processingResult.getKey()) != null) {
            String messagePrefix = processingResult.getMessagePrefix();
            if (messagePrefix != null) {
                printer.accept(this.myFormatter.formatPrefix(messagePrefix), (Key)key);
            }
            printer.accept(this.myFormatter.formatMessage(line) + "\n", (Key)key);
            return (messagePrefix != null ? messagePrefix.length() : 0) + line.length() + 1;
        }
        return 0;
    }

    @Nullable
    public ConsoleView getConsole() {
        return this.myConsole;
    }

    @NotNull
    public ConsoleView getConsoleNotNull() {
        ConsoleView console = this.getConsole();
        assert (console != null) : "it looks like console has been disposed";
        ConsoleView consoleView = console;
        if (consoleView == null) {
            LogConsoleBase.$$$reportNull$$$0(12);
        }
        return consoleView;
    }

    public ActionGroup getToolbarActions() {
        return this.getOrCreateActions();
    }

    public String getToolbarPlace() {
        return "unknown";
    }

    @Nullable
    public JComponent getToolbarContextComponent() {
        ConsoleView console = this.getConsole();
        return console == null ? null : console.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.getConsoleNotNull().getPreferredFocusableComponent();
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void clear() {
        this.getConsoleNotNull().clear();
        this.myLogLines.clear();
    }

    public JComponent getSearchComponent() {
        this.myLogFilterCombo.setModel(new DefaultComboBoxModel<LogFilter>(this.myFilters.toArray(new LogFilter[0])));
        this.resetLogFilter();
        this.myLogFilterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final LogFilter filter = (LogFilter)LogConsoleBase.this.myLogFilterCombo.getSelectedItem();
                Task.Backgroundable task2 = new Task.Backgroundable(LogConsoleBase.this.myProject, LogConsoleBase.getApplyingFilterTitle()){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LogConsoleBase.this.myModel.selectFilter(filter);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/logging/LogConsoleBase$5$1", "run"));
                    }
                };
                ProgressManager.getInstance().run((Task)task2);
            }
        });
        AccessibleContextUtil.setName(this.myLogFilterCombo, (String)ExecutionBundle.message((String)"log.filter.combo.accessible.name", (Object[])new Object[0]));
        this.myTextFilterWrapper.removeAll();
        this.myTextFilterWrapper.add(this.getTextFilterComponent());
        return this.mySearchComponent;
    }

    private void resetLogFilter() {
        for (LogFilter logFilter : this.myFilters) {
            if (!this.myModel.isFilterSelected(logFilter) || this.myLogFilterCombo.getSelectedItem() == logFilter) continue;
            this.myLogFilterCombo.setSelectedItem(logFilter);
            break;
        }
    }

    @NotNull
    protected Component getTextFilterComponent() {
        FilterComponent filterComponent = this.myFilter;
        if (filterComponent == null) {
            LogConsoleBase.$$$reportNull$$$0(13);
        }
        return filterComponent;
    }

    public boolean isContentBuiltIn() {
        return this.myBuildInActions;
    }

    public void writeToConsole(String text, Key outputType) {
        this.myProcessHandler.notifyTextAvailable(text, outputType);
    }

    public void addListener(LogConsoleListener listener2) {
        this.myListeners.add(listener2);
    }

    private void fireLoggingWillBeStopped() {
        for (LogConsoleListener listener2 : this.myListeners) {
            listener2.loggingWillBeStopped();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/logging/LogConsoleBase";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchComponent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyingFilterTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/logging/LogConsoleBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleNotNull";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFilterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onFilterStateChange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSearchFilter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printMessageToConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private static final class LightProcessHandler
    extends ProcessHandler {
        private final AnsiEscapeDecoder myDecoder = new AnsiEscapeDecoder();

        private LightProcessHandler() {
        }

        public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                LightProcessHandler.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                LightProcessHandler.$$$reportNull$$$0(1);
            }
            this.myDecoder.escapeText(text, outputType, (chunk, attributes) -> super.notifyTextAvailable(chunk, attributes));
        }

        protected void destroyProcessImpl() {
            throw new UnsupportedOperationException();
        }

        protected void detachProcessImpl() {
            throw new UnsupportedOperationException();
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diagnostic/logging/LogConsoleBase$LightProcessHandler";
            objectArray[2] = "notifyTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ReaderThread
    implements Runnable {
        private BufferedReader myReader;
        private boolean myRunning = false;
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)LogConsoleBase.this);

        ReaderThread(Reader reader) {
            this.myReader = reader != null ? new BufferedReader(reader) : null;
        }

        @Override
        public void run() {
            if (this.myReader == null) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ReaderThread.this.myRunning) {
                        try {
                            ReaderThread.this.myReader = LogConsoleBase.this.updateReaderIfNeeded(ReaderThread.this.myReader);
                            int i = 0;
                            while (i++ < 1000) {
                                BufferedReader reader = ReaderThread.this.myReader;
                                if (ReaderThread.this.myRunning && reader != null && reader.ready()) {
                                    LogConsoleBase.this.addMessage(reader.readLine());
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                            LogConsoleBase.this.addMessage("I/O Error" + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""));
                            return;
                        }
                    }
                    if (ReaderThread.this.myAlarm.isDisposed()) {
                        return;
                    }
                    ReaderThread.this.myAlarm.addRequest((Runnable)this, 100);
                }
            };
            if (this.myAlarm.isDisposed()) {
                return;
            }
            this.myAlarm.addRequest(runnable, 10);
        }

        public void startRunning() {
            this.myRunning = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            this.myRunning = false;
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                this.notifyAll();
            }
        }
    }

    private static final class ConsoleWithFloatingToolbar
    extends JBLayeredPane {
        private static final int TOP_OFFSET = 25;
        private static final int RIGHT_OFFSET = 20;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final FloatingToolbar myFloatingToolbar;

        private ConsoleWithFloatingToolbar(@NotNull JComponent component, @NotNull ActionGroup actions, @NotNull Disposable disposable) {
            if (component == null) {
                ConsoleWithFloatingToolbar.$$$reportNull$$$0(0);
            }
            if (actions == null) {
                ConsoleWithFloatingToolbar.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                ConsoleWithFloatingToolbar.$$$reportNull$$$0(2);
            }
            this.myComponent = component;
            this.myFloatingToolbar = new FloatingToolbar(component, actions, disposable);
            this.add(this.myComponent, JLayeredPane.DEFAULT_LAYER);
            this.add((Component)this.myFloatingToolbar, JLayeredPane.POPUP_LAYER);
        }

        public void doLayout() {
            Rectangle bounds = this.getBounds();
            this.myComponent.setBounds(0, 0, bounds.width, bounds.height);
            Dimension toolbarSize = this.myFloatingToolbar.getPreferredSize();
            this.myFloatingToolbar.setBounds(bounds.width - toolbarSize.width - 20, 25 - (toolbarSize.height - ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height) / 2, toolbarSize.width, toolbarSize.height);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diagnostic/logging/LogConsoleBase$ConsoleWithFloatingToolbar";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ToggleSearchFilterAction
    extends ToggleAction
    implements CustomComponentAction {
        ToggleSearchFilterAction() {
            super(() -> ExecutionBundle.message((String)"log.toggle.filter.component", (Object[])new Object[0]), (Icon)new LayeredIcon(new Icon[]{AllIcons.General.Filter, null}));
        }

        @NotNull
        protected abstract JComponent getSearchFilterComponent();

        protected boolean isModified(@NotNull JComponent component) {
            if (component == null) {
                ToggleSearchFilterAction.$$$reportNull$$$0(0);
            }
            return false;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleSearchFilterAction.$$$reportNull$$$0(1);
            }
            return Toggleable.isSelected((Presentation)e.getPresentation());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleSearchFilterAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleSearchFilterAction.$$$reportNull$$$0(3);
            }
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)state);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                ToggleSearchFilterAction.$$$reportNull$$$0(4);
            }
            if (place == null) {
                ToggleSearchFilterAction.$$$reportNull$$$0(5);
            }
            ActionButton button = new ActionButton((AnAction)this, presentation, "LogSearchFilterToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            NonOpaquePanel panel2 = new NonOpaquePanel();
            panel2.setBorder((Border)new JBEmptyBorder(0, 2, 0, 2));
            panel2.setLayout((LayoutManager)new HorizontalLayout(4, 0));
            panel2.add((Component)this.getSearchFilterComponent());
            panel2.add((Component)new FlowLayoutWrapper((JComponent)button));
            NonOpaquePanel nonOpaquePanel = panel2;
            if (nonOpaquePanel == null) {
                ToggleSearchFilterAction.$$$reportNull$$$0(6);
            }
            return nonOpaquePanel;
        }

        public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
            if (component == null) {
                ToggleSearchFilterAction.$$$reportNull$$$0(7);
            }
            if (presentation == null) {
                ToggleSearchFilterAction.$$$reportNull$$$0(8);
            }
            component.setVisible(presentation.isVisible());
            component.setEnabled(presentation.isEnabled());
            this.getSearchFilterComponent().setVisible(Toggleable.isSelected((Presentation)presentation));
            Icon icon = presentation.getIcon();
            if (icon instanceof LayeredIcon && ((LayeredIcon)icon).getIconCount() == 2) {
                ((LayeredIcon)icon).setIcon(this.isModified(component) ? AllIcons.Nodes.TabAlert : null, 1);
                presentation.setIcon(icon);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/logging/LogConsoleBase$ToggleSearchFilterAction";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/logging/LogConsoleBase$ToggleSearchFilterAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isModified";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateCustomComponent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 6 -> new IllegalStateException(string);
            };
        }
    }
}

