/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DisplayDescriptorChooser;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a \u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u00a8\u0006\u000b"}, d2={"getStoppableDescriptors", "", "Lkotlin/Pair;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "project", "Lcom/intellij/openapi/project/Project;", "chooseDisplayDescriptor", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "descriptors", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nStoppableRunDescriptors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoppableRunDescriptors.kt\ncom/intellij/execution/StoppableRunDescriptorsKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n382#2,7:108\n382#2,7:116\n13#3:115\n1563#4:123\n1634#4,3:124\n1563#4:127\n1634#4,3:128\n*S KotlinDebug\n*F\n+ 1 StoppableRunDescriptors.kt\ncom/intellij/execution/StoppableRunDescriptorsKt\n*L\n35#1:108,7\n46#1:116,7\n44#1:115\n55#1:123\n55#1:124,3\n61#1:127\n61#1:128,3\n*E\n"})
public final class StoppableRunDescriptorsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<RunContentDescriptor, RunnerAndConfigurationSettings>> getStoppableDescriptors(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        ExecutionEnvironment env;
        Object value$iv;
        Object object;
        Set<ExecutionEnvironment> envs;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExecutionManagerImpl executionManagerImpl = ExecutionManagerImpl.Companion.getInstanceIfCreated(project);
        if (executionManagerImpl == null) {
            return CollectionsKt.emptyList();
        }
        ExecutionManagerImpl manager = executionManagerImpl;
        List allDescriptors = CollectionsKt.asReversed(ExecutionManagerImpl.Companion.getAllDescriptors(project));
        Map map = new LinkedHashMap();
        List list = new ArrayList();
        Object object2 = allDescriptors.iterator();
        while (object2.hasNext()) {
            Object object3;
            void $this$getOrPut$iv;
            ProcessHandler processHandler;
            RunContentDescriptor descriptor = (RunContentDescriptor)object2.next();
            if (descriptor.getProcessHandler() == null || processHandler.isProcessTerminated()) continue;
            envs = manager.getExecutionEnvironments(descriptor);
            if (envs.size() == 0) {
                List extensions = DisplayDescriptorChooser.Companion.getEP_NAME().getExtensionList();
                ExecutionEnvironment chosenEnv = null;
                for (DisplayDescriptorChooser extension : extensions) {
                    Object object4;
                    void $this$getOrPut$iv2;
                    chosenEnv = extension.getExecutionEnvironment(descriptor);
                    if (chosenEnv == null) continue;
                    object = map;
                    ExecutionEnvironment key$iv = chosenEnv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv2 = $this$getOrPut$iv2.get(key$iv);
                    if (value$iv2 == null) {
                        boolean bl = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(key$iv, answer$iv);
                        object4 = answer$iv;
                    } else {
                        object4 = value$iv2;
                    }
                    ((List)object4).add(descriptor);
                }
                if (chosenEnv != null) continue;
                list.add(descriptor);
                continue;
            }
            if (envs.size() > 1) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ExecutionManagerImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Multiple execution environments for given run content descriptor: " + descriptor.getDisplayName());
            }
            Map $i$f$logger = map;
            Object key$iv = CollectionsKt.first((Iterable)envs);
            boolean $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            ((List)object3).add(descriptor);
        }
        Object $this$getStoppableDescriptors_u24lambda_u242 = object2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            List descriptors;
            env = (ExecutionEnvironment)entry.getKey();
            RunContentDescriptor chosenDescriptor = StoppableRunDescriptorsKt.chooseDisplayDescriptor(env, descriptors = (List)entry.getValue());
            if (chosenDescriptor == null) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                value$iv = descriptors;
                object = $this$getStoppableDescriptors_u24lambda_u242;
                boolean $i$f$map = false;
                void $i$f$getOrPut = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    RunContentDescriptor runContentDescriptor2 = (RunContentDescriptor)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(TuplesKt.to((Object)it, null));
                }
                object.addAll((List)destination$iv$iv);
                continue;
            }
            $this$getStoppableDescriptors_u24lambda_u242.add(TuplesKt.to((Object)chosenDescriptor, (Object)env.getRunnerAndConfigurationSettings()));
        }
        envs = list;
        object = $this$getStoppableDescriptors_u24lambda_u242;
        boolean $i$f$map = false;
        env = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RunContentDescriptor $this$mapTo$iv$iv2 = (RunContentDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(TuplesKt.to((Object)it, null));
        }
        object.addAll((List)destination$iv$iv);
        return CollectionsKt.build((List)object2);
    }

    private static final RunContentDescriptor chooseDisplayDescriptor(ExecutionEnvironment env, List<? extends RunContentDescriptor> descriptors) {
        List extensions = DisplayDescriptorChooser.Companion.getEP_NAME().getExtensionList();
        for (DisplayDescriptorChooser extension : extensions) {
            RunContentDescriptor descriptor = extension.chooseDescriptor(descriptors, env);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }
}

