/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ExecutorAction;
import com.intellij.execution.actions.RunConfigurationsComboBoxAction;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunConfigurableKt;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditConfigurationsDialog
extends SingleConfigurableEditor {
    private static final Logger LOG = Logger.getInstance(EditConfigurationsDialog.class);
    protected Executor myExecutor;
    @NotNull
    private final Project myProject;
    @Nullable
    private Action myRunAction;
    private final List<AnAction> myExecutorActions;
    @Nullable
    private final DataContext myDataContext;

    public EditConfigurationsDialog(@NotNull Project project) {
        if (project == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(0);
        }
        this(project, (DataContext)null);
    }

    public EditConfigurationsDialog(@NotNull Project project, @Nullable DataContext dataContext) {
        if (project == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(1);
        }
        this(project, RunConfigurableKt.createRunConfigurationConfigurable(project), null, dataContext);
    }

    public EditConfigurationsDialog(@NotNull Project project, @NotNull RunConfigurable configurable, @Nullable DataContext dataContext) {
        if (project == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(2);
        }
        if (configurable == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(3);
        }
        this(project, configurable, null, dataContext);
    }

    public EditConfigurationsDialog(@NotNull Project project, @Nullable ConfigurationFactory factory) {
        if (project == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(4);
        }
        this(project, RunConfigurableKt.createRunConfigurationConfigurable(project), factory, null);
    }

    private EditConfigurationsDialog(@NotNull Project project, @NotNull RunConfigurable runConfigurable, @Nullable ConfigurationFactory factory, @Nullable DataContext dataContext) {
        if (project == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(5);
        }
        if (runConfigurable == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(6);
        }
        super(project, (Configurable)runConfigurable, "#com.intellij.execution.impl.EditConfigurationsDialog", DialogWrapper.IdeModalityType.IDE);
        this.myExecutorActions = new ArrayList<AnAction>();
        this.myProject = project;
        this.myDataContext = dataContext;
        this.getConfigurable().getTree().registerKeyboardAction(event -> this.clickDefaultButton(), KeyStroke.getKeyStroke(10, 0), 0);
        this.getConfigurable().setDialogUpdateCallback(() -> this.updateDialog());
        this.getConfigurable().initTreeSelectionListener(this.getDisposable());
        this.setTitle(ExecutionBundle.message((String)"run.debug.dialog.title", (Object[])new Object[0]));
        this.setHorizontalStretch(1.3f);
        RunnerAndConfigurationSettings initial = null;
        if (factory != null) {
            this.addRunConfiguration(factory);
        } else {
            this.getConfigurable().selectConfigurableOnShow();
            initial = this.getConfigurable().getInitialSelectedConfiguration();
        }
        this.updateSelectedExecutor(initial);
    }

    public RunConfigurable getConfigurable() {
        return (RunConfigurable)super.getConfigurable();
    }

    private void addRunConfiguration(@NotNull ConfigurationFactory factory) {
        if (factory == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(7);
        }
        final RunConfigurable configurable = this.getConfigurable();
        final SingleConfigurationConfigurable<RunConfiguration> configuration = configurable.createNewConfiguration(factory);
        if (!this.isVisible()) {
            this.getContentPanel().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    configurable.updateRightPanel((Configurable)configuration);
                    EditConfigurationsDialog.this.getContentPanel().removeComponentListener(this);
                }
            });
        }
    }

    protected void doOKAction() {
        RunConfigurable configurable = this.getConfigurable();
        super.doOKAction();
        if (this.isOK()) {
            configurable.updateActiveConfigurationFromSelected();
        }
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(8);
        }
        return dialogStyle;
    }

    protected Action @NotNull [] createActions() {
        Object[] actions = super.createActions();
        if (this.myExecutor != null) {
            if (actions == null) {
                EditConfigurationsDialog.$$$reportNull$$$0(9);
            }
            return actions;
        }
        this.myRunAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleConfigurationConfigurable<RunConfiguration> selected = EditConfigurationsDialog.this.getConfigurable().getSelectedConfiguration();
                LOG.assertTrue(selected != null, (Object)"No configuration selected");
                LOG.assertTrue(EditConfigurationsDialog.this.myExecutor != null, (Object)"No executor selected");
                ExecutorRegistryImpl.RunnerHelper.run(EditConfigurationsDialog.this.myProject, selected.getConfiguration(), (RunnerAndConfigurationSettings)selected.getSettings(), Objects.requireNonNull(EditConfigurationsDialog.this.myDataContext), EditConfigurationsDialog.this.myExecutor);
                EditConfigurationsDialog.this.doOKAction();
            }
        };
        this.myRunAction.putValue("MacActionOrder", -100);
        Action[] actionArray = (Action[])ArrayUtil.prepend((Object)this.myRunAction, (Object[])actions);
        if (actionArray == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(10);
        }
        return actionArray;
    }

    protected JButton createJButtonForAction(Action action) {
        if (action == this.myRunAction) {
            JBOptionButton button = new JBOptionButton(action, null);
            button.setHideDisabledOptions(true);
            button.setAddSeparator(false);
            button.setOptionTooltipText(JBOptionButton.getDefaultTooltip());
            button.setIconTextGap(JBUI.CurrentTheme.ActionsList.elementIconGap());
            return button;
        }
        return super.createJButtonForAction(action);
    }

    private void updateSelectedExecutor(@Nullable RunnerAndConfigurationSettings selected) {
        if (this.myRunAction == null) {
            return;
        }
        Executor executor = null;
        if (selected != null) {
            executor = ExecutionManagerImpl.getInstance(this.myProject).getRecentExecutor(selected);
        }
        if (executor == null && (executor = ExecutorRegistry.getInstance().getExecutorById("Run")) != null && selected != null && !this.canRun(selected, executor) && (executor = ExecutorRegistry.getInstance().getExecutorById("Debug")) != null && !this.canRun(selected, executor)) {
            executor = null;
        }
        this.updateRunButton(executor, selected);
    }

    private boolean canRun(@Nullable RunnerAndConfigurationSettings settings, Executor executor) {
        return settings != null && ExecutorRegistryImpl.RunnerHelper.canRun(this.myProject, executor, settings.getConfiguration());
    }

    private void updateRunButton(@Nullable Executor executor, @Nullable RunnerAndConfigurationSettings selected) {
        this.myExecutor = executor;
        JBOptionButton button = (JBOptionButton)Objects.requireNonNull(this.getButton(Objects.requireNonNull(this.myRunAction)));
        button.setVisible(executor != null && this.myDataContext != null);
        button.setEnabled(executor != null && this.myDataContext != null);
        if (executor != null) {
            this.myRunAction.putValue("Name", executor.getActionName());
            button.setText(executor.getActionName());
            button.setIcon(executor.getIcon());
            this.myExecutorActions.forEach(action -> action.unregisterCustomShortcutSet(this.getContentPanel()));
            this.myExecutorActions.clear();
            if (selected == null) {
                return;
            }
            ArrayList actions = new ArrayList();
            RunConfigurationsComboBoxAction.forAllExecutors(o -> {
                if (o != executor) {
                    actions.add(this.createAction(selected, (Executor)o));
                }
            });
            button.setOptions(actions);
            ExecutorAction action2 = this.createAction(selected, executor);
            Object tooltip = UIUtil.removeMnemonic((String)executor.getStartActionText(selected.getName()));
            String actionShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2);
            if (!actionShortcut.isEmpty()) {
                tooltip = (String)tooltip + " (" + actionShortcut + ")";
            }
            button.setToolTipText((String)tooltip);
        }
    }

    @NotNull
    private ExecutorAction createAction(final @NotNull RunnerAndConfigurationSettings selected, final @NotNull Executor executor) {
        if (selected == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(11);
        }
        if (executor == null) {
            EditConfigurationsDialog.$$$reportNull$$$0(12);
        }
        return new ExecutorAction(executor){
            {
                super(executor3);
                AnAction action = ActionManager.getInstance().getAction(executor.getId());
                if (action != null) {
                    this.setShortcutSet(action.getShortcutSet());
                    this.registerCustomShortcutSet(EditConfigurationsDialog.this.getContentPanel(), null);
                }
                EditConfigurationsDialog.this.myExecutorActions.add(this);
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.run(EditConfigurationsDialog.this.myProject, selected, Objects.requireNonNull(EditConfigurationsDialog.this.myDataContext));
                EditConfigurationsDialog.this.doOKAction();
            }

            @Override
            protected RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                return selected;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/execution/impl/EditConfigurationsDialog$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getSelectedConfiguration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void updateDialog() {
        if (this.myExecutor != null && this.myRunAction == null) {
            this.updateDialogForSingleExecutor();
        } else {
            SingleConfigurationConfigurable<RunConfiguration> configurable = this.getConfigurable().getSelectedConfiguration();
            this.updateSelectedExecutor(configurable == null ? null : (RunnerAndConfigurationSettings)configurable.getSettings());
        }
    }

    private void updateDialogForSingleExecutor() {
        @Nls StringBuilder buffer = new StringBuilder();
        buffer.append(this.myExecutor.getId());
        SingleConfigurationConfigurable<RunConfiguration> configuration = this.getConfigurable().getSelectedConfiguration();
        if (configuration != null) {
            buffer.append(" - ");
            buffer.append(configuration.getNameText());
            ReadAction.nonBlocking(() -> this.canRun((RunnerAndConfigurationSettings)configuration.getSettings(), this.myExecutor)).finishOnUiThread(ModalityState.current(), b -> this.setOKActionEnabled((boolean)b)).expireWith(this.getDisposable()).submit((java.util.concurrent.Executor)AppExecutorUtil.getAppExecutorService());
        }
        this.setTitle(buffer.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/EditConfigurationsDialog";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/EditConfigurationsDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRunConfiguration";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

