/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfigurationVcsSupport;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.UriUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class RunConfigurationStorageUi {
    private static final Logger LOG = Logger.getInstance(RunConfigurationStorageUi.class);
    private static final Icon GEAR_WITH_DROPDOWN_ICON = LayeredIcon.layeredIcon(() -> new Icon[]{AllIcons.General.GearPlain, AllIcons.General.Dropdown});
    private static final Icon GEAR_WITH_DROPDOWN_DISABLED_ICON = LayeredIcon.layeredIcon(() -> new Icon[]{IconLoader.getDisabledIcon((Icon)AllIcons.General.GearPlain), IconLoader.getDisabledIcon((Icon)AllIcons.General.Dropdown)});
    private static final Icon GEAR_WITH_DROPDOWN_ERROR_ICON = LayeredIcon.layeredIcon(() -> new Icon[]{AllIcons.General.Error, AllIcons.General.Dropdown});
    private final JBCheckBox myStoreAsFileCheckBox;
    private final ActionButton myStoreAsFileGearButton;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Runnable myOnModifiedRunnable;
    private RCStorageType myRCStorageTypeInitial;
    @Nullable
    private @SystemIndependent @NonNls String myFolderPathIfStoredInArbitraryFileInitial;
    private RCStorageType myRCStorageType;
    @Nullable
    private @SystemIndependent @NonNls String myFolderPathIfStoredInArbitraryFile;
    @Nullable
    private Boolean myDotIdeaStorageVcsIgnored;

    public RunConfigurationStorageUi(@NotNull Project project, @Nullable Runnable onModifiedRunnable) {
        if (project == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(0);
        }
        this.myDotIdeaStorageVcsIgnored = null;
        if (project.isDefault()) {
            LOG.error("Don't use RunConfigurationStorageUi for default project");
        }
        this.myProject = project;
        this.myOnModifiedRunnable = onModifiedRunnable;
        this.myStoreAsFileCheckBox = new JBCheckBox(ExecutionBundle.message((String)"run.configuration.store.as.project.file", (Object[])new Object[0]));
        this.myStoreAsFileGearButton = this.createStoreAsFileGearButton();
        this.myStoreAsFileCheckBox.addActionListener(e -> {
            if (this.myStoreAsFileCheckBox.isSelected()) {
                this.setStorageTypeAndPathToTheBestPossibleState();
            } else {
                this.myRCStorageType = RCStorageType.Workspace;
                this.myFolderPathIfStoredInArbitraryFile = null;
            }
            if (this.myOnModifiedRunnable != null) {
                this.myOnModifiedRunnable.run();
            }
            this.myStoreAsFileGearButton.setEnabled(this.myStoreAsFileCheckBox.isSelected());
            if (this.myStoreAsFileCheckBox.isSelected()) {
                this.manageStorageFileLocation(null);
            }
        });
    }

    @NotNull
    private ActionButton createStoreAsFileGearButton() {
        final PopupState state = PopupState.forBalloon();
        DumbAwareAction showStoragePathAction = new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!state.isRecentlyHidden()) {
                    RunConfigurationStorageUi.this.manageStorageFileLocation((PopupState<Balloon>)state);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/RunConfigurationStorageUi$1", "actionPerformed"));
            }
        };
        Presentation presentation = new Presentation(ExecutionBundle.message((String)"run.configuration.manage.file.location", (Object[])new Object[0]));
        presentation.setIcon(GEAR_WITH_DROPDOWN_ICON);
        presentation.setDisabledIcon(GEAR_WITH_DROPDOWN_DISABLED_ICON);
        return new ActionButton((AnAction)showStoragePathAction, presentation, "toolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    private void manageStorageFileLocation(@Nullable PopupState<Balloon> state) {
        final Disposable balloonDisposable = Disposer.newDisposable();
        Function pathToErrorMessage = path -> RunConfigurationStorageUi.getErrorIfBadFolderPathForStoringInArbitraryFile(this.myProject, path);
        final RunConfigurationStoragePopup popup = new RunConfigurationStoragePopup(this.myProject, RunConfigurationStorageUi.getDotIdeaStoragePath(this.myProject), (Function<? super String, String>)pathToErrorMessage, balloonDisposable);
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)popup.getMainPanel()).setDialogMode(true).setBorderInsets((Insets)JBUI.insets((int)20, (int)15, (int)10, (int)15)).setFillColor(UIUtil.getPanelBackground()).setHideOnAction(false).setHideOnLinkClick(false).setHideOnKeyOutside(false).setBlockClicksThroughBalloon(true).setRequestFocus(true).createBalloon();
        balloon.setAnimationEnabled(false);
        final String path2 = this.myRCStorageType == RCStorageType.DotIdeaFolder ? RunConfigurationStorageUi.getDotIdeaStoragePath(this.myProject) : StringUtil.notNullize((String)this.myFolderPathIfStoredInArbitraryFile);
        LinkedHashSet<String> pathsToSuggest = new LinkedHashSet<String>();
        if (RunConfigurationStorageUi.getErrorIfBadFolderPathForStoringInArbitraryFile(this.myProject, path2) == null) {
            pathsToSuggest.add(path2);
        }
        if (this.myRCStorageTypeInitial == RCStorageType.ArbitraryFileInProject && this.myFolderPathIfStoredInArbitraryFileInitial != null) {
            pathsToSuggest.add(this.myFolderPathIfStoredInArbitraryFileInitial);
        }
        pathsToSuggest.add(RunConfigurationStorageUi.getDotIdeaStoragePath(this.myProject));
        pathsToSuggest.addAll(RunConfigurationStorageUi.getFolderPathsWithinProjectWhereRunConfigurationsStored(this.myProject));
        popup.reset(path2, pathsToSuggest, () -> balloon.hide());
        balloon.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)balloonDisposable);
                String newPath = popup.getPath();
                if (!newPath.equals(path2)) {
                    RunConfigurationStorageUi.this.applyChangedStoragePath(newPath);
                    if (RunConfigurationStorageUi.this.myOnModifiedRunnable != null) {
                        RunConfigurationStorageUi.this.myOnModifiedRunnable.run();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/RunConfigurationStorageUi$2", "onClosed"));
            }
        });
        if (state != null) {
            state.prepareToShow((Object)balloon);
        }
        balloon.show(RelativePoint.getSouthOf((JComponent)this.myStoreAsFileCheckBox), Balloon.Position.below);
    }

    private void applyChangedStoragePath(String newPath) {
        if (newPath.equals(RunConfigurationStorageUi.getDotIdeaStoragePath(this.myProject))) {
            this.myRCStorageType = RCStorageType.DotIdeaFolder;
            this.myFolderPathIfStoredInArbitraryFile = null;
        } else {
            this.myRCStorageType = RCStorageType.ArbitraryFileInProject;
            this.myFolderPathIfStoredInArbitraryFile = newPath;
        }
        this.validatePath();
    }

    private void validatePath() {
        ReadAction.nonBlocking(this::checkPathAndGetErrorIcon).expireWhen(() -> !this.myStoreAsFileGearButton.isShowing()).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> ((ActionButton)this.myStoreAsFileGearButton).setIcon(arg_0)).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private Icon checkPathAndGetErrorIcon() {
        if (this.myStoreAsFileCheckBox.isSelected() && this.myRCStorageType == RCStorageType.ArbitraryFileInProject && RunConfigurationStorageUi.getErrorIfBadFolderPathForStoringInArbitraryFile(this.myProject, this.myFolderPathIfStoredInArbitraryFile) != null) {
            return GEAR_WITH_DROPDOWN_ERROR_ICON;
        }
        return GEAR_WITH_DROPDOWN_ICON;
    }

    @NonNls
    @NotNull
    private static String getFileNameByRCName(@NotNull String rcName) {
        if (rcName == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(1);
        }
        String string = (String)Scheme_implKt.getMODERN_NAME_CONVERTER().invoke((Object)rcName) + ".run.xml";
        if (string == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Contract(value="_,null -> !null")
    @Nullable
    private static String getErrorIfBadFolderPathForStoringInArbitraryFile(@NotNull Project project, @Nullable @NonNls @SystemIndependent String path) {
        boolean isInContent;
        if (project == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(3);
        }
        if (RunConfigurationStorageUi.getDotIdeaStoragePath(project).equals(path)) {
            return null;
        }
        if (StringUtil.isEmpty((String)path)) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.path.not.specified", (Object[])new Object[0]);
        }
        if (path.endsWith("/.idea") || path.contains("/.idea/")) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.dot.idea.forbidden", (Object[])new Object[]{File.separator});
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file != null && !file.isDirectory()) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.path.expected", (Object[])new Object[0]);
        }
        String folderName = PathUtil.getFileName((String)path);
        String parentPath = PathUtil.getParentPath((String)path);
        while (file == null && !parentPath.isEmpty()) {
            if (!PathUtil.isValidFileName((String)folderName)) {
                return ExecutionBundle.message((String)"run.configuration.storage.folder.path.expected", (Object[])new Object[0]);
            }
            file = LocalFileSystem.getInstance().findFileByPath(parentPath);
            folderName = PathUtil.getFileName((String)parentPath);
            parentPath = PathUtil.getParentPath((String)parentPath);
        }
        if (file == null) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.not.within.project", (Object[])new Object[0]);
        }
        if (!file.isDirectory()) {
            return ExecutionBundle.message((String)"run.configuration.storage.folder.path.expected", (Object[])new Object[0]);
        }
        boolean bl = isInContent = WorkspaceFileIndex.getInstance((Project)project).isUrlInContent(VfsUtilCore.pathToUrl((String)path)) != ThreeState.NO;
        if (!isInContent) {
            if (ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file, false) == null) {
                return ExecutionBundle.message((String)"run.configuration.storage.folder.not.within.project", (Object[])new Object[0]);
            }
            return ExecutionBundle.message((String)"run.configuration.storage.folder.in.excluded.root", (Object[])new Object[0]);
        }
        return null;
    }

    @NonNls
    @NotNull
    private static String getDotIdeaStoragePath(@NotNull Project project) {
        if (project == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(4);
        }
        String string = ProjectKt.isDirectoryBased((Project)project) ? RunManagerImpl.getInstanceImpl(project).getDotIdeaRunConfigurationsPath$intellij_platform_execution_impl() : StringUtil.notNullize((String)project.getProjectFilePath());
        if (string == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void setStorageTypeAndPathToTheBestPossibleState() {
        VirtualFile baseDir;
        if (this.myRCStorageTypeInitial == RCStorageType.DotIdeaFolder) {
            this.myRCStorageType = RCStorageType.DotIdeaFolder;
            this.myFolderPathIfStoredInArbitraryFile = null;
            return;
        }
        if (this.myRCStorageTypeInitial == RCStorageType.ArbitraryFileInProject) {
            this.myRCStorageType = RCStorageType.ArbitraryFileInProject;
            this.myFolderPathIfStoredInArbitraryFile = StringUtil.notNullize((String)this.myFolderPathIfStoredInArbitraryFileInitial);
            return;
        }
        if (!ProjectKt.isDirectoryBased((Project)this.myProject)) {
            this.myRCStorageType = RCStorageType.DotIdeaFolder;
            this.myFolderPathIfStoredInArbitraryFile = null;
            return;
        }
        if (!PlatformUtils.isRider()) {
            RunConfigurationVcsSupport vcsSupport = (RunConfigurationVcsSupport)this.myProject.getService(RunConfigurationVcsSupport.class);
            if (!vcsSupport.hasActiveVcss(this.myProject)) {
                this.myRCStorageType = RCStorageType.DotIdeaFolder;
                this.myFolderPathIfStoredInArbitraryFile = null;
                return;
            }
            if (!this.isDotIdeaStorageVcsIgnored(vcsSupport)) {
                this.myRCStorageType = RCStorageType.DotIdeaFolder;
                this.myFolderPathIfStoredInArbitraryFile = null;
                return;
            }
        }
        LOG.assertTrue((baseDir = LocalFileSystem.getInstance().findFileByPath(StringUtil.notNullize((String)this.myProject.getBasePath()))) != null);
        if (!PlatformUtils.isRider() && !ProjectFileIndex.getInstance((Project)this.myProject).isInContent(baseDir)) {
            this.myRCStorageType = RCStorageType.DotIdeaFolder;
            this.myFolderPathIfStoredInArbitraryFile = null;
            return;
        }
        Collection<String> otherFolders = RunConfigurationStorageUi.getFolderPathsWithinProjectWhereRunConfigurationsStored(this.myProject);
        if (otherFolders.size() == 1) {
            this.myRCStorageType = RCStorageType.ArbitraryFileInProject;
            this.myFolderPathIfStoredInArbitraryFile = otherFolders.iterator().next();
            return;
        }
        this.myRCStorageType = RCStorageType.ArbitraryFileInProject;
        this.myFolderPathIfStoredInArbitraryFile = baseDir.getPath() + "/.run";
    }

    private boolean isDotIdeaStorageVcsIgnored(RunConfigurationVcsSupport vcsSupport) {
        if (this.myDotIdeaStorageVcsIgnored == null) {
            this.myDotIdeaStorageVcsIgnored = vcsSupport.isDirectoryVcsIgnored(this.myProject, RunConfigurationStorageUi.getDotIdeaStoragePath(this.myProject));
        }
        return this.myDotIdeaStorageVcsIgnored;
    }

    private static Collection<String> getFolderPathsWithinProjectWhereRunConfigurationsStored(@NotNull Project project) {
        if (project == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(6);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getAllSettings()) {
            String filePath = settings.getPathIfStoredInArbitraryFileInProject();
            if (!settings.isStoredInArbitraryFileInProject() || filePath == null) continue;
            result2.add(PathUtil.getParentPath((String)filePath));
        }
        return result2;
    }

    public JPanel createComponent() {
        return FormBuilder.createFormBuilder().setFormLeftIndent(10).setHorizontalGap(0).addLabeledComponent((JComponent)this.myStoreAsFileCheckBox, (JComponent)this.myStoreAsFileGearButton).getPanel();
    }

    public void addStoreAsFileCheckBoxListener(ActionListener listener2) {
        this.myStoreAsFileCheckBox.addActionListener(listener2);
    }

    public boolean isStoredInFile() {
        return this.myRCStorageType == RCStorageType.DotIdeaFolder || this.myRCStorageType == RCStorageType.ArbitraryFileInProject;
    }

    public boolean isModified() {
        if (this.myRCStorageType != this.myRCStorageTypeInitial) {
            return true;
        }
        return this.myRCStorageType == RCStorageType.ArbitraryFileInProject && !Objects.equals(this.myFolderPathIfStoredInArbitraryFileInitial, this.myFolderPathIfStoredInArbitraryFile);
    }

    public void reset(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(7);
        }
        boolean isManagedRunConfiguration = settings.getConfiguration().getType().isManaged();
        this.myRCStorageType = settings.isStoredInArbitraryFileInProject() ? RCStorageType.ArbitraryFileInProject : (settings.isStoredInDotIdeaFolder() ? RCStorageType.DotIdeaFolder : RCStorageType.Workspace);
        this.myFolderPathIfStoredInArbitraryFile = PathUtil.getParentPath((String)StringUtil.notNullize((String)settings.getPathIfStoredInArbitraryFileInProject()));
        this.myRCStorageTypeInitial = this.myRCStorageType;
        this.myFolderPathIfStoredInArbitraryFileInitial = this.myFolderPathIfStoredInArbitraryFile;
        this.myStoreAsFileCheckBox.setEnabled(isManagedRunConfiguration);
        this.myStoreAsFileCheckBox.setSelected(this.myRCStorageType == RCStorageType.DotIdeaFolder || this.myRCStorageType == RCStorageType.ArbitraryFileInProject);
        this.myStoreAsFileGearButton.setVisible(isManagedRunConfiguration);
        this.myStoreAsFileGearButton.setEnabled(this.myStoreAsFileCheckBox.isSelected());
        this.validatePath();
    }

    public void apply(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(8);
        }
        this.apply(settings, true);
    }

    public void apply(@NotNull RunnerAndConfigurationSettings settings, boolean checkPathValidity) {
        if (settings == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(9);
        }
        switch (this.myRCStorageType.ordinal()) {
            case 0: {
                settings.storeInLocalWorkspace();
                break;
            }
            case 1: {
                settings.storeInDotIdeaFolder();
                break;
            }
            case 2: {
                if (checkPathValidity && RunConfigurationStorageUi.getErrorIfBadFolderPathForStoringInArbitraryFile(this.myProject, this.myFolderPathIfStoredInArbitraryFile) != null) break;
                String name = settings.isTemplate() ? "Template " + settings.getType().getDisplayName() : settings.getName();
                String fileName = RunConfigurationStorageUi.getFileNameByRCName(name);
                settings.storeInArbitraryFileInProject(this.myFolderPathIfStoredInArbitraryFile + "/" + fileName);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.myRCStorageType));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rcName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/RunConfigurationStorageUi";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/RunConfigurationStorageUi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameByRCName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDotIdeaStoragePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileNameByRCName";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorIfBadFolderPathForStoringInArbitraryFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDotIdeaStoragePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFolderPathsWithinProjectWhereRunConfigurationsStored";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }

    private static final class RunConfigurationStoragePopup {
        private final JPanel myMainPanel;
        private final ComboBox<String> myPathComboBox;
        @NonNls
        private final @SystemIndependent String myDotIdeaStoragePath;
        private Runnable myClosePopupAction;

        RunConfigurationStoragePopup(@NotNull Project project, @NotNull String dotIdeaStoragePath, @NotNull Function<? super String, @NlsContexts.DialogMessage String> pathToErrorMessage, @NotNull Disposable uiDisposable) {
            if (project == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(0);
            }
            if (dotIdeaStoragePath == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(1);
            }
            if (pathToErrorMessage == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(2);
            }
            if (uiDisposable == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(3);
            }
            this.myDotIdeaStoragePath = dotIdeaStoragePath;
            this.myPathComboBox = this.createPathComboBox(project, uiDisposable);
            ComponentValidator validator = new ComponentValidator(uiDisposable);
            JTextComponent comboBoxEditorComponent = (JTextComponent)this.myPathComboBox.getEditor().getEditorComponent();
            validator.withValidator(() -> {
                String errorMessage = (String)pathToErrorMessage.fun((Object)this.getPath());
                return errorMessage != null ? new ValidationInfo(errorMessage, this.myPathComboBox) : null;
            }).andRegisterOnDocumentListener(comboBoxEditorComponent).installOn((JComponent)comboBoxEditorComponent);
            ComponentPanelBuilder builder2 = UI.PanelFactory.panel(this.myPathComboBox).withLabel(ExecutionBundle.message((String)"run.configuration.store.in", (Object[])new Object[0])).moveLabelOnTop();
            JPanel comboBoxPanel = builder2.createPanel();
            JButton doneButton = new JButton(ExecutionBundle.message((String)"run.configuration.done.button", (Object[])new Object[0]));
            doneButton.addActionListener(e -> this.myClosePopupAction.run());
            JPanel doneButtonPanel = new JPanel(new BorderLayout());
            doneButtonPanel.add((Component)doneButton, "East");
            this.myMainPanel = FormBuilder.createFormBuilder().addComponent((JComponent)comboBoxPanel).addComponent((JComponent)doneButtonPanel).getPanel();
            this.myMainPanel.setFocusCycleRoot(true);
            this.myMainPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
            DumbAwareAction.create(e -> {
                if (this.myPathComboBox.isPopupVisible()) {
                    this.myPathComboBox.setPopupVisible(false);
                } else {
                    validator.updateInfo(null);
                    this.myClosePopupAction.run();
                }
            }).registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.ENTER, CommonShortcuts.ESCAPE}), (JComponent)this.myMainPanel, uiDisposable);
        }

        @NotNull
        private ComboBox<String> createPathComboBox(final @NotNull Project project, @NotNull Disposable uiDisposable) {
            if (project == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(4);
            }
            if (uiDisposable == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(5);
            }
            ComboBox comboBox = new ComboBox(JBUI.scale((int)500));
            comboBox.setEditable(true);
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false){

                public boolean isFileSelectable(@Nullable VirtualFile file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.getPath().equals(myDotIdeaStoragePath)) {
                        return true;
                    }
                    return file.isDirectory() && super.isFileSelectable(file) && !file.getPath().endsWith("/.idea") && !file.getPath().contains("/.idea/") && (Boolean)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)project).isInContent(file)) != false;
                }
            };
            BrowseFolderRunnable selectFolderAction = new BrowseFolderRunnable(project, descriptor, (JComponent)comboBox, TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
            comboBox.initBrowsableEditor((Runnable)selectFolderAction, uiDisposable);
            ComboBox comboBox2 = comboBox;
            if (comboBox2 == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(6);
            }
            return comboBox2;
        }

        JPanel getMainPanel() {
            return this.myMainPanel;
        }

        void reset(@NotNull @SystemIndependent String folderPath, Collection<String> pathsToSuggest, @NotNull Runnable closePopupAction) {
            if (folderPath == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(7);
            }
            if (closePopupAction == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(8);
            }
            this.myPathComboBox.setSelectedItem((Object)FileUtil.toSystemDependentName((String)folderPath));
            for (String s : pathsToSuggest) {
                this.myPathComboBox.addItem((Object)FileUtil.toSystemDependentName((String)s));
            }
            this.myClosePopupAction = closePopupAction;
        }

        @NotNull
        @SystemIndependent String getPath() {
            String string = UriUtil.trimTrailingSlashes((String)FileUtil.toSystemIndependentName((String)this.myPathComboBox.getEditor().getItem().toString().trim()));
            if (string == null) {
                RunConfigurationStoragePopup.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dotIdeaStoragePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathToErrorMessage";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiDisposable";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/RunConfigurationStorageUi$RunConfigurationStoragePopup";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folderPath";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closePopupAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/RunConfigurationStorageUi$RunConfigurationStoragePopup";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPathComboBox";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createPathComboBox";
                    break;
                }
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static enum RCStorageType {
        Workspace,
        DotIdeaFolder,
        ArbitraryFileInProject;

    }
}

