/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.EnvFilesOptions;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.impl.statistics.FusAwareRunConfiguration;
import com.intellij.execution.impl.statistics.RunConfigurationTypeUsagesCollector;
import com.intellij.execution.target.ImplicitTargetAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RunConfigurationUsageTriggerCollector
extends CounterUsagesCollector {
    private static final String GROUP_NAME = "run.configuration.exec";
    private static final EventLogGroup GROUP = new EventLogGroup("run.configuration.exec", 79);
    public static final IntEventField ALTERNATIVE_JRE_VERSION = EventFields.Int((String)"alternative_jre_version");
    private static final ObjectEventField ADDITIONAL_FIELD = EventFields.createAdditionalDataField((String)"run.configuration.exec", (String)"started");
    private static final StringEventField EXECUTOR = EventFields.StringValidatedByCustomRule((String)"executor", RunConfigurationExecutorUtilValidator.class);
    private static final BooleanEventField IS_RERUN = EventFields.Boolean((String)"is_rerun");
    private static final BooleanEventField IS_RUNNING_CURRENT_FILE = EventFields.Boolean((String)"is_running_current_file");
    private static final BooleanEventField IS_SERVICE_VIEW = EventFields.Boolean((String)"service_view");
    private static final StringEventField TARGET = EventFields.StringValidatedByCustomRule((String)"target", RunTargetValidator.class);
    private static final IntEventField ENV_FILES_COUNT = EventFields.Int((String)"env_files_count");
    private static final EnumEventField<RunConfigurationFinishType> FINISH_TYPE = EventFields.Enum((String)"finish_type", RunConfigurationFinishType.class);
    private static final IdeActivityDefinition ACTIVITY_GROUP = GROUP.registerIdeActivity(null, new EventField[]{ADDITIONAL_FIELD, EXECUTOR, IS_RERUN, IS_RUNNING_CURRENT_FILE, TARGET, RunConfigurationTypeUsagesCollector.FACTORY_FIELD, RunConfigurationTypeUsagesCollector.ID_FIELD, EventFields.PluginInfo, ENV_FILES_COUNT, EventFields.Dumb, IS_SERVICE_VIEW}, new EventField[]{FINISH_TYPE}, null, true);
    public static final VarargEventId UI_SHOWN_STAGE = ACTIVITY_GROUP.registerStage("ui.shown");

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public static StructuredIdeActivity trigger(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull Executor executor, @Nullable RunConfiguration runConfiguration, boolean isRerun, boolean isRunningCurrentFile, boolean isDumb, boolean isServiceView) {
        if (project == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        StructuredIdeActivity structuredIdeActivity = ACTIVITY_GROUP.startedAsync(project, () -> ReadAction.nonBlocking(() -> RunConfigurationUsageTriggerCollector.buildContext(project, factory, executor, runConfiguration, isRerun, isRunningCurrentFile, isDumb, isServiceView)).expireWith((Disposable)project).submit((java.util.concurrent.Executor)NonUrgentExecutor.getInstance()));
        if (structuredIdeActivity == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        return structuredIdeActivity;
    }

    @NotNull
    public static StructuredIdeActivity triggerWithParent(@NotNull StructuredIdeActivity parentActivity, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull Executor executor, @Nullable RunConfiguration runConfiguration, boolean isRerun, boolean isRunningCurrentFile, boolean isDumb, boolean isServiceView) {
        if (parentActivity == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(4);
        }
        if (project == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(5);
        }
        if (factory == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(6);
        }
        if (executor == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(7);
        }
        StructuredIdeActivity structuredIdeActivity = ACTIVITY_GROUP.startedAsyncWithParent(project, parentActivity, () -> ReadAction.nonBlocking(() -> RunConfigurationUsageTriggerCollector.buildContext(project, factory, executor, runConfiguration, isRerun, isRunningCurrentFile, isDumb, isServiceView)).expireWith((Disposable)project).submit((java.util.concurrent.Executor)NonUrgentExecutor.getInstance()));
        if (structuredIdeActivity == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(8);
        }
        return structuredIdeActivity;
    }

    @NotNull
    private static List<EventPair<?>> buildContext(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull Executor executor, @Nullable RunConfiguration runConfiguration, boolean isRerun, boolean isRunningCurrentFile, boolean isDumb, boolean isServiceView) {
        String targetTypeId;
        if (project == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(9);
        }
        if (factory == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(10);
        }
        if (executor == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(11);
        }
        List<EventPair<?>> eventPairs = RunConfigurationTypeUsagesCollector.createFeatureUsageData(factory.getType(), factory);
        ExecutorGroup group2 = ExecutorGroup.getGroupIfProxy((Executor)executor);
        eventPairs.add(EXECUTOR.with((Object)(group2 != null ? group2.getId() : executor.getId())));
        eventPairs.add(IS_RERUN.with((Object)isRerun));
        eventPairs.add(IS_RUNNING_CURRENT_FILE.with((Object)isRunningCurrentFile));
        eventPairs.add(EventFields.Dumb.with((Object)isDumb));
        eventPairs.add(IS_SERVICE_VIEW.with((Object)isServiceView));
        if (runConfiguration instanceof FusAwareRunConfiguration) {
            List<EventPair<?>> additionalData = ((FusAwareRunConfiguration)runConfiguration).getAdditionalUsageData();
            ObjectEventData objectEventData = new ObjectEventData(additionalData);
            eventPairs.add(ADDITIONAL_FIELD.with((Object)objectEventData));
        }
        if ((targetTypeId = RunConfigurationUsageTriggerCollector.getTargetTypeId(project, runConfiguration)) != null) {
            eventPairs.add(TARGET.with((Object)targetTypeId));
        }
        if (runConfiguration instanceof EnvFilesOptions) {
            EnvFilesOptions envFilesOptions = (EnvFilesOptions)runConfiguration;
            eventPairs.add(ENV_FILES_COUNT.with((Object)envFilesOptions.getEnvFilePaths().size()));
        }
        List<EventPair<?>> list = eventPairs;
        if (list == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static String getTargetTypeId(@NotNull Project project, @Nullable RunConfiguration runConfiguration) {
        TargetEnvironmentType targetType;
        if (project == null) {
            RunConfigurationUsageTriggerCollector.$$$reportNull$$$0(13);
        }
        if (runConfiguration instanceof TargetEnvironmentAwareRunProfile) {
            String assignedTargetName = ((TargetEnvironmentAwareRunProfile)runConfiguration).getDefaultTargetName();
            TargetEnvironmentConfiguration effectiveTargetConfiguration = TargetEnvironmentConfigurations.getEffectiveConfiguration((String)assignedTargetName, (Project)project);
            if (effectiveTargetConfiguration != null) {
                return effectiveTargetConfiguration.getTypeId();
            }
        } else if (runConfiguration instanceof ImplicitTargetAwareRunProfile && (targetType = ((ImplicitTargetAwareRunProfile)runConfiguration).getTargetType()) != null) {
            return targetType.getId();
        }
        return null;
    }

    public static void logProcessFinished(@Nullable StructuredIdeActivity activity, RunConfigurationFinishType finishType) {
        if (activity != null) {
            activity.finished(() -> Collections.singletonList(FINISH_TYPE.with((Object)finishType)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "trigger";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "triggerWithParent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trigger";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "triggerWithParent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildContext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 12 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static enum RunConfigurationFinishType {
        FAILED_TO_START,
        UNKNOWN,
        TERMINATED_BY_STOP,
        TERMINATED_DUE_TO_RERUN;

    }

    @ApiStatus.Internal
    public static final class RunConfigurationExecutorUtilValidator
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "run_config_executor";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                RunConfigurationExecutorUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RunConfigurationExecutorUtilValidator.$$$reportNull$$$0(1);
            }
            for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                if (!StringUtil.equals((CharSequence)executor.getId(), (CharSequence)data)) continue;
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(executor.getClass());
                ValidationResultType validationResultType = info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RunConfigurationExecutorUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                RunConfigurationExecutorUtilValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector$RunConfigurationExecutorUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector$RunConfigurationExecutorUtilValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class RunTargetValidator
    extends CustomValidationRule {
        public static final String RULE_ID = "run_target";

        @NotNull
        public String getRuleId() {
            return RULE_ID;
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                RunTargetValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RunTargetValidator.$$$reportNull$$$0(1);
            }
            if ("local".equals(data)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    RunTargetValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            for (TargetEnvironmentType type : (TargetEnvironmentType[])TargetEnvironmentType.EXTENSION_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)type.getId(), (CharSequence)data)) continue;
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(type.getClass());
                ValidationResultType validationResultType = info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RunTargetValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                RunTargetValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector$RunTargetValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationUsageTriggerCollector$RunTargetValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

