/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.execution;

import com.intellij.execution.multilaunch.execution.ExecutionMode;
import com.intellij.execution.multilaunch.execution.conditions.Condition;
import com.intellij.execution.multilaunch.execution.executables.Executable;
import com.intellij.execution.multilaunch.execution.messaging.ExecutionNotifier;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/intellij/execution/multilaunch/execution/ExecutionDescriptor;", "", "executable", "Lcom/intellij/execution/multilaunch/execution/executables/Executable;", "condition", "Lcom/intellij/execution/multilaunch/execution/conditions/Condition;", "disableDebugging", "", "<init>", "(Lcom/intellij/execution/multilaunch/execution/executables/Executable;Lcom/intellij/execution/multilaunch/execution/conditions/Condition;Z)V", "getExecutable", "()Lcom/intellij/execution/multilaunch/execution/executables/Executable;", "getCondition", "()Lcom/intellij/execution/multilaunch/execution/conditions/Condition;", "getDisableDebugging", "()Z", "createListener", "Lcom/intellij/execution/multilaunch/execution/messaging/ExecutionNotifier;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "executionMode", "Lcom/intellij/execution/multilaunch/execution/ExecutionMode;", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public final class ExecutionDescriptor {
    @NotNull
    private final Executable executable;
    @NotNull
    private final Condition condition;
    private final boolean disableDebugging;

    public ExecutionDescriptor(@NotNull Executable executable, @NotNull Condition condition, boolean disableDebugging) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.executable = executable;
        this.condition = condition;
        this.disableDebugging = disableDebugging;
    }

    @NotNull
    public final Executable getExecutable() {
        return this.executable;
    }

    @NotNull
    public final Condition getCondition() {
        return this.condition;
    }

    public final boolean getDisableDebugging() {
        return this.disableDebugging;
    }

    @NotNull
    public final ExecutionNotifier createListener(@NotNull Lifetime lifetime, @NotNull ExecutionMode executionMode, @NotNull StructuredIdeActivity activity) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)executionMode), (String)"executionMode");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return this.condition.createExecutionListener(this, executionMode, activity, lifetime);
    }

    @NotNull
    public final Executable component1() {
        return this.executable;
    }

    @NotNull
    public final Condition component2() {
        return this.condition;
    }

    public final boolean component3() {
        return this.disableDebugging;
    }

    @NotNull
    public final ExecutionDescriptor copy(@NotNull Executable executable, @NotNull Condition condition, boolean disableDebugging) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        return new ExecutionDescriptor(executable, condition, disableDebugging);
    }

    public static /* synthetic */ ExecutionDescriptor copy$default(ExecutionDescriptor executionDescriptor, Executable executable, Condition condition, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            executable = executionDescriptor.executable;
        }
        if ((n & 2) != 0) {
            condition = executionDescriptor.condition;
        }
        if ((n & 4) != 0) {
            bl = executionDescriptor.disableDebugging;
        }
        return executionDescriptor.copy(executable, condition, bl);
    }

    @NotNull
    public String toString() {
        return "ExecutionDescriptor(executable=" + this.executable + ", condition=" + this.condition + ", disableDebugging=" + this.disableDebugging + ")";
    }

    public int hashCode() {
        int result2 = this.executable.hashCode();
        result2 = result2 * 31 + this.condition.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.disableDebugging);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExecutionDescriptor)) {
            return false;
        }
        ExecutionDescriptor executionDescriptor = (ExecutionDescriptor)other;
        if (!Intrinsics.areEqual((Object)this.executable, (Object)executionDescriptor.executable)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.condition, (Object)executionDescriptor.condition)) {
            return false;
        }
        return this.disableDebugging == executionDescriptor.disableDebugging;
    }
}

