/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.startup.ProjectStartupRunnerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/execution/startup/MyExecutor;", "Ljava/lang/Runnable;", "executor", "Lcom/intellij/execution/Executor;", "configuration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "alarm", "Lcom/intellij/util/Alarm;", "<init>", "(Lcom/intellij/execution/Executor;Lcom/intellij/execution/RunnerAndConfigurationSettings;Lcom/intellij/util/Alarm;)V", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm.PlatformType", "count", "", "name", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "run", "", "Companion", "intellij.platform.execution.impl"})
final class MyExecutor
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final ExecutionEnvironment environment;
    private final Project project;
    private int count;
    @NotNull
    private final String name;
    public static final int ATTEMPTS = 10;
    public static final long PAUSE = 300L;

    public MyExecutor(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Alarm alarm) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)alarm, (String)"alarm");
        this.alarm = alarm;
        this.environment = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)ExecutionEnvironmentBuilder.Companion.create(executor, configuration).contentToReuse(null).dataContext(null).activeTarget(), null, (int)1, null);
        this.project = configuration.getConfiguration().getProject();
        this.count = 10;
        String string = configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.name = string;
    }

    @Override
    public void run() {
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (ExecutionManager.Companion.getInstance(project).isStarting(this.environment)) {
            if (this.count <= 0) {
                Project project2 = this.project;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                Object[] objectArray = new Object[]{this.name, 10};
                ProjectStartupRunnerKt.access$showNotification(project2, ExecutionBundle.message((String)"project.startup.runner.notification.not.started", (Object[])objectArray));
                return;
            }
            this.count += -1;
            this.alarm.addRequest((Runnable)this, 300L);
        }
        ProjectStartupRunnerKt.access$getLOG$p().info("Starting startup task '" + this.name + "'");
        ProgramRunnerUtil.executeConfiguration(this.environment, true, true);
        if (this.alarm.isEmpty()) {
            Disposer.dispose((Disposable)((Disposable)this.alarm));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/startup/MyExecutor$Companion;", "", "<init>", "()V", "ATTEMPTS", "", "PAUSE", "", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

