/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.CustomToolLanguageConfigurable;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeConfigurationKt;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001)B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0007J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\u0006\u0010&\u001a\u00020\u001dJ\b\u0010'\u001a\u00020\u001dH\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u001a\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lcom/intellij/execution/target/TargetCustomToolPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "targetEnvironmentType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "targetSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "language", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "introspectable", "Lcom/intellij/execution/target/LanguageRuntimeType$Introspectable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/target/TargetEnvironmentType;Ljava/util/function/Supplier;Lcom/intellij/execution/target/LanguageRuntimeConfiguration;Lcom/intellij/execution/target/LanguageRuntimeType$Introspectable;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "component$delegate", "Lkotlin/Lazy;", "mainPanel", "Ljavax/swing/JPanel;", "languagePanel", "Lcom/intellij/execution/target/TargetCustomToolPanel$LanguagePanel;", "preferredFocusedComponent", "getPreferredFocusedComponent", "createComponent", "applyAll", "", "createCustomTool", "validateCustomTool", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "customToolLanguageConfigurable", "Lcom/intellij/execution/target/CustomToolLanguageConfigurable;", "getCustomToolLanguageConfigurable", "()Lcom/intellij/execution/target/CustomToolLanguageConfigurable;", "disposeUIResources", "recreateRuntimePanels", "createRuntimePanel", "LanguagePanel", "intellij.platform.execution.impl"})
@ApiStatus.Internal
public final class TargetCustomToolPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final TargetEnvironmentType<?> targetEnvironmentType;
    @NotNull
    private final Supplier<TargetEnvironmentConfiguration> targetSupplier;
    @NotNull
    private final LanguageRuntimeConfiguration language;
    @Nullable
    private final LanguageRuntimeType.Introspectable introspectable;
    @NotNull
    private final Lazy component$delegate;
    private JPanel mainPanel;
    @Nullable
    private LanguagePanel languagePanel;

    public TargetCustomToolPanel(@NotNull Project project, @NotNull TargetEnvironmentType<?> targetEnvironmentType, @NotNull Supplier<TargetEnvironmentConfiguration> targetSupplier, @NotNull LanguageRuntimeConfiguration language, @Nullable LanguageRuntimeType.Introspectable introspectable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetEnvironmentType, (String)"targetEnvironmentType");
        Intrinsics.checkNotNullParameter(targetSupplier, (String)"targetSupplier");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.project = project;
        this.targetEnvironmentType = targetEnvironmentType;
        this.targetSupplier = targetSupplier;
        this.language = language;
        this.introspectable = introspectable;
        this.component$delegate = LazyKt.lazy(() -> TargetCustomToolPanel.component_delegate$lambda$0(this));
    }

    @NotNull
    public final JComponent getComponent() {
        Lazy lazy = this.component$delegate;
        return (JComponent)lazy.getValue();
    }

    @Nullable
    public final JComponent getPreferredFocusedComponent() {
        return null;
    }

    private final JComponent createComponent() {
        BorderLayoutPanel result2 = new BorderLayoutPanel();
        this.mainPanel = new JPanel((LayoutManager)new VerticalLayout(4));
        this.recreateRuntimePanels();
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            jPanel = null;
        }
        result2.addToCenter((Component)jPanel);
        return (JComponent)result2;
    }

    public final void applyAll() {
        block0: {
            LanguagePanel languagePanel = this.languagePanel;
            if (languagePanel == null || (languagePanel = languagePanel.getConfigurable()) == null) break block0;
            languagePanel.apply();
        }
    }

    @RequiresEdt
    @Nullable
    public final Object createCustomTool() {
        CustomToolLanguageConfigurable<?> customToolLanguageConfigurable = this.getCustomToolLanguageConfigurable();
        return customToolLanguageConfigurable != null ? customToolLanguageConfigurable.createCustomTool() : null;
    }

    @NotNull
    public final Collection<ValidationInfo> validateCustomTool() {
        Object object = this.getCustomToolLanguageConfigurable();
        if (object == null || (object = object.validate()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final CustomToolLanguageConfigurable<?> getCustomToolLanguageConfigurable() {
        LanguagePanel languagePanel = this.languagePanel;
        Configurable configurable = languagePanel != null ? languagePanel.getConfigurable() : null;
        return configurable instanceof CustomToolLanguageConfigurable ? (CustomToolLanguageConfigurable)configurable : null;
    }

    public final void disposeUIResources() {
    }

    private final void recreateRuntimePanels() {
        this.languagePanel = null;
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            jPanel = null;
        }
        JPanel $this$recreateRuntimePanels_u24lambda_u240 = jPanel;
        boolean bl = false;
        $this$recreateRuntimePanels_u24lambda_u240.removeAll();
        $this$recreateRuntimePanels_u24lambda_u240.add(this.createRuntimePanel(this.language).getPanel());
    }

    private final LanguagePanel createRuntimePanel(LanguageRuntimeConfiguration language) {
        LanguagePanel languagePanel;
        Configurable configurable = LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)language).createConfigurable(this.project, language, this.targetEnvironmentType, this.targetSupplier);
        if (this.introspectable != null) {
            CustomToolLanguageConfigurable customToolLanguageConfigurable = configurable instanceof CustomToolLanguageConfigurable ? (CustomToolLanguageConfigurable)configurable : null;
            if (customToolLanguageConfigurable != null) {
                customToolLanguageConfigurable.setIntrospectable(this.introspectable);
            }
        }
        DialogPanel panel2 = BuilderKt.panel(arg_0 -> TargetCustomToolPanel.createRuntimePanel$lambda$0(configurable, language, arg_0));
        configurable.reset();
        LanguagePanel it = languagePanel = new LanguagePanel(language, configurable, (JComponent)panel2);
        boolean bl = false;
        this.languagePanel = it;
        return languagePanel;
    }

    private static final JComponent component_delegate$lambda$0(TargetCustomToolPanel this$0) {
        return this$0.createComponent();
    }

    private static final Unit createRuntimePanel$lambda$0(Configurable $configurable, LanguageRuntimeConfiguration $language, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TargetCustomToolPanel.createRuntimePanel$lambda$0$0($configurable, $language, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createRuntimePanel$lambda$0$0(Configurable $configurable, LanguageRuntimeConfiguration $language, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = $configurable.createComponent();
        if (jComponent == null) {
            throw new IllegalStateException("for runtime: " + $language);
        }
        JComponent languageUI = jComponent;
        $this$row.cell(languageUI).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/target/TargetCustomToolPanel$LanguagePanel;", "", "language", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "configurable", "Lcom/intellij/openapi/options/Configurable;", "panel", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/execution/target/LanguageRuntimeConfiguration;Lcom/intellij/openapi/options/Configurable;Ljavax/swing/JComponent;)V", "getLanguage", "()Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "getConfigurable", "()Lcom/intellij/openapi/options/Configurable;", "getPanel", "()Ljavax/swing/JComponent;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.execution.impl"})
    private static final class LanguagePanel {
        @NotNull
        private final LanguageRuntimeConfiguration language;
        @NotNull
        private final Configurable configurable;
        @NotNull
        private final JComponent panel;

        public LanguagePanel(@NotNull LanguageRuntimeConfiguration language, @NotNull Configurable configurable, @NotNull JComponent panel2) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            this.language = language;
            this.configurable = configurable;
            this.panel = panel2;
        }

        @NotNull
        public final LanguageRuntimeConfiguration getLanguage() {
            return this.language;
        }

        @NotNull
        public final Configurable getConfigurable() {
            return this.configurable;
        }

        @NotNull
        public final JComponent getPanel() {
            return this.panel;
        }

        @NotNull
        public final LanguageRuntimeConfiguration component1() {
            return this.language;
        }

        @NotNull
        public final Configurable component2() {
            return this.configurable;
        }

        @NotNull
        public final JComponent component3() {
            return this.panel;
        }

        @NotNull
        public final LanguagePanel copy(@NotNull LanguageRuntimeConfiguration language, @NotNull Configurable configurable, @NotNull JComponent panel2) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            return new LanguagePanel(language, configurable, panel2);
        }

        public static /* synthetic */ LanguagePanel copy$default(LanguagePanel languagePanel, LanguageRuntimeConfiguration languageRuntimeConfiguration, Configurable configurable, JComponent jComponent, int n, Object object) {
            if ((n & 1) != 0) {
                languageRuntimeConfiguration = languagePanel.language;
            }
            if ((n & 2) != 0) {
                configurable = languagePanel.configurable;
            }
            if ((n & 4) != 0) {
                jComponent = languagePanel.panel;
            }
            return languagePanel.copy(languageRuntimeConfiguration, configurable, jComponent);
        }

        @NotNull
        public String toString() {
            return "LanguagePanel(language=" + this.language + ", configurable=" + this.configurable + ", panel=" + this.panel + ")";
        }

        public int hashCode() {
            int result2 = this.language.hashCode();
            result2 = result2 * 31 + this.configurable.hashCode();
            result2 = result2 * 31 + this.panel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LanguagePanel)) {
                return false;
            }
            LanguagePanel languagePanel = (LanguagePanel)other;
            if (!Intrinsics.areEqual((Object)this.language, (Object)languagePanel.language)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.configurable, (Object)languagePanel.configurable)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.panel, (Object)languagePanel.panel);
        }
    }
}

