/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunnerLayout {
    public static final Key<Integer> DEFAULT_INDEX = Key.create((String)"RunnerLayoutDefaultIndex");
    public static final Key<Integer> DROP_INDEX = Key.create((String)"RunnerLayoutDropIndex");
    private final Map<String, ViewImpl> myViews = new LinkedHashMap<String, ViewImpl>();
    private final Map<String, ViewImpl.Default> myDefaultViews = new HashMap<String, ViewImpl.Default>();
    private final Set<TabImpl> myTabs = new TreeSet<TabImpl>(Comparator.comparingInt(TabImpl::getIndex));
    private final Int2ObjectMap<TabImpl.Default> myDefaultTabs = new Int2ObjectOpenHashMap();
    private final General myGeneral = new General();
    private final Map<String, Pair<String, LayoutAttractionPolicy>> myDefaultFocus = new HashMap<String, Pair<String, LayoutAttractionPolicy>>();
    private Set<String> myLightWeightIds = null;

    @Nullable
    public String getDefaultDisplayName(int defaultIndex) {
        TabImpl.Default tab = (TabImpl.Default)this.myDefaultTabs.get(defaultIndex);
        return tab != null ? tab.myDisplayName : null;
    }

    @Nullable
    public Icon getDefaultIcon(int defaultIndex) {
        TabImpl.Default tab = (TabImpl.Default)this.myDefaultTabs.get(defaultIndex);
        return tab != null ? tab.myIcon : null;
    }

    public int getDefaultTabIndex(String contentId) {
        ViewImpl.Default viewDefault = this.myDefaultViews.get(contentId);
        return viewDefault != null ? viewDefault.getTabID() : -1;
    }

    @Nullable
    public PlaceInGrid getDefaultPlaceInGrid(String contentId) {
        ViewImpl.Default viewDefault = this.myDefaultViews.get(contentId);
        return viewDefault != null ? viewDefault.getPlaceInGrid() : null;
    }

    public boolean getDefaultIsMinimized(String contentId) {
        ViewImpl.Default viewDefault = this.myDefaultViews.get(contentId);
        return viewDefault != null && viewDefault.isMinimizedInGrid();
    }

    @ApiStatus.Internal
    @NotNull
    public TabImpl getOrCreateTab(int index) {
        if (index < 0) {
            TabImpl tabImpl = this.createNewTab();
            if (tabImpl == null) {
                RunnerLayout.$$$reportNull$$$0(0);
            }
            return tabImpl;
        }
        TabImpl tab = this.findTab(index);
        if (tab != null) {
            TabImpl tabImpl = tab;
            if (tabImpl == null) {
                RunnerLayout.$$$reportNull$$$0(1);
            }
            return tabImpl;
        }
        TabImpl tabImpl = tab = this.createNewTab(index);
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(2);
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl createNewTab(int index) {
        TabImpl.Default defaultTab = this.getOrCreateDefaultTab(index);
        TabImpl tab = defaultTab.createTab();
        this.myTabs.add(tab);
        TabImpl tabImpl = tab;
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(3);
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl.Default getOrCreateDefaultTab(int index) {
        TabImpl.Default tab = (TabImpl.Default)this.myDefaultTabs.get(index);
        if (tab == null) {
            tab = new TabImpl.Default(index, null, null);
            this.myDefaultTabs.put(index, (Object)tab);
        }
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(4);
        }
        return default_;
    }

    @ApiStatus.Internal
    @NotNull
    public TabImpl createNewTab() {
        int index = this.myTabs.stream().mapToInt(x -> x.getIndex()).max().orElse(-1) + 1;
        return this.createNewTab(index);
    }

    private boolean isUsed(@NotNull TabImpl tab) {
        if (tab == null) {
            RunnerLayout.$$$reportNull$$$0(5);
        }
        for (ViewImpl each : this.myViews.values()) {
            if (each.getTab() != tab) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private TabImpl findTab(int index) {
        for (TabImpl each : this.myTabs) {
            if (index != each.getIndex()) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public Element getState() {
        Element element = this.write(new Element("layout"));
        if (element == null) {
            RunnerLayout.$$$reportNull$$$0(6);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            RunnerLayout.$$$reportNull$$$0(7);
        }
        this.read(state);
    }

    @NotNull
    public Element read(@NotNull Element parentNode) {
        if (parentNode == null) {
            RunnerLayout.$$$reportNull$$$0(8);
        }
        List tabs = parentNode.getChildren(StringUtil.getShortName((String)TabImpl.class.getName()));
        for (Object eachTabElement : tabs) {
            TabImpl eachTab = (TabImpl)XmlSerializer.deserialize((Element)eachTabElement, TabImpl.class);
            XmlSerializer.deserializeInto((Element)eachTabElement, (Object)this.getOrCreateTab(eachTab.getIndex()));
        }
        List views = parentNode.getChildren(StringUtil.getShortName((String)ViewImpl.class.getName()));
        for (Element content : views) {
            ViewImpl view = new ViewImpl();
            XmlSerializer.deserializeInto((Element)content, (Object)view);
            view.assignTab(this.getOrCreateTab(view.getTabIndex()));
            this.myViews.put(view.getID(), view);
        }
        Element general = parentNode.getChild(StringUtil.getShortName((String)this.myGeneral.getClass().getName(), (char)'$'));
        XmlSerializer.deserializeInto((Element)(general == null ? new Element("state") : general), (Object)this.myGeneral);
        Element element = parentNode;
        if (element == null) {
            RunnerLayout.$$$reportNull$$$0(9);
        }
        return element;
    }

    @NotNull
    public Element write(@NotNull Element parentNode) {
        Element element;
        if (parentNode == null) {
            RunnerLayout.$$$reportNull$$$0(10);
        }
        for (ViewImpl eachState : this.myViews.values()) {
            if (this.myLightWeightIds != null && this.myLightWeightIds.contains(eachState.getID())) continue;
            element = XmlSerializer.serialize((Object)eachState);
            parentNode.addContent(element == null ? new Element("ViewImpl") : element);
        }
        for (TabImpl eachTab : this.myTabs) {
            if (!this.isUsed(eachTab)) continue;
            element = XmlSerializer.serialize((Object)eachTab);
            parentNode.addContent(element == null ? new Element("TabImpl") : element);
        }
        Element generalContent = XmlSerializer.serialize((Object)this.myGeneral);
        if (generalContent != null) {
            parentNode.addContent(generalContent);
        }
        Element element2 = parentNode;
        if (element2 == null) {
            RunnerLayout.$$$reportNull$$$0(11);
        }
        return element2;
    }

    public void resetToDefault() {
        this.myViews.clear();
        this.myTabs.clear();
    }

    @NotNull
    public ViewImpl getStateFor(@NotNull Content content) {
        if (content == null) {
            RunnerLayout.$$$reportNull$$$0(12);
        }
        return this.getOrCreateView(RunnerLayout.getOrCreateContentId(content));
    }

    public void clearStateFor(@NotNull Content content) {
        if (content == null) {
            RunnerLayout.$$$reportNull$$$0(13);
        }
        String id = RunnerLayout.getOrCreateContentId(content);
        this.clearStateForId(id);
    }

    public void clearStateForId(@NotNull String id) {
        Tab tab;
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(14);
        }
        this.myDefaultViews.remove(id);
        ViewImpl view = this.myViews.remove(id);
        if (view != null && (tab = view.getTab()) instanceof TabImpl) {
            this.myTabs.remove(tab);
        }
    }

    @NotNull
    private static String getOrCreateContentId(@NotNull Content content) {
        Object id;
        if (content == null) {
            RunnerLayout.$$$reportNull$$$0(15);
        }
        if ((id = (String)content.getUserData(ViewImpl.ID)) == null) {
            id = "UnknownView-" + content.getDisplayName();
            content.putUserData(ViewImpl.ID, id);
        }
        String string = id;
        if (string == null) {
            RunnerLayout.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private ViewImpl getOrCreateView(@NotNull String id) {
        ViewImpl view;
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(17);
        }
        if ((view = this.myViews.get(id)) == null) {
            view = this.getOrCreateDefault(id).createView(this);
            this.myViews.put(id, view);
        }
        ViewImpl viewImpl = view;
        if (viewImpl == null) {
            RunnerLayout.$$$reportNull$$$0(18);
        }
        return viewImpl;
    }

    @Nullable
    public ViewImpl getViewById(@NotNull String id) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(19);
        }
        return this.myViews.get(id);
    }

    @NotNull
    private ViewImpl.Default getOrCreateDefault(@NotNull String id) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(20);
        }
        if (this.myDefaultViews.containsKey(id)) {
            ViewImpl.Default default_ = this.myDefaultViews.get(id);
            if (default_ == null) {
                RunnerLayout.$$$reportNull$$$0(21);
            }
            return default_;
        }
        ViewImpl.Default default_ = this.setDefault(id, Integer.MAX_VALUE, PlaceInGrid.bottom, false);
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(22);
        }
        return default_;
    }

    @ApiStatus.Internal
    @NotNull
    public TabImpl.Default setDefault(int tabID, String displayName, Icon icon) {
        TabImpl.Default tab = new TabImpl.Default(tabID, displayName, icon);
        this.myDefaultTabs.put(tabID, (Object)tab);
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(23);
        }
        return default_;
    }

    @ApiStatus.Internal
    @NotNull
    public ViewImpl.Default setDefault(@NotNull String id, int tabIndex, @NotNull PlaceInGrid placeInGrid, boolean isMinimized) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(24);
        }
        if (placeInGrid == null) {
            RunnerLayout.$$$reportNull$$$0(25);
        }
        ViewImpl.Default view = new ViewImpl.Default(id, tabIndex, placeInGrid, isMinimized);
        this.myDefaultViews.put(id, view);
        ViewImpl.Default default_ = view;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(26);
        }
        return default_;
    }

    @NotNull
    public PlaceInGrid getDefaultGridPlace(@NotNull Content content) {
        if (content == null) {
            RunnerLayout.$$$reportNull$$$0(27);
        }
        PlaceInGrid placeInGrid = this.getOrCreateDefault(RunnerLayout.getOrCreateContentId(content)).getPlaceInGrid();
        if (placeInGrid == null) {
            RunnerLayout.$$$reportNull$$$0(28);
        }
        return placeInGrid;
    }

    public boolean isToFocus(String id, @NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(29);
        }
        return Objects.equals(id, this.getToFocus(condition));
    }

    public void setToFocus(String id, @NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(30);
        }
        this.myGeneral.focusOnCondition.put(condition, id);
    }

    public void setDefaultToFocus(@NotNull String id, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(31);
        }
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(32);
        }
        if (policy == null) {
            RunnerLayout.$$$reportNull$$$0(33);
        }
        this.myDefaultFocus.put(condition, (Pair<String, LayoutAttractionPolicy>)Pair.create((Object)id, (Object)policy));
    }

    void cancelDefaultFocusBy(@NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(34);
        }
        this.myDefaultFocus.remove(condition);
    }

    @Nullable
    public String getToFocus(@NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(35);
        }
        return this.myGeneral.focusOnCondition.containsKey(condition) ? this.myGeneral.focusOnCondition.get(condition) : (this.myDefaultFocus.containsKey(condition) ? (String)this.myDefaultFocus.get(condition).getFirst() : null);
    }

    @NotNull
    public LayoutAttractionPolicy getAttractionPolicy(@NotNull String condition) {
        Pair<String, LayoutAttractionPolicy> pair;
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(36);
        }
        Object object = (pair = this.myDefaultFocus.get(condition)) == null ? new LayoutAttractionPolicy.FocusOnce() : (LayoutAttractionPolicy)pair.getSecond();
        if (object == null) {
            RunnerLayout.$$$reportNull$$$0(37);
        }
        return object;
    }

    public void setLightWeight(Content content) {
        if (this.myLightWeightIds == null) {
            this.myLightWeightIds = new HashSet<String>();
        }
        this.myLightWeightIds.add(RunnerLayout.getOrCreateContentId(content));
    }

    public boolean isTabLabelsHidden() {
        return this.myGeneral.isTabLabelsHidden;
    }

    public void setTabLabelsHidden(boolean tabLabelsHidden) {
        this.myGeneral.isTabLabelsHidden = tabLabelsHidden;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 7, 8, 10, 12, 13, 14, 15, 17, 19, 20, 24, 25, 27, 29, 30, 31, 32, 33, 34, 35, 36 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/impl/RunnerLayout";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInGrid";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateTab";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTab";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDefaultTab";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerLayout";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContentId";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateView";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDefault";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setDefault";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultGridPlace";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttractionPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUsed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getStateFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearStateFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clearStateForId";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateContentId";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateView";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getViewById";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDefault";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setDefault";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGridPlace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isToFocus";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setToFocus";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultToFocus";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "cancelDefaultFocusBy";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getToFocus";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAttractionPolicy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 7, 8, 10, 12, 13, 14, 15, 17, 19, 20, 24, 25, 27, 29, 30, 31, 32, 33, 34, 35, 36 -> new IllegalArgumentException(string);
        };
    }

    public static final class General {
        public volatile boolean horizontalToolbar = false;
        public volatile Map<String, String> focusOnCondition = new HashMap<String, String>();
        public volatile boolean isTabLabelsHidden = true;
    }
}

