/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionHelper {
    private static final Logger LOG = Logger.getInstance(ExecutionHelper.class);

    private ExecutionHelper() {
    }

    public static void showErrors(@NotNull Project myProject, @NotNull List<? extends Exception> errors, @NlsContexts.TabTitle @NotNull String tabDisplayName, @Nullable VirtualFile file) {
        if (myProject == null) {
            ExecutionHelper.$$$reportNull$$$0(0);
        }
        if (errors == null) {
            ExecutionHelper.$$$reportNull$$$0(1);
        }
        if (tabDisplayName == null) {
            ExecutionHelper.$$$reportNull$$$0(2);
        }
        ExecutionHelper.showExceptions(myProject, errors, Collections.emptyList(), tabDisplayName, file);
    }

    public static void showExceptions(@NotNull Project myProject, @NotNull List<? extends Exception> errors, @NotNull List<? extends Exception> warnings, @NlsContexts.TabTitle @NotNull String tabDisplayName, @Nullable VirtualFile file) {
        if (myProject == null) {
            ExecutionHelper.$$$reportNull$$$0(3);
        }
        if (errors == null) {
            ExecutionHelper.$$$reportNull$$$0(4);
        }
        if (warnings == null) {
            ExecutionHelper.$$$reportNull$$$0(5);
        }
        if (tabDisplayName == null) {
            ExecutionHelper.$$$reportNull$$$0(6);
        }
        errors.forEach(it -> LOG.warn(tabDisplayName + " error: " + it.getMessage()));
        warnings.forEach(it -> LOG.warn(tabDisplayName + " warning: " + it.getMessage()));
        ApplicationManager.getApplication().invokeLater(() -> {
            if (myProject.isDisposed()) {
                return;
            }
            if (errors.isEmpty() && warnings.isEmpty()) {
                ContentManagerUtil.cleanupContents(null, (Project)myProject, (String)tabDisplayName);
                return;
            }
            ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
            try {
                ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
            }
            catch (NullPointerException e) {
                Object errorText = "";
                if (!errors.isEmpty()) {
                    StringBuilder builder2 = new StringBuilder();
                    for (Exception exception : errors) {
                        builder2.append("\n");
                        builder2.append(exception.getMessage());
                    }
                    errorText = ExecutionBundle.message((String)"exception.error.text", (Object[])new Object[0]) + String.valueOf(builder2);
                }
                Object warningText = "";
                if (!warnings.isEmpty()) {
                    StringBuilder builder3 = new StringBuilder();
                    for (Exception exception : warnings) {
                        builder3.append("\n");
                        builder3.append(exception.getMessage());
                    }
                    warningText = ExecutionBundle.message((String)"warning.error.text", (Object[])new Object[0]) + String.valueOf(builder3);
                }
                Messages.showErrorDialog((String)((String)errorText + (((String)errorText).isEmpty() || ((String)warningText).isEmpty() ? "" : "\n") + (String)warningText), (String)ExecutionBundle.message((String)"execution.error", (Object[])new Object[0]));
                return;
            }
            ExecutionHelper.addMessages(4, errors, errorTreeView, file, "Unknown Error");
            ExecutionHelper.addMessages(5, warnings, errorTreeView, file, "Unknown Warning");
            ToolWindow window = ToolWindowManager.getInstance((Project)myProject).getToolWindow("Messages");
            if (window != null) {
                window.activate(null);
            }
        });
    }

    private static void addMessages(int messageCategory, @NotNull List<? extends Exception> exceptions, @NotNull ErrorViewPanel errorTreeView, @Nullable VirtualFile file, @NotNull String defaultMessage) {
        if (exceptions == null) {
            ExecutionHelper.$$$reportNull$$$0(7);
        }
        if (errorTreeView == null) {
            ExecutionHelper.$$$reportNull$$$0(8);
        }
        if (defaultMessage == null) {
            ExecutionHelper.$$$reportNull$$$0(9);
        }
        for (Exception exception : exceptions) {
            String[] messages;
            String message = exception.getMessage();
            String[] stringArray = messages = StringUtil.isNotEmpty((String)message) ? StringUtil.splitByLines((String)message) : ArrayUtilRt.EMPTY_STRING_ARRAY;
            if (messages.length == 0) {
                messages = new String[]{defaultMessage};
            }
            errorTreeView.addMessage(messageCategory, messages, file, -1, -1, null);
        }
    }

    public static void showOutput(@NotNull Project myProject, @NotNull ProcessOutput output, @NlsContexts.TabTitle @NotNull String tabDisplayName, @Nullable VirtualFile file, boolean activateWindow) {
        if (myProject == null) {
            ExecutionHelper.$$$reportNull$$$0(10);
        }
        if (output == null) {
            ExecutionHelper.$$$reportNull$$$0(11);
        }
        if (tabDisplayName == null) {
            ExecutionHelper.$$$reportNull$$$0(12);
        }
        String stdout = output.getStdout();
        String stderr = output.getStderr();
        if (ApplicationManager.getApplication().isUnitTestMode() && !stdout.isEmpty() && !stderr.isEmpty()) {
            throw new RuntimeException("STDOUT:\n" + stdout + "\nSTDERR:\n" + stderr);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow toolWindow;
            String[] stderrLines;
            String[] stdoutLines;
            if (myProject.isDisposed()) {
                return;
            }
            String stdOutTitle = "[Stdout]:";
            String stderrTitle = "[Stderr]:";
            ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
            try {
                ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
            }
            catch (NullPointerException e) {
                Messages.showErrorDialog((String)("[Stdout]:\n" + stdout + "\n[Stderr]:\n" + stderr), (String)ExecutionBundle.message((String)"process.output", (Object[])new Object[0]));
                return;
            }
            if (!StringUtil.isEmpty((String)stdout) && (stdoutLines = StringUtil.splitByLines((String)stdout)).length > 0) {
                if (StringUtil.isEmpty((String)stderr)) {
                    errorTreeView.addMessage(1, stdoutLines, file, -1, -1, null);
                } else if (file == null) {
                    errorTreeView.addMessage(1, stdoutLines, "[Stdout]:", NonNavigatable.INSTANCE, null, null, null);
                } else {
                    errorTreeView.addMessage(1, new String[]{"[Stdout]:"}, file, -1, -1, null);
                    errorTreeView.addMessage(1, new String[]{""}, file, -1, -1, null);
                    errorTreeView.addMessage(1, stdoutLines, file, -1, -1, null);
                }
            }
            if (!StringUtil.isEmpty((String)stderr) && (stderrLines = StringUtil.splitByLines((String)stderr)).length > 0) {
                if (file == null) {
                    errorTreeView.addMessage(1, stderrLines, "[Stderr]:", NonNavigatable.INSTANCE, null, null, null);
                } else {
                    errorTreeView.addMessage(1, new String[]{"[Stderr]:"}, file, -1, -1, null);
                    errorTreeView.addMessage(1, ArrayUtilRt.EMPTY_STRING_ARRAY, file, -1, -1, null);
                    errorTreeView.addMessage(1, stderrLines, file, -1, -1, null);
                }
            }
            errorTreeView.addMessage(1, new String[]{"Process finished with exit code " + output.getExitCode()}, null, -1, -1, null);
            if (activateWindow && (toolWindow = ToolWindowManager.getInstance((Project)myProject).getToolWindow("Messages")) != null) {
                toolWindow.activate(null);
            }
        });
    }

    private static void openMessagesView(@NotNull ErrorViewPanel errorTreeView, @NotNull Project myProject, @NlsContexts.TabTitle @NotNull String tabDisplayName) {
        if (errorTreeView == null) {
            ExecutionHelper.$$$reportNull$$$0(13);
        }
        if (myProject == null) {
            ExecutionHelper.$$$reportNull$$$0(14);
        }
        if (tabDisplayName == null) {
            ExecutionHelper.$$$reportNull$$$0(15);
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(myProject, () -> {
            MessageView messageView = MessageView.getInstance((Project)myProject);
            messageView.runWhenInitialized(() -> {
                Content content = ContentFactory.getInstance().createContent((JComponent)((Object)errorTreeView), tabDisplayName, true);
                messageView.getContentManager().addContent(content);
                Disposer.register((Disposable)content, (Disposable)errorTreeView);
                messageView.getContentManager().setSelectedContent(content);
                ContentManagerUtil.cleanupContents((Content)content, (Project)myProject, (String)tabDisplayName);
            });
        }, ExecutionBundle.message((String)"open.message.view", (Object[])new Object[0]), null);
    }

    public static Collection<RunContentDescriptor> findRunningConsoleByTitle(Project project, @NotNull NotNullFunction<? super String, Boolean> titleMatcher) {
        if (titleMatcher == null) {
            ExecutionHelper.$$$reportNull$$$0(16);
        }
        return ExecutionHelper.findRunningConsole(project, (NotNullFunction<? super RunContentDescriptor, Boolean>)((NotNullFunction)selectedContent -> (Boolean)titleMatcher.fun((Object)selectedContent.getDisplayName())));
    }

    public static Collection<RunContentDescriptor> findRunningConsole(@NotNull Project project, @NotNull NotNullFunction<? super RunContentDescriptor, Boolean> descriptorMatcher) {
        if (project == null) {
            ExecutionHelper.$$$reportNull$$$0(17);
        }
        if (descriptorMatcher == null) {
            ExecutionHelper.$$$reportNull$$$0(18);
        }
        return (Collection)ReadAction.compute(() -> {
            ToolWindow toolWindow;
            RunContentManager contentManager = RunContentManager.getInstance((Project)project);
            RunContentDescriptor selectedContent = contentManager.getSelectedContent();
            if (selectedContent != null && (toolWindow = contentManager.getToolWindowByDescriptor(selectedContent)) != null && toolWindow.isVisible() && ((Boolean)descriptorMatcher.fun((Object)selectedContent)).booleanValue()) {
                return Collections.singletonList(selectedContent);
            }
            SmartList result2 = new SmartList();
            for (RunContentDescriptor runContentDescriptor2 : contentManager.getAllDescriptors()) {
                if (!((Boolean)descriptorMatcher.fun((Object)runContentDescriptor2)).booleanValue()) continue;
                result2.add(runContentDescriptor2);
            }
            return result2;
        });
    }

    public static List<RunContentDescriptor> collectConsolesByDisplayName(@NotNull Project project, @NotNull NotNullFunction<? super String, Boolean> titleMatcher) {
        if (project == null) {
            ExecutionHelper.$$$reportNull$$$0(19);
        }
        if (titleMatcher == null) {
            ExecutionHelper.$$$reportNull$$$0(20);
        }
        SmartList result2 = new SmartList();
        for (RunContentDescriptor runContentDescriptor2 : ExecutionManagerImpl.getAllDescriptors(project)) {
            if (!((Boolean)titleMatcher.fun((Object)runContentDescriptor2.getDisplayName())).booleanValue()) continue;
            result2.add(runContentDescriptor2);
        }
        return result2;
    }

    public static void selectContentDescriptor(@NotNull DataContext dataContext, @NotNull Project project, @NotNull Collection<? extends RunContentDescriptor> contentDescriptors, @NlsContexts.PopupTitle String selectDialogTitle, Consumer<? super RunContentDescriptor> descriptorConsumer) {
        if (dataContext == null) {
            ExecutionHelper.$$$reportNull$$$0(21);
        }
        if (project == null) {
            ExecutionHelper.$$$reportNull$$$0(22);
        }
        if (contentDescriptors == null) {
            ExecutionHelper.$$$reportNull$$$0(23);
        }
        if (contentDescriptors.size() == 1) {
            RunContentDescriptor descriptor2 = contentDescriptors.iterator().next();
            descriptorConsumer.consume((Object)descriptor2);
            ExecutionHelper.descriptorToFront(project, descriptor2);
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Expected a single content descriptor, got " + String.valueOf(contentDescriptors));
        } else if (contentDescriptors.size() > 1) {
            Icon icon = DefaultRunExecutor.getRunExecutorInstance().getIcon();
            JBPopupFactory.getInstance().createPopupChooserBuilder(new ArrayList<RunContentDescriptor>(contentDescriptors)).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value, index) -> {
                label2.setText(value.getDisplayName());
                label2.setIcon(icon);
            })).setTitle(selectDialogTitle).setItemChosenCallback(descriptor -> {
                descriptorConsumer.consume(descriptor);
                ExecutionHelper.descriptorToFront(project, descriptor);
            }).createPopup().showInBestPositionFor(dataContext);
        }
    }

    private static void descriptorToFront(@NotNull Project project, @NotNull RunContentDescriptor descriptor) {
        if (project == null) {
            ExecutionHelper.$$$reportNull$$$0(24);
        }
        if (descriptor == null) {
            ExecutionHelper.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            RunContentManager manager = RunContentManager.getInstance((Project)project);
            ToolWindow toolWindow = manager.getToolWindowByDescriptor(descriptor);
            if (toolWindow != null) {
                toolWindow.show(null);
                manager.selectRunContent(descriptor);
            }
        }, project.getDisposed());
    }

    public static void executeExternalProcess(@Nullable Project myProject, @NotNull ProcessHandler processHandler, @NotNull ExecutionMode mode, @NotNull GeneralCommandLine cmdline) {
        if (processHandler == null) {
            ExecutionHelper.$$$reportNull$$$0(26);
        }
        if (mode == null) {
            ExecutionHelper.$$$reportNull$$$0(27);
        }
        if (cmdline == null) {
            ExecutionHelper.$$$reportNull$$$0(28);
        }
        ExecutionHelper.executeExternalProcess(myProject, processHandler, mode, cmdline.getCommandLineString());
    }

    private static void executeExternalProcess(@Nullable Project myProject, @NotNull ProcessHandler processHandler, @NotNull ExecutionMode mode, @NotNull String presentableCmdline) {
        String title;
        if (processHandler == null) {
            ExecutionHelper.$$$reportNull$$$0(29);
        }
        if (mode == null) {
            ExecutionHelper.$$$reportNull$$$0(30);
        }
        if (presentableCmdline == null) {
            ExecutionHelper.$$$reportNull$$$0(31);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.debug("Running " + presentableCmdline);
            processHandler.waitFor();
            return;
        }
        String string = title = mode.getTitle() != null ? mode.getTitle() : ExecutionBundle.message((String)"progress.title.please.wait", (Object[])new Object[0]);
        final Runnable process2 = mode.cancelable() ? ExecutionHelper.createCancelableExecutionProcess(processHandler, mode.shouldCancelFun()) : (mode.getTimeout() <= 0 ? () -> processHandler.waitFor() : ExecutionHelper.createTimeLimitedExecutionProcess(processHandler, mode, presentableCmdline));
        if (mode.withModalProgress() || !mode.inBackGround() && ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, title, mode.cancelable(), myProject, mode.getProgressParentComponent());
        } else if (mode.inBackGround()) {
            Task.Backgroundable task2 = new Task.Backgroundable(myProject, title, mode.cancelable()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    process2.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/ExecutionHelper$1", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)task2);
        } else {
            String title2 = mode.getTitle2();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null && title2 != null) {
                indicator.setText2(title2);
            }
            process2.run();
        }
    }

    private static Runnable createCancelableExecutionProcess(final @NotNull ProcessHandler processHandler, final @Nullable BooleanSupplier cancelableFun) {
        if (processHandler == null) {
            ExecutionHelper.$$$reportNull$$$0(32);
        }
        return new Runnable(){
            private ProgressIndicator myProgressIndicator;
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myWaitThread = () -> {
                try {
                    processHandler.waitFor();
                }
                finally {
                    this.mySemaphore.up();
                }
            };
            private final Runnable myCancelListener = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (myProgressIndicator != null && (myProgressIndicator.isCanceled() || !myProgressIndicator.isRunning()) || cancelableFun != null && cancelableFun.getAsBoolean() || processHandler.isProcessTerminated()) {
                            if (processHandler.isProcessTerminated()) break;
                            try {
                                processHandler.destroyProcess();
                                break;
                            }
                            finally {
                                mySemaphore.up();
                            }
                        }
                        try {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(1000L);
                                continue;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };

            @Override
            public void run() {
                this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (this.myProgressIndicator != null && StringUtil.isEmpty((String)this.myProgressIndicator.getText())) {
                    this.myProgressIndicator.setText(ExecutionBundle.message((String)"please.wait", (Object[])new Object[0]));
                }
                LOG.assertTrue(this.myProgressIndicator != null || cancelableFun != null, (Object)"Cancelable process must have an opportunity to be canceled!");
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myWaitThread);
                ApplicationManager.getApplication().executeOnPooledThread(this.myCancelListener);
                OSProcessHandler.checkEdtAndReadAction((ProcessHandler)processHandler);
                this.mySemaphore.waitFor();
            }
        };
    }

    private static Runnable createTimeLimitedExecutionProcess(final @NotNull ProcessHandler processHandler, final @NotNull ExecutionMode mode, final @NotNull String presentableCmdline) {
        if (processHandler == null) {
            ExecutionHelper.$$$reportNull$$$0(33);
        }
        if (mode == null) {
            ExecutionHelper.$$$reportNull$$$0(34);
        }
        if (presentableCmdline == null) {
            ExecutionHelper.$$$reportNull$$$0(35);
        }
        final ProcessOutput outputCollected = new ProcessOutput();
        processHandler.addProcessListener(new ProcessListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String eventText;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (StringUtil.isNotEmpty((String)(eventText = event.getText()))) {
                    if (ProcessOutputType.isStdout((Key)outputType)) {
                        outputCollected.appendStdout(eventText);
                    } else if (ProcessOutputType.isStderr((Key)outputType)) {
                        outputCollected.appendStderr(eventText);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/ExecutionHelper$3";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        final Throwable invocatorStack = new Throwable();
        return new Runnable(){
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myProcessRunnable = () -> {
                try {
                    boolean finished = processHandler.waitFor(1000L * (long)mode.getTimeout());
                    if (!finished) {
                        mode.onTimeout(processHandler, presentableCmdline, outputCollected, invocatorStack);
                        processHandler.destroyProcess();
                    }
                }
                finally {
                    this.mySemaphore.up();
                }
            };

            @Override
            public void run() {
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myProcessRunnable);
                OSProcessHandler.checkEdtAndReadAction((ProcessHandler)processHandler);
                this.mySemaphore.waitFor();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myProject";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabDisplayName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTreeView";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleMatcher";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorMatcher";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptors";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 26: 
            case 29: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdline";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableCmdline";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ExecutionHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrors";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showExceptions";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addMessages";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "showOutput";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "openMessagesView";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findRunningConsoleByTitle";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "findRunningConsole";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "collectConsolesByDisplayName";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "selectContentDescriptor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "descriptorToFront";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "executeExternalProcess";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "createCancelableExecutionProcess";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "createTimeLimitedExecutionProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class ErrorViewPanel
    extends NewErrorTreeViewPanel {
        ErrorViewPanel(@NotNull Project project) {
            if (project == null) {
                ErrorViewPanel.$$$reportNull$$$0(0);
            }
            super(project, "reference.toolWindows.messages");
            Disposer.register((Disposable)project, (Disposable)this);
        }

        protected boolean canHideWarnings() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper$ErrorViewPanel", "<init>"));
        }
    }
}

