/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationManager;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.RunDialog;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.popup.NumericMnemonicItem;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ChooseRunConfigurationPopup
implements ExecutorProvider {
    private final Project myProject;
    @NotNull
    final String myAddKey;
    @NotNull
    private final Executor myDefaultExecutor;
    @Nullable
    final Executor myAlternativeExecutor;
    private Executor myCurrentExecutor;
    boolean myEditConfiguration;
    RunListPopup myPopup;

    public ChooseRunConfigurationPopup(@NotNull Project project, @NotNull String addKey, @NotNull Executor defaultExecutor, @Nullable Executor alternativeExecutor) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(0);
        }
        if (addKey == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(1);
        }
        if (defaultExecutor == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myAddKey = addKey;
        this.myDefaultExecutor = defaultExecutor;
        this.myAlternativeExecutor = alternativeExecutor;
    }

    @RequiresBackgroundThread
    @NotNull
    ListPopupStep<?> buildStep(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertBackgroundThread();
        List<ItemWrapper<?>> settingsList = ChooseRunConfigurationManager.createSettingsList(this.myProject, this, dataContext, true);
        return new ChooseRunConfigurationManager.ConfigurationListPopupStep(this, this.myProject, this.myDefaultExecutor.getActionName(), settingsList);
    }

    void show(@NotNull ListPopupStep<?> step2) {
        if (step2 == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(4);
        }
        this.myPopup = new RunListPopup(this.myProject, null, step2, null);
        String adText = this.getAdText(this.myAlternativeExecutor);
        if (adText != null) {
            this.myPopup.setAdText(adText);
        }
        this.myPopup.showCenteredInCurrentWindow(this.myProject);
    }

    @Nullable
    @Nls
    private String getAdText(Executor alternateExecutor) {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (alternateExecutor != null && !properties.isTrueValue(this.myAddKey)) {
            return ExecutionBundle.message((String)"choose.run.configuration.popup.ad.text.hold", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("SHIFT")), alternateExecutor.getActionName()});
        }
        if (!properties.isTrueValue("run.configuration.edit.ad")) {
            return ExecutionBundle.message((String)"choose.run.configuration.popup.ad.text.edit", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("F4"))});
        }
        if (!properties.isTrueValue("run.configuration.delete.ad")) {
            return ExecutionBundle.message((String)"choose.run.configuration.popup.ad.text.delete", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("DELETE"))});
        }
        return null;
    }

    private void registerActions(final RunListPopup popup) {
        popup.registerAction("alternateExecutor", KeyStroke.getKeyStroke("shift pressed SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myAlternativeExecutor;
                ChooseRunConfigurationPopup.this.updatePresentation();
            }
        });
        popup.registerAction("restoreDefaultExecutor", KeyStroke.getKeyStroke("released SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myDefaultExecutor;
                ChooseRunConfigurationPopup.this.updatePresentation();
            }
        });
        popup.registerAction("invokeAction", KeyStroke.getKeyStroke("shift ENTER"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.handleSelect(true);
            }
        });
        popup.registerAction("editConfiguration", KeyStroke.getKeyStroke("F4"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myEditConfiguration = true;
                popup.handleSelect(true);
            }
        });
        popup.registerAction("deleteConfiguration", KeyStroke.getKeyStroke("DELETE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.removeSelected();
            }
        });
        popup.registerAction("speedsearch_bksp", KeyStroke.getKeyStroke("BACK_SPACE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedSearch speedSearch = popup.getSpeedSearch();
                if (speedSearch.isHoldingFilter()) {
                    speedSearch.backspace();
                    speedSearch.update();
                } else {
                    popup.removeSelected();
                }
            }
        });
        for (int i = 0; i < 10; ++i) {
            this.addNumberAction(popup, i);
        }
    }

    private void addNumberAction(RunListPopup popup, int number) {
        Action action = ChooseRunConfigurationPopup.createNumberAction(number, popup, this.myDefaultExecutor);
        Action action_ = ChooseRunConfigurationPopup.createNumberAction(number, popup, this.myAlternativeExecutor);
        popup.registerAction(number + "Action", KeyStroke.getKeyStroke(String.valueOf(number)), action);
        popup.registerAction(number + "Action_", KeyStroke.getKeyStroke("shift pressed " + number), action_);
        popup.registerAction(number + "Action1", KeyStroke.getKeyStroke("NUMPAD" + number), action);
        popup.registerAction(number + "Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD" + number), action_);
    }

    private void updatePresentation() {
        this.myPopup.setCaption(this.getExecutor().getActionName());
    }

    private static void execute(ItemWrapper<?> itemWrapper, @Nullable Executor executor) {
        if (executor == null) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null) {
            itemWrapper.perform(project, executor, dataContext);
        }
    }

    void editConfiguration(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(6);
        }
        Executor executor = this.getExecutor();
        PropertiesComponent.getInstance().setValue("run.configuration.edit.ad", Boolean.toString(true));
        if (RunDialog.editConfiguration(project, configuration, ExecutionBundle.message((String)"dialog.title.edit.configuration.settings", (Object[])new Object[0]), executor)) {
            RunManager.getInstance((Project)project).setSelectedConfiguration(configuration);
            ExecutorRegistryImpl.RunnerHelper.run(project, configuration.getConfiguration(), configuration, DataContext.EMPTY_CONTEXT, executor);
        }
    }

    @Deprecated
    public static void deleteConfiguration(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configurationSettings, @Nullable JBPopup popupToCancel) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(7);
        }
        if (configurationSettings == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(8);
        }
        ChooseRunConfigurationManager.deleteConfiguration(project, configurationSettings, popupToCancel);
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        Executor executor = this.myCurrentExecutor == null ? this.myDefaultExecutor : this.myCurrentExecutor;
        if (executor == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(9);
        }
        return executor;
    }

    private static Action createNumberAction(int number, ListPopupImpl listPopup, Executor executor) {
        return new MyAbstractAction(listPopup, number, executor);
    }

    @Deprecated
    @NotNull
    public static List<ItemWrapper<?>> createSettingsList(@NotNull Project project, @NotNull ExecutorProvider executorProvider, @NotNull DataContext dataContext, boolean isCreateEditAction) {
        if (project == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(10);
        }
        if (executorProvider == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(11);
        }
        if (dataContext == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(12);
        }
        List<ItemWrapper<?>> list = ChooseRunConfigurationManager.createSettingsList(project, executorProvider, dataContext, isCreateEditAction);
        if (list == null) {
            ChooseRunConfigurationPopup.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExecutor";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationSettings";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/ChooseRunConfigurationPopup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildStep";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "editConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteConfiguration";
                break;
            }
            case 9: 
            case 13: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 13 -> new IllegalStateException(string);
        };
    }

    private final class RunListPopup
    extends ListPopupImpl {
        RunListPopup(Project project, WizardPopup aParent, ListPopupStep aStep, Object parentValue) {
            super(project, aParent, aStep, parentValue);
            ChooseRunConfigurationPopup.this.registerActions(this);
        }

        protected WizardPopup createPopup(WizardPopup parent, PopupStep step2, Object parentValue) {
            return new RunListPopup(this.getProject(), parent, (ListPopupStep)step2, parentValue);
        }

        public boolean shouldBeShowing(Object value) {
            if (super.shouldBeShowing(value)) {
                return true;
            }
            if (value instanceof ChooseRunConfigurationManager.FolderWrapper) {
                ChooseRunConfigurationManager.FolderWrapper folderWrapper = (ChooseRunConfigurationManager.FolderWrapper)value;
                if (this.mySpeedSearch.isHoldingFilter()) {
                    for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : folderWrapper.myConfigurations) {
                        if (!this.mySpeedSearch.shouldBeShowing(runnerAndConfigurationSettings.getName() + runnerAndConfigurationSettings.getConfiguration().getPresentableType())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        protected ListCellRenderer<?> getListElementRenderer() {
            return new PopupListElementRenderer<Object>(this, (ListPopupImpl)this){

                protected JComponent createIconBar() {
                    JPanel res = new JPanel(new BorderLayout());
                    res.setBorder((Border)JBUI.Borders.emptyRight((int)JBUI.CurrentTheme.ActionsList.elementIconGap()));
                    res.add((Component)this.myMnemonicLabel, "West");
                    res.add((Component)this.myIconLabel, "Center");
                    return res;
                }
            };
        }

        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            if (e instanceof MouseEvent && e.isShiftDown()) {
                this.handleShiftClick(handleFinalChoices, e, this);
                return;
            }
            this._handleSelect(handleFinalChoices, e);
        }

        private void _handleSelect(boolean handleFinalChoices, InputEvent e) {
            super.handleSelect(handleFinalChoices, e);
        }

        private void handleShiftClick(boolean handleFinalChoices, InputEvent inputEvent, RunListPopup popup) {
            ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myAlternativeExecutor;
            popup._handleSelect(handleFinalChoices, inputEvent);
        }

        public void removeSelected() {
            int index;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            if (!propertiesComponent.isTrueValue("run.configuration.delete.ad")) {
                propertiesComponent.setValue("run.configuration.delete.ad", Boolean.toString(true));
            }
            if ((index = this.getSelectedIndex()) == -1) {
                return;
            }
            Object o = this.getListModel().get(index);
            if (o instanceof ItemWrapper && ((ItemWrapper)o).canBeDeleted()) {
                RunnerAndConfigurationSettings runConfig = (RunnerAndConfigurationSettings)((ItemWrapper)o).getValue();
                ChooseRunConfigurationManager.deleteConfiguration(ChooseRunConfigurationPopup.this.myProject, Objects.requireNonNull(runConfig), (JBPopup)ChooseRunConfigurationPopup.this.myPopup);
                this.getListModel().deleteItem(o);
                List values = this.getListStep().getValues();
                values.remove(o);
                if (index < values.size()) {
                    this.onChildSelectedFor(values.get(index));
                } else if (index - 1 >= 0) {
                    this.onChildSelectedFor(values.get(index - 1));
                }
            }
        }

        protected boolean isResizable() {
            return true;
        }
    }

    public static abstract class ItemWrapper<T>
    extends Wrapper {
        private final T myValue;
        private boolean myDynamic;

        protected ItemWrapper(@Nullable T value) {
            this(value, false);
        }

        protected ItemWrapper(@Nullable T value, boolean addSeparatorAbove) {
            super(addSeparatorAbove);
            this.myValue = value;
        }

        @NlsActions.ActionText
        @Nullable
        public T getValue() {
            return this.myValue;
        }

        public boolean isDynamic() {
            return this.myDynamic;
        }

        public void setDynamic(boolean b) {
            this.myDynamic = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemWrapper)) {
                return false;
            }
            return Objects.equals(this.myValue, ((ItemWrapper)o).myValue);
        }

        public int hashCode() {
            return this.myValue != null ? this.myValue.hashCode() : 0;
        }

        public abstract void perform(@NotNull Project var1, @NotNull Executor var2, @NotNull DataContext var3);

        @Nullable
        public ConfigurationType getType() {
            return null;
        }

        public boolean available(Executor executor) {
            return false;
        }

        public boolean hasActions() {
            return false;
        }

        public PopupStep<?> getNextStep(Project project, ChooseRunConfigurationPopup action) {
            return PopupStep.FINAL_CHOICE;
        }

        public static ItemWrapper<?> wrap(@NotNull Project project, @NotNull RunnerAndConfigurationSettings settings, boolean dynamic) {
            if (project == null) {
                ItemWrapper.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ItemWrapper.$$$reportNull$$$0(1);
            }
            ItemWrapper<?> result2 = ItemWrapper.wrap(project, settings);
            result2.setDynamic(dynamic);
            return result2;
        }

        public static ItemWrapper<?> wrap(final @NotNull Project project, final @NotNull RunnerAndConfigurationSettings settings) {
            if (project == null) {
                ItemWrapper.$$$reportNull$$$0(2);
            }
            if (settings == null) {
                ItemWrapper.$$$reportNull$$$0(3);
            }
            return new ItemWrapper<RunnerAndConfigurationSettings>(settings){

                @Override
                public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (executor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    RunnerAndConfigurationSettings config = (RunnerAndConfigurationSettings)this.getValue();
                    RunManager manager = RunManager.getInstance((Project)project2);
                    if (!manager.isRiderRunWidgetActive()) {
                        RunManager.getInstance((Project)project2).setSelectedConfiguration(config);
                    }
                    ExecutorRegistryImpl.RunnerHelper.run(project2, settings.getConfiguration(), settings, context, executor);
                }

                @Override
                public ConfigurationType getType() {
                    return Objects.requireNonNull((RunnerAndConfigurationSettings)this.getValue()).getType();
                }

                @Override
                public Icon getIcon() {
                    return RunManagerEx.getInstanceEx(project).getConfigurationIcon(Objects.requireNonNull((RunnerAndConfigurationSettings)this.getValue()), true);
                }

                @Override
                public String getText() {
                    return Executor.shortenNameIfNeeded((String)Objects.requireNonNull((RunnerAndConfigurationSettings)this.getValue()).getName()) + ((RunnerAndConfigurationSettings)this.getValue()).getConfiguration().getPresentableType();
                }

                @Override
                public boolean hasActions() {
                    return true;
                }

                @Override
                public boolean available(@NotNull Executor executor) {
                    RunnerAndConfigurationSettings value;
                    if (executor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return (value = (RunnerAndConfigurationSettings)this.getValue()) != null && ExecutorRegistryImpl.RunnerHelper.canRun(project, executor, settings.getConfiguration());
                }

                @Override
                public PopupStep<?> getNextStep(@NotNull Project project2, @NotNull ChooseRunConfigurationPopup action) {
                    if (project2 == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (action == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return new ChooseRunConfigurationManager.ConfigurationActionsStep(project2, action, Objects.requireNonNull((RunnerAndConfigurationSettings)this.getValue()), this.isDynamic());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executor";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "action";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "perform";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "available";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getNextStep";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @Override
        public boolean canBeDeleted() {
            return !this.isDynamic() && this.getValue() instanceof RunnerAndConfigurationSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper";
            objectArray[2] = "wrap";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyAbstractAction
    extends AbstractAction
    implements DumbAware {
        private final ListPopupImpl myListPopup;
        private final int myNumber;
        private final Executor myExecutor;

        MyAbstractAction(ListPopupImpl listPopup, int number, Executor executor) {
            this.myListPopup = listPopup;
            this.myNumber = number;
            this.myExecutor = executor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myListPopup.getSpeedSearch().isHoldingFilter()) {
                return;
            }
            for (Object item : this.myListPopup.getListStep().getValues()) {
                if (!(item instanceof ItemWrapper) || ((ItemWrapper)item).getMnemonic() != this.myNumber) continue;
                this.myListPopup.setFinalRunnable(() -> ChooseRunConfigurationPopup.execute((ItemWrapper)item, this.myExecutor));
                this.myListPopup.closeOk(null);
            }
        }
    }

    @ApiStatus.Internal
    public static abstract class Wrapper
    implements NumericMnemonicItem {
        private int myMnemonic = -1;
        private boolean myMnemonicsEnabled;
        private final boolean myAddSeparatorAbove;
        private boolean myChecked;

        protected Wrapper(boolean addSeparatorAbove) {
            this.myAddSeparatorAbove = addSeparatorAbove;
        }

        public int getMnemonic() {
            return this.myMnemonic;
        }

        @Nullable
        public Character getMnemonicChar() {
            return this.myMnemonic > -1 ? Character.valueOf(Character.forDigit(this.myMnemonic, 10)) : null;
        }

        public boolean digitMnemonicsEnabled() {
            return this.myMnemonicsEnabled;
        }

        public boolean isChecked() {
            return this.myChecked;
        }

        public void setChecked(boolean checked) {
            this.myChecked = checked;
        }

        public void setMnemonic(int mnemonic) {
            this.myMnemonic = mnemonic;
        }

        protected void setMnemonicsEnabled(boolean mnemonicsEnabled) {
            this.myMnemonicsEnabled = mnemonicsEnabled;
        }

        public boolean addSeparatorAbove() {
            return this.myAddSeparatorAbove;
        }

        @Nullable
        public abstract Icon getIcon();

        @NlsActions.ActionText
        public abstract String getText();

        public boolean canBeDeleted() {
            return false;
        }

        public String toString() {
            return "Wrapper[" + this.getText() + "]";
        }
    }
}

