/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.ProjectRunConfigurationConfigurable;
import com.intellij.execution.ui.RunToolbarPopupKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.ExperimentalUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class EditRunConfigurationsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        RunnerAndConfigurationSettings configurationSettings;
        Project project;
        if (e == null) {
            EditRunConfigurationsAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) != null && project.isDisposed()) {
            return;
        }
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        if ((configurationSettings = (RunnerAndConfigurationSettings)e.getData(RunToolbarPopupKt.RUN_CONFIGURATION_KEY)) != null) {
            new EditConfigurationsDialog(project, new ProjectRunConfigurationConfigurable(this, project){

                @Override
                protected RunnerAndConfigurationSettings getInitialSelectedConfiguration() {
                    return configurationSettings;
                }
            }, e.getDataContext()).show();
        } else {
            new EditConfigurationsDialog(project, e.getDataContext()).show();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            EditRunConfigurationsAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(true);
        if (e.getData(RunToolbarPopupKt.RUN_CONFIGURATION_KEY) != null) {
            presentation.setText(ExecutionBundle.message((String)"choose.run.popup.edit", (Object[])new Object[0]));
            presentation.setDescription(ExecutionBundle.message((String)"choose.run.popup.edit.description", (Object[])new Object[0]));
            if (!ExperimentalUI.isNewUI()) {
                presentation.setIcon(AllIcons.Actions.EditSource);
            }
        } else if ("RunConfigurationsCombobox".equals(e.getPlace())) {
            presentation.setText(ExecutionBundle.messagePointer((String)"edit.configuration.action", (Object[])new Object[0]));
            presentation.setDescription(presentation.getText());
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            EditRunConfigurationsAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/EditRunConfigurationsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/EditRunConfigurationsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

