/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.statistics.RunConfigurationUsageTriggerCollector;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.UIBundle;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0002\u001a \u0010\u000f\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a&\u0010\u0014\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u00a8\u0006\u0018"}, d2={"isOfSameType", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runnerAndConfigurationSettings", "triggerUsage", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "createEnvironmentBuilder", "Lcom/intellij/execution/runners/ExecutionEnvironmentBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Lcom/intellij/execution/Executor;", "configuration", "userApprovesStopForSameTypeConfigurations", "configName", "", "instancesCount", "", "userApprovesStopForIncompatibleConfigurations", "runningIncompatibleDescriptors", "", "Lcom/intellij/execution/ui/RunContentDescriptor;", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nExecutionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionManagerImpl.kt\ncom/intellij/execution/impl/ExecutionManagerImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1180:1\n1#2:1181\n*E\n"})
public final class ExecutionManagerImplKt {
    @ApiStatus.Internal
    public static final boolean isOfSameType(@NotNull RunnerAndConfigurationSettings $this$isOfSameType, @NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$isOfSameType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)runnerAndConfigurationSettings, (String)"runnerAndConfigurationSettings");
        if ($this$isOfSameType == runnerAndConfigurationSettings) {
            return true;
        }
        RunConfiguration runConfiguration = $this$isOfSameType.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
        RunConfiguration thisConfiguration = runConfiguration;
        RunConfiguration runConfiguration2 = runnerAndConfigurationSettings.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration2, (String)"getConfiguration(...)");
        RunConfiguration thatConfiguration = runConfiguration2;
        if (thisConfiguration == thatConfiguration) {
            return true;
        }
        if ($this$isOfSameType instanceof RunnerAndConfigurationSettingsImpl && runnerAndConfigurationSettings instanceof RunnerAndConfigurationSettingsImpl && ((RunnerAndConfigurationSettingsImpl)$this$isOfSameType).getFilePathIfRunningCurrentFile() != null) {
            return Intrinsics.areEqual((Object)((RunnerAndConfigurationSettingsImpl)$this$isOfSameType).getFilePathIfRunningCurrentFile(), (Object)((RunnerAndConfigurationSettingsImpl)runnerAndConfigurationSettings).getFilePathIfRunningCurrentFile());
        }
        if (thisConfiguration instanceof UserDataHolder) {
            RunProfile runProfile = (RunProfile)ExecutionManagerImpl.Companion.getDELEGATED_RUN_PROFILE_KEY$intellij_platform_execution_impl().get((UserDataHolder)thisConfiguration);
            if (runProfile == null) {
                return false;
            }
            RunProfile originalRunProfile = runProfile;
            if (originalRunProfile == thatConfiguration) {
                return true;
            }
            if (thatConfiguration instanceof UserDataHolder) {
                return originalRunProfile == ExecutionManagerImpl.Companion.getDELEGATED_RUN_PROFILE_KEY$intellij_platform_execution_impl().get((UserDataHolder)thatConfiguration);
            }
        }
        return false;
    }

    private static final StructuredIdeActivity triggerUsage(ExecutionEnvironment environment) {
        StructuredIdeActivity parentIdeActivity;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        boolean isDumb = DumbService.Companion.isDumb(project);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        Object runConfiguration = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
        RunConfiguration runConfiguration2 = runConfiguration;
        if (runConfiguration2 == null || (runConfiguration2 = runConfiguration2.getFactory()) == null) {
            return null;
        }
        RunConfiguration configurationFactory = runConfiguration2;
        boolean isRerun = Intrinsics.areEqual((Object)environment.getUserData(ExecutionManagerImpl.Companion.getREPORT_NEXT_START_AS_RERUN$intellij_platform_execution_impl()), (Object)true);
        boolean isServiceView = RunDashboardManager.getInstance((Project)environment.getProject()).isShowInDashboard(runConfiguration);
        if (!isRerun) {
            environment.putUserData(ExecutionManagerImpl.Companion.getREPORT_NEXT_START_AS_RERUN$intellij_platform_execution_impl(), (Object)true);
        }
        return (parentIdeActivity = (StructuredIdeActivity)environment.getUserData(ExecutionManagerImpl.Companion.getPARENT_PROFILE_IDE_ACTIVITY$intellij_platform_execution_impl())) == null ? RunConfigurationUsageTriggerCollector.trigger(environment.getProject(), (ConfigurationFactory)configurationFactory, environment.getExecutor(), runConfiguration, isRerun, environment.isRunningCurrentFile(), isDumb, isServiceView) : RunConfigurationUsageTriggerCollector.triggerWithParent(parentIdeActivity, environment.getProject(), (ConfigurationFactory)configurationFactory, environment.getExecutor(), runConfiguration, isRerun, environment.isRunningCurrentFile(), isDumb, isServiceView);
    }

    private static final ExecutionEnvironmentBuilder createEnvironmentBuilder(Project project, Executor executor, RunnerAndConfigurationSettings configuration) {
        ProgramRunner runner;
        ExecutionEnvironmentBuilder builder2 = new ExecutionEnvironmentBuilder(project, executor);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = configuration;
        if (runnerAndConfigurationSettings != null) {
            RunnerAndConfigurationSettings it = runnerAndConfigurationSettings;
            boolean bl = false;
            v1 = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)((RunProfile)it.getConfiguration()));
        } else {
            v1 = runner = null;
        }
        if (runner == null && configuration != null) {
            ExecutionManagerImpl.Companion.getLOG().error("Cannot find runner for " + configuration.getName());
        } else if (runner != null) {
            builder2.runnerAndSettings(runner, configuration);
        }
        return builder2;
    }

    private static final boolean userApprovesStopForSameTypeConfigurations(Project project, String configName, int instancesCount) {
        RunManagerConfig config = RunManagerImpl.Companion.getInstanceImpl(project).getConfig();
        if (!config.isRestartRequiresConfirmation()) {
            return true;
        }
        DoNotAskOption option2 = new DoNotAskOption(config){
            final /* synthetic */ RunManagerConfig $config;
            {
                this.$config = $config;
            }

            public boolean isToBeShown() {
                return this.$config.isRestartRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                this.$config.setRestartRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            public String getDoNotShowMessage() {
                String string = UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
        Object[] objectArray = new Object[]{configName, instancesCount};
        String string = ExecutionBundle.message((String)"rerun.singleton.confirmation.message", (Object[])objectArray);
        objectArray = new Object[]{configName};
        return Messages.showOkCancelDialog((Project)project, (String)string, (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])objectArray), (String)ExecutionBundle.message((String)"rerun.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DoNotAskOption)option2) == 0;
    }

    private static final boolean userApprovesStopForIncompatibleConfigurations(Project project, String configName, List<? extends RunContentDescriptor> runningIncompatibleDescriptors) {
        RunManagerConfig config = RunManagerImpl.Companion.getInstanceImpl(project).getConfig();
        if (!config.isStopIncompatibleRequiresConfirmation()) {
            return true;
        }
        DoNotAskOption option2 = new DoNotAskOption(config){
            final /* synthetic */ RunManagerConfig $config;
            {
                this.$config = $config;
            }

            public boolean isToBeShown() {
                return this.$config.isStopIncompatibleRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                this.$config.setStopIncompatibleRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            public String getDoNotShowMessage() {
                String string = UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
        StringBuilder names = new StringBuilder();
        for (RunContentDescriptor runContentDescriptor2 : runningIncompatibleDescriptors) {
            String string;
            CharSequence charSequence;
            String name = runContentDescriptor2.getDisplayName();
            if (((CharSequence)names).length() > 0) {
                names.append(", ");
            }
            if ((charSequence = (CharSequence)name) == null || charSequence.length() == 0) {
                string = ExecutionBundle.message((String)"run.configuration.no.name", (Object[])new Object[0]);
            } else {
                String string2 = "'%s'";
                Object[] objectArray = new Object[]{name};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            }
            names.append(string);
        }
        Object[] objectArray = new Object[]{configName, names.toString(), runningIncompatibleDescriptors.size()};
        String string = ExecutionBundle.message((String)"stop.incompatible.confirmation.message", (Object[])objectArray);
        objectArray = new Object[]{runningIncompatibleDescriptors.size()};
        return Messages.showOkCancelDialog((Project)project, (String)string, (String)ExecutionBundle.message((String)"incompatible.configuration.is.running.dialog.title", (Object[])objectArray), (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DoNotAskOption)option2) == 0;
    }

    public static final /* synthetic */ StructuredIdeActivity access$triggerUsage(ExecutionEnvironment environment) {
        return ExecutionManagerImplKt.triggerUsage(environment);
    }

    public static final /* synthetic */ ExecutionEnvironmentBuilder access$createEnvironmentBuilder(Project project, Executor executor, RunnerAndConfigurationSettings configuration) {
        return ExecutionManagerImplKt.createEnvironmentBuilder(project, executor, configuration);
    }

    public static final /* synthetic */ boolean access$userApprovesStopForSameTypeConfigurations(Project project, String configName, int instancesCount) {
        return ExecutionManagerImplKt.userApprovesStopForSameTypeConfigurations(project, configName, instancesCount);
    }

    public static final /* synthetic */ boolean access$userApprovesStopForIncompatibleConfigurations(Project project, String configName, List runningIncompatibleDescriptors) {
        return ExecutionManagerImplKt.userApprovesStopForIncompatibleConfigurations(project, configName, runningIncompatibleDescriptors);
    }
}

