/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class RerunTestsAction
extends DumbAwareAction {
    public static final String ID = "RerunTests";
    private static final Set<RunContentDescriptor> REGISTRY = new HashSet<RunContentDescriptor>();

    public static void register(final @NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            RerunTestsAction.$$$reportNull$$$0(0);
        }
        if (descriptor.getComponent() != null && REGISTRY.add(descriptor)) {
            Disposer.register((Disposable)descriptor, (Disposable)new Disposable(){

                public void dispose() {
                    REGISTRY.remove(descriptor);
                }
            });
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RerunTestsAction.$$$reportNull$$$0(1);
        }
        ArrayList<RunContentDescriptor> descriptors = new ArrayList<RunContentDescriptor>(REGISTRY);
        for (RunContentDescriptor descriptor : descriptors) {
            RunContentManager runContentManager;
            if (descriptor.getComponent() == null) {
                REGISTRY.remove(descriptor);
                continue;
            }
            Project project = e.getProject();
            if (project == null || (runContentManager = RunContentManager.getInstance((Project)project)).getToolWindowByDescriptor(descriptor) == null) continue;
            ExecutionUtil.restart((RunContentDescriptor)descriptor);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RerunTestsAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RerunTestsAction.$$$reportNull$$$0(3);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/RerunTestsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/RerunTestsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

