/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerProxy;
import com.intellij.execution.dashboard.RunDashboardUiManager;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunContentManagerImplKt;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.execution.ui.layout.impl.DockableGridContainerFactory;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.icons.CustomIconUtilKt;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EmptyIcon;
import java.awt.KeyboardFocusManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import javax.swing.Icon;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 P2\u00020\u0001:\u0002PQB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\tH\u0017J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J*\u0010\u0019\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\tH\u0016J\n\u0010&\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0018\u0010)\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\tH\u0016J \u0010)\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\t2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\n\u0012\u0004\u0012\u000202\u0018\u0001012\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u001a\u00103\u001a\u0004\u0018\u00010\t2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0016J\"\u0010)\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\t2\b\u00105\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u00106\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002J\u0018\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0018\u0010;\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J#\u0010<\u001a\u00020\u00102\u0018\u0010=\u001a\u0014\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100>H\u0082\bJ\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020\t0@H\u0016J\u0010\u0010A\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010B\u001a\u00020CH\u0002J\u0014\u0010D\u001a\u0004\u0018\u00010\u000b2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\u0010\u0010G\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J\u001a\u0010H\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010I\u001a\u00020\u0018H\u0002J\u0016\u0010J\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\tJ\u0018\u0010K\u001a\u00020\u00102\u0006\u0010L\u001a\u00020\u00162\u0006\u0010M\u001a\u00020(H\u0002J\u0018\u0010N\u001a\u00020\u00102\u0006\u0010M\u001a\u00020(2\u0006\u0010O\u001a\u00020:H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006R"}, d2={"Lcom/intellij/execution/ui/RunContentManagerImpl;", "Lcom/intellij/execution/ui/RunContentManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "descriptors", "", "Lcom/intellij/execution/RunContentDescriptorId;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "toolWindowIdToBaseIcon", "", "Ljavax/swing/Icon;", "toolWindowIdZBuffer", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "init", "", "registerRunContentDescriptor", "descriptor", "getRunContentDescriptors", "", "registerToolWindow", "Lcom/intellij/ui/content/ContentManager;", "executor", "Lcom/intellij/execution/Executor;", "initToolWindow", "toolWindowId", "toolWindowIcon", "contentManager", "syncPublisher", "Lcom/intellij/execution/ui/RunContentWithExecutorListener;", "getSyncPublisher", "()Lcom/intellij/execution/ui/RunContentWithExecutorListener;", "toFrontRunContent", "requestor", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "hideRunContent", "getSelectedContent", "removeRunContent", "", "showRunContent", "executionId", "", "getContentManagerByToolWindowId", "getReuseContent", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getReuseCondition", "Ljava/util/function/Predicate;", "Lcom/intellij/ui/content/Content;", "findContentDescriptor", "info", "contentToReuse", "getContentManagerForRunner", "getOrCreateContentManagerForToolWindow", "id", "getToolWindowByDescriptor", "Lcom/intellij/openapi/wm/ToolWindow;", "updateToolWindowDecoration", "processToolWindowContentManagers", "processor", "Lkotlin/Function2;", "getAllDescriptors", "", "selectRunContent", "getToolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "getContentDescriptorToolWindowId", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getToolWindowIdByEnvironment", "getDescriptorBy", "runnerInfo", "moveContent", "updateToolWindowIcon", "contentManagerToUpdate", "alive", "setToolWindowIcon", "toolWindow", "Companion", "CloseListener", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunContentManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunContentManagerImpl.kt\ncom/intellij/execution/ui/RunContentManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,774:1\n518#1,17:776\n518#1,17:793\n518#1,17:810\n518#1,17:827\n23#2:775\n*S KotlinDebug\n*F\n+ 1 RunContentManagerImpl.kt\ncom/intellij/execution/ui/RunContentManagerImpl\n*L\n497#1:776,17\n538#1:793,17\n550#1:810,17\n624#1:827,17\n151#1:775\n*E\n"})
public final class RunContentManagerImpl
implements RunContentManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<RunContentDescriptorId, RunContentDescriptor> descriptors;
    @NotNull
    private final Map<String, Icon> toolWindowIdToBaseIcon;
    @NotNull
    private final ConcurrentLinkedDeque<String> toolWindowIdZBuffer;
    @JvmField
    @NotNull
    public static final Key<Boolean> ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<RunnerAndConfigurationSettings> TEMPORARY_CONFIGURATION_KEY;

    public RunContentManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.descriptors = new ConcurrentHashMap();
        this.toolWindowIdToBaseIcon = new HashMap();
        this.toolWindowIdZBuffer = new ConcurrentLinkedDeque();
        DockableGridContainerFactory containerFactory = new DockableGridContainerFactory();
        DockManager.getInstance((Project)this.project).register("runner-grid", (DockContainerFactory)containerFactory, (Disposable)this.project);
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.project)).submit(() -> RunContentManagerImpl._init_$lambda$0(this));
    }

    private final void init() {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(this){
            final /* synthetic */ RunContentManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                RunContentManagerImpl.access$getToolWindowIdZBuffer$p(this.this$0).retainAll(toolWindowManager.getToolWindowIdSet());
                String activeToolWindowId = toolWindowManager.getActiveToolWindowId();
                if (activeToolWindowId != null && RunContentManagerImpl.access$getToolWindowIdZBuffer$p(this.this$0).remove(activeToolWindowId)) {
                    RunContentManagerImpl.access$getToolWindowIdZBuffer$p(this.this$0).addFirst(activeToolWindowId);
                }
            }
        });
        messageBusConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(this){
            final /* synthetic */ RunContentManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void beforePluginUnload(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    RunContentManagerImpl this_$iv = this.this$0;
                    boolean $i$f$processToolWindowContentManagers = false;
                    ToolWindowManager toolWindowManager$iv = RunContentManagerImpl.access$getToolWindowManager(this_$iv);
                    HashSet<String> processedToolWindowIds$iv = new HashSet<String>();
                    for (Executor executor$iv : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                        Content[] contents;
                        ContentManager contentManager;
                        ToolWindow toolWindow$iv;
                        String toolWindowId$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)executor$iv.getToolWindowId(), (String)"getToolWindowId(...)");
                        if (!processedToolWindowIds$iv.add(toolWindowId$iv) || toolWindowManager$iv.getToolWindow(toolWindowId$iv) == null || toolWindow$iv.getContentManagerIfCreated() == null) continue;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)contentManager.getContents(), (String)"getContents(...)");
                        int n = contents.length;
                        for (int i = 0; i < n; ++i) {
                            RunContentDescriptor runContentDescriptor2;
                            Content content = contents[i];
                            Intrinsics.checkNotNull((Object)content);
                            if (RunContentManagerImpl.Companion.getRunContentDescriptorByContent(content) == null) continue;
                            ProcessHandler processHandler = runContentDescriptor2.getProcessHandler();
                            boolean bl2 = processHandler != null ? processHandler.isProcessTerminated() : false;
                            if (!bl2) continue;
                            contentManager.removeContent(content, true);
                        }
                    }
                    RunDashboardUiManager runDashboardUiManager = RunDashboardUiManager.getInstanceIfCreated((Project)RunContentManagerImpl.access$getProject$p(this_$iv));
                    if (runDashboardUiManager == null) break block4;
                    RunDashboardUiManager it$iv = runDashboardUiManager;
                    boolean bl = false;
                    String string = it$iv.getToolWindowId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolWindowId(...)");
                    String toolWindowId$iv = string;
                    if (RunContentManagerImpl.access$getToolWindowIdToBaseIcon$p(this_$iv).containsKey(toolWindowId$iv) && toolWindowManager$iv.getToolWindow(toolWindowId$iv) != null) {
                        void contentManager;
                        ContentManager contentManager2 = it$iv.getDashboardContentManager();
                        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getDashboardContentManager(...)");
                        ContentManager bl3 = contentManager2;
                        boolean $i$a$-processToolWindowContentManagers-RunContentManagerImpl$init$2$beforePluginUnload$2 = false;
                        Content[] contentArray = contentManager.getContents();
                        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                        for (Content content : contentArray) {
                            RunContentDescriptor runContentDescriptor3;
                            Intrinsics.checkNotNull((Object)content);
                            if (RunContentManagerImpl.Companion.getRunContentDescriptorByContent(content) == null) continue;
                            ProcessHandler processHandler = runContentDescriptor3.getProcessHandler();
                            boolean bl4 = processHandler != null ? processHandler.isProcessTerminated() : false;
                            if (!bl4) continue;
                            contentManager.removeContent(content, true);
                        }
                    }
                }
            }
        });
    }

    @ApiStatus.Internal
    public void registerRunContentDescriptor(@NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        RunContentDescriptorId runContentDescriptorId = descriptor.getId();
        if (runContentDescriptorId == null) {
            RunContentManagerImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(RunContentManagerImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("ContentDescriptorId was not assigned to descriptor " + descriptor);
            return;
        }
        this.descriptors.put(runContentDescriptorId, descriptor);
        Disposer.register((Disposable)((Disposable)descriptor), () -> RunContentManagerImpl.registerRunContentDescriptor$lambda$0(this, runContentDescriptorId));
    }

    @ApiStatus.Internal
    @NotNull
    public Collection<RunContentDescriptor> getRunContentDescriptors() {
        return this.descriptors.values();
    }

    @ApiStatus.Internal
    @NotNull
    public final ContentManager registerToolWindow(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        ToolWindowManager toolWindowManager = this.getToolWindowManager();
        String string = executor.getToolWindowId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolWindowId(...)");
        String toolWindowId = string;
        ToolWindow toolWindow = toolWindowManager.getToolWindow(toolWindowId);
        if (toolWindow != null) {
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            return contentManager;
        }
        toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(toolWindowId, null, null, false, false, false, false, null, executor.getToolWindowIcon(), () -> ((Executor)executor).getActionName(), 254, null));
        toolWindow.setToHideOnEmptyContent(true);
        if (Intrinsics.areEqual((Object)"Run", (Object)executor.getId()) || Registry.Companion.is("debugger.new.tool.window.layout.dnd", false)) {
            ToolWindowContentUi.setAllowTabsReordering((ToolWindow)toolWindow, (boolean)true);
        }
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        contentManager2.addUiDataProvider(arg_0 -> RunContentManagerImpl.registerToolWindow$lambda$0(executor, arg_0));
        Icon icon = executor.getToolWindowIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getToolWindowIcon(...)");
        this.initToolWindow(executor, toolWindowId, icon, contentManager2);
        return contentManager2;
    }

    private final void initToolWindow(Executor executor, String toolWindowId, Icon toolWindowIcon, ContentManager contentManager) {
        this.toolWindowIdToBaseIcon.put(toolWindowId, toolWindowIcon);
        contentManager.addContentManagerListener(new ContentManagerListener(executor, this){
            final /* synthetic */ Executor $executor;
            final /* synthetic */ RunContentManagerImpl this$0;
            {
                this.$executor = $executor;
                this.this$0 = $receiver;
            }

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                    return;
                }
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                Content content2 = content;
                Executor executor = this.$executor;
                if (executor == null) {
                    Executor executor2 = RunContentManagerImpl.Companion.getExecutorByContent(content2);
                    executor = executor2;
                    Intrinsics.checkNotNull((Object)executor2);
                }
                Executor contentExecutor = executor;
                RunContentManagerImpl.access$getSyncPublisher(this.this$0).contentSelected(RunContentManagerImpl.Companion.getRunContentDescriptorByContent(content2), contentExecutor);
                content2.setHelpId(contentExecutor.getHelpId());
            }
        });
        Disposer.register((Disposable)((Disposable)contentManager), () -> RunContentManagerImpl.initToolWindow$lambda$0(contentManager, this, toolWindowId));
        this.toolWindowIdZBuffer.addLast(toolWindowId);
    }

    private final RunContentWithExecutorListener getSyncPublisher() {
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = RunContentManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        Object object = messageBus.syncPublisher(topic);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        return (RunContentWithExecutorListener)object;
    }

    public void toFrontRunContent(@NotNull Executor requestor, @NotNull ProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        RunContentDescriptor runContentDescriptor2 = this.getDescriptorBy(handler2, requestor);
        if (runContentDescriptor2 == null) {
            return;
        }
        RunContentDescriptor descriptor = runContentDescriptor2;
        this.toFrontRunContent(requestor, descriptor);
    }

    public void toFrontRunContent(@NotNull Executor requestor, @NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ApplicationManager.getApplication().invokeLater(() -> RunContentManagerImpl.toFrontRunContent$lambda$0(this, requestor, descriptor), this.project.getDisposed());
    }

    public void hideRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ApplicationManager.getApplication().invokeLater(() -> RunContentManagerImpl.hideRunContent$lambda$0(this, executor, descriptor), this.project.getDisposed());
    }

    @Nullable
    public RunContentDescriptor getSelectedContent() {
        Iterator<String> iterator = this.toolWindowIdZBuffer.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<String> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ContentManager contentManager;
            String activeWindow = iterator2.next();
            Intrinsics.checkNotNull((Object)activeWindow);
            if (this.getContentManagerByToolWindowId(activeWindow) == null) continue;
            Content content = contentManager.getSelectedContent();
            if (content == null) {
                if (contentManager.getContentCount() != 0) break;
                continue;
            }
            Content selectedContent = content;
            return Companion.getRunContentDescriptorByContent(selectedContent);
        }
        return null;
    }

    public boolean removeRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ContentManager contentManager = this.getContentManagerForRunner(executor, descriptor);
        Content content = RunContentManagerImplKt.access$getRunContentByDescriptor(contentManager, descriptor);
        return content != null && contentManager.removeContent(content, true);
    }

    public void showRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.showRunContent(executor, descriptor, descriptor.getExecutionId());
    }

    private final void showRunContent(Executor executor, RunContentDescriptor descriptor, long executionId) {
        String toolWindowId;
        block15: {
            Content content;
            block14: {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                this.registerRunContentDescriptor(descriptor);
                ContentManager contentManager = this.getContentManagerForRunner(executor, descriptor);
                toolWindowId = RunContentManagerImplKt.access$getToolWindowIdForRunner(executor, descriptor);
                RunContentDescriptor oldDescriptor = RunContentManagerImplKt.access$chooseReuseContentForDescriptor(contentManager, descriptor, executionId, descriptor.getDisplayName(), this.getReuseCondition(toolWindowId));
                content = null;
                if (oldDescriptor == null) {
                    content = RunContentManagerImplKt.access$createNewContent(descriptor, executor);
                } else {
                    Content content2 = oldDescriptor.getAttachedContent();
                    Intrinsics.checkNotNull((Object)content2);
                    content = content2;
                    SingleContentSupplier.Companion.removeSubContentsOfContent(content, true);
                    this.getSyncPublisher().contentRemoved(oldDescriptor, executor);
                    Disposer.dispose((Disposable)((Disposable)oldDescriptor));
                }
                content.setExecutionId(executionId);
                content.setComponent(descriptor.getComponent());
                content.setPreferredFocusedComponent(descriptor.getPreferredFocusComputable());
                content.putUserData(RunContentDescriptor.DESCRIPTOR_KEY, (Object)descriptor);
                content.putUserData(RunContentManagerImplKt.EXECUTOR_KEY, (Object)executor);
                content.setDisplayName(descriptor.getDisplayName());
                CoroutineScope coroutineScope = descriptor.getCoroutineScope();
                Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(descriptor, content, null){
                    int label;
                    final /* synthetic */ RunContentDescriptor $descriptor;
                    final /* synthetic */ Content $content;
                    {
                        this.$descriptor = $descriptor;
                        this.$content = $content;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$descriptor.getDisplayNameProperty().collect(new FlowCollector(this.$content){
                                    final /* synthetic */ Content $content;
                                    {
                                        this.$content = $content;
                                    }

                                    public final Object emit(String it, Continuation<? super Unit> $completion) {
                                        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$content, it, null){
                                            int label;
                                            final /* synthetic */ Content $content;
                                            final /* synthetic */ String $it;
                                            {
                                                this.$content = $content;
                                                this.$it = $it;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.$content.setDisplayName(this.$it);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), $completion);
                                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            return object;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }, (Continuation)this);
                                if (object2 != object) throw new KotlinNothingValueException();
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                throw new KotlinNothingValueException();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                descriptor.setAttachedContent(content);
                ToolWindow toolWindow = this.getToolWindowManager().getToolWindow(toolWindowId);
                ProcessHandler processHandler = descriptor.getProcessHandler();
                if (processHandler != null) {
                    ProcessListener processAdapter2 = new ProcessListener(descriptor, content, this, toolWindowId, toolWindow, processHandler, executor){
                        private volatile boolean processTerminated;
                        private Job startNotifiedJob;
                        final /* synthetic */ RunContentDescriptor $descriptor;
                        final /* synthetic */ Content $content;
                        final /* synthetic */ RunContentManagerImpl this$0;
                        final /* synthetic */ String $toolWindowId;
                        final /* synthetic */ ToolWindow $toolWindow;
                        final /* synthetic */ ProcessHandler $processHandler;
                        final /* synthetic */ Executor $executor;
                        {
                            this.$descriptor = $descriptor;
                            this.$content = $content;
                            this.this$0 = $receiver;
                            this.$toolWindowId = $toolWindowId;
                            this.$toolWindow = $toolWindow;
                            this.$processHandler = $processHandler;
                            this.$executor = $executor;
                        }

                        public final boolean getProcessTerminated() {
                            return this.processTerminated;
                        }

                        public final void setProcessTerminated(boolean bl) {
                            this.processTerminated = bl;
                        }

                        public void startNotified(ProcessEvent event) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            CoroutineScope coroutineScope = this.$descriptor.getCoroutineScope();
                            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
                            this.startNotifiedJob = BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$content, this.$descriptor, this.this$0, this.$toolWindowId, this.$toolWindow, null){
                                int label;
                                final /* synthetic */ Content $content;
                                final /* synthetic */ RunContentDescriptor $descriptor;
                                final /* synthetic */ RunContentManagerImpl this$0;
                                final /* synthetic */ String $toolWindowId;
                                final /* synthetic */ ToolWindow $toolWindow;
                                {
                                    this.$content = $content;
                                    this.$descriptor = $descriptor;
                                    this.this$0 = $receiver;
                                    this.$toolWindowId = $toolWindowId;
                                    this.$toolWindow = $toolWindow;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$content, this.$descriptor, this.this$0, this.$toolWindowId, this.$toolWindow, null){
                                                int label;
                                                final /* synthetic */ Content $content;
                                                final /* synthetic */ RunContentDescriptor $descriptor;
                                                final /* synthetic */ RunContentManagerImpl this$0;
                                                final /* synthetic */ String $toolWindowId;
                                                final /* synthetic */ ToolWindow $toolWindow;
                                                {
                                                    this.$content = $content;
                                                    this.$descriptor = $descriptor;
                                                    this.this$0 = $receiver;
                                                    this.$toolWindowId = $toolWindowId;
                                                    this.$toolWindow = $toolWindow;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            this.$content.setIcon(RunContentManagerImpl.Companion.getLiveIndicator(this.$descriptor.getIcon()));
                                                            Icon toolWindowIcon = (Icon)RunContentManagerImpl.access$getToolWindowIdToBaseIcon$p(this.this$0).get(this.$toolWindowId);
                                                            if (ExperimentalUI.Companion.isNewUI() && toolWindowIcon instanceof ScalableIcon) {
                                                                toolWindowIcon = CustomIconUtilKt.loadIconCustomVersionOrScale((ScalableIcon)((ScalableIcon)toolWindowIcon), (int)20);
                                                            }
                                                            ToolWindow toolWindow = this.$toolWindow;
                                                            Intrinsics.checkNotNull((Object)toolWindow);
                                                            toolWindow.setIcon(RunContentManagerImpl.Companion.getLiveIndicator(toolWindowIcon));
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            CoroutineScope coroutineScope2 = this.$descriptor.getCoroutineScope();
                            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope2, (String)"getCoroutineScope(...)");
                            BuildersKt.launch$default((CoroutineScope)coroutineScope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$processHandler, this, this.$content, null){
                                long J$0;
                                int label;
                                final /* synthetic */ ProcessHandler $processHandler;
                                final /* synthetic */ showRunContent.processAdapter.1 this$0;
                                final /* synthetic */ Content $content;
                                {
                                    this.$processHandler = $processHandler;
                                    this.this$0 = $receiver;
                                    this.$content = $content;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = this.$processHandler.getNativePid();
                                            if (v0 == null) ** GOTO lbl16
                                            this.label = 1;
                                            v1 = FutureKt.await((CompletionStage)((CompletionStage)v0), (Continuation)((Continuation)this));
                                            if (v1 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl15
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl15:
                                            // 2 sources

                                            if ((v0 = (Long)v1) != null) ** GOTO lbl17
lbl16:
                                            // 2 sources

                                            return Unit.INSTANCE;
lbl17:
                                            // 1 sources

                                            this.J$0 = pid = v0.longValue();
                                            this.label = 2;
                                            v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$content, pid, null){
                                                int label;
                                                final /* synthetic */ showRunContent.processAdapter.1 this$0;
                                                final /* synthetic */ Content $content;
                                                final /* synthetic */ long $pid;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$content = $content;
                                                    this.$pid = $pid;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            if (!this.this$0.getProcessTerminated()) {
                                                                Object[] objectArray = new Object[]{Boxing.boxLong((long)this.$pid)};
                                                                this.$content.setDescription(ExecutionBundle.message((String)"process.id.tooltip", (Object[])objectArray));
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v2 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl27
                                        }
                                        case 2: {
                                            pid = this.J$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl27:
                                            // 2 sources

                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            CoroutineScope coroutineScope3 = this.$descriptor.getCoroutineScope();
                            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope3, (String)"getCoroutineScope(...)");
                            BuildersKt.launch$default((CoroutineScope)coroutineScope3, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$descriptor, this, this.$content, null){
                                int label;
                                final /* synthetic */ RunContentDescriptor $descriptor;
                                final /* synthetic */ showRunContent.processAdapter.1 this$0;
                                final /* synthetic */ Content $content;
                                {
                                    this.$descriptor = $descriptor;
                                    this.this$0 = $receiver;
                                    this.$content = $content;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.$descriptor.getIconProperty().collect(new FlowCollector(this.this$0, this.$content){
                                                final /* synthetic */ showRunContent.processAdapter.1 this$0;
                                                final /* synthetic */ Content $content;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$content = $content;
                                                }

                                                public final Object emit(Icon it, Continuation<? super Unit> $completion) {
                                                    Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$content, it, null){
                                                        int label;
                                                        final /* synthetic */ showRunContent.processAdapter.1 this$0;
                                                        final /* synthetic */ Content $content;
                                                        final /* synthetic */ Icon $it;
                                                        {
                                                            this.this$0 = $receiver;
                                                            this.$content = $content;
                                                            this.$it = $it;
                                                            super(2, $completion);
                                                        }

                                                        public final Object invokeSuspend(Object $result) {
                                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    if (!this.this$0.getProcessTerminated()) {
                                                                        this.$content.setIcon(RunContentManagerImpl.Companion.getLiveIndicator(this.$it));
                                                                    }
                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                        }

                                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    }), $completion);
                                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                        return object;
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            }, (Continuation)this);
                                            if (object2 != object) throw new KotlinNothingValueException();
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            throw new KotlinNothingValueException();
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }

                        public void processTerminated(ProcessEvent event) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            this.processTerminated = true;
                            CoroutineScope coroutineScope = this.$descriptor.getCoroutineScope();
                            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, this.this$0, this.$toolWindowId, this.$toolWindow, this.$descriptor, this.$content, this.$executor, null){
                                int label;
                                final /* synthetic */ showRunContent.processAdapter.1 this$0;
                                final /* synthetic */ RunContentManagerImpl this$1;
                                final /* synthetic */ String $toolWindowId;
                                final /* synthetic */ ToolWindow $toolWindow;
                                final /* synthetic */ RunContentDescriptor $descriptor;
                                final /* synthetic */ Content $content;
                                final /* synthetic */ Executor $executor;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                    this.$toolWindowId = $toolWindowId;
                                    this.$toolWindow = $toolWindow;
                                    this.$descriptor = $descriptor;
                                    this.$content = $content;
                                    this.$executor = $executor;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Job job = showRunContent.processAdapter.1.access$getStartNotifiedJob$p(this.this$0);
                                            if (job == null) break;
                                            this.label = 1;
                                            Object object2 = job.join((Continuation)this);
                                            if (object2 == object) {
                                                return object;
                                            }
                                            break;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            break;
                                        }
                                    }
                                    this.label = 2;
                                    Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.$toolWindowId, this.$toolWindow, this.$descriptor, this.$content, this.$executor, null){
                                        int label;
                                        final /* synthetic */ RunContentManagerImpl this$0;
                                        final /* synthetic */ String $toolWindowId;
                                        final /* synthetic */ ToolWindow $toolWindow;
                                        final /* synthetic */ RunContentDescriptor $descriptor;
                                        final /* synthetic */ Content $content;
                                        final /* synthetic */ Executor $executor;
                                        {
                                            this.this$0 = $receiver;
                                            this.$toolWindowId = $toolWindowId;
                                            this.$toolWindow = $toolWindow;
                                            this.$descriptor = $descriptor;
                                            this.$content = $content;
                                            this.$executor = $executor;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    Icon icon;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    if (RunContentManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                                                        return Unit.INSTANCE;
                                                    }
                                                    ContentManager contentManager = RunContentManagerImpl.access$getContentManagerByToolWindowId(this.this$0, this.$toolWindowId);
                                                    if (contentManager == null) {
                                                        return Unit.INSTANCE;
                                                    }
                                                    ContentManager manager = contentManager;
                                                    boolean alive = RunContentManagerImplKt.access$isAlive(manager);
                                                    boolean bl = alive;
                                                    ToolWindow toolWindow = this.$toolWindow;
                                                    Intrinsics.checkNotNull((Object)toolWindow);
                                                    RunContentManagerImpl.access$setToolWindowIcon(this.this$0, bl, toolWindow);
                                                    Icon icon2 = icon = this.$descriptor.getIcon();
                                                    this.$content.setIcon(icon2 == null ? this.$executor.getDisabledIcon() : IconLoader.getTransparentIcon((Icon)icon2));
                                                    this.$content.setDescription(null);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    if (object3 != object) return Unit.INSTANCE;
                                    return object;
                                    {
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }

                        public static final /* synthetic */ Job access$getStartNotifiedJob$p(showRunContent.processAdapter.1 $this) {
                            return $this.startNotifiedJob;
                        }
                    };
                    processHandler.addProcessListener(processAdapter2);
                    Disposable disposer = content.getDisposer();
                    if (disposer != null) {
                        Disposer.register((Disposable)disposer, () -> RunContentManagerImpl.showRunContent$lambda$0(processHandler, processAdapter2));
                    }
                } else {
                    CoroutineScope coroutineScope2 = descriptor.getCoroutineScope();
                    Intrinsics.checkNotNullExpressionValue((Object)coroutineScope2, (String)"getCoroutineScope(...)");
                    BuildersKt.launch$default((CoroutineScope)coroutineScope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(descriptor, content, executor, null){
                        int label;
                        final /* synthetic */ RunContentDescriptor $descriptor;
                        final /* synthetic */ Content $content;
                        final /* synthetic */ Executor $executor;
                        {
                            this.$descriptor = $descriptor;
                            this.$content = $content;
                            this.$executor = $executor;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.$descriptor.getIconProperty().collect(new FlowCollector(this.$content, this.$executor){
                                        final /* synthetic */ Content $content;
                                        final /* synthetic */ Executor $executor;
                                        {
                                            this.$content = $content;
                                            this.$executor = $executor;
                                        }

                                        public final Object emit(Icon it, Continuation<? super Unit> $completion) {
                                            Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$content, it, this.$executor, null){
                                                int label;
                                                final /* synthetic */ Content $content;
                                                final /* synthetic */ Icon $it;
                                                final /* synthetic */ Executor $executor;
                                                {
                                                    this.$content = $content;
                                                    this.$it = $it;
                                                    this.$executor = $executor;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Icon icon = this.$it;
                                                            if (icon == null) {
                                                                Icon icon2 = this.$executor.getToolWindowIcon();
                                                                icon = icon2;
                                                                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getToolWindowIcon(...)");
                                                            }
                                                            this.$content.setIcon(icon);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), $completion);
                                            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                return object;
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }, (Continuation)this);
                                    if (object2 != object) throw new KotlinNothingValueException();
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    throw new KotlinNothingValueException();
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                if (oldDescriptor == null) {
                    contentManager.addContent(content);
                    content.putUserData(Content.CLOSE_LISTENER_KEY, (Object)new CloseListener(content, executor));
                } else if (Intrinsics.areEqual((Object)RunDashboardUiManager.getInstance((Project)this.project).getToolWindowId(), (Object)toolWindowId)) {
                    RunDashboardUiManager.getInstance((Project)this.project).contentReused(content, oldDescriptor);
                }
                if (descriptor.isSelectContentWhenAdded()) break block14;
                if (oldDescriptor == null) break block15;
                ContentManager contentManager2 = content.getManager();
                Intrinsics.checkNotNull((Object)contentManager2);
                if (!contentManager2.isSelected(content)) break block15;
            }
            ContentManager contentManager = content.getManager();
            Intrinsics.checkNotNull((Object)contentManager);
            contentManager.setSelectedContent(content);
        }
        if (!descriptor.isActivateToolWindowWhenAdded()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> RunContentManagerImpl.showRunContent$lambda$1(descriptor, this, toolWindowId), this.project.getDisposed());
    }

    private final ContentManager getContentManagerByToolWindowId(String toolWindowId) {
        RunDashboardUiManager manager;
        RunDashboardUiManager runDashboardUiManager = manager = RunDashboardUiManager.getInstanceIfCreated((Project)this.project);
        if (runDashboardUiManager != null) {
            RunDashboardUiManager it = runDashboardUiManager;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getToolWindowId(), (Object)toolWindowId)) {
                return this.toolWindowIdToBaseIcon.containsKey(toolWindowId) ? it.getDashboardContentManager() : null;
            }
        }
        ToolWindow toolWindow = this.getToolWindowManager().getToolWindow(toolWindowId);
        return toolWindow != null ? toolWindow.getContentManagerIfCreated() : null;
    }

    @Nullable
    public RunContentDescriptor getReuseContent(@NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        RunContentDescriptor contentToReuse = executionEnvironment.getContentToReuse();
        if (contentToReuse != null) {
            return contentToReuse;
        }
        String toolWindowId = this.getContentDescriptorToolWindowId(executionEnvironment);
        Predicate<Content> reuseCondition = null;
        ContentManager contentManager = null;
        if (toolWindowId == null) {
            Executor executor = executionEnvironment.getExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
            contentManager = this.getContentManagerForRunner(executor, null);
            reuseCondition = null;
        } else {
            Executor executor = executionEnvironment.getExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
            contentManager = this.getOrCreateContentManagerForToolWindow(toolWindowId, executor);
            reuseCondition = this.getReuseCondition(toolWindowId);
        }
        return RunContentManagerImplKt.access$chooseReuseContentForDescriptor(contentManager, null, executionEnvironment.getExecutionId(), executionEnvironment.toString(), reuseCondition);
    }

    private final Predicate<Content> getReuseCondition(String toolWindowId) {
        RunDashboardUiManager runDashboardUiManager = RunDashboardUiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)runDashboardUiManager, (String)"getInstance(...)");
        RunDashboardUiManager runDashboardManager = runDashboardUiManager;
        return Intrinsics.areEqual((Object)runDashboardManager.getToolWindowId(), (Object)toolWindowId) ? runDashboardManager.getReuseCondition() : null;
    }

    @Nullable
    public RunContentDescriptor findContentDescriptor(@NotNull Executor requestor, @NotNull ProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        return this.getDescriptorBy(handler2, requestor);
    }

    public void showRunContent(@NotNull Executor info, @NotNull RunContentDescriptor descriptor, @Nullable RunContentDescriptor contentToReuse) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Companion.copyContentAndBehavior(descriptor, contentToReuse);
        this.showRunContent(info, descriptor, descriptor.getExecutionId());
    }

    private final ContentManager getContentManagerForRunner(Executor executor, RunContentDescriptor descriptor) {
        RunContentDescriptor runContentDescriptor2 = descriptor;
        if (runContentDescriptor2 == null || (runContentDescriptor2 = runContentDescriptor2.getAttachedContent()) == null || (runContentDescriptor2 = runContentDescriptor2.getManager()) == null) {
            runContentDescriptor2 = this.getOrCreateContentManagerForToolWindow(RunContentManagerImplKt.access$getToolWindowIdForRunner(executor, descriptor), executor);
        }
        return runContentDescriptor2;
    }

    private final ContentManager getOrCreateContentManagerForToolWindow(String id, Executor executor) {
        RunDashboardUiManager runDashboardUiManager = RunDashboardUiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)runDashboardUiManager, (String)"getInstance(...)");
        RunDashboardUiManager dashboardManager = runDashboardUiManager;
        ContentManager contentManager = this.getContentManagerByToolWindowId(id);
        if (contentManager != null) {
            this.updateToolWindowDecoration(id, executor);
            return contentManager;
        }
        if (Intrinsics.areEqual((Object)dashboardManager.getToolWindowId(), (Object)id)) {
            String string = dashboardManager.getToolWindowId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolWindowId(...)");
            Icon icon = dashboardManager.getToolWindowIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getToolWindowIcon(...)");
            ContentManager contentManager2 = dashboardManager.getDashboardContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getDashboardContentManager(...)");
            this.initToolWindow(null, string, icon, contentManager2);
            ContentManager contentManager3 = dashboardManager.getDashboardContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager3, (String)"getDashboardContentManager(...)");
            return contentManager3;
        }
        return this.registerToolWindow(executor);
    }

    @Nullable
    public ToolWindow getToolWindowByDescriptor(@NotNull RunContentDescriptor descriptor) {
        ToolWindow toolWindow;
        ContentManager contentManager;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String string = descriptor.getContentToolWindowId();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            return this.getToolWindowManager().getToolWindow(it);
        }
        RunContentManagerImpl this_$iv = this;
        boolean $i$f$processToolWindowContentManagers = false;
        ToolWindowManager toolWindowManager$iv = this_$iv.getToolWindowManager();
        HashSet<String> processedToolWindowIds$iv = new HashSet<String>();
        for (Executor executor$iv : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            ToolWindow toolWindow$iv;
            String toolWindowId$iv;
            Intrinsics.checkNotNullExpressionValue((Object)executor$iv.getToolWindowId(), (String)"getToolWindowId(...)");
            if (!processedToolWindowIds$iv.add(toolWindowId$iv) || toolWindowManager$iv.getToolWindow(toolWindowId$iv) == null || toolWindow$iv.getContentManagerIfCreated() == null) continue;
            bl = false;
            if (RunContentManagerImplKt.access$getRunContentByDescriptor(contentManager, descriptor) == null) continue;
            return toolWindow;
        }
        RunDashboardUiManager runDashboardUiManager = RunDashboardUiManager.getInstanceIfCreated((Project)this_$iv.project);
        if (runDashboardUiManager != null) {
            RunDashboardUiManager it$iv = runDashboardUiManager;
            boolean bl3 = false;
            String string2 = it$iv.getToolWindowId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getToolWindowId(...)");
            String toolWindowId$iv = string2;
            if (this_$iv.toolWindowIdToBaseIcon.containsKey(toolWindowId$iv)) {
                ToolWindow toolWindow2 = toolWindowManager$iv.getToolWindow(toolWindowId$iv);
                if (toolWindow2 != null) {
                    ContentManager contentManager2 = it$iv.getDashboardContentManager();
                    Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getDashboardContentManager(...)");
                    contentManager = contentManager2;
                    toolWindow = toolWindow2;
                    bl = false;
                    if (RunContentManagerImplKt.access$getRunContentByDescriptor(contentManager, descriptor) != null) {
                        return toolWindow;
                    }
                }
            }
        }
        return null;
    }

    private final void updateToolWindowDecoration(String id, Executor executor) {
        block1: {
            ToolWindow toolWindow;
            RunDashboardUiManager runDashboardUiManager = RunDashboardUiManager.getInstanceIfCreated((Project)this.project);
            if (Intrinsics.areEqual((Object)(runDashboardUiManager != null ? runDashboardUiManager.getToolWindowId() : null), (Object)id)) {
                return;
            }
            ToolWindow toolWindow2 = this.getToolWindowManager().getToolWindow(id);
            if (toolWindow2 == null) break block1;
            ToolWindow $this$updateToolWindowDecoration_u24lambda_u240 = toolWindow = toolWindow2;
            boolean bl = false;
            $this$updateToolWindowDecoration_u24lambda_u240.setStripeTitle(executor.getToolWindowTitle());
            $this$updateToolWindowDecoration_u24lambda_u240.setIcon(executor.getToolWindowIcon());
            this.toolWindowIdToBaseIcon.put(id, executor.getToolWindowIcon());
        }
    }

    private final void processToolWindowContentManagers(Function2<? super ToolWindow, ? super ContentManager, Unit> processor) {
        block3: {
            boolean $i$f$processToolWindowContentManagers = false;
            ToolWindowManager toolWindowManager = this.getToolWindowManager();
            HashSet<String> processedToolWindowIds = new HashSet<String>();
            for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                ToolWindow toolWindow;
                String toolWindowId;
                Intrinsics.checkNotNullExpressionValue((Object)executor.getToolWindowId(), (String)"getToolWindowId(...)");
                if (!processedToolWindowIds.add(toolWindowId) || toolWindowManager.getToolWindow(toolWindowId) == null) continue;
                ContentManager contentManager = toolWindow.getContentManagerIfCreated();
                if (contentManager == null) continue;
                processor.invoke((Object)toolWindow, (Object)contentManager);
            }
            RunDashboardUiManager runDashboardUiManager = RunDashboardUiManager.getInstanceIfCreated((Project)this.project);
            if (runDashboardUiManager == null) break block3;
            RunDashboardUiManager it = runDashboardUiManager;
            boolean bl = false;
            String string = it.getToolWindowId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolWindowId(...)");
            String toolWindowId = string;
            if (this.toolWindowIdToBaseIcon.containsKey(toolWindowId)) {
                ToolWindow toolWindow = toolWindowManager.getToolWindow(toolWindowId);
                if (toolWindow == null) {
                    return;
                }
                ContentManager contentManager = it.getDashboardContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getDashboardContentManager(...)");
                processor.invoke((Object)toolWindow, (Object)contentManager);
            }
        }
    }

    @NotNull
    public List<RunContentDescriptor> getAllDescriptors() {
        List descriptors;
        block5: {
            RunContentDescriptor it;
            boolean bl;
            ContentManager contentManager;
            boolean bl2;
            descriptors = (List)new SmartList();
            RunContentManagerImpl this_$iv = this;
            boolean $i$f$processToolWindowContentManagers = false;
            ToolWindowManager toolWindowManager$iv = this_$iv.getToolWindowManager();
            HashSet<String> processedToolWindowIds$iv = new HashSet<String>();
            for (Executor executor$iv : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                Content[] contentArray;
                ToolWindow toolWindow$iv;
                String toolWindowId$iv;
                Intrinsics.checkNotNullExpressionValue((Object)executor$iv.getToolWindowId(), (String)"getToolWindowId(...)");
                if (!processedToolWindowIds$iv.add(toolWindowId$iv) || toolWindowManager$iv.getToolWindow(toolWindowId$iv) == null || toolWindow$iv.getContentManagerIfCreated() == null) continue;
                bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)contentManager.getContents(), (String)"getContents(...)");
                for (Content content : contentArray) {
                    Intrinsics.checkNotNull((Object)content);
                    if (Companion.getRunContentDescriptorByContent(content) == null) continue;
                    bl = false;
                    descriptors.add(it);
                }
            }
            RunDashboardUiManager runDashboardUiManager = RunDashboardUiManager.getInstanceIfCreated((Project)this_$iv.project);
            if (runDashboardUiManager == null) break block5;
            RunDashboardUiManager it$iv = runDashboardUiManager;
            boolean bl3 = false;
            String string = it$iv.getToolWindowId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolWindowId(...)");
            String toolWindowId$iv = string;
            if (this_$iv.toolWindowIdToBaseIcon.containsKey(toolWindowId$iv) && toolWindowManager$iv.getToolWindow(toolWindowId$iv) != null) {
                ContentManager contentManager2 = it$iv.getDashboardContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getDashboardContentManager(...)");
                contentManager = contentManager2;
                bl2 = false;
                Content[] contentArray = contentManager.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                for (Content content : contentArray) {
                    Intrinsics.checkNotNull((Object)content);
                    if (Companion.getRunContentDescriptorByContent(content) != null) {
                        bl = false;
                        descriptors.add(it);
                    }
                }
            }
        }
        return descriptors;
    }

    public void selectRunContent(@NotNull RunContentDescriptor descriptor) {
        ContentManager contentManager;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        RunContentManagerImpl this_$iv = this;
        boolean $i$f$processToolWindowContentManagers = false;
        ToolWindowManager toolWindowManager$iv = this_$iv.getToolWindowManager();
        HashSet<String> processedToolWindowIds$iv = new HashSet<String>();
        for (Executor executor$iv : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            ToolWindow toolWindow$iv;
            String toolWindowId$iv;
            Intrinsics.checkNotNullExpressionValue((Object)executor$iv.getToolWindowId(), (String)"getToolWindowId(...)");
            if (!processedToolWindowIds$iv.add(toolWindowId$iv) || toolWindowManager$iv.getToolWindow(toolWindowId$iv) == null || toolWindow$iv.getContentManagerIfCreated() == null) continue;
            bl = false;
            Content content = RunContentManagerImplKt.access$getRunContentByDescriptor(contentManager, descriptor);
            if (content == null) continue;
            Content content2 = content;
            contentManager.setSelectedContent(content2);
            return;
        }
        RunDashboardUiManager runDashboardUiManager = RunDashboardUiManager.getInstanceIfCreated((Project)this_$iv.project);
        if (runDashboardUiManager != null) {
            RunDashboardUiManager it$iv = runDashboardUiManager;
            boolean bl2 = false;
            String string = it$iv.getToolWindowId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolWindowId(...)");
            String toolWindowId$iv = string;
            if (this_$iv.toolWindowIdToBaseIcon.containsKey(toolWindowId$iv) && toolWindowManager$iv.getToolWindow(toolWindowId$iv) != null) {
                ContentManager contentManager2 = it$iv.getDashboardContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getDashboardContentManager(...)");
                contentManager = contentManager2;
                bl = false;
                Content content = RunContentManagerImplKt.access$getRunContentByDescriptor(contentManager, descriptor);
                if (content != null) {
                    Content content3 = content;
                    contentManager.setSelectedContent(content3);
                    return;
                }
            }
        }
    }

    private final ToolWindowManager getToolWindowManager() {
        return ToolWindowManager.Companion.getInstance(this.project);
    }

    @Nullable
    public String getContentDescriptorToolWindowId(@Nullable RunConfiguration configuration) {
        RunDashboardManager runDashboardContentManager;
        if (configuration != null && (runDashboardContentManager = RunDashboardManagerProxy.Companion.getInstance(this.project)).isShowInDashboard(configuration)) {
            return RunDashboardUiManager.getInstance((Project)this.project).getToolWindowId();
        }
        return null;
    }

    @NotNull
    public String getToolWindowIdByEnvironment(@NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        String toolWindowId = this.getContentDescriptorToolWindowId(executionEnvironment);
        String string = toolWindowId;
        if (string == null) {
            String string2 = executionEnvironment.getExecutor().getToolWindowId();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getToolWindowId(...)");
        }
        return string;
    }

    private final RunContentDescriptor getDescriptorBy(ProcessHandler handler2, Executor runnerInfo) {
        RunContentDescriptor runContentDescriptor2 = RunContentManagerImpl.getDescriptorBy$find(handler2, this.getContentManagerForRunner(runnerInfo, null));
        if (runContentDescriptor2 != null) {
            RunContentDescriptor it = runContentDescriptor2;
            boolean bl = false;
            return it;
        }
        Object object = RunDashboardUiManager.getInstanceIfCreated((Project)this.project);
        if (object == null || (object = object.getToolWindowId()) == null) {
            return null;
        }
        ContentManager contentManager = this.getContentManagerByToolWindowId((String)object);
        if (contentManager == null) {
            return null;
        }
        RunContentDescriptor runContentDescriptor3 = RunContentManagerImpl.getDescriptorBy$find(handler2, contentManager);
        if (runContentDescriptor3 != null) {
            RunContentDescriptor it = runContentDescriptor3;
            boolean bl = false;
            return it;
        }
        return null;
    }

    public final void moveContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Content content = descriptor.getAttachedContent();
        if (content == null) {
            return;
        }
        Content content2 = content;
        ContentManager oldContentManager = content2.getManager();
        ContentManager newContentManager = this.getOrCreateContentManagerForToolWindow(RunContentManagerImplKt.access$getToolWindowIdForRunner(executor, descriptor), executor);
        if (oldContentManager == null || oldContentManager == newContentManager) {
            return;
        }
        ContentManagerListener listener2 = (ContentManagerListener)content2.getUserData(Content.CLOSE_LISTENER_KEY);
        if (listener2 != null) {
            oldContentManager.removeContentManagerListener(listener2);
        }
        oldContentManager.removeContent(content2, false);
        if (RunContentManagerImplKt.access$isAlive(descriptor)) {
            if (!RunContentManagerImplKt.access$isAlive(oldContentManager)) {
                this.updateToolWindowIcon(oldContentManager, false);
            }
            if (!RunContentManagerImplKt.access$isAlive(newContentManager)) {
                this.updateToolWindowIcon(newContentManager, true);
            }
        }
        newContentManager.addContent(content2);
    }

    private final void updateToolWindowIcon(ContentManager contentManagerToUpdate, boolean alive) {
        ToolWindow toolWindow;
        ContentManager contentManager;
        boolean bl;
        RunContentManagerImpl this_$iv = this;
        boolean $i$f$processToolWindowContentManagers = false;
        ToolWindowManager toolWindowManager$iv = this_$iv.getToolWindowManager();
        HashSet<String> processedToolWindowIds$iv = new HashSet<String>();
        for (Executor executor$iv : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            ToolWindow toolWindow$iv;
            String toolWindowId$iv;
            Intrinsics.checkNotNullExpressionValue((Object)executor$iv.getToolWindowId(), (String)"getToolWindowId(...)");
            if (!processedToolWindowIds$iv.add(toolWindowId$iv) || toolWindowManager$iv.getToolWindow(toolWindowId$iv) == null || toolWindow$iv.getContentManagerIfCreated() == null) continue;
            bl = false;
            if (!Intrinsics.areEqual((Object)contentManagerToUpdate, (Object)contentManager)) continue;
            this.setToolWindowIcon(alive, toolWindow);
            return;
        }
        RunDashboardUiManager runDashboardUiManager = RunDashboardUiManager.getInstanceIfCreated((Project)this_$iv.project);
        if (runDashboardUiManager != null) {
            RunDashboardUiManager it$iv = runDashboardUiManager;
            boolean bl2 = false;
            String string = it$iv.getToolWindowId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getToolWindowId(...)");
            String toolWindowId$iv = string;
            if (this_$iv.toolWindowIdToBaseIcon.containsKey(toolWindowId$iv)) {
                ToolWindow toolWindow2 = toolWindowManager$iv.getToolWindow(toolWindowId$iv);
                if (toolWindow2 != null) {
                    ContentManager contentManager2 = it$iv.getDashboardContentManager();
                    Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getDashboardContentManager(...)");
                    contentManager = contentManager2;
                    toolWindow = toolWindow2;
                    bl = false;
                    if (Intrinsics.areEqual((Object)contentManagerToUpdate, (Object)contentManager)) {
                        this.setToolWindowIcon(alive, toolWindow);
                        return;
                    }
                }
            }
        }
    }

    private final void setToolWindowIcon(boolean alive, ToolWindow toolWindow) {
        Icon icon;
        Icon base = this.toolWindowIdToBaseIcon.get(toolWindow.getId());
        if (alive) {
            icon = Companion.getLiveIndicator(base);
        } else {
            icon = base;
            if (icon == null) {
                icon = EmptyIcon.ICON_13;
            }
        }
        toolWindow.setIcon(icon);
    }

    private static final void _init_$lambda$0(RunContentManagerImpl this$0) {
        this$0.init();
    }

    private static final void registerRunContentDescriptor$lambda$0(RunContentManagerImpl this$0, RunContentDescriptorId $runContentDescriptorId) {
        this$0.descriptors.remove($runContentDescriptorId);
    }

    private static final void registerToolWindow$lambda$0(Executor $executor, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"HELP_ID");
        sink.set(dataKey, (Object)$executor.getHelpId());
    }

    private static final void initToolWindow$lambda$0(ContentManager $contentManager, RunContentManagerImpl this$0, String $toolWindowId) {
        $contentManager.removeAllContents(true);
        this$0.toolWindowIdZBuffer.remove($toolWindowId);
        this$0.toolWindowIdToBaseIcon.remove($toolWindowId);
    }

    private static final void toFrontRunContent$lambda$0(RunContentManagerImpl this$0, Executor $requestor, RunContentDescriptor $descriptor) {
        ContentManager contentManager = this$0.getContentManagerForRunner($requestor, $descriptor);
        Content content = RunContentManagerImplKt.access$getRunContentByDescriptor(contentManager, $descriptor);
        if (content != null) {
            contentManager.setSelectedContent(content);
            ToolWindow toolWindow = this$0.getToolWindowManager().getToolWindow(RunContentManagerImplKt.access$getToolWindowIdForRunner($requestor, $descriptor));
            Intrinsics.checkNotNull((Object)toolWindow);
            toolWindow.show(null);
        }
    }

    private static final void hideRunContent$lambda$0(RunContentManagerImpl this$0, Executor $executor, RunContentDescriptor $descriptor) {
        block0: {
            ToolWindow toolWindow;
            ToolWindow toolWindow2 = toolWindow = this$0.getToolWindowManager().getToolWindow(RunContentManagerImplKt.access$getToolWindowIdForRunner($executor, $descriptor));
            if (toolWindow2 == null) break block0;
            toolWindow2.hide(null);
        }
    }

    private static final void showRunContent$lambda$0(ProcessHandler $processHandler, showRunContent.processAdapter.1 $processAdapter) {
        $processHandler.removeProcessListener((ProcessListener)$processAdapter);
    }

    private static final void showRunContent$lambda$1(RunContentDescriptor $descriptor, RunContentManagerImpl this$0, String $toolWindowId) {
        boolean focus = $descriptor.isAutoFocusContent();
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == null) {
            focus = true;
        }
        ToolWindow toolWindow = this$0.getToolWindowManager().getToolWindow($toolWindowId);
        Intrinsics.checkNotNull((Object)toolWindow);
        toolWindow.activate($descriptor.getActivationCallback(), focus, focus);
    }

    private static final RunContentDescriptor getDescriptorBy$find(ProcessHandler $handler, ContentManager manager) {
        if (manager == null) {
            return null;
        }
        List list = manager.getContentsRecursively();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContentsRecursively(...)");
        List contents = list;
        for (Object e : contents) {
            RunContentDescriptor runContentDescriptor2;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Content content = (Content)e;
            RunContentDescriptor runContentDescriptor3 = runContentDescriptor2 = Companion.getRunContentDescriptorByContent(content);
            if ((runContentDescriptor3 != null ? runContentDescriptor3.getProcessHandler() : null) != $handler) continue;
            return runContentDescriptor2;
        }
        return null;
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final boolean isSplitRun() {
        return Companion.isSplitRun();
    }

    @JvmStatic
    public static final void copyContentAndBehavior(@NotNull RunContentDescriptor descriptor, @Nullable RunContentDescriptor contentToReuse) {
        Companion.copyContentAndBehavior(descriptor, contentToReuse);
    }

    @JvmStatic
    public static final boolean isTerminated(@NotNull Content content) {
        return Companion.isTerminated(content);
    }

    @JvmStatic
    @Nullable
    public static final RunContentDescriptor getRunContentDescriptorByContent(@NotNull Content content) {
        return Companion.getRunContentDescriptorByContent(content);
    }

    @JvmStatic
    @Nullable
    public static final Executor getExecutorByContent(@NotNull Content content) {
        return Companion.getExecutorByContent(content);
    }

    @JvmStatic
    @NotNull
    public static final Icon getLiveIndicator(@Nullable Icon icon) {
        return Companion.getLiveIndicator(icon);
    }

    public static final /* synthetic */ ConcurrentLinkedDeque access$getToolWindowIdZBuffer$p(RunContentManagerImpl $this) {
        return $this.toolWindowIdZBuffer;
    }

    public static final /* synthetic */ ContentManager access$getContentManagerByToolWindowId(RunContentManagerImpl $this, String toolWindowId) {
        return $this.getContentManagerByToolWindowId(toolWindowId);
    }

    public static final /* synthetic */ void access$setToolWindowIcon(RunContentManagerImpl $this, boolean alive, ToolWindow toolWindow) {
        $this.setToolWindowIcon(alive, toolWindow);
    }

    static {
        Key key = Key.create((String)"ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY = key;
        Key key2 = Key.create((String)"TemporaryConfiguration");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        TEMPORARY_CONFIGURATION_KEY = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/ui/RunContentManagerImpl$CloseListener;", "Lcom/intellij/execution/ui/BaseContentCloseListener;", "content", "Lcom/intellij/ui/content/Content;", "myExecutor", "Lcom/intellij/execution/Executor;", "<init>", "(Lcom/intellij/execution/ui/RunContentManagerImpl;Lcom/intellij/ui/content/Content;Lcom/intellij/execution/Executor;)V", "disposeContent", "", "closeQuery", "", "projectClosing", "intellij.platform.execution.impl"})
    private final class CloseListener
    extends BaseContentCloseListener {
        @NotNull
        private final Executor myExecutor;

        public CloseListener(@NotNull Content content, Executor myExecutor) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)myExecutor, (String)"myExecutor");
            super(content, RunContentManagerImpl.this.project);
            this.myExecutor = myExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void disposeContent(@NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            try {
                RunContentDescriptor descriptor = Companion.getRunContentDescriptorByContent(content);
                RunContentManagerImpl.this.getSyncPublisher().contentRemoved(descriptor, this.myExecutor);
                if (descriptor != null) {
                    Disposer.dispose((Disposable)((Disposable)descriptor));
                }
            }
            finally {
                content.release();
            }
        }

        @Override
        protected boolean closeQuery(@NotNull Content content, boolean projectClosing) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            RunContentDescriptor runContentDescriptor2 = Companion.getRunContentDescriptorByContent(content);
            if (runContentDescriptor2 == null) {
                return true;
            }
            RunContentDescriptor descriptor = runContentDescriptor2;
            if (((Boolean)Content.TEMPORARY_REMOVED_KEY.get((UserDataHolder)content, (Object)false)).booleanValue()) {
                return true;
            }
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated()) {
                return true;
            }
            String sessionName = descriptor.getDisplayName();
            boolean killable = processHandler instanceof KillableProcess && ((KillableProcess)processHandler).canKillProcess();
            Project project = RunContentManagerImpl.this.project;
            BaseContentCloseListener.WaitForProcessTask task2 = new BaseContentCloseListener.WaitForProcessTask(processHandler, sessionName, projectClosing, killable, project){
                final /* synthetic */ ProcessHandler $processHandler;
                final /* synthetic */ boolean $killable;
                {
                    this.$processHandler = $processHandler;
                    this.$killable = $killable;
                    super($processHandler, $sessionName, $projectClosing, $super_call_param$1);
                }

                public void onCancel() {
                    if (this.$killable && !this.$processHandler.isProcessTerminated()) {
                        ProcessHandler processHandler = this.$processHandler;
                        Intrinsics.checkNotNull((Object)processHandler, (String)"null cannot be cast to non-null type com.intellij.execution.KillableProcess");
                        ((KillableProcess)processHandler).killProcess();
                    }
                }
            };
            if (killable) {
                String string = ExecutionBundle.message((String)"terminating.process.progress.kill", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String cancelText = string;
                task2.setCancelText(cancelText);
                task2.setCancelTooltipText(cancelText);
            }
            return this.askUserAndWait(processHandler, sessionName, task2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0006H\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0007R#\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/ui/RunContentManagerImpl$Companion;", "", "<init>", "()V", "ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "TEMPORARY_CONFIGURATION_KEY", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "isSplitRun", "copyContentAndBehavior", "", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "contentToReuse", "isTerminated", "content", "Lcom/intellij/ui/content/Content;", "getRunContentDescriptorByContent", "getExecutorByContent", "Lcom/intellij/execution/Executor;", "getLiveIndicator", "Ljavax/swing/Icon;", "icon", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @ApiStatus.Internal
        public final boolean isSplitRun() {
            return Registry.Companion.is("run.toolwindow.split.enabled", false);
        }

        @JvmStatic
        public final void copyContentAndBehavior(@NotNull RunContentDescriptor descriptor, @Nullable RunContentDescriptor contentToReuse) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (contentToReuse != null) {
                Content attachedContent = contentToReuse.getAttachedContent();
                if (attachedContent != null && attachedContent.isValid()) {
                    descriptor.setAttachedContent(attachedContent);
                }
                if (contentToReuse.isReuseToolWindowActivation()) {
                    descriptor.setActivateToolWindowWhenAdded(contentToReuse.isActivateToolWindowWhenAdded());
                }
                ProcessHandler processHandler = descriptor.getProcessHandler();
                if ((processHandler != null ? (String)processHandler.getUserData(RunContentDescriptor.CONTENT_TOOL_WINDOW_ID_KEY) : null) == null) {
                    descriptor.setContentToolWindowId(contentToReuse.getContentToolWindowId());
                }
                descriptor.setSelectContentWhenAdded(contentToReuse.isSelectContentWhenAdded());
            }
        }

        @JvmStatic
        public final boolean isTerminated(@NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            RunContentDescriptor runContentDescriptor2 = this.getRunContentDescriptorByContent(content);
            if (runContentDescriptor2 == null || (runContentDescriptor2 = runContentDescriptor2.getProcessHandler()) == null) {
                return true;
            }
            RunContentDescriptor processHandler = runContentDescriptor2;
            return processHandler.isProcessTerminated();
        }

        @JvmStatic
        @Nullable
        public final RunContentDescriptor getRunContentDescriptorByContent(@NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return (RunContentDescriptor)content.getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
        }

        @JvmStatic
        @Nullable
        public final Executor getExecutorByContent(@NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return (Executor)content.getUserData(RunContentManagerImplKt.EXECUTOR_KEY);
        }

        @JvmStatic
        @NotNull
        public final Icon getLiveIndicator(@Nullable Icon icon) {
            Icon icon2 = icon;
            if (icon2 == null) {
                icon2 = EmptyIcon.ICON_13;
            }
            Icon icon3 = ExecutionUtil.withLiveIndicator((Icon)icon2);
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"withLiveIndicator(...)");
            return icon3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

