/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.actions;

import com.intellij.execution.ui.actions.BaseViewAction;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.content.Content;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CloseViewAction
extends BaseViewAction
implements ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            CloseViewAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    protected void update(AnActionEvent e, ViewContext context, Content[] content) {
        CloseViewAction.setEnabled((AnActionEvent)e, (boolean)CloseViewAction.isEnabled(content));
        boolean unpinAction = CloseViewAction.isUnpinAction(e, content);
        Presentation presentation = e.getPresentation();
        if (unpinAction) {
            String text = RegistryManager.getInstance().is("ide.editor.tabs.interactive.pin.button") ? TextWithMnemonic.parse((String)IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0])).dropMnemonic(true).getText() : "";
            presentation.setText(text);
        }
        presentation.setIcon(unpinAction ? AllIcons.Actions.PinTab : AllIcons.Actions.Close);
        presentation.setHoveredIcon(unpinAction ? AllIcons.Actions.PinTab : AllIcons.Actions.CloseHovered);
    }

    protected void actionPerformed(AnActionEvent e, ViewContext context, Content[] content) {
        if (CloseViewAction.isUnpinAction(e, content)) {
            if (Registry.get((String)"ide.editor.tabs.interactive.pin.button").asBoolean()) {
                content[0].setPinned(false);
            }
            return;
        }
        CloseViewAction.perform(context, content[0]);
    }

    public static boolean perform(ViewContext context, Content content) {
        return context.getContentManager().removeContent(content, context.isToDisposeRemovedContent());
    }

    public static boolean isEnabled(Content[] content) {
        return content.length == 1 && content[0].isCloseable();
    }

    private static boolean isUnpinAction(AnActionEvent e, Content[] content) {
        return content.length == 1 && content[0].isPinnable() && content[0].isPinned() && !ViewContext.isPopupPlace((String)e.getPlace());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/layout/actions/CloseViewAction", "getActionUpdateThread"));
    }
}

