/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ProcessCloseConfirmation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TerminateRemoteProcessDialog {
    @Nullable
    public static ProcessCloseConfirmation show(Project project, @NotNull String sessionName, @NotNull ProcessHandler processHandler) {
        if (sessionName == null) {
            TerminateRemoteProcessDialog.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            TerminateRemoteProcessDialog.$$$reportNull$$$0(1);
        }
        if (processHandler.isSilentlyDestroyOnClose() || Boolean.TRUE.equals(processHandler.getUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE))) {
            return ProcessCloseConfirmation.TERMINATE;
        }
        final boolean canDisconnect = !Boolean.TRUE.equals(processHandler.getUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY));
        ProcessCloseConfirmation confirmation = GeneralSettings.getInstance().getProcessCloseConfirmation();
        if (confirmation != ProcessCloseConfirmation.ASK) {
            if (confirmation == ProcessCloseConfirmation.DISCONNECT && !canDisconnect) {
                confirmation = ProcessCloseConfirmation.TERMINATE;
            }
            return confirmation;
        }
        ArrayList<String> options = new ArrayList<String>(3);
        options.add(ExecutionBundle.message((String)"button.terminate", (Object[])new Object[0]));
        if (canDisconnect) {
            options.add(ExecutionBundle.message((String)"button.disconnect", (Object[])new Object[0]));
        }
        options.add(CommonBundle.getCancelButtonText());
        DoNotAskOption.Adapter doNotAskOption = new DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                ProcessCloseConfirmation confirmation;
                if (isSelected && (confirmation = TerminateRemoteProcessDialog.getConfirmation(exitCode, canDisconnect)) != null) {
                    GeneralSettings.getInstance().setProcessCloseConfirmation(confirmation);
                }
            }
        };
        final AtomicBoolean alreadyGone = new AtomicBoolean(false);
        final Runnable dialogRemover = Messages.createMessageDialogRemover((Project)project);
        ProcessListener listener2 = new ProcessListener(){

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                alreadyGone.set(true);
                dialogRemover.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/TerminateRemoteProcessDialog$2", "processWillTerminate"));
            }
        };
        processHandler.addProcessListener(listener2);
        boolean defaultDisconnect = processHandler.detachIsDefault();
        int exitCode = Messages.showDialog((Project)project, (String)ExecutionBundle.message((String)"terminate.process.confirmation.text", (Object[])new Object[]{sessionName}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{sessionName}), (String[])ArrayUtil.toStringArray(options), (int)(canDisconnect && defaultDisconnect ? 1 : 0), (Icon)Messages.getWarningIcon(), (DoNotAskOption)doNotAskOption);
        processHandler.removeProcessListener(listener2);
        if (alreadyGone.get()) {
            return ProcessCloseConfirmation.DISCONNECT;
        }
        return TerminateRemoteProcessDialog.getConfirmation(exitCode, canDisconnect);
    }

    private static ProcessCloseConfirmation getConfirmation(int button, boolean withDisconnect) {
        if (button == 0) {
            return ProcessCloseConfirmation.TERMINATE;
        }
        if (button == 1 && withDisconnect) {
            return ProcessCloseConfirmation.DISCONNECT;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sessionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processHandler";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/TerminateRemoteProcessDialog";
        objectArray[2] = "show";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

