/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.design;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.multilaunch.MultiLaunchConfiguration;
import com.intellij.execution.multilaunch.design.ExecutableRow;
import com.intellij.execution.multilaunch.design.ExecutableRowFactory;
import com.intellij.execution.multilaunch.design.ExecutablesTable;
import com.intellij.execution.multilaunch.design.MultiLaunchConfigurationViewModel;
import com.intellij.execution.multilaunch.execution.executables.Executable;
import com.intellij.execution.multilaunch.state.ExecutableRowSnapshot;
import com.intellij.execution.multilaunch.state.ExecutableRowSnapshotFactoryKt;
import com.intellij.execution.options.LifetimedSettingsEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\rH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/execution/multilaunch/design/MultiLaunchConfigurationEditor;", "Lcom/intellij/execution/options/LifetimedSettingsEditor;", "Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;)V", "runManagerListenerConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "viewModel", "Lcom/intellij/execution/multilaunch/design/MultiLaunchConfigurationViewModel;", "resetEditorFrom", "", "multiLaunchConfiguration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "wrapWithScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "component", "createTable", "Lcom/intellij/execution/multilaunch/design/ExecutablesTable;", "createActivateToolWindowsCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "createActivateToolWindowsHelp", "Lcom/intellij/ui/ContextHelpLabel;", "disposeEditor", "ConfigurationChangedListener", "intellij.platform.execution.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMultiLaunchConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiLaunchConfigurationEditor.kt\ncom/intellij/execution/multilaunch/design/MultiLaunchConfigurationEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1869#2,2:155\n1869#2,2:157\n1#3:159\n*S KotlinDebug\n*F\n+ 1 MultiLaunchConfigurationEditor.kt\ncom/intellij/execution/multilaunch/design/MultiLaunchConfigurationEditor\n*L\n48#1:155,2\n59#1:157,2\n*E\n"})
public final class MultiLaunchConfigurationEditor
extends LifetimedSettingsEditor<MultiLaunchConfiguration> {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiLaunchConfiguration configuration;
    @NotNull
    private final MessageBusConnection runManagerListenerConnection;
    @NotNull
    private MultiLaunchConfigurationViewModel viewModel;

    /*
     * WARNING - void declaration
     */
    public MultiLaunchConfigurationEditor(@NotNull Project project, @NotNull MultiLaunchConfiguration configuration) {
        void $this$_init__u24lambda_u240;
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.project = project;
        this.configuration = configuration;
        this.viewModel = new MultiLaunchConfigurationViewModel(this.project, this.configuration);
        MessageBusConnection messageBusConnection2 = messageBusConnection = this.project.getMessageBus().connect();
        MultiLaunchConfigurationEditor multiLaunchConfigurationEditor = this;
        boolean bl = false;
        Topic topic = RunManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        $this$_init__u24lambda_u240.subscribe(topic, (Object)new ConfigurationChangedListener());
        multiLaunchConfigurationEditor.runManagerListenerConnection = messageBusConnection;
    }

    protected void resetEditorFrom(@NotNull MultiLaunchConfiguration multiLaunchConfiguration) {
        MultiLaunchConfigurationViewModel multiLaunchConfigurationViewModel;
        Intrinsics.checkNotNullParameter((Object)multiLaunchConfiguration, (String)"multiLaunchConfiguration");
        MultiLaunchConfigurationViewModel $this$resetEditorFrom_u24lambda_u240 = multiLaunchConfigurationViewModel = this.viewModel;
        boolean bl = false;
        $this$resetEditorFrom_u24lambda_u240.reset();
        Iterable $this$forEach$iv = multiLaunchConfiguration.getParameters().getRows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableRowSnapshot contextSnapshot = (ExecutableRowSnapshot)((Object)element$iv);
            boolean bl2 = false;
            ExecutableRow row = ExecutableRowFactory.INSTANCE.create($this$resetEditorFrom_u24lambda_u240.getProject(), multiLaunchConfiguration, contextSnapshot);
            $this$resetEditorFrom_u24lambda_u240.addRow(row);
        }
        $this$resetEditorFrom_u24lambda_u240.setActivateAllToolWindows(multiLaunchConfiguration.getParameters().getActivateToolWindows());
    }

    protected void applyEditorTo(@NotNull MultiLaunchConfiguration multiLaunchConfiguration) {
        List<ExecutableRowSnapshot> list;
        Intrinsics.checkNotNullParameter((Object)multiLaunchConfiguration, (String)"multiLaunchConfiguration");
        List<ExecutableRowSnapshot> $this$applyEditorTo_u24lambda_u240 = list = multiLaunchConfiguration.getParameters().getRows();
        boolean bl = false;
        $this$applyEditorTo_u24lambda_u240.clear();
        Iterable $this$forEach$iv = this.viewModel.getRows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableRow it = (ExecutableRow)element$iv;
            boolean bl2 = false;
            if (it == null) continue;
            $this$applyEditorTo_u24lambda_u240.add(ExecutableRowSnapshotFactoryKt.toSnapshot(it));
        }
        multiLaunchConfiguration.getParameters().setActivateToolWindows(this.viewModel.getActivateAllToolWindows());
    }

    @Override
    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime) {
        JLabel jLabel;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JPanel $this$createEditor_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        boolean bl = false;
        JLabel $this$createEditor_u24lambda_u240_u240 = jLabel = new JLabel(ExecutionBundle.message((String)"run.configurations.multilaunch.tasks.to.launch", (Object[])new Object[0]));
        boolean bl2 = false;
        $this$createEditor_u24lambda_u240_u240.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        JLabel comment = jLabel;
        $this$createEditor_u24lambda_u240.add((Component)comment, "wrap");
        ExecutablesTable table = this.createTable(lifetime);
        JBScrollPane pane2 = this.wrapWithScrollPane((JComponent)((Object)table));
        $this$createEditor_u24lambda_u240.add((Component)pane2, "grow, wrap");
        JBCheckBox activateAllToolWindows = this.createActivateToolWindowsCheckbox();
        $this$createEditor_u24lambda_u240.add((Component)activateAllToolWindows, "split 2");
        $this$createEditor_u24lambda_u240.add((Component)this.createActivateToolWindowsHelp(), "gapleft 5, wrap");
        return jPanel;
    }

    private final JBScrollPane wrapWithScrollPane(JComponent component) {
        JBScrollPane scrollPane2 = new JBScrollPane(component){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                if (!this.isPreferredSizeSet()) {
                    this.setPreferredSize(new Dimension(0, preferredSize.height));
                }
                Intrinsics.checkNotNull((Object)preferredSize);
                return preferredSize;
            }
        };
        scrollPane2.setBorder(IdeBorderFactory.createBorder((int)15));
        scrollPane2.setViewportBorder((Border)JBUI.Borders.empty());
        return scrollPane2;
    }

    private final ExecutablesTable createTable(Lifetime lifetime) {
        ExecutablesTable executablesTable;
        ExecutablesTable $this$createTable_u24lambda_u240 = executablesTable = new ExecutablesTable(this.project, this.viewModel, lifetime);
        boolean bl = false;
        ColoredTableCellRenderer renderer2 = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                if (!(value instanceof Executable)) {
                    return;
                }
                this.setIcon(((Executable)value).getIcon());
                this.append(((Executable)value).getName());
            }
        };
        $this$createTable_u24lambda_u240.setDefaultRenderer(Object.class, (TableCellRenderer)renderer2);
        $this$createTable_u24lambda_u240.putClientProperty(JBViewport.FORCE_VISIBLE_ROW_COUNT_KEY, true);
        JTable jTable = (JTable)((Object)$this$createTable_u24lambda_u240);
        TableModel tableModel = $this$createTable_u24lambda_u240.getModel();
        Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type com.intellij.util.ui.EditableModel");
        RowsDnDSupport.install((JTable)jTable, (EditableModel)((EditableModel)tableModel));
        return executablesTable;
    }

    private final JBCheckBox createActivateToolWindowsCheckbox() {
        JBCheckBox jBCheckBox;
        JBCheckBox $this$createActivateToolWindowsCheckbox_u24lambda_u240 = jBCheckBox = new JBCheckBox(ExecutionBundle.message((String)"run.configurations.multilaunch.options.activate.tool.windows", (Object[])new Object[0]), this.configuration.getParameters().getActivateToolWindows());
        boolean bl = false;
        $this$createActivateToolWindowsCheckbox_u24lambda_u240.addItemListener(arg_0 -> MultiLaunchConfigurationEditor.createActivateToolWindowsCheckbox$lambda$0$0(this, arg_0));
        return jBCheckBox;
    }

    private final ContextHelpLabel createActivateToolWindowsHelp() {
        String p0 = HtmlChunk.div().child((HtmlChunk)HtmlChunk.p().addText(ExecutionBundle.message((String)"run.configurations.multilaunch.options.activate.tool.windows.description1", (Object[])new Object[0]))).child((HtmlChunk)HtmlChunk.p().addText(ExecutionBundle.message((String)"run.configurations.multilaunch.options.activate.tool.windows.description2", (Object[])new Object[0]))).child((HtmlChunk)HtmlChunk.p().addText(ExecutionBundle.message((String)"run.configurations.multilaunch.options.activate.tool.windows.description3", (Object[])new Object[0]))).toString();
        boolean bl = false;
        return ContextHelpLabel.create((String)p0);
    }

    @Override
    protected void disposeEditor() {
        Disposer.dispose((Disposable)((Disposable)this.runManagerListenerConnection));
    }

    private static final void createActivateToolWindowsCheckbox$lambda$0$0(MultiLaunchConfigurationEditor this$0, ItemEvent it) {
        switch (it.getStateChange()) {
            case 1: {
                this$0.viewModel.setActivateAllToolWindows(true);
                break;
            }
            case 2: {
                this$0.viewModel.setActivateAllToolWindows(false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/multilaunch/design/MultiLaunchConfigurationEditor$ConfigurationChangedListener;", "Lcom/intellij/execution/RunManagerListener;", "<init>", "(Lcom/intellij/execution/multilaunch/design/MultiLaunchConfigurationEditor;)V", "runConfigurationAdded", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runConfigurationChanged", "runConfigurationRemoved", "handleChanged", "intellij.platform.execution.impl"})
    public final class ConfigurationChangedListener
    implements RunManagerListener {
        public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.handleChanged(settings);
        }

        public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.handleChanged(settings);
        }

        public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.handleChanged(settings);
        }

        private final void handleChanged(RunnerAndConfigurationSettings settings) {
            if (Intrinsics.areEqual((Object)settings.getConfiguration(), (Object)MultiLaunchConfigurationEditor.this.configuration)) {
                return;
            }
            MultiLaunchConfigurationEditor.this.resetEditorFrom(MultiLaunchConfigurationEditor.this.configuration);
        }
    }
}

