/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.SettingsEditorFragmentType;
import com.intellij.execution.util.EnvFilesUtilKt;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonParameterFragments<Settings extends CommonProgramRunConfigurationParameters> {
    private final List<SettingsEditorFragment<Settings, ?>> myFragments;
    private final SettingsEditorFragment<Settings, LabeledComponent<TextFieldWithBrowseButton>> myWorkingDirectory;
    private final Computable<Boolean> myHasModule;

    public CommonParameterFragments(@NotNull Project project, Computable<Module> moduleProvider) {
        if (project == null) {
            CommonParameterFragments.$$$reportNull$$$0(0);
        }
        this.myFragments = new ArrayList();
        this.myHasModule = () -> moduleProvider.compute() != null;
        this.myWorkingDirectory = CommonParameterFragments.createWorkingDirectory(project, moduleProvider);
        this.myFragments.add(this.myWorkingDirectory);
        this.myFragments.add(CommonParameterFragments.createEnvParameters());
    }

    @NotNull
    public SettingsEditorFragment<Settings, RawCommandLineEditor> programArguments() {
        RawCommandLineEditor programArguments = new RawCommandLineEditor();
        CommandLinePanel.setMinimumWidth((Component)programArguments, (int)400);
        String message = ExecutionBundle.message((String)"run.configuration.program.parameters.placeholder", (Object[])new Object[0]);
        programArguments.getEditorField().getEmptyText().setText(message);
        programArguments.getEditorField().getAccessibleContext().setAccessibleName(message);
        TextComponentEmptyText.setupPlaceholderVisibility((JTextComponent)programArguments.getEditorField());
        CommonParameterFragments.setMonospaced(programArguments.getTextField());
        MacrosDialog.addMacroSupport((ExtendableTextField)programArguments.getEditorField(), MacrosDialog.Filters.ALL, (Computable<Boolean>)((Computable)() -> this.myHasModule.compute() != null));
        SettingsEditorFragment parameters = new SettingsEditorFragment("commandLineParameters", ExecutionBundle.message((String)"run.configuration.program.parameters.name", (Object[])new Object[0]), null, (JComponent)programArguments, 100, (settings, component) -> component.setText(settings.getProgramParameters()), (settings, component) -> settings.setProgramParameters(component.getText()), Predicates.alwaysTrue());
        parameters.setRemovable(false);
        parameters.setEditorGetter(editor -> editor.getEditorField());
        parameters.setHint(ExecutionBundle.message((String)"run.configuration.program.parameters.hint", (Object[])new Object[0]));
        SettingsEditorFragment settingsEditorFragment = parameters;
        if (settingsEditorFragment == null) {
            CommonParameterFragments.$$$reportNull$$$0(1);
        }
        return settingsEditorFragment;
    }

    public List<SettingsEditorFragment<Settings, ?>> getFragments() {
        return this.myFragments;
    }

    public <S extends InputRedirectAware> SettingsEditorFragment<S, ?> createRedirectFragment() {
        TextFieldWithBrowseButton inputFile = new TextFieldWithBrowseButton();
        inputFile.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>((ComponentWithBrowseButton)inputFile, null, FileChooserDescriptorFactory.createSingleFileDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile initialFile = super.getInitialFile();
                if (initialFile != null) {
                    return initialFile;
                }
                String text = ((TextFieldWithBrowseButton)((LabeledComponent)CommonParameterFragments.this.myWorkingDirectory.component()).getComponent()).getText();
                return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)text));
            }
        });
        MacrosDialog.addMacroSupport((ExtendableTextField)inputFile.getTextField(), MacrosDialog.Filters.ALL, (Computable<Boolean>)((Computable)() -> this.myHasModule.compute() != null));
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)inputFile, (String)ExecutionBundle.message((String)"redirect.input.from", (Object[])new Object[0]));
        labeledComponent.setLabelLocation("West");
        SettingsEditorFragment redirectInput = new SettingsEditorFragment("redirectInput", ExecutionBundle.message((String)"redirect.input.from.name", (Object[])new Object[0]), ExecutionBundle.message((String)"group.operating.system", (Object[])new Object[0]), (JComponent)labeledComponent, (settings, component) -> ((TextFieldWithBrowseButton)component.getComponent()).setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)settings.getInputRedirectOptions().getRedirectInputPath()))), (settings, component) -> {
            String filePath = ((TextFieldWithBrowseButton)component.getComponent()).getText();
            settings.getInputRedirectOptions().setRedirectInput(component.isVisible() && StringUtil.isNotEmpty((String)filePath));
            settings.getInputRedirectOptions().setRedirectInputPath(StringUtil.isEmpty((String)filePath) ? null : FileUtil.toSystemIndependentName((String)filePath));
        }, settings -> StringUtil.isNotEmpty((String)settings.getInputRedirectOptions().getRedirectInputPath()));
        redirectInput.setActionHint(ExecutionBundle.message((String)"read.input.from.the.specified.file", (Object[])new Object[0]));
        return redirectInput;
    }

    public static <S extends CommonProgramRunConfigurationParameters> SettingsEditorFragment<S, LabeledComponent<TextFieldWithBrowseButton>> createWorkingDirectory(@NotNull Project project, @NotNull Computable<? extends Module> moduleProvider) {
        if (project == null) {
            CommonParameterFragments.$$$reportNull$$$0(2);
        }
        if (moduleProvider == null) {
            CommonParameterFragments.$$$reportNull$$$0(3);
        }
        ExtendableTextField textField = new ExtendableTextField(10);
        MacrosDialog.addMacroSupport(textField, MacrosDialog.Filters.DIRECTORY_PATH, (Computable<Boolean>)((Computable)() -> moduleProvider.compute() != null));
        TextFieldWithBrowseButton workingDirectoryField = new TextFieldWithBrowseButton((JTextField)textField);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]));
        workingDirectoryField.addBrowseFolderListener(project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        LabeledComponent field = LabeledComponent.create((JComponent)workingDirectoryField, (String)ExecutionBundle.message((String)"run.configuration.working.directory.label", (Object[])new Object[0]), (String)"West");
        SettingsEditorFragment workingDirectorySettings = new SettingsEditorFragment("workingDirectory", ExecutionBundle.message((String)"run.configuration.working.directory.name", (Object[])new Object[0]), null, (JComponent)field, (settings, component) -> ((TextFieldWithBrowseButton)component.getComponent()).setText(settings.getWorkingDirectory()), (settings, component) -> settings.setWorkingDirectory(((TextFieldWithBrowseButton)component.getComponent()).getText()), Predicates.alwaysTrue());
        workingDirectorySettings.setRemovable(false);
        workingDirectorySettings.setValidation(settings -> {
            ThrowableRunnable runnable = () -> ProgramParametersUtil.checkWorkingDirectoryExist(settings, project, (Module)moduleProvider.compute());
            ValidationInfo validationInfo = RuntimeConfigurationException.validate((JComponent)textField, (ThrowableRunnable)runnable);
            return Collections.singletonList(validationInfo);
        });
        return workingDirectorySettings;
    }

    public static <S extends CommonProgramRunConfigurationParameters> SettingsEditorFragment<S, ?> createEnvParameters() {
        EnvironmentVariablesComponent env = new EnvironmentVariablesComponent();
        env.setLabelLocation("West");
        CommonParameterFragments.setMonospaced(((TextFieldWithBrowseButton)env.getComponent()).getTextField());
        SettingsEditorFragment fragment = new SettingsEditorFragment("environmentVariables", ExecutionBundle.message((String)"environment.variables.fragment.name", (Object[])new Object[0]), ExecutionBundle.message((String)"group.operating.system", (Object[])new Object[0]), (JComponent)((Object)env), (settings, c) -> env.reset((CommonProgramRunConfigurationParameters)settings), (settings, c) -> {
            if (!env.isVisible()) {
                settings.setEnvs(Collections.emptyMap());
                settings.setPassParentEnvs(true);
            } else {
                env.apply((CommonProgramRunConfigurationParameters)settings);
            }
        }, Predicates.alwaysTrue());
        fragment.setCanBeHidden(true);
        fragment.setHint(ExecutionBundle.message((String)"environment.variables.fragment.hint", (Object[])new Object[0]));
        fragment.setActionHint(ExecutionBundle.message((String)"set.custom.environment.variables.for.the.process", (Object[])new Object[0]));
        fragment.addValidation(s -> EnvFilesUtilKt.checkEnvFiles(s));
        return fragment;
    }

    public static void setMonospaced(Component field) {
        field.setFont(EditorUtil.getEditorFont((int)JBUI.Fonts.label().getSize()));
    }

    public static <S> SettingsEditorFragment<S, JLabel> createHeader(@Nls(capitalization=Nls.Capitalization.Title) String title) {
        JLabel jLabel = new JLabel(title);
        jLabel.setFont(JBUI.Fonts.label().deriveFont(1));
        SettingsEditorFragment fragment = new SettingsEditorFragment("title", null, null, (JComponent)jLabel, SettingsEditorFragmentType.HEADER, (__, ___) -> {}, (__, ___) -> {}, Predicates.alwaysTrue());
        fragment.setCanBeHidden(false);
        fragment.setRemovable(false);
        return fragment;
    }

    public static <S> SettingsEditorFragment<S, JLabel> createRunHeader() {
        return CommonParameterFragments.createHeader(ExecutionBundle.message((String)"application.configuration.title.run", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/CommonParameterFragments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/CommonParameterFragments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "programArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createWorkingDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

