/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.PreparedIcon;
import com.intellij.execution.ui.RedesignedRunConfigurationSelector;
import com.intellij.execution.ui.RedesignedRunWidgetKt;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.toolbar.HeaderToolbarButtonLook;
import com.intellij.ui.BadgeRectProvider;
import com.intellij.ui.BadgeShapeProvider;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.StrokeKt;
import com.intellij.ui.icons.TextHoledIcon;
import com.intellij.ui.icons.TextIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J$\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J4\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/ui/RunWidgetButtonLook;", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/toolbar/HeaderToolbarButtonLook;", "<init>", "()V", "getStateBackground", "Ljava/awt/Color;", "component", "Ljavax/swing/JComponent;", "state", "", "paintIcon", "", "g", "Ljava/awt/Graphics;", "actionButton", "Lcom/intellij/openapi/actionSystem/ActionButtonComponent;", "icon", "Ljavax/swing/Icon;", "x", "y", "intellij.platform.execution.impl"})
final class RunWidgetButtonLook
extends HeaderToolbarButtonLook {
    public RunWidgetButtonLook() {
        super(RunWidgetButtonLook::_init_$lambda$0);
    }

    @Nullable
    protected Color getStateBackground(@NotNull JComponent component, int state) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ActionButton actionButton = component instanceof ActionButton ? (ActionButton)component : null;
        boolean isDisabled = actionButton != null && (actionButton = actionButton.getPresentation()) != null ? !actionButton.isEnabled() : false;
        boolean isStopButton = RedesignedRunWidgetKt.access$isStopButton(component);
        if (isDisabled || !isStopButton && !RedesignedRunWidgetKt.access$buttonIsRunning(component)) {
            return super.getStateBackground(component, state);
        }
        Color color = isStopButton ? JBUI.CurrentTheme.RunWidget.STOP_BACKGROUND : JBUI.CurrentTheme.RunWidget.RUNNING_BACKGROUND;
        return switch (state) {
            case 0 -> color;
            case -1 -> ColorUtil.alphaBlending((Color)JBUI.CurrentTheme.RunWidget.PRESSED_BACKGROUND, (Color)color);
            default -> ColorUtil.alphaBlending((Color)JBUI.CurrentTheme.RunWidget.HOVER_BACKGROUND, (Color)color);
        };
    }

    public void paintIcon(@Nullable Graphics g, @Nullable ActionButtonComponent actionButton, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Point iconPos = IdeaActionButtonLook.getIconPosition((ActionButtonComponent)actionButton, (Icon)icon);
        this.paintIcon(g, actionButton, icon, iconPos.x, iconPos.y);
    }

    public void paintIcon(@Nullable Graphics g, @Nullable ActionButtonComponent actionButton, @NotNull Icon icon, int x, int y) {
        Icon textIcon;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (actionButton == null) {
            return;
        }
        if (icon.getIconWidth() == 0 || icon.getIconHeight() == 0) {
            return;
        }
        if (actionButton instanceof ActionButton && ((ActionButton)actionButton).getAction() instanceof RedesignedRunConfigurationSelector) {
            super.paintIcon(g, actionButton, icon, x, y);
            return;
        }
        Icon resultIcon = icon;
        if (icon instanceof LayeredIcon && ((LayeredIcon)icon).getAllLayers().length == 2 && (textIcon = ((LayeredIcon)icon).getAllLayers()[1]) instanceof TextIcon) {
            String text = ((TextIcon)textIcon).getText();
            BadgeRectProvider provider = new BadgeRectProvider(0.0, 0.45, text.length() == 1 ? 0.75 : 0.3, 1.2, 1.2, 0.0, 33, null);
            Icon icon2 = ((LayeredIcon)icon).getAllLayers()[0];
            Intrinsics.checkNotNull((Object)icon2);
            float f = JBUIScale.scale((float)12.0f);
            Color color = JBUI.CurrentTheme.RunWidget.RUNNING_ICON_COLOR;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"RUNNING_ICON_COLOR");
            resultIcon = (Icon)new TextHoledIcon(icon2, text, f, color, (BadgeShapeProvider)provider);
        }
        if (resultIcon instanceof EmptyIcon) {
            return;
        }
        if (!(resultIcon instanceof PreparedIcon)) {
            boolean iconWithBackground;
            boolean executionAction = RedesignedRunWidgetKt.access$isRunWidgetExecutionAction(actionButton);
            boolean bl = iconWithBackground = executionAction && RedesignedRunWidgetKt.access$buttonIsRunning(actionButton) || RedesignedRunWidgetKt.access$isStopButton(actionButton);
            Color color = iconWithBackground ? JBUI.CurrentTheme.RunWidget.RUNNING_ICON_COLOR : (executionAction ? JBUI.CurrentTheme.RunWidget.RUN_ICON_COLOR : JBUI.CurrentTheme.RunWidget.ICON_COLOR);
            Intrinsics.checkNotNull((Object)color);
            resultIcon = StrokeKt.toStrokeIcon((Icon)resultIcon, (Color)color);
        }
        IdeaActionButtonLook.paintIconImpl((Graphics)g, (ActionButtonComponent)actionButton, (Icon)resultIcon, (int)x, (int)y);
    }

    private static final int _init_$lambda$0() {
        return 16;
    }
}

