/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.actions;

import com.intellij.execution.ui.layout.actions.ViewLayoutModificationAction;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.custom.options.ContentLayoutStateSettings;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RestoreViewAction
extends DumbAwareToggleAction
implements ViewLayoutModificationAction {
    private final Content myContent;
    private final ContentLayoutStateSettings myLayoutSettings;

    public RestoreViewAction(@NotNull RunnerContentUi ui, @NotNull Content content) {
        if (ui == null) {
            RestoreViewAction.$$$reportNull$$$0(0);
        }
        if (content == null) {
            RestoreViewAction.$$$reportNull$$$0(1);
        }
        this(content, new DefaultContentStateSettings(ui, content));
    }

    public RestoreViewAction(@NotNull Content content, ContentLayoutStateSettings layoutSettings) {
        if (content == null) {
            RestoreViewAction.$$$reportNull$$$0(2);
        }
        this.myContent = content;
        this.myLayoutSettings = layoutSettings;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            RestoreViewAction.$$$reportNull$$$0(3);
        }
        return this.myLayoutSettings.isSelected();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            RestoreViewAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            RestoreViewAction.$$$reportNull$$$0(5);
        }
        this.myLayoutSettings.setSelected(state);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RestoreViewAction.$$$reportNull$$$0(6);
        }
        super.update(e);
        e.getPresentation().setText(this.myLayoutSettings.getDisplayName(), false);
        e.getPresentation().setEnabled(this.myLayoutSettings.isEnabled());
    }

    @Override
    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            RestoreViewAction.$$$reportNull$$$0(7);
        }
        return content;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/actions/RestoreViewAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/actions/RestoreViewAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }

    private static final class DefaultContentStateSettings
    implements ContentLayoutStateSettings {
        private final RunnerContentUi myUi;
        private final Content myContent;

        public DefaultContentStateSettings(@NotNull RunnerContentUi ui, @NotNull Content content) {
            if (ui == null) {
                DefaultContentStateSettings.$$$reportNull$$$0(0);
            }
            if (content == null) {
                DefaultContentStateSettings.$$$reportNull$$$0(1);
            }
            this.myUi = ui;
            this.myContent = content;
        }

        public boolean isSelected() {
            return this.myContent.isValid() && Objects.requireNonNull(this.myContent.getManager()).getIndexOfContent(this.myContent) != -1;
        }

        public void setSelected(boolean state) {
            if (state) {
                this.myUi.restore(this.myContent);
                this.myUi.select(this.myContent, true);
            } else {
                this.myUi.minimize(this.myContent, null);
            }
        }

        public void restore() {
            this.setSelected(true);
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myContent.getDisplayName();
            if (string == null) {
                DefaultContentStateSettings.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isEnabled() {
            return !this.isSelected() || this.myUi.getContentManager().getContents().length > 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ui/layout/actions/RestoreViewAction$DefaultContentStateSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ui/layout/actions/RestoreViewAction$DefaultContentStateSettings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

