/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.terminal.TerminalConsoleFontSizeProvider;
import com.intellij.terminal.TerminalFontSizeProvider;
import com.intellij.terminal.TerminalUiSettingsListener;
import com.intellij.terminal.TerminalUiSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.ui.AwtTransformers;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import com.jediterm.terminal.ui.settings.DefaultSettingsProvider;
import java.awt.Color;
import java.awt.Font;
import java.util.Collections;
import java.util.List;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalSystemSettingsProviderBase
extends DefaultSettingsProvider {
    public static final TextAttributesKey COMMAND_TO_RUN_USING_IDE_KEY = TextAttributesKey.createTextAttributesKey((String)"TERMINAL_COMMAND_TO_RUN_USING_IDE");
    private final TerminalUiSettingsManager myUiSettingsManager;
    private final TerminalFontSizeProvider myFontSizeProvider = this.createFontSizeProvider();

    public JBTerminalSystemSettingsProviderBase() {
        this.myUiSettingsManager = TerminalUiSettingsManager.getInstance();
    }

    @ApiStatus.Internal
    @NotNull
    protected TerminalFontSizeProvider createFontSizeProvider() {
        return new TerminalConsoleFontSizeProvider();
    }

    @ApiStatus.Internal
    public void addUiSettingsListener(@NotNull Disposable parentDisposable, final @NotNull TerminalUiSettingsListener listener2) {
        if (parentDisposable == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(1);
        }
        this.myUiSettingsManager.addListener(parentDisposable, new TerminalUiSettingsListener(){

            @Override
            public void cursorChanged() {
                listener2.cursorChanged();
            }
        });
        this.myFontSizeProvider.addListener(parentDisposable, new TerminalFontSizeProvider.Listener(){

            @Override
            public void fontChanged(boolean showZoomIndicator) {
                listener2.fontChanged();
            }
        });
    }

    @ApiStatus.Internal
    @NotNull
    protected EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.myUiSettingsManager.getEditorColorsScheme();
        if (editorColorsScheme == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(2);
        }
        return editorColorsScheme;
    }

    @NotNull
    public TerminalActionPresentation getOpenUrlActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.OpenAsUrl.text", (Object[])new Object[0]), Collections.emptyList());
    }

    @NotNull
    public TerminalActionPresentation getCopyActionPresentation() {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.CopySelectedText");
        if (strokes.isEmpty()) {
            strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("$Copy");
        }
        return new TerminalActionPresentation(UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.$Copy.text", (Object[])new Object[0])), strokes);
    }

    @NotNull
    public TerminalActionPresentation getPasteActionPresentation() {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.Paste");
        if (strokes.isEmpty()) {
            strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("$Paste");
        }
        return new TerminalActionPresentation(UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.$Paste.text", (Object[])new Object[0])), strokes);
    }

    @NotNull
    public TerminalActionPresentation getSelectAllActionPresentation() {
        TerminalActionPresentation terminalActionPresentation = this.getSelectAllActionPresentation(true);
        if (terminalActionPresentation == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(3);
        }
        return terminalActionPresentation;
    }

    @NotNull
    protected TerminalActionPresentation getSelectAllActionPresentation(boolean useCommonShortcuts) {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId(useCommonShortcuts ? "$SelectAll" : "Terminal.SelectAll");
        return new TerminalActionPresentation(UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.$SelectAll.text", (Object[])new Object[0])), strokes);
    }

    @NotNull
    public TerminalActionPresentation getClearBufferActionPresentation() {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.ClearBuffer");
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.ClearBuffer.text", (Object[])new Object[0]), strokes);
    }

    @NotNull
    public TerminalActionPresentation getPageUpActionPresentation() {
        TerminalActionPresentation presentation = super.getPageUpActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.PageUp.text", (Object[])new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getPageDownActionPresentation() {
        TerminalActionPresentation presentation = super.getPageDownActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.PageDown.text", (Object[])new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getLineUpActionPresentation() {
        TerminalActionPresentation presentation = super.getLineUpActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.LineUp.text", (Object[])new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getLineDownActionPresentation() {
        TerminalActionPresentation presentation = super.getLineDownActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.LineDown.text", (Object[])new Object[0]), presentation.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getFindActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.Find.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.Find", "Find"));
    }

    @NotNull
    public TerminalColorPalette getTerminalColorPalette() {
        TerminalColorPalette terminalColorPalette = this.myUiSettingsManager.getTerminalColorPalette();
        if (terminalColorPalette == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(4);
        }
        return terminalColorPalette;
    }

    @NotNull
    @Nls
    public static String getGotoNextSplitTerminalActionText(boolean forward) {
        String string = forward ? ActionsBundle.message((String)"action.NextSplitter.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.PrevSplitter.text", (Object[])new Object[0]);
        if (string == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public TerminalAction getGotoNextSplitTerminalAction(@Nullable JBTerminalWidgetListener listener2, boolean forward) {
        String actionId = forward ? "TW.MoveToNextSplitter" : "TW.MoveToPreviousSplitter";
        String text = UIUtil.removeMnemonic((String)JBTerminalSystemSettingsProviderBase.getGotoNextSplitTerminalActionText(forward));
        return new TerminalAction(new TerminalActionPresentation(text, JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId(actionId)), event -> {
            if (listener2 != null) {
                listener2.gotoNextSplitTerminal(forward);
            }
            return true;
        });
    }

    @NotNull
    public static List<KeyStroke> getKeyStrokesByActionId(@Language(value="devkit-action-id") @NotNull String actionId, @NotNull String failoverActionId) {
        List<KeyStroke> strokes;
        if (actionId == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(6);
        }
        if (failoverActionId == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(7);
        }
        if ((strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId(actionId)).isEmpty() && ActionManager.getInstance().getAction(actionId) == null) {
            strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId(failoverActionId);
        }
        List<KeyStroke> list = strokes;
        if (list == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public static List<KeyStroke> getKeyStrokesByActionId(@NotNull String actionId) {
        if (actionId == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.mapNotNull((Object[])KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts(), shortcut -> {
            KeyStroke keyStroke;
            if (shortcut instanceof KeyboardShortcut) {
                KeyboardShortcut ks = (KeyboardShortcut)shortcut;
                keyStroke = ks.getFirstKeyStroke();
            } else {
                keyStroke = null;
            }
            return keyStroke;
        });
        if (list == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public TerminalActionPresentation getNextTabActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.SelectNextTab.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("NextTab"));
    }

    @NotNull
    public TerminalActionPresentation getPreviousTabActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.SelectPreviousTab.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("PreviousTab"));
    }

    @NotNull
    public TerminalActionPresentation getMoveTabRightActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.MoveRight.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.MoveToolWindowTabRight"));
    }

    @NotNull
    public TerminalActionPresentation getMoveTabLeftActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.MoveLeft.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.MoveToolWindowTabLeft"));
    }

    @NotNull
    public TerminalActionPresentation getShowTabsActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.ShowTabs.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("ShowContent"));
    }

    public float getLineSpacing() {
        return this.getColorsScheme().getConsoleLineSpacing();
    }

    public float getColumnSpacing() {
        return 1.0f;
    }

    @NotNull
    public TextStyle getSelectionColor() {
        return new TextStyle(AwtTransformers.fromAwtToTerminalColor((Color)this.getColorsScheme().getColor(EditorColors.SELECTION_FOREGROUND_COLOR)), AwtTransformers.fromAwtToTerminalColor((Color)this.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR)));
    }

    @NotNull
    public TextStyle getFoundPatternColor() {
        return new TextStyle(AwtTransformers.fromAwtToTerminalColor((Color)this.getColorsScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getForegroundColor()), AwtTransformers.fromAwtToTerminalColor((Color)this.getColorsScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getBackgroundColor()));
    }

    public TextStyle getHyperlinkColor() {
        return new TextStyle(AwtTransformers.fromAwtToTerminalColor((Color)this.getColorsScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor()), AwtTransformers.fromAwtToTerminalColor((Color)this.getColorsScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getBackgroundColor()));
    }

    @NotNull
    public TerminalColor getDefaultBackground() {
        return new TerminalColor(() -> this.getTerminalColorPalette().getDefaultBackground());
    }

    @NotNull
    public TerminalColor getDefaultForeground() {
        return new TerminalColor(() -> this.getTerminalColorPalette().getDefaultForeground());
    }

    @NotNull
    public TextStyle getDefaultStyle() {
        return new TextStyle(this.getDefaultForeground(), this.getDefaultBackground());
    }

    @ApiStatus.Internal
    public FontPreferences getFontPreferences() {
        return this.getColorsScheme().getConsoleFontPreferences();
    }

    public Font getTerminalFont() {
        Font font = this.getColorsScheme().getFont(EditorFontType.CONSOLE_PLAIN);
        return font.deriveFont(this.getTerminalFontSize());
    }

    public float getTerminalFontSize() {
        return this.myFontSizeProvider.getFontSize();
    }

    @ApiStatus.Internal
    public void setTerminalFontSize(float fontSize) {
        this.myFontSizeProvider.setFontSize(fontSize);
    }

    @ApiStatus.Internal
    public void resetTerminalFontSize() {
        this.myFontSizeProvider.resetFontSize();
    }

    public boolean useAntialiasing() {
        return true;
    }

    public boolean copyOnSelect() {
        return SystemInfo.isLinux;
    }

    public boolean pasteOnMiddleMouseClick() {
        return true;
    }

    public int getBufferMaxLinesCount() {
        int linesCount = AdvancedSettings.getInt((String)"terminal.buffer.max.lines.count");
        if (linesCount > 0) {
            return linesCount;
        }
        return super.getBufferMaxLinesCount();
    }

    public boolean overrideIdeShortcuts() {
        return false;
    }

    public boolean useInverseSelectionColor() {
        return false;
    }

    public int caretBlinkingMs() {
        EditorSettingsExternalizable instance = EditorSettingsExternalizable.getInstance();
        return instance.isBlinkCaret() ? instance.getBlinkPeriod() : 0;
    }

    @NotNull
    public CursorShape getCursorShape() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        TerminalUiSettingsManager.CursorShape shape = TerminalUiSettingsManager.getInstance().getCursorShape();
        if (shape == TerminalUiSettingsManager.CursorShape.BLOCK) {
            CursorShape cursorShape = editorSettings.isBlinkCaret() ? CursorShape.BLINK_BLOCK : CursorShape.STEADY_BLOCK;
            if (cursorShape == null) {
                JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(11);
            }
            return cursorShape;
        }
        if (shape == TerminalUiSettingsManager.CursorShape.UNDERLINE) {
            CursorShape cursorShape = editorSettings.isBlinkCaret() ? CursorShape.BLINK_UNDERLINE : CursorShape.STEADY_UNDERLINE;
            if (cursorShape == null) {
                JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(12);
            }
            return cursorShape;
        }
        CursorShape cursorShape = editorSettings.isBlinkCaret() ? CursorShape.BLINK_VERTICAL_BAR : CursorShape.STEADY_VERTICAL_BAR;
        if (cursorShape == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(13);
        }
        return cursorShape;
    }

    public boolean shouldDisableLineSpacingForAlternateScreenBuffer() {
        return AdvancedSettings.getBoolean((String)"terminal.use.1.0.line.spacing.for.alternative.screen.buffer");
    }

    public boolean shouldFillCharacterBackgroundIncludingLineSpacing() {
        return AdvancedSettings.getBoolean((String)"terminal.fill.character.background.including.line.spacing");
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public TerminalActionPresentation getNewSessionActionPresentation() {
        return new TerminalActionPresentation("New Session", ClientSystemInfo.isMac() ? KeyStroke.getKeyStroke(84, 256) : KeyStroke.getKeyStroke(84, 192));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 8, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/JBTerminalSystemSettingsProviderBase";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failoverActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/JBTerminalSystemSettingsProviderBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectAllActionPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalColorPalette";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoNextSplitTerminalActionText";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokesByActionId";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCursorShape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addUiSettingsListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokesByActionId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 8, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

