/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionMode;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionModes {
    private static final Logger LOG = Logger.getInstance(ExecutionMode.class);

    public static class SameThreadMode
    extends ExecutionMode {
        private final int myTimeout;

        public SameThreadMode(boolean cancelable, @NlsContexts.ProgressTitle @Nullable String title2, int timeout) {
            super(cancelable, null, title2, false, false, null);
            this.myTimeout = timeout;
        }

        public SameThreadMode(@NlsContexts.ProgressTitle @Nullable String title2) {
            this(true, title2, -1);
        }

        public SameThreadMode(boolean cancelable) {
            this(cancelable, null, -1);
        }

        public SameThreadMode(int timeout) {
            this(false, null, timeout);
        }

        public SameThreadMode() {
            this(true);
        }

        @Override
        public int getTimeout() {
            return this.myTimeout;
        }

        @Override
        public void onTimeout(@NotNull ProcessHandler processHandler, @NotNull String commandLineString, @NotNull ProcessOutput outputCollected, @Nullable Throwable invocatorStack) {
            if (processHandler == null) {
                SameThreadMode.$$$reportNull$$$0(0);
            }
            if (commandLineString == null) {
                SameThreadMode.$$$reportNull$$$0(1);
            }
            if (outputCollected == null) {
                SameThreadMode.$$$reportNull$$$0(2);
            }
            super.onTimeout(processHandler, commandLineString, outputCollected, invocatorStack);
            String output = "\n    stdout: " + outputCollected.getStdout() + ";\n    stderr: " + outputCollected.getStderr();
            LOG.error(new Throwable("Timeout (" + this.getTimeout() + " sec) on executing: " + commandLineString + "; output collected: " + output, invocatorStack));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commandLineString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputCollected";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/ExecutionModes$SameThreadMode";
            objectArray[2] = "onTimeout";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ModalProgressMode
    extends ExecutionMode {
        public ModalProgressMode(boolean cancelable, @NlsContexts.ProgressTitle @Nullable String title, JComponent progressParentComponent) {
            super(cancelable, title, null, false, true, progressParentComponent);
        }

        public ModalProgressMode(@NlsContexts.ProgressTitle @Nullable String title) {
            this(true, title, null);
        }

        public ModalProgressMode(@NlsContexts.ProgressTitle @Nullable String title, JComponent progressParentComponent) {
            this(true, title, progressParentComponent);
        }
    }

    public static final class BackGroundMode
    extends ExecutionMode {
        public BackGroundMode(boolean cancelable, @NlsContexts.ProgressTitle @Nullable String title) {
            super(cancelable, title, null, true, false, null);
        }

        public BackGroundMode(@NlsContexts.ProgressTitle @Nullable String title) {
            this(true, title);
        }
    }
}

