/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PauseOutputAction
extends ToggleAction
implements DumbAware {
    PauseOutputAction() {
        super(ExecutionBundle.messagePointer((String)"run.configuration.pause.output.action.name", (Object[])new Object[0]), AllIcons.Actions.Pause);
    }

    @Nullable
    private static ConsoleView getConsoleView(AnActionEvent event) {
        return (ConsoleView)event.getData(LangDataKeys.CONSOLE_VIEW);
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        ConsoleView consoleView;
        if (event == null) {
            PauseOutputAction.$$$reportNull$$$0(0);
        }
        return (consoleView = PauseOutputAction.getConsoleView(event)) != null && consoleView.isOutputPaused();
    }

    public void setSelected(@NotNull AnActionEvent event, boolean flag) {
        ConsoleView consoleView;
        if (event == null) {
            PauseOutputAction.$$$reportNull$$$0(1);
        }
        if ((consoleView = PauseOutputAction.getConsoleView(event)) != null) {
            consoleView.setOutputPaused(flag);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PauseOutputAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        boolean isEnabled;
        if (event == null) {
            PauseOutputAction.$$$reportNull$$$0(3);
        }
        super.update(event);
        ConsoleView consoleView = PauseOutputAction.getConsoleView(event);
        if (consoleView == null || !consoleView.canPause()) {
            isEnabled = false;
        } else {
            RunContentDescriptor descriptor = StopAction.getRecentlyStartedContentDescriptor(event.getDataContext());
            ProcessHandler handler2 = descriptor != null ? descriptor.getProcessHandler() : null;
            isEnabled = handler2 != null && !handler2.isProcessTerminated() || consoleView.hasDeferredOutput();
        }
        Presentation presentation = event.getPresentation();
        presentation.setEnabledAndVisible(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/PauseOutputAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/PauseOutputAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

