/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.impl.RCInArbitraryFileManager;
import com.intellij.execution.impl.RCInArbitraryFileManagerKt;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u00018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0014J)\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0000\u00a2\u0006\u0002\b!J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0000\u00a2\u0006\u0002\b$J!\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bH\u0000\u00a2\u0006\u0002\b*J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-H\u0080@\u00a2\u0006\u0004\b.\u0010/J\u001e\u00100\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u00101J\u001e\u00102\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\b2\u0006\u00103\u001a\u000204H\u0082@\u00a2\u0006\u0002\u00105J\u0013\u00106\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0000\u00a2\u0006\u0002\b7R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u000b\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0018\u00010\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/execution/impl/RCInArbitraryFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "filePathToRunConfigs", "", "", "", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "filePathToDigest", "kotlin.jvm.PlatformType", "", "", "saveInProgress", "", "addRunConfiguration", "", "runConfig", "addRunConfiguration$intellij_platform_execution_impl", "removeRunConfiguration", "removeRunConfigOnlyIfFileNameChanged", "deleteContainingFile", "removeRunConfiguration$intellij_platform_execution_impl", "deleteFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadChangedRunConfigsFromFile", "Lcom/intellij/execution/impl/RCInArbitraryFileManager$DeletedAndAddedRunConfigs;", "runManager", "Lcom/intellij/execution/impl/RunManagerImpl;", "filePath", "loadChangedRunConfigsFromFile$intellij_platform_execution_impl", "findRunConfigsThatAreNotWithinProjectContent", "", "findRunConfigsThatAreNotWithinProjectContent$intellij_platform_execution_impl", "getRunConfigsFromFiles", "", "filePaths", "getRunConfigsFromFiles$intellij_platform_execution_impl", "hasRunConfigsFromFile", "hasRunConfigsFromFile$intellij_platform_execution_impl", "saveRunConfigs", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "saveRunConfigs$intellij_platform_execution_impl", "(Ljava/util/concurrent/locks/ReentrantReadWriteLock;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveRunConfig", "(Ljava/util/concurrent/locks/ReentrantReadWriteLock;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveToFile", "data", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "(Ljava/lang/String;Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearAllAndReturnFilePaths", "clearAllAndReturnFilePaths$intellij_platform_execution_impl", "DeletedAndAddedRunConfigs", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRCInArbitraryFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RCInArbitraryFileManager.kt\ncom/intellij/execution/impl/RCInArbitraryFileManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1#2:327\n*E\n"})
public final class RCInArbitraryFileManager {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, List<RunnerAndConfigurationSettingsImpl>> filePathToRunConfigs;
    private final Map<String, long[]> filePathToDigest;
    private volatile boolean saveInProgress;

    public RCInArbitraryFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.filePathToRunConfigs = new LinkedHashMap();
        this.filePathToDigest = Collections.synchronizedMap(new HashMap());
    }

    public final void addRunConfiguration$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettingsImpl runConfig) {
        Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
        String filePath = runConfig.getPathIfStoredInArbitraryFileInProject();
        if (!runConfig.isStoredInArbitraryFileInProject() || filePath == null) {
            RCInArbitraryFileManagerKt.access$getLOG().error("Unexpected run configuration, path: " + filePath);
            return;
        }
        List<RunnerAndConfigurationSettingsImpl> runConfigs = this.filePathToRunConfigs.get(filePath);
        if (runConfigs != null) {
            if (!runConfigs.contains(runConfig)) {
                runConfigs.add(runConfig);
            }
        } else {
            Object[] objectArray = new RunnerAndConfigurationSettingsImpl[]{runConfig};
            this.filePathToRunConfigs.put(filePath, CollectionsKt.mutableListOf((Object[])objectArray));
        }
    }

    public final void removeRunConfiguration$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettingsImpl runConfig, boolean removeRunConfigOnlyIfFileNameChanged, boolean deleteContainingFile) {
        Iterator<Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>>> fileEntryIterator;
        Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
        Iterator<Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>>> iterator = fileEntryIterator = this.filePathToRunConfigs.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator<RunnerAndConfigurationSettingsImpl> runConfigIterator;
            Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>> fileEntry = iterator.next();
            String filePath = fileEntry.getKey();
            Iterator<RunnerAndConfigurationSettingsImpl> iterator2 = runConfigIterator = fileEntry.getValue().iterator();
            while (iterator2.hasNext()) {
                RunnerAndConfigurationSettingsImpl rc = iterator2.next();
                if (!Intrinsics.areEqual((Object)rc, (Object)runConfig) && (!rc.isTemplate() || !runConfig.isTemplate() || !Intrinsics.areEqual((Object)rc.getType(), (Object)runConfig.getType()))) continue;
                if (!Intrinsics.areEqual((Object)filePath, (Object)runConfig.getPathIfStoredInArbitraryFileInProject()) || !removeRunConfigOnlyIfFileNameChanged) {
                    runConfigIterator.remove();
                    if (fileEntry.getValue().isEmpty()) {
                        fileEntryIterator.remove();
                        this.filePathToDigest.remove(filePath);
                        if (deleteContainingFile) {
                            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
                            if (virtualFile != null) {
                                VirtualFile it = virtualFile;
                                boolean bl = false;
                                this.deleteFile(it);
                            }
                        }
                    }
                }
                return;
            }
        }
    }

    public static /* synthetic */ void removeRunConfiguration$intellij_platform_execution_impl$default(RCInArbitraryFileManager rCInArbitraryFileManager, RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        rCInArbitraryFileManager.removeRunConfiguration$intellij_platform_execution_impl(runnerAndConfigurationSettingsImpl, bl, bl2);
    }

    private final void deleteFile(VirtualFile file) {
        ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), () -> RCInArbitraryFileManager.deleteFile$lambda$0(file, this));
    }

    @NotNull
    public final DeletedAndAddedRunConfigs loadChangedRunConfigsFromFile$intellij_platform_execution_impl(@NotNull RunManagerImpl runManager, @NotNull String filePath) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)((Object)runManager), (String)"runManager");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.saveInProgress) {
            return new DeletedAndAddedRunConfigs(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        Map<String, List<RunnerAndConfigurationSettingsImpl>> filePathToRunConfigs = this.filePathToRunConfigs;
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file == null || !file.isValid()) {
            RCInArbitraryFileManagerKt.access$getLOG().warn("It's unexpected that the file doesn't exist at this point (" + filePath + ")");
            List list = filePathToRunConfigs.get(filePath);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List rcsToDelete = list;
            return new DeletedAndAddedRunConfigs(rcsToDelete, CollectionsKt.emptyList());
        }
        if (!ProjectFileIndex.getInstance((Project)this.project).isInContent(file)) {
            List rcsToDelete;
            List list = filePathToRunConfigs.get(filePath);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if (!((Collection)(rcsToDelete = list)).isEmpty()) {
                RCInArbitraryFileManagerKt.access$getLOG().warn("It's unexpected that the model contains run configurations for file, which is not within the project content (" + filePath + ")");
            }
            return new DeletedAndAddedRunConfigs(rcsToDelete, CollectionsKt.emptyList());
        }
        List list = filePathToRunConfigs.get(filePath);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List previouslyLoadedRunConfigs = list;
        try {
            element = JDOMUtil.load((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            RCInArbitraryFileManagerKt.access$getLOG().warn("Failed to parse file " + filePath, (Throwable)e);
            return new DeletedAndAddedRunConfigs(previouslyLoadedRunConfigs, CollectionsKt.emptyList());
        }
        Element element2 = element;
        if (!Intrinsics.areEqual((Object)element2.getName(), (Object)"component") || !Intrinsics.areEqual((Object)element2.getAttributeValue("name"), (Object)"ProjectRunConfigurationManager")) {
            RCInArbitraryFileManagerKt.access$getLOG().trace("Unexpected root element " + element2.getName() + " with name=" + element2.getAttributeValue("name") + " in " + filePath);
            return new DeletedAndAddedRunConfigs(previouslyLoadedRunConfigs, CollectionsKt.emptyList());
        }
        List loadedRunConfigs = new ArrayList();
        Element rootElementForLoadedDigest = RCInArbitraryFileManagerKt.access$createRootElement();
        for (Element configElement : element2.getChildren("configuration")) {
            try {
                RunnerAndConfigurationSettingsImpl runConfig = new RunnerAndConfigurationSettingsImpl(runManager, null, false, null, 14, null);
                Intrinsics.checkNotNull((Object)configElement);
                runConfig.readExternal(configElement, true, filePath);
                runConfig.storeInArbitraryFileInProject(filePath);
                loadedRunConfigs.add(runConfig);
                rootElementForLoadedDigest.addContent(runConfig.writeScheme());
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                RCInArbitraryFileManagerKt.access$getLOG().warn("Failed to read run configuration in " + filePath, e);
            }
        }
        Intrinsics.checkNotNull((Object)rootElementForLoadedDigest);
        long[] loadedDigest = RCInArbitraryFileManagerKt.access$computeDigest(JdomKt.toBufferExposingByteArray$default((Element)rootElementForLoadedDigest, null, (int)1, null));
        long[] previouslyLoadedDigests = this.filePathToDigest.get(filePath);
        if (previouslyLoadedDigests != null && Arrays.equals(previouslyLoadedDigests, loadedDigest)) {
            return new DeletedAndAddedRunConfigs(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        this.filePathToDigest.put(filePath, loadedDigest);
        return new DeletedAndAddedRunConfigs(previouslyLoadedRunConfigs, loadedRunConfigs);
    }

    @NotNull
    public final List<RunnerAndConfigurationSettingsImpl> findRunConfigsThatAreNotWithinProjectContent$intellij_platform_execution_impl() {
        Map<String, List<RunnerAndConfigurationSettingsImpl>> filePathToRunConfigs = this.filePathToRunConfigs;
        if (filePathToRunConfigs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        List deletedRunConfigs = new ArrayList();
        for (Map.Entry<String, List<RunnerAndConfigurationSettingsImpl>> entry : filePathToRunConfigs.entrySet()) {
            String filePath = entry.getKey();
            List<RunnerAndConfigurationSettingsImpl> runConfigs = entry.getValue();
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
            if (file == null) {
                if (this.saveInProgress) continue;
                deletedRunConfigs.addAll((Collection)runConfigs);
                RCInArbitraryFileManagerKt.access$getLOG().warn("It's unexpected that the file doesn't exist at this point (" + filePath + ")");
                continue;
            }
            if (fileIndex.isInContent(file)) continue;
            deletedRunConfigs.addAll((Collection)runConfigs);
        }
        return deletedRunConfigs;
    }

    @NotNull
    public final Collection<RunnerAndConfigurationSettingsImpl> getRunConfigsFromFiles$intellij_platform_execution_impl(@NotNull Collection<String> filePaths) {
        Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
        List result2 = new ArrayList();
        for (String filePath : filePaths) {
            List<RunnerAndConfigurationSettingsImpl> list = this.filePathToRunConfigs.get(filePath);
            if (list == null) continue;
            Collection p0 = list;
            boolean bl = false;
            result2.addAll(p0);
        }
        return result2;
    }

    public final boolean hasRunConfigsFromFile$intellij_platform_execution_impl(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.filePathToRunConfigs.containsKey(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object saveRunConfigs$intellij_platform_execution_impl(@NotNull ReentrantReadWriteLock lock, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof saveRunConfigs.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RCInArbitraryFileManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveRunConfigs$intellij_platform_execution_impl(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                error = new Ref.ObjectRef();
                var5_7 = lock.readLock();
                var5_7.lock();
                try {
                    $i$a$-read-RCInArbitraryFileManager$saveRunConfigs$filePaths$1 = false;
                    $i$a$-read-RCInArbitraryFileManager$saveRunConfigs$filePaths$1 = CollectionsKt.sorted((Iterable)this.filePathToRunConfigs.keySet());
                }
                finally {
                    var5_7.unlock();
                }
                filePaths = $i$a$-read-RCInArbitraryFileManager$saveRunConfigs$filePaths$1;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)lock);
                $continuation.L$1 = error;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)filePaths);
                $continuation.label = 1;
                v0 = FileUtilKt.writeWithEnsureWritable((Project)this.project, (Collection)filePaths, (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this, lock, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ RCInArbitraryFileManager this$0;
                    final /* synthetic */ ReentrantReadWriteLock $lock;
                    {
                        this.this$0 = $receiver;
                        this.$lock = $lock;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        String string = (String)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void filePath;
                                ResultKt.throwOnFailure((Object)$result);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)filePath);
                                this.label = 1;
                                Object object2 = RCInArbitraryFileManager.access$saveRunConfig(this.this$0, this.$lock, (String)filePath, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(String p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, saveRunConfigs$lambda$1(kotlin.jvm.internal.Ref$ObjectRef java.lang.String java.lang.Throwable ), (Ljava/lang/String;Ljava/lang/Throwable;)Lkotlin/Unit;)((Ref.ObjectRef)error), (Continuation)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl38
            }
            case 1: {
                filePaths = (List)$continuation.L$2;
                error = (Ref.ObjectRef)$continuation.L$1;
                lock = (ReentrantReadWriteLock)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                v1 = (Throwable)error.element;
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-RCInArbitraryFileManager$saveRunConfigs$4 = false;
                    throw it;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object saveRunConfig(ReentrantReadWriteLock lock, String filePath, Continuation<? super Unit> $completion) {
        if (!($completion instanceof saveRunConfig.1)) ** GOTO lbl-1000
        var13_4 = $completion;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ RCInArbitraryFileManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RCInArbitraryFileManager.access$saveRunConfig(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var7_7 = lock.readLock();
                var7_7.lock();
                try {
                    $i$a$-read-RCInArbitraryFileManager$saveRunConfig$rootElement$1 = false;
                    rootElement = RCInArbitraryFileManagerKt.access$createRootElement();
                    v0 = this.filePathToRunConfigs.get(filePath);
                    if (v0 == null) {
                        v1 = null;
                    } else {
                        for (RunnerAndConfigurationSettingsImpl runConfig : v0) {
                            rootElement.addContent(runConfig.writeScheme());
                        }
                        v1 = rootElement;
                    }
                    var8_9 = v1;
                    v2 = var8_9;
                }
                finally {
                    var7_7.unlock();
                }
                if (v2 == null) {
                    return Unit.INSTANCE;
                }
                rootElement = v2;
                this.saveInProgress = true;
                previouslyLoadedDigest = this.filePathToDigest.get(filePath);
                data = JdomKt.toBufferExposingByteArray$default((Element)rootElement, null, (int)1, null);
                newDigest = RCInArbitraryFileManagerKt.access$computeDigest(data);
                if (previouslyLoadedDigest != null && Arrays.equals(newDigest, previouslyLoadedDigest)) ** GOTO lbl79
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)lock);
                $continuation.L$1 = filePath;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rootElement);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)previouslyLoadedDigest);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.L$5 = newDigest;
                $continuation.label = 1;
                v3 = this.saveToFile(filePath, data, (Continuation<? super Unit>)$continuation);
                ** if (v3 != var14_6) goto lbl53
lbl52:
                // 1 sources

                return var14_6;
lbl53:
                // 1 sources

                ** GOTO lbl65
            }
            case 1: {
                newDigest = (long[])$continuation.L$5;
                data = (BufferExposingByteArrayOutputStream)$continuation.L$4;
                previouslyLoadedDigest = (long[])$continuation.L$3;
                rootElement = (Element)$continuation.L$2;
                filePath = (String)$continuation.L$1;
                lock = (ReentrantReadWriteLock)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl65:
                    // 2 sources

                    this.filePathToDigest.put(filePath, newDigest);
                    ** GOTO lbl79
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (AccessDeniedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot save run configuration in " + filePath, e);
                }
            }
            catch (Throwable var5_21) {
                throw var5_21;
            }
            {
                finally {
                    this.saveInProgress = false;
                }
lbl79:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object saveToFile(String filePath, BufferExposingByteArrayOutputStream data, Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.edtWriteAction(() -> RCInArbitraryFileManager.saveToFile$lambda$0(filePath, this, data), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final Collection<String> clearAllAndReturnFilePaths$intellij_platform_execution_impl() {
        List filePaths = CollectionsKt.toList((Iterable)this.filePathToRunConfigs.keySet());
        this.filePathToRunConfigs.clear();
        this.filePathToDigest.clear();
        return filePaths;
    }

    private static final Unit deleteFile$lambda$0(VirtualFile $file, RCInArbitraryFileManager this$0) {
        ActionsKt.runWriteAction(() -> RCInArbitraryFileManager.deleteFile$lambda$0$0($file, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit deleteFile$lambda$0$0(VirtualFile $file, RCInArbitraryFileManager this$0) {
        $file.delete((Object)this$0);
        return Unit.INSTANCE;
    }

    private static final Unit saveRunConfigs$lambda$1(Ref.ObjectRef $error, String string, Throwable e) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if ($error.element == null) {
            $error.element = e;
        } else {
            ExceptionsKt.addSuppressed((Throwable)((Throwable)$error.element), (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit saveToFile$lambda$0(String $filePath, RCInArbitraryFileManager this$0, BufferExposingByteArrayOutputStream $data) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath($filePath);
        if (file == null) {
            String string = PathUtil.getParentPath((String)$filePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            String parentPath = string;
            VirtualFile dir = VfsUtil.createDirectoryIfMissing((String)parentPath);
            if (dir == null) {
                RCInArbitraryFileManagerKt.access$getLOG().error("Failed to create directory " + parentPath);
                return Unit.INSTANCE;
            }
            file = dir.createChildData((Object)this$0, PathUtil.getFileName((String)$filePath));
        }
        Closeable closeable = file.getOutputStream((Object)this$0);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            $data.writeTo(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$saveRunConfig(RCInArbitraryFileManager $this, ReentrantReadWriteLock lock, String filePath, Continuation $completion) {
        return $this.saveRunConfig(lock, filePath, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$saveToFile(RCInArbitraryFileManager $this, String filePath, BufferExposingByteArrayOutputStream data, Continuation $completion) {
        return $this.saveToFile(filePath, data, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/impl/RCInArbitraryFileManager$DeletedAndAddedRunConfigs;", "", "deleted", "", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "added", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;)V", "deletedRunConfigs", "getDeletedRunConfigs", "()Ljava/util/Collection;", "addedRunConfigs", "getAddedRunConfigs", "intellij.platform.execution.impl"})
    public static final class DeletedAndAddedRunConfigs {
        @NotNull
        private final Collection<RunnerAndConfigurationSettingsImpl> deletedRunConfigs;
        @NotNull
        private final Collection<RunnerAndConfigurationSettingsImpl> addedRunConfigs;

        public DeletedAndAddedRunConfigs(@NotNull Collection<RunnerAndConfigurationSettingsImpl> deleted, @NotNull Collection<RunnerAndConfigurationSettingsImpl> added) {
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
            Intrinsics.checkNotNullParameter(added, (String)"added");
            this.deletedRunConfigs = deleted.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)new ArrayList<RunnerAndConfigurationSettingsImpl>(deleted);
            this.addedRunConfigs = added.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)new ArrayList<RunnerAndConfigurationSettingsImpl>(added);
        }

        @NotNull
        public final Collection<RunnerAndConfigurationSettingsImpl> getDeletedRunConfigs() {
            return this.deletedRunConfigs;
        }

        @NotNull
        public final Collection<RunnerAndConfigurationSettingsImpl> getAddedRunConfigs() {
            return this.addedRunConfigs;
        }
    }
}

