/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.CommonBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runToolbar.RWProcessController;
import com.intellij.execution.runToolbar.RunToolbarDataKt;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.execution.runToolbar.RunToolbarProcessData;
import com.intellij.execution.runToolbar.RunToolbarSettings;
import com.intellij.execution.runToolbar.RunToolbarShortcutHelper;
import com.intellij.execution.runToolbar.SlotDate;
import com.intellij.execution.runToolbar.data.RWActiveProcesses;
import com.intellij.execution.runToolbar.data.RWAddedController;
import com.intellij.execution.runToolbar.data.RWSlotController;
import com.intellij.execution.runToolbar.data.RWSlotManagerState;
import com.intellij.execution.runToolbar.data.RWSlotsConfigurationListener;
import com.intellij.execution.runToolbar.data.RWStateController;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.ActivityTracker;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u0007\u0018\u0000 m2\u00020\u0001:\u0001mB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u00103\u001a\u00020*H\u0002J\u0010\u00104\u001a\u00020*2\u0006\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u000208H\u0002J\u0014\u00109\u001a\u0002082\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\"H\u0002J\b\u0010;\u001a\u000208H\u0002J\u000f\u0010<\u001a\u0004\u0018\u00010=H\u0000\u00a2\u0006\u0002\b>J\r\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bAJ\b\u0010F\u001a\u000208H\u0002J\r\u0010G\u001a\u00020BH\u0000\u00a2\u0006\u0002\bHJ\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00170J2\u0006\u0010K\u001a\u000206H\u0002J\u0015\u0010L\u001a\u0002082\u0006\u0010K\u001a\u000206H\u0000\u00a2\u0006\u0002\bMJ\u0015\u0010N\u001a\u0002082\u0006\u0010K\u001a\u000206H\u0000\u00a2\u0006\u0002\bOJ\u0010\u0010P\u001a\u0002082\u0006\u0010K\u001a\u000206H\u0002J\u000e\u0010Q\u001a\u0002082\u0006\u0010K\u001a\u000206J\u000e\u0010R\u001a\u0002082\u0006\u0010S\u001a\u00020TJ\r\u0010U\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\bVJ\u001e\u0010W\u001a\u00020\u00172\n\b\u0002\u0010X\u001a\u0004\u0018\u00010Y2\b\b\u0002\u0010Z\u001a\u00020\"H\u0002J\u0017\u0010[\u001a\u0004\u0018\u00010\u00172\u0006\u0010\\\u001a\u00020@H\u0000\u00a2\u0006\u0002\b]J\u0015\u0010^\u001a\u0002082\u0006\u0010Z\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b_J\u0015\u0010`\u001a\u0002082\u0006\u0010Z\u001a\u00020\"H\u0000\u00a2\u0006\u0002\baJ\u001f\u0010b\u001a\u0002082\u0006\u0010c\u001a\u00020\"2\b\u0010X\u001a\u0004\u0018\u00010YH\u0000\u00a2\u0006\u0002\bdJ\b\u0010e\u001a\u000208H\u0002J\u000e\u0010f\u001a\b\u0012\u0004\u0012\u00020\"0gH\u0002J$\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010Y0i2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\"0gH\u0002J\u0016\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010Y0iH\u0002J\u001e\u0010k\u001a\u0002082\u0014\u0010l\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010Y0iH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00170$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020*@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00100\u001a\u00020*2\u0006\u0010)\u001a\u00020*@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R\u001e\u0010C\u001a\u00020B2\u0006\u0010)\u001a\u00020B@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bD\u0010E\u00a8\u0006n"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarSlotManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "runToolbarSettings", "Lcom/intellij/execution/runToolbar/RunToolbarSettings;", "slotListeners", "Lcom/intellij/execution/runToolbar/data/RWSlotController;", "getSlotListeners$intellij_platform_execution_impl", "()Lcom/intellij/execution/runToolbar/data/RWSlotController;", "activeListener", "Lcom/intellij/execution/runToolbar/data/RWAddedController;", "getActiveListener$intellij_platform_execution_impl", "()Lcom/intellij/execution/runToolbar/data/RWAddedController;", "stateListeners", "Lcom/intellij/execution/runToolbar/data/RWStateController;", "getStateListeners$intellij_platform_execution_impl", "()Lcom/intellij/execution/runToolbar/data/RWStateController;", "mainSlotData", "Lcom/intellij/execution/runToolbar/SlotDate;", "getMainSlotData$intellij_platform_execution_impl", "()Lcom/intellij/execution/runToolbar/SlotDate;", "setMainSlotData$intellij_platform_execution_impl", "(Lcom/intellij/execution/runToolbar/SlotDate;)V", "activeProcesses", "Lcom/intellij/execution/runToolbar/data/RWActiveProcesses;", "getActiveProcesses", "()Lcom/intellij/execution/runToolbar/data/RWActiveProcesses;", "dataIds", "", "", "slotsData", "", "activeDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "processController", "Lcom/intellij/execution/runToolbar/RWProcessController;", "value", "", "initialized", "getInitialized$intellij_platform_execution_impl", "()Z", "setInitialized$intellij_platform_execution_impl", "(Z)V", "active", "getActive$intellij_platform_execution_impl", "setActive$intellij_platform_execution_impl", "getUpdateMainBySelected", "getMoveNewOnTop", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "clear", "", "traceState", "txt", "update", "getMainOrFirstActiveProcess", "Lcom/intellij/execution/runToolbar/RunToolbarProcess;", "getMainOrFirstActiveProcess$intellij_platform_execution_impl", "slotsCount", "", "slotsCount$intellij_platform_execution_impl", "Lcom/intellij/execution/runToolbar/data/RWSlotManagerState;", "state", "setState", "(Lcom/intellij/execution/runToolbar/data/RWSlotManagerState;)V", "updateState", "getState", "getState$intellij_platform_execution_impl", "getAppropriateSettings", "", "env", "processNotStarted", "processNotStarted$intellij_platform_execution_impl", "processStarted", "processStarted$intellij_platform_execution_impl", "addNewProcess", "processTerminating", "processTerminated", "executionId", "", "addAndSaveSlot", "addAndSaveSlot$intellij_platform_execution_impl", "addSlot", "configuration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "id", "getData", "index", "getData$intellij_platform_execution_impl", "moveToTop", "moveToTop$intellij_platform_execution_impl", "removeSlot", "removeSlot$intellij_platform_execution_impl", "configurationChanged", "slotId", "configurationChanged$intellij_platform_execution_impl", "saveSlotsConfiguration", "getSlotOrder", "", "getConfigurationMap", "", "slotOrder", "publishConfigurations", "slotConfigurations", "Companion", "intellij.platform.execution.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRunToolbarSlotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunToolbarSlotManager.kt\ncom/intellij/execution/runToolbar/RunToolbarSlotManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,591:1\n774#2:592\n865#2,2:593\n1878#2,3:595\n774#2:598\n865#2,2:599\n1869#2,2:601\n1617#2,9:604\n1869#2:613\n1870#2:615\n1626#2:616\n774#2:617\n865#2,2:618\n774#2:620\n865#2,2:621\n295#2,2:623\n295#2,2:625\n295#2,2:627\n295#2,2:629\n295#2,2:631\n1285#2,2:634\n1299#2,4:636\n1#3:603\n1#3:614\n58#4:633\n13#5:640\n*S KotlinDebug\n*F\n+ 1 RunToolbarSlotManager.kt\ncom/intellij/execution/runToolbar/RunToolbarSlotManager\n*L\n92#1:592\n92#1:593,2\n92#1:595,3\n141#1:598\n141#1:599,2\n141#1:601,2\n261#1:604,9\n261#1:613\n261#1:615\n261#1:616\n262#1:617\n262#1:618,2\n278#1:620\n278#1:621,2\n281#1:623,2\n282#1:625,2\n339#1:627,2\n358#1:629,2\n369#1:631,2\n536#1:634,2\n536#1:636,4\n261#1:614\n505#1:633\n35#1:640\n*E\n"})
public final class RunToolbarSlotManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final RunToolbarSettings runToolbarSettings;
    @NotNull
    private final RWSlotController slotListeners;
    @NotNull
    private final RWAddedController activeListener;
    @NotNull
    private final RWStateController stateListeners;
    @NotNull
    private SlotDate mainSlotData;
    @NotNull
    private final RWActiveProcesses activeProcesses;
    @NotNull
    private final List<String> dataIds;
    @NotNull
    private final Map<String, SlotDate> slotsData;
    @Nullable
    private CheckedDisposable activeDisposable;
    @NotNull
    private final RWProcessController processController;
    private boolean initialized;
    private boolean active;
    @NotNull
    private RWSlotManagerState state;
    @NotNull
    private static final Logger LOG;
    @JvmField
    @Topic.ProjectLevel
    @NotNull
    public static final Topic<RWSlotsConfigurationListener> RUN_TOOLBAR_SLOT_CONFIGURATION_MAP_TOPIC;

    public RunToolbarSlotManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.runToolbarSettings = RunToolbarSettings.Companion.getInstance(this.project);
        this.slotListeners = new RWSlotController();
        this.activeListener = new RWAddedController();
        this.stateListeners = new RWStateController();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.mainSlotData = new SlotDate(this.project, string);
        this.activeProcesses = new RWActiveProcesses();
        this.dataIds = new ArrayList();
        this.slotsData = new LinkedHashMap();
        this.processController = new RWProcessController(this.project);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RunToolbarSlotManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.slotsData.put(this.this$0.getMainSlotData$intellij_platform_execution_impl().getId(), this.this$0.getMainSlotData$intellij_platform_execution_impl());
                        this.this$0.getActiveListener$intellij_platform_execution_impl().addListener(new RunToolbarShortcutHelper(this.this$0.project));
                        Disposer.register((Disposable)((Disposable)this.this$0.project), () -> 1.invokeSuspend$lambda$0(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(RunToolbarSlotManager this$0) {
                this$0.getActiveListener$intellij_platform_execution_impl().clear();
                this$0.getStateListeners$intellij_platform_execution_impl().clear();
                this$0.getSlotListeners$intellij_platform_execution_impl().clear();
            }
        }), (int)2, null);
        this.state = RWSlotManagerState.INACTIVE;
    }

    @NotNull
    public final RWSlotController getSlotListeners$intellij_platform_execution_impl() {
        return this.slotListeners;
    }

    @NotNull
    public final RWAddedController getActiveListener$intellij_platform_execution_impl() {
        return this.activeListener;
    }

    @NotNull
    public final RWStateController getStateListeners$intellij_platform_execution_impl() {
        return this.stateListeners;
    }

    @NotNull
    public final SlotDate getMainSlotData$intellij_platform_execution_impl() {
        return this.mainSlotData;
    }

    public final void setMainSlotData$intellij_platform_execution_impl(@NotNull SlotDate slotDate) {
        Intrinsics.checkNotNullParameter((Object)slotDate, (String)"<set-?>");
        this.mainSlotData = slotDate;
    }

    @NotNull
    public final RWActiveProcesses getActiveProcesses() {
        return this.activeProcesses;
    }

    public final boolean getInitialized$intellij_platform_execution_impl() {
        return this.initialized;
    }

    public final void setInitialized$intellij_platform_execution_impl(boolean value) {
        if (this.initialized == value) {
            return;
        }
        this.initialized = value;
        if (value) {
            this.activeListener.initialize();
        }
    }

    public final boolean getActive$intellij_platform_execution_impl() {
        return this.active;
    }

    /*
     * WARNING - void declaration
     */
    public final void setActive$intellij_platform_execution_impl(boolean value) {
        if (this.active == value) {
            return;
        }
        this.active = value;
        if (value) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            void $this$forEachIndexed$iv;
            void $this$filterTo$iv$iv2;
            if (RunToolbarProcess.Companion.getLogNeeded()) {
                LOG.info("ACTIVE SM settings: new on top " + this.runToolbarSettings.getMoveNewOnTop() + "; update by selected " + this.getUpdateMainBySelected() + " RunToolbar");
            }
            this.clear();
            CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
            CheckedDisposable disp = checkedDisposable;
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)((Disposable)disp));
            this.activeDisposable = disp;
            Pair<List<String>, Map<String, RunnerAndConfigurationSettings>> settingsData = this.runToolbarSettings.getConfigurations();
            List slotOrder = (List)settingsData.getFirst();
            Map configurations = (Map)settingsData.getSecond();
            Iterable $this$filter$iv = slotOrder;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(configurations.get(it) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void s;
                int n;
                Object element$iv$iv;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv = (String)item$iv;
                int index = n;
                boolean bl = false;
                if (index == 0) {
                    this.traceState("SM reset main");
                    this.slotsData.remove(this.mainSlotData.getId());
                    this.mainSlotData.updateId((String)s);
                    this.mainSlotData.setConfiguration((RunnerAndConfigurationSettings)configurations.get(s));
                    this.slotsData.put(this.mainSlotData.getId(), this.mainSlotData);
                    this.traceState("SM after reset ");
                    continue;
                }
                this.addSlot((RunnerAndConfigurationSettings)configurations.get(s), (String)s);
            }
            if (RunToolbarProcess.Companion.getLogNeeded()) {
                LOG.info("SM restoreRunConfigurations: " + configurations.values() + " RunToolbar");
            }
            MessageBusConnection con = this.project.getMessageBus().connect((Disposable)disp);
            Topic topic = RunManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            con.subscribe(topic, (Object)new RunManagerListener(this){
                final /* synthetic */ RunToolbarSlotManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void runConfigurationSelected(RunnerAndConfigurationSettings settings) {
                    if (!RunToolbarSlotManager.access$getUpdateMainBySelected(this.this$0) || Intrinsics.areEqual((Object)this.this$0.getMainSlotData$intellij_platform_execution_impl().getConfiguration(), (Object)settings)) {
                        return;
                    }
                    ExecutionEnvironment executionEnvironment = this.this$0.getMainSlotData$intellij_platform_execution_impl().getEnvironment();
                    if (executionEnvironment != null) {
                        ExecutionEnvironment executionEnvironment2 = executionEnvironment;
                        RunToolbarSlotManager runToolbarSlotManager = this.this$0;
                        ExecutionEnvironment it = executionEnvironment2;
                        boolean bl = false;
                        SlotDate slot = RunToolbarSlotManager.addSlot$default(runToolbarSlotManager, settings, null, 2, null);
                        if (RunToolbarProcess.Companion.getLogNeeded()) {
                            RunToolbarSlotManager.access$getLOG$cp().info("SM runConfigurationSelected: " + settings + " first slot added RunToolbar");
                        }
                        runToolbarSlotManager.moveToTop$intellij_platform_execution_impl(slot.getId());
                    } else {
                        RunToolbarSlotManager runToolbarSlotManager = this.this$0;
                        boolean bl = false;
                        runToolbarSlotManager.getMainSlotData$intellij_platform_execution_impl().setConfiguration(settings);
                        if (RunToolbarProcess.Companion.getLogNeeded()) {
                            RunToolbarSlotManager.access$getLOG$cp().info("SM runConfigurationSelected: " + settings + " change main configuration RunToolbar");
                        }
                        RunToolbarSlotManager.access$update(runToolbarSlotManager);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void runConfigurationRemoved(RunnerAndConfigurationSettings settings) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                    boolean changed = false;
                    Map $this$filter$iv = RunToolbarSlotManager.access$getSlotsData$p(this.this$0);
                    boolean $i$f$filter = false;
                    Map map = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        Map.Entry<K, V> it = element$iv$iv = iterator.next();
                        boolean bl = false;
                        if (!(Intrinsics.areEqual(it.getValue(), (Object)settings) && ((SlotDate)it.getValue()).getEnvironment() == null)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    $this$filter$iv = destination$iv$iv;
                    RunToolbarSlotManager runToolbarSlotManager = this.this$0;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> it = element$iv = iterator2.next();
                        boolean bl = false;
                        changed = true;
                        ((SlotDate)it.getValue()).setConfiguration(RunManager.Companion.getInstance(RunToolbarSlotManager.access$getProject$p(runToolbarSlotManager)).getSelectedConfiguration());
                    }
                    if (changed) {
                        RunToolbarSlotManager.access$update(this.this$0);
                    }
                }
            });
            List<ExecutionEnvironment> executions = this.processController.getActiveExecutions$intellij_platform_execution_impl();
            Iterable $this$filter$iv2 = executions;
            boolean $i$f$filter2 = false;
            Iterable item$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ExecutionEnvironment it = (ExecutionEnvironment)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)RunToolbarDataKt.isRunning(it), (Object)true)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExecutionEnvironment it = (ExecutionEnvironment)element$iv;
                boolean bl = false;
                this.addNewProcess(it);
            }
            this.activeListener.enabled();
            this.update();
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ActivityTracker.getInstance().inc();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else {
            CheckedDisposable checkedDisposable = this.activeDisposable;
            if (checkedDisposable != null) {
                CheckedDisposable it = checkedDisposable;
                boolean bl = false;
                if (!it.isDisposed()) {
                    Disposer.dispose((Disposable)((Disposable)it));
                }
                this.activeDisposable = null;
            }
            this.activeListener.disabled();
            this.clear();
            if (RunToolbarProcess.Companion.getLogNeeded()) {
                LOG.info("INACTIVE SM RunToolbar");
            }
        }
        this.slotListeners.rebuildPopup();
        this.publishConfigurations(this.getConfigurationMap());
    }

    private final boolean getUpdateMainBySelected() {
        return this.runToolbarSettings.getUpdateMainBySelected();
    }

    private final boolean getMoveNewOnTop(ExecutionEnvironment executionEnvironment) {
        if (!this.runToolbarSettings.getMoveNewOnTop()) {
            return false;
        }
        Boolean bl = (Boolean)executionEnvironment.getUserData(RunToolbarProcessData.RUN_TOOLBAR_SUPPRESS_MAIN_SLOT_USER_DATA_KEY);
        boolean suppressValue = bl != null ? bl : false;
        return !suppressValue;
    }

    private final void clear() {
        this.dataIds.clear();
        this.mainSlotData.clear();
        this.slotsData.clear();
        this.slotsData.put(this.mainSlotData.getId(), this.mainSlotData);
        this.activeProcesses.clear$intellij_platform_execution_impl();
        this.setState(RWSlotManagerState.INACTIVE);
    }

    private final void traceState(String txt) {
        if (!RunToolbarProcess.Companion.getLogNeeded()) {
            return;
        }
        String string = txt;
        if (string != null) {
            String it = string;
            boolean bl = false;
            LOG.info(it);
        }
        LOG.info("SM state: " + this.state + " mainSlot: " + this.mainSlotData + " RunToolbar");
        LOG.info("SM slotsData: " + this.slotsData.values() + " RunToolbar");
    }

    static /* synthetic */ void traceState$default(RunToolbarSlotManager runToolbarSlotManager, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        runToolbarSlotManager.traceState(string);
    }

    private final void update() {
        this.saveSlotsConfiguration();
        this.updateState();
        if (!RunToolbarProcess.Companion.getLogNeeded()) {
            return;
        }
        LOG.trace("!!!!!UPDATE RunToolbar");
    }

    @Nullable
    public final RunToolbarProcess getMainOrFirstActiveProcess$intellij_platform_execution_impl() {
        ExecutionEnvironment executionEnvironment = this.mainSlotData.getEnvironment();
        if (executionEnvironment == null || (executionEnvironment = RunToolbarDataKt.getRunToolbarProcess(executionEnvironment)) == null) {
            executionEnvironment = (RunToolbarProcess)CollectionsKt.firstOrNull((Iterable)this.activeProcesses.getProcesses().keySet());
        }
        return executionEnvironment;
    }

    public final int slotsCount$intellij_platform_execution_impl() {
        return this.dataIds.size();
    }

    private final void setState(RWSlotManagerState value) {
        if (value == this.state) {
            return;
        }
        this.state = value;
        RunToolbarSlotManager.traceState$default(this, null, 1, null);
        this.stateListeners.stateChanged(value);
    }

    private final void updateState() {
        RWSlotManagerState rWSlotManagerState;
        RunToolbarSlotManager runToolbarSlotManager = this;
        switch (this.activeProcesses.getActiveCount()) {
            case 0: {
                rWSlotManagerState = RWSlotManagerState.INACTIVE;
                break;
            }
            case 1: {
                rWSlotManagerState = this.mainSlotData.getEnvironment();
                if (rWSlotManagerState != null) {
                    RWSlotManagerState it = rWSlotManagerState;
                    RunToolbarSlotManager runToolbarSlotManager2 = runToolbarSlotManager;
                    boolean bl = false;
                    RWSlotManagerState rWSlotManagerState2 = RWSlotManagerState.SINGLE_MAIN;
                    runToolbarSlotManager = runToolbarSlotManager2;
                    rWSlotManagerState = rWSlotManagerState2;
                    if (rWSlotManagerState2 != null) break;
                }
                rWSlotManagerState = RWSlotManagerState.SINGLE_PLAIN;
                break;
            }
            default: {
                rWSlotManagerState = this.mainSlotData.getEnvironment();
                if (rWSlotManagerState != null) {
                    RWSlotManagerState it = rWSlotManagerState;
                    RunToolbarSlotManager runToolbarSlotManager3 = runToolbarSlotManager;
                    boolean bl = false;
                    RWSlotManagerState rWSlotManagerState3 = RWSlotManagerState.MULTIPLE_WITH_MAIN;
                    runToolbarSlotManager = runToolbarSlotManager3;
                    rWSlotManagerState = rWSlotManagerState3;
                    if (rWSlotManagerState3 != null) break;
                }
                rWSlotManagerState = RWSlotManagerState.MULTIPLE;
            }
        }
        runToolbarSlotManager.setState(rWSlotManagerState);
    }

    @NotNull
    public final RWSlotManagerState getState$intellij_platform_execution_impl() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<SlotDate> getAppropriateSettings(ExecutionEnvironment env) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List sortedSlots = new ArrayList();
        sortedSlots.add(this.mainSlotData);
        Iterable iterable = this.dataIds;
        List list = sortedSlots;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SlotDate it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.slotsData.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list.addAll(CollectionsKt.toList((Iterable)((List)destination$iv$iv)));
        Iterable $this$filter$iv = sortedSlots;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SlotDate it = (SlotDate)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getConfiguration(), (Object)env.getRunnerAndConfigurationSettings())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void processNotStarted$intellij_platform_execution_impl(@NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
    }

    public final void processStarted$intellij_platform_execution_impl(@NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.addNewProcess(env);
        this.update();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ActivityTracker.getInstance().inc();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void addNewProcess(ExecutionEnvironment env) {
        boolean isCompoundProcess;
        SlotDate slotDate;
        Object object;
        boolean newSlot;
        List emptySlotsWithConfiguration;
        Object it;
        block18: {
            boolean bl;
            void $this$filterTo$iv$iv;
            Iterable<SlotDate> appropriateSettings;
            Iterable<SlotDate> $this$filter$iv = appropriateSettings = this.getAppropriateSettings(env);
            boolean $i$f$filter = false;
            Iterable<SlotDate> iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                it = (SlotDate)t;
                bl = false;
                if (!(((SlotDate)it).getEnvironment() == null)) continue;
                destination$iv$iv.add(t);
            }
            emptySlotsWithConfiguration = (List)destination$iv$iv;
            newSlot = false;
            Iterable<SlotDate> $this$firstOrNull$iv = appropriateSettings;
            boolean $i$f$firstOrNull = false;
            for (Object object2 : $this$firstOrNull$iv) {
                it = (SlotDate)object2;
                bl = false;
                ExecutionEnvironment executionEnvironment = ((SlotDate)it).getEnvironment();
                boolean bl2 = executionEnvironment != null ? executionEnvironment.getExecutionId() == env.getExecutionId() : false;
                if (!bl2) continue;
                object = object2;
                break block18;
            }
            object = null;
        }
        if ((slotDate = (SlotDate)object) == null) {
            Object v6;
            block19: {
                Iterable $this$firstOrNull$iv = emptySlotsWithConfiguration;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    SlotDate slotData = (SlotDate)element$iv;
                    boolean bl3 = false;
                    if (env.getRunnerAndConfigurationSettings() != null) {
                        boolean bl4 = false;
                        DataContext dataContext = env.getDataContext();
                        bl = Intrinsics.areEqual((Object)slotData.getId(), (Object)(dataContext != null ? (String)dataContext.getData(RunToolbarProcessData.RW_SLOT) : null));
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    v6 = element$iv;
                    break block19;
                }
                v6 = null;
            }
            if ((slotDate = (SlotDate)v6) == null && (slotDate = (SlotDate)CollectionsKt.firstOrNull((List)emptySlotsWithConfiguration)) == null) {
                boolean bl = false;
                newSlot = true;
                slotDate = RunToolbarSlotManager.addSlot$default(this, env.getRunnerAndConfigurationSettings(), null, 2, null);
            }
        }
        SlotDate slot = slotDate;
        slot.setEnvironment(env);
        this.activeProcesses.updateActiveProcesses$intellij_platform_execution_impl(this.slotsData);
        if (!newSlot) {
            return;
        }
        RunManagerImpl runManager = RunManagerImpl.Companion.getInstanceImpl(this.project);
        String string = (String)env.getUserData(RunToolbarProcessData.RW_MAIN_CONFIGURATION_ID);
        if (string != null) {
            it = string;
            boolean bl = false;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager.getConfigurationById((String)it);
            v9 = (runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null) instanceof CompoundRunConfiguration;
        } else {
            v9 = isCompoundProcess = false;
        }
        if (isCompoundProcess || !this.getMoveNewOnTop(env)) {
            return;
        }
        List secondarySlotsContainingMainSlotConfig = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.dataIds), arg_0 -> RunToolbarSlotManager.addNewProcess$lambda$5(this, arg_0)), arg_0 -> RunToolbarSlotManager.addNewProcess$lambda$6(this, arg_0)));
        if (secondarySlotsContainingMainSlotConfig.isEmpty()) {
            this.moveToTop$intellij_platform_execution_impl(slot.getId());
        } else if (this.mainSlotData.getEnvironment() != null) {
            Object v10;
            block20: {
                Iterable iterable = secondarySlotsContainingMainSlotConfig;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : iterable) {
                    SlotDate it2 = (SlotDate)element$iv;
                    boolean bl = false;
                    if (!(it2.getEnvironment() == null)) continue;
                    v10 = element$iv;
                    break block20;
                }
                v10 = null;
            }
            SlotDate freeSlotCorrespondingToMain = v10;
            if (freeSlotCorrespondingToMain != null) {
                freeSlotCorrespondingToMain.setEnvironment(this.mainSlotData.getEnvironment());
                RunToolbarSlotManager.addNewProcess$removeFormerMainSlotAndMoveCurrentToTop(this, slot);
            } else {
                this.moveToTop$intellij_platform_execution_impl(slot.getId());
            }
        } else {
            RunToolbarSlotManager.addNewProcess$removeFormerMainSlotAndMoveCurrentToTop(this, slot);
        }
    }

    public final void processTerminating(@NotNull ExecutionEnvironment env) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Iterable $this$firstOrNull$iv = this.slotsData.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SlotDate it = (SlotDate)element$iv;
                boolean bl = false;
                ExecutionEnvironment executionEnvironment = it.getEnvironment();
                boolean bl2 = executionEnvironment != null ? executionEnvironment.getExecutionId() == env.getExecutionId() : false;
                if (!bl2) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        SlotDate slotDate = v2;
        if (slotDate != null) {
            SlotDate it = slotDate;
            boolean bl = false;
            it.setEnvironment(env);
        }
        this.activeProcesses.updateActiveProcesses$intellij_platform_execution_impl(this.slotsData);
        this.updateState();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ActivityTracker.getInstance().inc();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void processTerminated(long executionId) {
        Object v2;
        block9: {
            Iterable $this$firstOrNull$iv = this.slotsData.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SlotDate it = (SlotDate)element$iv;
                boolean bl = false;
                ExecutionEnvironment executionEnvironment = it.getEnvironment();
                boolean bl2 = executionEnvironment != null ? executionEnvironment.getExecutionId() == executionId : false;
                if (!bl2) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        SlotDate slotDate = v2;
        if (slotDate != null) {
            boolean removable;
            SlotDate slotDate2 = slotDate;
            boolean bl = false;
            ExecutionEnvironment executionEnvironment = slotDate2.getEnvironment();
            if (executionEnvironment != null && (executionEnvironment = executionEnvironment.getRunnerAndConfigurationSettings()) != null) {
                ExecutionEnvironment it = executionEnvironment;
                boolean bl3 = false;
                v5 = !RunManager.Companion.getInstance(this.project).hasSettings((RunnerAndConfigurationSettings)it);
            } else {
                v5 = removable = true;
            }
            if (removable) {
                if (Intrinsics.areEqual((Object)slotDate2, (Object)this.mainSlotData) && this.slotsData.size() == 1) {
                    slotDate2.clear();
                    slotDate2.setConfiguration(RunManager.Companion.getInstance(this.project).getSelectedConfiguration());
                } else {
                    this.removeSlot$intellij_platform_execution_impl(slotDate2.getId());
                }
            } else {
                slotDate2.setEnvironment(null);
            }
        }
        if (RunToolbarProcess.Companion.getLogNeeded()) {
            LOG.info("SM process stopped: " + executionId + " RunToolbar");
        }
        this.activeProcesses.updateActiveProcesses$intellij_platform_execution_impl(this.slotsData);
        this.updateState();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ActivityTracker.getInstance().inc();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final SlotDate addAndSaveSlot$intellij_platform_execution_impl() {
        SlotDate slot = RunToolbarSlotManager.addSlot$default(this, null, null, 3, null);
        this.saveSlotsConfiguration();
        return slot;
    }

    private final SlotDate addSlot(RunnerAndConfigurationSettings configuration, String id) {
        SlotDate slot = new SlotDate(this.project, id);
        slot.setConfiguration(configuration);
        this.dataIds.add(slot.getId());
        this.slotsData.put(slot.getId(), slot);
        this.slotListeners.slotAdded();
        return slot;
    }

    static /* synthetic */ SlotDate addSlot$default(RunToolbarSlotManager runToolbarSlotManager, RunnerAndConfigurationSettings runnerAndConfigurationSettings, String string, int n, Object object) {
        if ((n & 1) != 0) {
            runnerAndConfigurationSettings = null;
        }
        if ((n & 2) != 0) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = string2;
        }
        return runToolbarSlotManager.addSlot(runnerAndConfigurationSettings, string);
    }

    @Nullable
    public final SlotDate getData$intellij_platform_execution_impl(int index) {
        SlotDate slotDate;
        if (index >= 0 && index < this.dataIds.size()) {
            String it = this.dataIds.get(index);
            boolean bl = false;
            slotDate = this.slotsData.get(it);
        } else {
            slotDate = null;
        }
        return slotDate;
    }

    public final void moveToTop$intellij_platform_execution_impl(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (Intrinsics.areEqual((Object)this.mainSlotData.getId(), (Object)id)) {
            return;
        }
        SlotDate slotDate = this.slotsData.get(id);
        if (slotDate != null) {
            SlotDate newMain = slotDate;
            boolean bl = false;
            SlotDate oldMain = this.mainSlotData;
            this.mainSlotData = newMain;
            this.dataIds.remove(id);
            this.dataIds.add(0, oldMain.getId());
        }
        this.update();
    }

    public final void removeSlot$intellij_platform_execution_impl(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        int index = this.dataIds.indexOf(id);
        SlotDate slotDate = index >= 0 ? this.getData$intellij_platform_execution_impl(index) : (Intrinsics.areEqual((Object)this.mainSlotData.getId(), (Object)id) ? this.mainSlotData : null);
        if (slotDate != null) {
            SlotDate slotDate2 = slotDate;
            boolean bl = false;
            ExecutionEnvironment executionEnvironment = slotDate2.getEnvironment();
            if (executionEnvironment != null) {
                ExecutionEnvironment it = executionEnvironment;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)RunToolbarDataKt.isRunning(it), (Object)true)) {
                    RunToolbarSlotManager.removeSlot$remove(id, this, index);
                } else {
                    String string = LangBundle.message((String)"run.toolbar.remove.active.process.slot.message", (Object[])new Object[0]);
                    Object[] objectArray = new Object[1];
                    Object object = it.getRunnerAndConfigurationSettings();
                    if (object == null || (object = object.getName()) == null) {
                        object = objectArray[0] = "";
                    }
                    if (Messages.showOkCancelDialog((Project)this.project, (String)string, (String)LangBundle.message((String)"run.toolbar.remove.active.process.slot.title", (Object[])objectArray), (String)LangBundle.message((String)"run.toolbar.remove.active.process.slot.ok", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) == 0) {
                        RunContentDescriptor runContentDescriptor2 = it.getContentToReuse();
                        if (runContentDescriptor2 != null) {
                            RunContentDescriptor it2 = runContentDescriptor2;
                            boolean bl3 = false;
                            ExecutionManagerImpl.Companion.stopProcess(it2);
                        }
                        RunToolbarSlotManager.removeSlot$remove(id, this, index);
                    }
                }
            } else {
                RunToolbarSlotManager $this$removeSlot_u24lambda_u241_u241 = this;
                boolean bl4 = false;
                RunToolbarSlotManager.removeSlot$remove(id, this, index);
            }
        } else {
            this.slotListeners.rebuildPopup();
        }
        this.update();
    }

    public final void configurationChanged$intellij_platform_execution_impl(@NotNull String slotId, @Nullable RunnerAndConfigurationSettings configuration) {
        Intrinsics.checkNotNullParameter((Object)slotId, (String)"slotId");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, slotId, configuration, null){
            int label;
            final /* synthetic */ RunToolbarSlotManager this$0;
            final /* synthetic */ String $slotId;
            final /* synthetic */ RunnerAndConfigurationSettings $configuration;
            {
                this.this$0 = $receiver;
                this.$slotId = $slotId;
                this.$configuration = $configuration;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ((RWSlotsConfigurationListener)RunToolbarSlotManager.access$getProject$p(this.this$0).getMessageBus().syncPublisher(RunToolbarSlotManager.RUN_TOOLBAR_SLOT_CONFIGURATION_MAP_TOPIC)).configurationChanged(this.$slotId, this.$configuration);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.saveSlotsConfiguration();
    }

    private final void saveSlotsConfiguration() {
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this.project;
        boolean $i$f$serviceIfCreated = false;
        RunManager runManager = (RunManager)$this$serviceIfCreated$iv.getServiceIfCreated(RunManager.class);
        if (runManager != null) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mainSlotData.getConfiguration();
            if (runnerAndConfigurationSettings != null) {
                RunnerAndConfigurationSettings it = runnerAndConfigurationSettings;
                boolean bl = false;
                if (runManager.hasSettings(it) && !Intrinsics.areEqual((Object)it, (Object)runManager.getSelectedConfiguration())) {
                    ExecutionEnvironment executionEnvironment = this.mainSlotData.getEnvironment();
                    if (!(executionEnvironment != null && (executionEnvironment = RunToolbarDataKt.getRunToolbarProcess(executionEnvironment)) != null ? executionEnvironment.isTemporaryProcess() : false)) {
                        runManager.setSelectedConfiguration(this.mainSlotData.getConfiguration());
                        if (RunToolbarProcess.Companion.getLogNeeded()) {
                            LOG.info("MANAGER saveSlotsConfiguration. change selected configuration by main: " + this.mainSlotData.getConfiguration() + " RunToolbar");
                        }
                    }
                }
            }
        }
        List<String> slotOrder = this.getSlotOrder();
        Map<String, RunnerAndConfigurationSettings> configurations = this.getConfigurationMap(slotOrder);
        if (RunToolbarProcess.Companion.getLogNeeded()) {
            LOG.info("MANAGER saveSlotsConfiguration: " + configurations + " RunToolbar");
        }
        this.runToolbarSettings.setConfigurations(configurations, slotOrder);
        this.publishConfigurations(configurations);
    }

    private final List<String> getSlotOrder() {
        List list = new ArrayList();
        list.add(this.mainSlotData.getId());
        list.addAll((Collection)this.dataIds);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, RunnerAndConfigurationSettings> getConfigurationMap(List<String> slotOrder) {
        void $this$associateWithTo$iv$iv;
        Iterable $this$associateWith$iv = slotOrder;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            SlotDate slotDate = this.slotsData.get(it);
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = slotDate != null ? slotDate.getConfiguration() : null;
            map.put(t, runnerAndConfigurationSettings);
        }
        return destination$iv$iv;
    }

    private final Map<String, RunnerAndConfigurationSettings> getConfigurationMap() {
        return this.getConfigurationMap(this.getSlotOrder());
    }

    private final void publishConfigurations(Map<String, ? extends RunnerAndConfigurationSettings> slotConfigurations) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, slotConfigurations, null){
            int label;
            final /* synthetic */ RunToolbarSlotManager this$0;
            final /* synthetic */ Map<String, RunnerAndConfigurationSettings> $slotConfigurations;
            {
                this.this$0 = $receiver;
                this.$slotConfigurations = $slotConfigurations;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ((RWSlotsConfigurationListener)RunToolbarSlotManager.access$getProject$p(this.this$0).getMessageBus().syncPublisher(RunToolbarSlotManager.RUN_TOOLBAR_SLOT_CONFIGURATION_MAP_TOPIC)).slotsConfigurationChanged(this.$slotConfigurations);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final SlotDate addNewProcess$lambda$5(RunToolbarSlotManager this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.slotsData.get(it);
    }

    private static final boolean addNewProcess$lambda$6(RunToolbarSlotManager this$0, SlotDate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getConfiguration(), (Object)this$0.mainSlotData.getConfiguration());
    }

    private static final void addNewProcess$removeFormerMainSlotAndMoveCurrentToTop(RunToolbarSlotManager this$0, SlotDate slot) {
        SlotDate formerMain = this$0.mainSlotData;
        formerMain.setEnvironment(null);
        this$0.moveToTop$intellij_platform_execution_impl(slot.getId());
        this$0.removeSlot$intellij_platform_execution_impl(formerMain.getId());
    }

    private static final void removeSlot$remove(String $id, RunToolbarSlotManager this$0, int index) {
        if (Intrinsics.areEqual((Object)$id, (Object)this$0.mainSlotData.getId())) {
            if (!((Collection)this$0.dataIds).isEmpty()) {
                String firstSlotId = this$0.dataIds.get(0);
                SlotDate slotDate = this$0.slotsData.get(firstSlotId);
                if (slotDate != null) {
                    SlotDate it = slotDate;
                    boolean bl = false;
                    this$0.mainSlotData = it;
                    this$0.slotsData.remove($id);
                    this$0.dataIds.remove(it.getId());
                }
            }
        } else {
            this$0.slotsData.remove($id);
            this$0.dataIds.remove($id);
        }
        BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, index, null){
            int label;
            final /* synthetic */ RunToolbarSlotManager this$0;
            final /* synthetic */ int $index;
            {
                this.this$0 = $receiver;
                this.$index = $index;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.getSlotListeners$intellij_platform_execution_impl().slotRemoved(this.$index);
                        ActivityTracker.getInstance().inc();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static final /* synthetic */ boolean access$getUpdateMainBySelected(RunToolbarSlotManager $this) {
        return $this.getUpdateMainBySelected();
    }

    public static final /* synthetic */ void access$update(RunToolbarSlotManager $this) {
        $this.update();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RunToolbarSlotManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        RUN_TOOLBAR_SLOT_CONFIGURATION_MAP_TOPIC = new Topic("RunToolbarWidgetSlotConfigurationMapChanged", RWSlotsConfigurationListener.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarSlotManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/execution/runToolbar/RunToolbarSlotManager;", "project", "Lcom/intellij/openapi/project/Project;", "RUN_TOOLBAR_SLOT_CONFIGURATION_MAP_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/execution/runToolbar/data/RWSlotsConfigurationListener;", "kotlin.jvm.PlatformType", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nRunToolbarSlotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunToolbarSlotManager.kt\ncom/intellij/execution/runToolbar/RunToolbarSlotManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,591:1\n30#2,2:592\n*S KotlinDebug\n*F\n+ 1 RunToolbarSlotManager.kt\ncom/intellij/execution/runToolbar/RunToolbarSlotManager$Companion\n*L\n37#1:592,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RunToolbarSlotManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RunToolbarSlotManager> serviceClass$iv = RunToolbarSlotManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RunToolbarSlotManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

