/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.TagButton;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationEditorFragment<Settings, C extends JComponent>
extends SettingsEditorFragment<Settings, C> {
    private RunnerAndConfigurationSettingsImpl mySettings;
    private final Predicate<? super RunnerAndConfigurationSettingsImpl> myInitialVisibility;

    public RunConfigurationEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group2, C component, int commandLinePosition, Predicate<? super RunnerAndConfigurationSettingsImpl> initialVisibility) {
        super(id, name, group2, component, commandLinePosition, (settings, c) -> {}, (settings, c) -> {}, settings -> false);
        this.myInitialVisibility = initialVisibility;
    }

    public void resetEditorFrom(@NotNull RunnerAndConfigurationSettingsImpl s) {
        if (s == null) {
            RunConfigurationEditorFragment.$$$reportNull$$$0(0);
        }
        this.mySettings = s;
        this.doReset(s);
    }

    protected abstract void doReset(@NotNull RunnerAndConfigurationSettingsImpl var1);

    public abstract void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl var1);

    public boolean isInitiallyVisible(Settings settings) {
        return this.myInitialVisibility.test(this.mySettings);
    }

    public static <Settings> SettingsEditorFragment<Settings, ?> createSettingsTag(String id, @Nls String name, @Nls String group2, @NotNull Predicate<? super RunnerAndConfigurationSettingsImpl> getter, @NotNull BiConsumer<? super RunnerAndConfigurationSettingsImpl, ? super Boolean> setter, int menuPosition) {
        if (getter == null) {
            RunConfigurationEditorFragment.$$$reportNull$$$0(1);
        }
        if (setter == null) {
            RunConfigurationEditorFragment.$$$reportNull$$$0(2);
        }
        Ref ref = new Ref();
        TagButton button = new TagButton(name, e -> {
            ((TagButtonRunConfigurationEditorFragment)((Object)((Object)ref.get()))).setSelected(false);
            ((TagButtonRunConfigurationEditorFragment)((Object)((Object)ref.get()))).logFragmentChange(false, (AnActionEvent)e);
        });
        TagButtonRunConfigurationEditorFragment fragment = new TagButtonRunConfigurationEditorFragment(id, name, group2, button, getter, setter, menuPosition);
        ref.set(fragment);
        return fragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ui/RunConfigurationEditorFragment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createSettingsTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TagButtonRunConfigurationEditorFragment<Settings>
    extends RunConfigurationEditorFragment<Settings, TagButton> {
        @NotNull
        private final Predicate<? super RunnerAndConfigurationSettingsImpl> myGetter;
        @NotNull
        private final BiConsumer<? super RunnerAndConfigurationSettingsImpl, ? super Boolean> mySetter;
        private final int myMenuPosition;

        private TagButtonRunConfigurationEditorFragment(String id, @Nls String name, @Nls String group2, TagButton button, @NotNull Predicate<? super RunnerAndConfigurationSettingsImpl> getter, @NotNull BiConsumer<? super RunnerAndConfigurationSettingsImpl, ? super Boolean> setter, int menuPosition) {
            if (getter == null) {
                TagButtonRunConfigurationEditorFragment.$$$reportNull$$$0(0);
            }
            if (setter == null) {
                TagButtonRunConfigurationEditorFragment.$$$reportNull$$$0(1);
            }
            super(id, name, group2, button, 0, getter);
            this.myGetter = getter;
            this.mySetter = setter;
            this.myMenuPosition = menuPosition;
        }

        void logFragmentChange(boolean selected, @Nullable AnActionEvent e) {
            this.logChange(selected, e);
        }

        protected void disposeEditor() {
            Disposer.dispose((Disposable)((Disposable)this.myComponent));
        }

        @Override
        public void doReset(@NotNull RunnerAndConfigurationSettingsImpl s) {
            if (s == null) {
                TagButtonRunConfigurationEditorFragment.$$$reportNull$$$0(2);
            }
            ((TagButton)this.component()).setVisible(this.myGetter.test(s));
        }

        @Override
        public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
            if (s == null) {
                TagButtonRunConfigurationEditorFragment.$$$reportNull$$$0(3);
            }
            this.mySetter.accept(s, (Boolean)((TagButton)this.component()).isVisible());
        }

        public boolean isTag() {
            return true;
        }

        public int getMenuPosition() {
            return this.myMenuPosition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ui/RunConfigurationEditorFragment$TagButtonRunConfigurationEditorFragment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doReset";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyEditorTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

