/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.GridCell;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.actions.CloseViewAction;
import com.intellij.execution.ui.layout.actions.MinimizeViewAction;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.MutualMap;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.DefaultTabPainterAdapter;
import com.intellij.ui.tabs.impl.DragHelper;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.SingleHeightTabs;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GridCellImpl
implements GridCell {
    private final GridImpl myContainer;
    private final Set<Content> myMinimizedContents;
    private final GridCellTabs myTabs;
    private final GridImpl.Placeholder myPlaceholder;
    private final PlaceInGrid myPlaceInGrid;
    private final ViewContextEx myContext;
    private JBPopup myPopup;

    GridCellImpl(ViewContextEx context, @NotNull GridImpl container, GridImpl.Placeholder placeholder, PlaceInGrid placeInGrid) {
        if (container == null) {
            GridCellImpl.$$$reportNull$$$0(0);
        }
        this.myMinimizedContents = new HashSet<Content>();
        this.myContext = context;
        this.myContainer = container;
        this.myPlaceInGrid = placeInGrid;
        this.myPlaceholder = placeholder;
        this.myPlaceholder.setContentProvider(() -> this.getContents());
        this.myTabs = new GridCellTabs(context, container);
        this.myTabs.getPresentation().setSideComponentVertical(true).setFocusCycle(false).setPaintFocus(true).setTabDraggingEnabled(context.isMoveToGridActionEnabled()).setSideComponentOnTabs(false);
        this.myTabs.addTabMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UIUtil.isCloseClick((MouseEvent)e)) {
                    GridCellImpl.this.closeOrMinimize(e);
                }
            }
        });
        this.rebuildPopupGroup();
        this.myTabs.addListener(new TabsListener(){

            public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (oldSelection != null && GridCellImpl.this.myContext.isStateBeingRestored()) {
                    GridCellImpl.this.saveUiState();
                }
            }

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                GridCellImpl.this.updateSelection(GridCellImpl.this.myTabs.getComponent().isShowing());
                if (!GridCellImpl.this.myTabs.getComponent().isShowing()) {
                    return;
                }
                if (newSelection != null) {
                    newSelection.stopAlerting();
                }
            }
        });
    }

    public void rebuildPopupGroup() {
        this.myTabs.setPopupGroup(this.myContext.getCellPopupGroup("debuggerCellPopup"), "debuggerCellPopup", true);
    }

    public PlaceInGrid getPlaceInGrid() {
        return this.myPlaceInGrid;
    }

    void add(Content content) {
        if (this.myTabs.myContents.containsKey((Object)content)) {
            return;
        }
        this.myTabs.myContents.put((Object)content, null);
        this.revalidateCell(() -> this.myTabs.addTab(this.createTabInfoFor(content)));
        this.updateSelection(this.myTabs.getComponent().getRootPane() != null);
    }

    void remove(Content content) {
        if (!this.myTabs.myContents.containsKey((Object)content)) {
            return;
        }
        TabInfo info = this.getTabFor(content);
        this.myTabs.myContents.remove((Object)content);
        this.revalidateCell(() -> this.myTabs.removeTab(info));
        this.updateSelection(this.myTabs.getComponent().getRootPane() != null);
    }

    private void revalidateCell(Runnable contentAction) {
        if (this.myTabs.myContents.size() == 0) {
            this.myPlaceholder.removeAll();
            this.myTabs.removeAllTabs();
            if (this.myPopup != null) {
                this.myPopup.cancel();
                this.myPopup = null;
            }
        } else {
            if (this.myPlaceholder.isNull()) {
                this.myPlaceholder.setContent(this.myTabs.getComponent());
            }
            contentAction.run();
        }
        this.restoreProportions();
        this.myTabs.getComponent().revalidate();
        this.myTabs.getComponent().repaint();
    }

    void setHideTabs(boolean hide) {
        this.myTabs.getPresentation().setHideTabs(hide);
    }

    private TabInfo createTabInfoFor(Content content) {
        TabInfo tabInfo = GridCellImpl.updatePresentation(new TabInfo((JComponent)((Object)new ProviderWrapper(content, this.myContext))), content).setObject((Object)content).setPreferredFocusableComponent(content.getPreferredFocusableComponent()).setActionsContextComponent(content.getActionsContextComponent());
        this.myTabs.myContents.remove((Object)content);
        this.myTabs.myContents.put((Object)content, (Object)tabInfo);
        ActionGroup group2 = (ActionGroup)this.myContext.getActionManager().getAction("Runner.View.Toolbar");
        tabInfo.setTabLabelActions(group2, "debuggerCellToolbar");
        tabInfo.setDragOutDelegate((TabInfo.DragOutDelegate)((RunnerContentUi)this.myContext).myDragOutDelegate);
        return tabInfo;
    }

    @Nullable
    private static TabInfo updatePresentation(TabInfo info, Content content) {
        if (info == null) {
            return null;
        }
        return info.setIcon(content.getIcon()).setText(content.getDisplayName()).setTooltipText(content.getDescription()).setActionsContextComponent(content.getActionsContextComponent()).setActions(content.getActions(), content.getPlace()).setTabColor(content.getTabColor());
    }

    public ActionCallback select(Content content, boolean requestFocus) {
        TabInfo tabInfo = (TabInfo)this.myTabs.myContents.getValue((Object)content);
        return tabInfo != null ? this.myTabs.select(tabInfo, requestFocus) : ActionCallback.DONE;
    }

    public void processAlert(Content content, boolean activate) {
        TabInfo tab;
        if (this.myMinimizedContents.contains(content)) {
            content.fireAlert();
        }
        if ((tab = this.getTabFor(content)) == null) {
            return;
        }
        if (this.myTabs.getSelectedInfo() != tab) {
            if (activate) {
                tab.fireAlert();
            } else {
                tab.stopAlerting();
            }
        }
    }

    public void updateTabPresentation(Content content) {
        GridCellImpl.updatePresentation(this.myTabs.findInfo(content), content);
    }

    public boolean isMinimized(Content content) {
        return this.myMinimizedContents.contains(content);
    }

    public boolean contains(Component c) {
        return this.myTabs.getComponent().isAncestorOf(c);
    }

    @Nullable
    TabInfo getTabFor(Content content) {
        return (TabInfo)this.myTabs.myContents.getValue((Object)content);
    }

    @NotNull
    private Content getContentFor(TabInfo tab) {
        Content content = (Content)this.myTabs.myContents.getKey((Object)tab);
        if (content == null) {
            GridCellImpl.$$$reportNull$$$0(1);
        }
        return content;
    }

    public void setToolbarHorizontal(boolean horizontal) {
        this.myTabs.getPresentation().setSideComponentVertical(!horizontal);
    }

    public void setToolbarBefore(boolean before) {
        this.myTabs.getPresentation().setSideComponentBefore(before);
    }

    public ActionCallback restoreLastUiState() {
        boolean detached;
        ActionCallback result2 = new ActionCallback();
        this.restoreProportions();
        Content[] contents = this.getContents();
        SmartList toMinimize = new SmartList();
        int window = 0;
        for (Content each : contents) {
            View view = this.myContainer.getStateFor(each);
            if (view.isMinimizedInGrid()) {
                toMinimize.add(each);
            }
            window = view.getWindow();
        }
        this.minimize(toMinimize.toArray(new Content[0]));
        Tab tab = this.myContainer.getTab();
        boolean bl = detached = tab != null && tab.isDetached(this.myPlaceInGrid) || window != this.myContext.getWindow();
        if (detached && contents.length > 0) {
            if (tab != null) {
                tab.setDetached(this.myPlaceInGrid, false);
            }
            this.myContext.detachTo(window, this).notifyWhenDone(result2);
        } else {
            result2.setDone();
        }
        return result2;
    }

    Content[] getContents() {
        return this.myTabs.myContents.getKeys().toArray(new Content[this.myTabs.myContents.size()]);
    }

    public int getContentCount() {
        return this.myTabs.myContents.size();
    }

    public void saveUiState() {
        Window frame;
        this.saveProportions();
        for (Content each : this.myTabs.myContents.getKeys()) {
            this.saveState(each, false);
        }
        for (Content each : this.myMinimizedContents) {
            this.saveState(each, true);
        }
        DimensionService service = DimensionService.getInstance();
        Dimension size = this.myContext.getContentManager().getComponent().getSize();
        service.setSize(this.getDimensionKey(), size, this.myContext.getProject());
        if (this.myContext.getWindow() != 0 && (frame = SwingUtilities.getWindowAncestor((Component)((Object)this.myPlaceholder))) != null && frame.isShowing()) {
            service.setLocation(this.getDimensionKey(), frame.getLocationOnScreen());
        }
    }

    public void saveProportions() {
        this.myContainer.saveSplitterProportions(this.myPlaceInGrid);
    }

    private void saveState(Content content, boolean minimized) {
        View state = this.myContext.getStateFor(content);
        state.setMinimizedInGrid(minimized);
        state.setPlaceInGrid(this.myPlaceInGrid);
        List<Content> contents = this.myContainer.getContents();
        Tab tab = this.myContainer.getTabIndex();
        if (minimized && contents.size() == 1 && contents.get(0).equals((Object)content)) {
            state.setTabIndex(-1);
            if (tab instanceof TabImpl) {
                ((TabImpl)tab).setIndex(-1);
            }
        }
        state.assignTab(tab);
        state.setWindow(this.myContext.getWindow());
    }

    public void restoreProportions() {
        this.myContainer.restoreLastSplitterProportions(this.myPlaceInGrid);
    }

    public void updateSelection(boolean isShowing) {
        ContentManager contentManager = this.myContext.getContentManager();
        if (contentManager.isDisposed()) {
            return;
        }
        for (Content each : this.myTabs.myContents.getKeys()) {
            boolean isSelected;
            TabInfo eachTab = this.getTabFor(each);
            boolean bl = isSelected = eachTab != null && this.myTabs.getSelectedInfo() == eachTab;
            if (isSelected && isShowing) {
                contentManager.addSelectedContent(each);
                continue;
            }
            contentManager.removeFromSelection(each);
        }
        for (Content each : this.myMinimizedContents) {
            contentManager.removeFromSelection(each);
        }
    }

    public void minimize(Content[] contents) {
        if (contents.length == 0) {
            return;
        }
        this.myContext.saveUiState();
        for (final Content each : contents) {
            this.myMinimizedContents.add(each);
            this.remove(each);
            this.saveState(each, true);
            boolean isShowing = this.myTabs.getComponent().getRootPane() != null;
            this.myContainer.minimize(each, new CellTransform.Restore(){

                public ActionCallback restoreInGrid() {
                    GridCellImpl.this.restore(each);
                    return ActionCallback.DONE;
                }
            });
            this.updateSelection(isShowing);
        }
    }

    @Nullable
    public Point getLocation() {
        return DimensionService.getInstance().getLocation(this.getDimensionKey(), this.myContext.getProject());
    }

    @Nullable
    public Dimension getSize() {
        return DimensionService.getInstance().getSize(this.getDimensionKey(), this.myContext.getProject());
    }

    private String getDimensionKey() {
        return "GridCell.Tab." + this.myContainer.getTab().getIndex() + "." + this.myPlaceInGrid.name();
    }

    public boolean isValidForCalculateProportions() {
        return this.getContentCount() > 0;
    }

    public void minimize(Content content) {
        this.minimize(new Content[]{content});
    }

    public void closeOrMinimize(MouseEvent e) {
        TabInfo tabInfo = this.myTabs.findInfo(e);
        if (tabInfo == null) {
            return;
        }
        Content content = this.getContentFor(tabInfo);
        if (CloseViewAction.isEnabled(new Content[]{content})) {
            CloseViewAction.perform(this.myContext, content);
        } else if (MinimizeViewAction.isEnabled(this.myContext, this.getContents(), "debuggerCellToolbar")) {
            this.minimize(content);
        }
    }

    void restore(@NotNull Content content) {
        if (content == null) {
            GridCellImpl.$$$reportNull$$$0(2);
        }
        this.myMinimizedContents.remove(content);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/impl/GridCellImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/GridCellImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class GridCellTabs
    extends SingleHeightTabs {
        final ViewContextEx myContext;
        final MutualMap<Content, TabInfo> myContents;

        @NotNull
        protected TabPainterAdapter createTabPainterAdapter() {
            TabPainterAdapter painter;
            InternalUICustomization customization = InternalUICustomization.getInstance();
            if (customization != null && (painter = customization.getDebuggerTabPainterAdapter()) != null) {
                TabPainterAdapter tabPainterAdapter = painter;
                if (tabPainterAdapter == null) {
                    GridCellTabs.$$$reportNull$$$0(0);
                }
                return tabPainterAdapter;
            }
            return new DefaultTabPainterAdapter(JBTabPainter.getDEBUGGER());
        }

        private GridCellTabs(@NotNull ViewContextEx context, @NotNull GridImpl container) {
            if (context == null) {
                GridCellTabs.$$$reportNull$$$0(1);
            }
            if (container == null) {
                GridCellTabs.$$$reportNull$$$0(2);
            }
            super(context.getProject(), context.getFocusManager(), (Disposable)container);
            this.myContents = new MutualMap(true);
            this.myContext = context;
            JBRunnerTabs tabs = ((RunnerContentUi)this.myContext).tabs;
            ((JBTabsImpl)tabs).addNestedTabs((JBTabsImpl)this, (Disposable)container);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Content[] contentArray;
            Content content;
            if (sink == null) {
                GridCellTabs.$$$reportNull$$$0(3);
            }
            super.uiDataSnapshot(sink);
            TabInfo target = this.getTargetInfo();
            Content content2 = content = target == null ? null : (Content)this.myContents.getKey((Object)target);
            if (content == null) {
                contentArray = null;
            } else {
                Content[] contentArray2 = new Content[1];
                contentArray = contentArray2;
                contentArray2[0] = content;
            }
            sink.set(ViewContext.CONTENT_KEY, contentArray);
            sink.set(ViewContext.CONTEXT_KEY, (Object)this.myContext);
        }

        @NotNull
        protected DragHelper createDragHelper(@NotNull JBTabsImpl tabs, @NotNull Disposable parentDisposable) {
            if (tabs == null) {
                GridCellTabs.$$$reportNull$$$0(4);
            }
            if (parentDisposable == null) {
                GridCellTabs.$$$reportNull$$$0(5);
            }
            return new DragHelper(this, tabs, parentDisposable){

                protected boolean canFinishDragging(@NotNull MouseEvent me) {
                    if (me == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "com/intellij/execution/ui/layout/impl/GridCellImpl$GridCellTabs$1", "canFinishDragging"));
                }
            };
        }

        public boolean useSmallLabels() {
            return true;
        }

        public void processDropOver(@NotNull TabInfo over, @NotNull RelativePoint point) {
            if (over == null) {
                GridCellTabs.$$$reportNull$$$0(6);
            }
            if (point == null) {
                GridCellTabs.$$$reportNull$$$0(7);
            }
            ((RunnerContentUi)this.myContext).tabs.processDropOver(over, point);
        }

        @NotNull
        public Image startDropOver(@NotNull TabInfo tabInfo, @NotNull RelativePoint point) {
            if (tabInfo == null) {
                GridCellTabs.$$$reportNull$$$0(8);
            }
            if (point == null) {
                GridCellTabs.$$$reportNull$$$0(9);
            }
            Image image = ((RunnerContentUi)this.myContext).tabs.startDropOver(tabInfo, point);
            if (image == null) {
                GridCellTabs.$$$reportNull$$$0(10);
            }
            return image;
        }

        public void resetDropOver(@NotNull TabInfo tabInfo) {
            if (tabInfo == null) {
                GridCellTabs.$$$reportNull$$$0(11);
            }
            ((RunnerContentUi)this.myContext).tabs.resetDropOver(tabInfo);
        }

        @NotNull
        protected TabLabel createTabLabel(@NotNull TabInfo info) {
            if (info == null) {
                GridCellTabs.$$$reportNull$$$0(12);
            }
            return new SingleHeightTabs.SingleHeightLabel((JBTabsImpl)this, info){

                public void setAlignmentToCenter(boolean toCenter) {
                    super.setAlignmentToCenter(false);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ui/layout/impl/GridCellImpl$GridCellTabs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabs";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "over";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabInfo";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTabPainterAdapter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ui/layout/impl/GridCellImpl$GridCellTabs";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startDropOver";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createDragHelper";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processDropOver";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "startDropOver";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "resetDropOver";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createTabLabel";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class ProviderWrapper
    extends NonOpaquePanel
    implements UiDataProvider {
        Content myContent;
        ViewContext myContext;

        private ProviderWrapper(Content content, ViewContext context) {
            this.myContent = content;
            this.myContext = context;
            this.setLayout(new BorderLayout());
            this.add(content.getComponent(), "Center");
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ProviderWrapper.$$$reportNull$$$0(0);
            }
            sink.set(ViewContext.CONTENT_KEY, (Object)new Content[]{this.myContent});
            sink.set(ViewContext.CONTEXT_KEY, (Object)this.myContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/execution/ui/layout/impl/GridCellImpl$ProviderWrapper", "uiDataSnapshot"));
        }
    }
}

