/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.EnvFilesOptions;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.envFile.EnvFileParserKt;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ShellEnvironmentReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"checkEnvFiles", "", "configuration", "Lcom/intellij/execution/CommonProgramRunConfigurationParameters;", "configureEnvsFromFiles", "", "", "Lcom/intellij/execution/EnvFilesOptions;", "parse", "", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nEnvFilesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvFilesUtil.kt\ncom/intellij/execution/util/EnvFilesUtilKt\n+ 2 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n*L\n1#1,70:1\n13#2,8:71\n*S KotlinDebug\n*F\n+ 1 EnvFilesUtil.kt\ncom/intellij/execution/util/EnvFilesUtilKt\n*L\n44#1:71,8\n*E\n"})
public final class EnvFilesUtilKt {
    public static final void checkEnvFiles(@Nullable CommonProgramRunConfigurationParameters configuration) throws RuntimeConfigurationException {
        if (configuration instanceof EnvFilesOptions) {
            try {
                EnvFilesUtilKt.configureEnvsFromFiles((EnvFilesOptions)((Object)configuration), false);
            }
            catch (ProgramParametersConfigurator.ParametersConfiguratorException e) {
                throw new RuntimeConfigurationException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Experimental
    @NotNull
    public static final Map<String, String> configureEnvsFromFiles(@NotNull EnvFilesOptions configuration, boolean parse) throws ProgramParametersConfigurator.ParametersConfiguratorException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Map result2 = new HashMap();
        for (String path : configuration.getEnvFilePaths()) {
            Object[] objectArray;
            try {
                String extension;
                Path file = Path.of(path, new String[0]);
                Intrinsics.checkNotNull((Object)file);
                Intrinsics.checkNotNullExpressionValue((Object)PathsKt.getExtension((Path)file).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)extension, (Object)"sh") || Intrinsics.areEqual((Object)extension, (Object)"bat")) {
                    if (!parse) continue;
                    ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
                    Intrinsics.checkNotNull((Object)indicator);
                    ProgressIndicator $this$withPushPop$iv = indicator;
                    boolean $i$f$withPushPop = false;
                    boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
                    $this$withPushPop$iv.pushState();
                    try {
                        boolean bl = false;
                        Object[] objectArray2 = new Object[]{PathsKt.getName((Path)file)};
                        indicator.setText(ExecutionBundle.message((String)"progress.title.script.running", (Object[])objectArray2));
                        ProcessBuilder processBuilder = Intrinsics.areEqual((Object)extension, (Object)"bat") ? ShellEnvironmentReader.winShellCommand((Path)file, null) : ShellEnvironmentReader.shellCommand(null, (Path)file, null);
                        Intrinsics.checkNotNull((Object)processBuilder);
                        ProcessBuilder command = processBuilder;
                        Object object = ShellEnvironmentReader.readEnvironment((ProcessBuilder)command, (long)0L).first;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                        result2.putAll((Map)object);
                        Unit unit = Unit.INSTANCE;
                        continue;
                    }
                    finally {
                        $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
                        $this$withPushPop$iv.popState();
                        continue;
                    }
                }
                String text = PathsKt.readText$default((Path)file, null, (int)1, null);
                if (!parse) continue;
                result2.putAll(EnvFileParserKt.parseEnvFile(text));
            }
            catch (FileNotFoundException e) {
                objectArray = new Object[]{path};
                throw new ProgramParametersConfigurator.ParametersConfiguratorException(ExecutionBundle.message((String)"file.not.found.0", (Object[])objectArray), e);
            }
            catch (IOException e) {
                objectArray = new Object[]{path};
                throw new ProgramParametersConfigurator.ParametersConfiguratorException(ExecutionBundle.message((String)"cannot.read.file.0", (Object[])objectArray), e);
            }
        }
        return result2;
    }

    public static /* synthetic */ Map configureEnvsFromFiles$default(EnvFilesOptions envFilesOptions, boolean bl, int n, Object object) throws ProgramParametersConfigurator.ParametersConfiguratorException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return EnvFilesUtilKt.configureEnvsFromFiles(envFilesOptions, bl);
    }
}

