/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.ide.macro.MacroPathConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class WslMacroPathConverter
implements MacroPathConverter {
    private static final Logger LOG = Logger.getInstance(WslMacroPathConverter.class);
    private final WSLDistribution myWsl;

    public WslMacroPathConverter(@NotNull WSLDistribution wsl) {
        if (wsl == null) {
            WslMacroPathConverter.$$$reportNull$$$0(0);
        }
        this.myWsl = wsl;
    }

    @NotNull
    public String convertPath(@NotNull String path) {
        String string;
        if (path == null) {
            WslMacroPathConverter.$$$reportNull$$$0(1);
        }
        try {
            String converted = this.myWsl.getWslPath(path);
            string = converted != null ? converted : path;
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Failed to convert to path: " + path, (Throwable)e);
            String string2 = path;
            if (string2 == null) {
                WslMacroPathConverter.$$$reportNull$$$0(3);
            }
            return string2;
        }
        if (string == null) {
            WslMacroPathConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String convertPathList(@NotNull String pathList) {
        if (pathList == null) {
            WslMacroPathConverter.$$$reportNull$$$0(4);
        }
        List paths = StringUtil.split((String)pathList, (String)File.pathSeparator);
        String string = Strings.join((Collection)ContainerUtil.map((Collection)paths, p -> this.convertPath((String)p)), (String)":");
        if (string == null) {
            WslMacroPathConverter.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslMacroPathConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslMacroPathConverter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPathList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertPath";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertPathList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

