/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CompositeFilterWrapper {
    private final Project myProject;
    private final TerminalExecutionConsole myConsole;
    private final List<Filter> myCustomFilters;
    private volatile CompositeFilter myCompositeFilter;

    CompositeFilterWrapper(@NotNull Project project, @Nullable TerminalExecutionConsole console, @NotNull Disposable disposable) {
        if (project == null) {
            CompositeFilterWrapper.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            CompositeFilterWrapper.$$$reportNull$$$0(1);
        }
        this.myCustomFilters = new CopyOnWriteArrayList<Filter>();
        this.myProject = project;
        this.myConsole = console;
        ConsoleFilterProvider.FILTER_PROVIDERS.addChangeListener(() -> {
            this.myCompositeFilter = null;
        }, disposable);
    }

    void addFilter(@NotNull Filter filter) {
        if (filter == null) {
            CompositeFilterWrapper.$$$reportNull$$$0(2);
        }
        this.myCustomFilters.add(filter);
        this.myCompositeFilter = null;
    }

    @RequiresReadLock
    @NotNull
    private List<Filter> computeConsoleFilters() {
        ThreadingAssertions.softAssertReadAccess();
        if (this.myProject.isDefault()) {
            List<Filter> list = Collections.emptyList();
            if (list == null) {
                CompositeFilterWrapper.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (this.myProject.isDisposed()) {
            List<Filter> list = Collections.emptyList();
            if (list == null) {
                CompositeFilterWrapper.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = ConsoleViewUtil.computeConsoleFilters((Project)this.myProject, (ConsoleView)this.myConsole, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        if (list == null) {
            CompositeFilterWrapper.$$$reportNull$$$0(5);
        }
        return list;
    }

    @RequiresReadLock
    @NotNull
    CompositeFilter getCompositeFilter() {
        ThreadingAssertions.softAssertReadAccess();
        CompositeFilter filter = this.myCompositeFilter;
        if (filter != null) {
            CompositeFilter compositeFilter = filter;
            if (compositeFilter == null) {
                CompositeFilterWrapper.$$$reportNull$$$0(6);
            }
            return compositeFilter;
        }
        List<Filter> predefinedFilters = this.computeConsoleFilters();
        filter = new CompositeFilter(this.myProject, ContainerUtil.concat(this.myCustomFilters, predefinedFilters));
        filter.setForceUseAllFilters(true);
        this.myCompositeFilter = filter;
        CompositeFilter compositeFilter = filter;
        if (compositeFilter == null) {
            CompositeFilterWrapper.$$$reportNull$$$0(7);
        }
        return compositeFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/CompositeFilterWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/CompositeFilterWrapper";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeConsoleFilters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

