/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RunManagerConfig {
    public static final int MIN_RECENT_LIMIT = 0;
    public static final int DEFAULT_RECENT_LIMIT = 5;
    private final PropertiesComponent propertyService;
    @NonNls
    private static final String RECENTS_LIMIT = "recentsLimit";
    @NonNls
    private static final String RESTART_REQUIRES_CONFIRMATION = "restartRequiresConfirmation";
    @NonNls
    private static final String DELETION_FROM_POPUP_REQUIRES_CONFIRMATION = "deletionFromPopupRequiresConfirmation";
    @NonNls
    private static final String STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION = "stopIncompatibleRequiresConfirmation";
    @NonNls
    private static final String RECENTS_LIMIT_KEY = "temporary.configurations.limit";
    @NonNls
    private static final String CONFIRM_RERUN_KEY = "confirm.rerun.with.termination";

    public RunManagerConfig(@Nullable PropertiesComponent propertiesComponent) {
        this.propertyService = propertiesComponent;
    }

    public int getRecentsLimit() {
        return AdvancedSettings.getInt((String)RECENTS_LIMIT_KEY);
    }

    public void setRecentsLimit(int recentsLimit) {
        AdvancedSettings.setInt((String)RECENTS_LIMIT_KEY, (int)Math.max(0, recentsLimit));
    }

    public void migrateToAdvancedSettings() {
        if (this.propertyService != null) {
            if (this.propertyService.isValueSet(RECENTS_LIMIT)) {
                this.setRecentsLimit(Math.max(0, StringUtil.parseInt((String)this.propertyService.getValue(RECENTS_LIMIT), (int)5)));
                this.propertyService.unsetValue(RECENTS_LIMIT);
            }
            if (this.propertyService.isValueSet(RESTART_REQUIRES_CONFIRMATION)) {
                this.setRestartRequiresConfirmation(this.propertyService.getBoolean(RESTART_REQUIRES_CONFIRMATION));
                this.propertyService.unsetValue(RESTART_REQUIRES_CONFIRMATION);
            }
        }
    }

    public boolean isRestartRequiresConfirmation() {
        return AdvancedSettings.getBoolean((String)CONFIRM_RERUN_KEY);
    }

    public void setRestartRequiresConfirmation(boolean restartRequiresConfirmation) {
        AdvancedSettings.setBoolean((String)CONFIRM_RERUN_KEY, (boolean)restartRequiresConfirmation);
    }

    public boolean isDeletionFromPopupRequiresConfirmation() {
        return this.propertyService == null || this.propertyService.getBoolean(DELETION_FROM_POPUP_REQUIRES_CONFIRMATION, true);
    }

    public void setDeletionFromPopupRequiresConfirmation(boolean deletionFromPopupRequiresConfirmation) {
        if (this.propertyService != null) {
            this.propertyService.setValue(DELETION_FROM_POPUP_REQUIRES_CONFIRMATION, deletionFromPopupRequiresConfirmation, true);
        }
    }

    public boolean isStopIncompatibleRequiresConfirmation() {
        return this.propertyService == null || this.propertyService.getBoolean(STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION, true);
    }

    public void setStopIncompatibleRequiresConfirmation(boolean stopIncompatibleRequiresConfirmation) {
        if (this.propertyService != null) {
            this.propertyService.setValue(STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION, stopIncompatibleRequiresConfirmation, true);
        }
    }
}

