/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetManagerImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.SuggestUsingRunDashBoardUtil;
import com.intellij.execution.compound.CompoundRunConfigurationOptions;
import com.intellij.execution.compound.CompoundRunConfigurationSettingsEditor;
import com.intellij.execution.compound.CompoundRunConfigurationType;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.compound.TypeNameTarget;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationMinimalBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunConfigurationListManagerHelperKt;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runToolbar.RunToolbarProcessData;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ExperimentalUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\u00016B'\b\u0007\u0012\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0018J\u0014\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fJ\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u0010\"\u001a\u00020\u001cH\u0002J\b\u0010#\u001a\u00020$H\u0017J\b\u0010%\u001a\u00020\u001cH\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-J\b\u0010&\u001a\u00020\u0002H\u0017J\u0010\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u0002H\u0017J\b\u00101\u001a\u00020\u0010H\u0016J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u00105\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u00010)R.\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fj\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/execution/compound/CompoundRunConfiguration;", "Lcom/intellij/execution/configurations/RunConfigurationMinimalBase;", "Lcom/intellij/execution/compound/CompoundRunConfigurationOptions;", "Lcom/intellij/execution/RunnerIconProvider;", "Lcom/intellij/execution/configurations/WithoutOwnBeforeRunSteps;", "", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "sortedConfigurationsWithTargets", "Ljava/util/LinkedHashMap;", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lcom/intellij/execution/ExecutionTarget;", "Lkotlin/collections/LinkedHashMap;", "isInitialized", "", "isDirty", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConfigurationsWithTargets", "", "runManager", "Lcom/intellij/execution/impl/RunManagerImpl;", "setConfigurationsWithTargets", "", "value", "setConfigurationsWithoutTargets", "", "initIfNeeded", "doInit", "markInitialized", "getConfigurationEditor", "Lcom/intellij/execution/compound/CompoundRunConfigurationSettingsEditor;", "checkConfiguration", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getConfigurationsWithEffectiveRunTargets", "", "Lcom/intellij/execution/compound/SettingsAndEffectiveTarget;", "loadState", "state", "clone", "getExecutorIcon", "Ljavax/swing/Icon;", "configuration", "hasRunningSingletons", "Companion", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nCompoundRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompoundRunConfiguration.kt\ncom/intellij/execution/compound/CompoundRunConfiguration\n+ 2 runConfigurationType.kt\ncom/intellij/execution/configurations/RunConfigurationTypeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,231:1\n26#2:232\n1300#3,2:233\n1315#3,4:235\n1586#3:240\n1661#3,3:241\n1807#3,3:258\n1#4:239\n1#4:255\n139#5,10:244\n221#5:254\n222#5:256\n149#5:257\n*S KotlinDebug\n*F\n+ 1 CompoundRunConfiguration.kt\ncom/intellij/execution/compound/CompoundRunConfiguration\n*L\n32#1:232\n61#1:233,2\n61#1:235,4\n113#1:240\n113#1:241,3\n206#1:258,3\n136#1:255\n136#1:244,10\n136#1:254\n136#1:256\n136#1:257\n*E\n"})
public final class CompoundRunConfiguration
extends RunConfigurationMinimalBase<CompoundRunConfigurationOptions>
implements RunnerIconProvider,
WithoutOwnBeforeRunSteps,
Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LinkedHashMap<RunConfiguration, ExecutionTarget> sortedConfigurationsWithTargets;
    private boolean isInitialized;
    @NotNull
    private final AtomicBoolean isDirty;
    @JvmField
    @NotNull
    public static final Comparator<RunConfiguration> COMPARATOR = CompoundRunConfiguration::COMPARATOR$lambda$0;

    @JvmOverloads
    public CompoundRunConfiguration(@NlsSafe @Nullable String name, @NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(name, factory, project);
        this.sortedConfigurationsWithTargets = new LinkedHashMap();
        this.isDirty = new AtomicBoolean();
    }

    public /* synthetic */ CompoundRunConfiguration(String string, Project project, ConfigurationFactory configurationFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            boolean $i$f$runConfigurationType = false;
            configurationFactory = (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(CompoundRunConfigurationType.class);
        }
        this(string, project, configurationFactory);
    }

    @NotNull
    public final Map<RunConfiguration, ExecutionTarget> getConfigurationsWithTargets(@NotNull RunManagerImpl runManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)runManager), (String)"runManager");
        this.initIfNeeded(runManager);
        return this.sortedConfigurationsWithTargets;
    }

    public final void setConfigurationsWithTargets(@NotNull Map<RunConfiguration, ? extends ExecutionTarget> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.markInitialized();
        this.sortedConfigurationsWithTargets.clear();
        this.sortedConfigurationsWithTargets.putAll(value);
        this.isDirty.set(true);
    }

    /*
     * WARNING - void declaration
     */
    public final void setConfigurationsWithoutTargets(@NotNull Collection<? extends RunConfiguration> value) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Iterable iterable = value;
        CompoundRunConfiguration compoundRunConfiguration = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void var5_6 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            RunConfiguration runConfiguration = (RunConfiguration)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object v = null;
            map.put(t, v);
        }
        compoundRunConfiguration.setConfigurationsWithTargets(destination$iv$iv);
    }

    private final void initIfNeeded(RunManagerImpl runManager) {
        if (this.isInitialized) {
            return;
        }
        this.doInit(runManager);
    }

    @TestOnly
    public final void doInit(@NotNull RunManagerImpl runManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)runManager), (String)"runManager");
        this.sortedConfigurationsWithTargets.clear();
        ExecutionTargetManager executionTargetManager = ExecutionTargetManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNull((Object)executionTargetManager, (String)"null cannot be cast to non-null type com.intellij.execution.ExecutionTargetManagerImpl");
        ExecutionTargetManagerImpl targetManager = (ExecutionTargetManagerImpl)executionTargetManager;
        for (TypeNameTarget item : ((CompoundRunConfigurationOptions)this.getOptions()).getConfigurations()) {
            ExecutionTarget executionTarget;
            String type = item.getType();
            String name = item.getName();
            if (type == null || name == null) continue;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager.findConfigurationByTypeAndName(type, name);
            Object settings = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
            if (settings == null || settings == this) continue;
            if (item.getTargetId() != null) {
                String it;
                boolean bl = false;
                executionTarget = targetManager.findTargetByIdFor((RunConfiguration)settings, it);
            } else {
                executionTarget = null;
            }
            ExecutionTarget target = executionTarget;
            this.sortedConfigurationsWithTargets.put((RunConfiguration)settings, target);
        }
        this.markInitialized();
    }

    private final void markInitialized() {
        this.isInitialized = true;
    }

    @ApiStatus.Internal
    @NotNull
    public CompoundRunConfigurationSettingsEditor getConfigurationEditor() {
        return new CompoundRunConfigurationSettingsEditor(this.getProject());
    }

    public void checkConfiguration() {
        if (this.sortedConfigurationsWithTargets.isEmpty()) {
            throw new RuntimeConfigurationException(ExecutionBundle.message((String)"nothing.to.run.error.message", (Object[])new Object[0]));
        }
        if (ExecutionTargetManager.getInstance((Project)this.getProject()).getTargetsFor((RunConfiguration)this).isEmpty()) {
            throw new RuntimeConfigurationException(ExecutionBundle.message((String)"no.suitable.targets.to.run.error.message", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Iterable iterable = this.getConfigurationsWithEffectiveRunTargets();
        Project project = this.getProject();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SettingsAndEffectiveTarget settingsAndEffectiveTarget = (SettingsAndEffectiveTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getConfiguration().getType());
        }
        SuggestUsingRunDashBoardUtil.promptUserToUseRunDashboard(project, (List)destination$iv$iv);
        return (arg_0, arg_1) -> CompoundRunConfiguration.getState$lambda$1(this, executor, arg_0, arg_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SettingsAndEffectiveTarget> getConfigurationsWithEffectiveRunTargets() {
        void $this$mapNotNullTo$iv$iv;
        ExecutionTarget executionTarget = ExecutionTargetManager.getActiveTarget((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)executionTarget, (String)"getActiveTarget(...)");
        ExecutionTarget activeTarget = executionTarget;
        ExecutionTarget defaultTarget = DefaultExecutionTarget.INSTANCE;
        Map $this$mapNotNull$iv = this.sortedConfigurationsWithTargets;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            RunConfiguration configuration = (RunConfiguration)entry.getKey();
            ExecutionTarget specifiedTarget = (ExecutionTarget)entry.getValue();
            ExecutionTarget executionTarget2 = specifiedTarget;
            if (executionTarget2 == null) {
                executionTarget2 = ExecutionTargetManager.canRun((RunConfiguration)configuration, (ExecutionTarget)activeTarget) ? activeTarget : defaultTarget;
            }
            ExecutionTarget effectiveTarget = executionTarget2;
            Intrinsics.checkNotNull((Object)effectiveTarget);
            SettingsAndEffectiveTarget it$iv$iv = new SettingsAndEffectiveTarget(configuration, effectiveTarget);
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @ApiStatus.Internal
    @NotNull
    public CompoundRunConfigurationOptions getState() {
        if (this.isDirty.compareAndSet(true, false)) {
            ((CompoundRunConfigurationOptions)this.getOptions()).getConfigurations().clear();
            for (Map.Entry entry : ((Map)this.sortedConfigurationsWithTargets).entrySet()) {
                ExecutionTarget executionTarget = (ExecutionTarget)entry.getValue();
                ((CompoundRunConfigurationOptions)this.getOptions()).getConfigurations().add(new TypeNameTarget(((RunConfiguration)entry.getKey()).getType().getId(), ((RunConfiguration)entry.getKey()).getName(), executionTarget != null ? executionTarget.getId() : null));
            }
        }
        return (CompoundRunConfigurationOptions)this.getOptions();
    }

    @ApiStatus.Internal
    public void loadState(@NotNull CompoundRunConfigurationOptions state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        ((CompoundRunConfigurationOptions)this.getOptions()).getConfigurations().clear();
        ((CompoundRunConfigurationOptions)this.getOptions()).getConfigurations().addAll((Collection<TypeNameTarget>)state.getConfigurations());
        this.sortedConfigurationsWithTargets.clear();
        this.isInitialized = false;
    }

    @NotNull
    public RunConfiguration clone() {
        CompoundRunConfiguration clone = new CompoundRunConfiguration(this.getName(), this.getProject(), this.getFactory());
        CompoundRunConfigurationOptions compoundRunConfigurationOptions = this.getState();
        Intrinsics.checkNotNull((Object)((Object)compoundRunConfigurationOptions));
        clone.loadState(compoundRunConfigurationOptions);
        return (RunConfiguration)clone;
    }

    @NotNull
    public Icon getExecutorIcon(@NotNull RunConfiguration configuration, @NotNull Executor executor) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (!this.hasRunningSingletons(executor)) {
            Icon icon2 = executor.getIcon();
            Intrinsics.checkNotNull((Object)icon2);
            icon = icon2;
        } else {
            Icon icon3 = !ExperimentalUI.Companion.isNewUI() && Intrinsics.areEqual((Object)"Run", (Object)executor.getId()) ? AllIcons.Actions.Restart : (ExperimentalUI.Companion.isNewUI() && !Intrinsics.areEqual((Object)executor.getRerunIcon(), (Object)executor.getIcon()) ? executor.getRerunIcon() : ExecutionUtil.getLiveIndicator((Icon)executor.getIcon()));
            Intrinsics.checkNotNull((Object)icon3);
            icon = icon3;
        }
        return icon;
    }

    public final boolean hasRunningSingletons(@Nullable Executor executor) {
        boolean bl;
        block6: {
            Project project = this.getProject();
            if (project.isDisposed()) {
                return false;
            }
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.Companion.getInstance(project);
            List<RunContentDescriptor> runningDescriptors = executionManager.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)arg_0 -> CompoundRunConfiguration.hasRunningSingletons$lambda$0(project, this, executor, arg_0)));
            if (executor != null) {
                Iterable $this$any$iv = runningDescriptors;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RunContentDescriptor it = (RunContentDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!executionManager.getExecutors(it).contains(executor)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            } else {
                bl = !((Collection)runningDescriptors).isEmpty();
            }
        }
        return bl;
    }

    @JvmOverloads
    public CompoundRunConfiguration(@NlsSafe @Nullable String name, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(name, project, null, 4, null);
    }

    @JvmOverloads
    public CompoundRunConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(null, project, null, 5, null);
    }

    private static final void getState$lambda$1$0(CompoundRunConfiguration this$0, Executor $executor) {
        RunnerAndConfigurationSettings compoundSettings = RunManagerImpl.Companion.getInstanceImpl(this$0.getProject()).findSettings((RunConfiguration)this$0);
        long groupId = ExecutionEnvironment.getNextUnusedExecutionId();
        for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : this$0.getConfigurationsWithEffectiveRunTargets()) {
            RunnerAndConfigurationSettings settings;
            RunConfiguration configuration = settingsAndEffectiveTarget.component1();
            ExecutionTarget target = settingsAndEffectiveTarget.component2();
            if (RunManagerImpl.Companion.getInstanceImpl(this$0.getProject()).findSettings(configuration) == null) continue;
            ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)settings, (Executor)$executor, (ExecutionTarget)target, (Long)groupId, null, (Consumer)RunToolbarProcessData.Companion.prepareBaseSettingCustomization$default((RunToolbarProcessData.Companion)RunToolbarProcessData.Companion, (RunnerAndConfigurationSettings)compoundSettings, null, (int)2, null));
        }
    }

    private static final ExecutionResult getState$lambda$1(CompoundRunConfiguration this$0, Executor $executor, Executor executor, ProgramRunner programRunner) {
        Intrinsics.checkNotNullParameter((Object)programRunner, (String)"<unused var>");
        ApplicationManager.getApplication().invokeLater(() -> CompoundRunConfiguration.getState$lambda$1$0(this$0, $executor));
        return null;
    }

    private static final boolean hasRunningSingletons$lambda$0(Project $project, CompoundRunConfiguration this$0, Executor $executor, RunnerAndConfigurationSettings s) {
        RunManagerImpl manager = RunManagerImpl.Companion.getInstanceImpl($project);
        Iterator iterator = ((Map)this$0.sortedConfigurationsWithTargets).entrySet().iterator();
        while (iterator.hasNext()) {
            RunConfiguration configuration = (RunConfiguration)iterator.next().getKey();
            if (configuration instanceof CompoundRunConfiguration && ((CompoundRunConfiguration)configuration).hasRunningSingletons($executor)) {
                return true;
            }
            RunnerAndConfigurationSettings settings = manager.findSettings(configuration);
            if (settings == null || settings.getConfiguration().isAllowRunningInParallel() || !Intrinsics.areEqual((Object)configuration, (Object)s.getConfiguration())) continue;
            return true;
        }
        return false;
    }

    private static final int COMPARATOR$lambda$0(RunConfiguration o1, RunConfiguration o2) {
        int n;
        ConfigurationType configurationType = o1.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"getType(...)");
        ConfigurationType configurationType2 = o2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType2, (String)"getType(...)");
        int compareTypeResult = RunConfigurationListManagerHelperKt.compareTypesForUi(configurationType, configurationType2);
        if (compareTypeResult == 0) {
            String string = o1.getName();
            String string2 = o2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            n = string.compareTo(string2);
        } else {
            n = compareTypeResult;
        }
        return n;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/compound/CompoundRunConfiguration$Companion;", "", "<init>", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/execution/configurations/RunConfiguration;", "Lkotlin/Comparator;", "intellij.platform.execution.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

