/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationCreationListener;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.VirtualConfigurationType;
import com.intellij.execution.impl.NewRunConfigurationPopup;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunConfigurableKt;
import com.intellij.execution.impl.RunConfigurableNodeKind;
import com.intellij.execution.impl.RunConfigurableTreeRenderer;
import com.intellij.execution.impl.RunConfigurationBean;
import com.intellij.execution.impl.RunConfigurationCreator;
import com.intellij.execution.impl.RunConfigurationListManagerHelperKt;
import com.intellij.execution.impl.RunConfigurationSelector;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.impl.TemplateConfigurable;
import com.intellij.execution.impl.ValidationResult;
import com.intellij.execution.impl.statistics.RunConfigurationOptionUsagesCollector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.dnd.TransferableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.AlignedPopup;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IconManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.mac.touchbar.TouchbarActionCustomizations;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0016\u0018\u0000 \u0092\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0010\u0092\u0001\u0093\u0001\u0094\u0001\u0095\u0001\u0096\u0001\u0097\u0001\u0098\u0001\u0099\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u00104\u001a\u0004\u0018\u00010\u0001J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u000203J\u0012\u00108\u001a\f09\u00a2\u0006\u0002\b:\u00a2\u0006\u0002\b;H\u0016J\b\u0010<\u001a\u000206H\u0004J\u0010\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020\u0002H\u0004J\b\u0010?\u001a\u000206H\u0002J\u0010\u0010@\u001a\u0002062\u0006\u0010A\u001a\u00020BH\u0014J\u0010\u0010C\u001a\u0002062\u0006\u0010D\u001a\u00020\rH\u0014J\u0006\u0010E\u001a\u000206J\n\u0010F\u001a\u0004\u0018\u00010GH\u0014J\u0010\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020JH\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010\r2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010L\u001a\u0002062\u0006\u0010M\u001a\u00020 H\u0002J\u001a\u0010N\u001a\u0002062\u0006\u0010O\u001a\u00020\r2\b\b\u0001\u0010P\u001a\u000209H\u0002J\u0010\u0010Q\u001a\u00020B2\u0006\u0010O\u001a\u00020\rH\u0002J\u0010\u0010R\u001a\u0002062\b\u0010S\u001a\u0004\u0018\u00010\u0001J\u0010\u0010T\u001a\u00020\u000b2\u0006\u0010S\u001a\u00020\u0001H\u0002J\b\u0010U\u001a\u000206H\u0002J\b\u0010V\u001a\u000206H\u0002J\u0016\u0010W\u001a\u0002062\f\u0010X\u001a\b\u0012\u0004\u0012\u00020J0YH\u0002J\u0012\u0010Z\u001a\u0002062\b\u0010[\u001a\u0004\u0018\u00010\\H\u0004J\u0014\u0010]\u001a\u0004\u0018\u00010^2\b\u0010[\u001a\u0004\u0018\u00010\\H\u0014J\b\u0010_\u001a\u00020^H\u0014J\n\u0010c\u001a\u0004\u0018\u00010^H\u0016J\b\u0010d\u001a\u000206H\u0016J\b\u0010e\u001a\u000206H\u0016J\b\u0010f\u001a\u000206H\u0004J\b\u0010g\u001a\u000206H\u0016J(\u0010h\u001a\b\u0012\u0004\u0012\u00020j0i2\u0006\u0010k\u001a\u00020\r2\u0006\u0010l\u001a\u00020\\2\b\u0010m\u001a\u0004\u0018\u00010GH\u0002J\u0012\u0010n\u001a\u0004\u0018\u00010\r2\u0006\u0010l\u001a\u00020\\H\u0002J\u001e\u0010o\u001a\u0002062\u0006\u0010k\u001a\u00020\r2\f\u0010S\u001a\b\u0012\u0002\b\u0003\u0018\u00010YH\u0002J\b\u0010-\u001a\u00020\u000bH\u0016J\b\u0010p\u001a\u00020\u000bH\u0004J\b\u0010q\u001a\u000206H\u0016J\b\u0010r\u001a\u000206H\u0016J\b\u0010s\u001a\u000206H\u0002J\b\u0010t\u001a\u000206H\u0002J\n\u0010|\u001a\u0004\u0018\u000109H\u0016J\u0012\u0010\u007f\u001a\u00020\r2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0002J)\u0010\u0082\u0001\u001a\u001a\u0012\u0005\u0012\u00030\u0081\u0001\u0012\u0005\u0012\u00030\u0081\u0001\u0012\u0005\u0012\u00030\u0084\u0001\u0018\u00010\u0083\u00012\b\u0010\u0085\u0001\u001a\u00030\u0081\u0001J-\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020J0Y2\u0007\u0010\u0087\u0001\u001a\u00020G2\b\u0010O\u001a\u0004\u0018\u00010\r2\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010\rH\u0002J\u0017\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020J0Y2\u0006\u0010M\u001a\u00020 H\u0016J\u0013\u0010\u0089\u0001\u001a\u0004\u0018\u0001092\u0006\u0010I\u001a\u00020JH\u0003J\n\u0010\u008a\u0001\u001a\u00030\u0081\u0001H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\u0011R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00010\u001fj\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0001`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010)\u001a\u00060*R\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010`\u001a\u0004\u0018\u00010\\8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010bR\u0019\u0010u\u001a\n\u0012\u0004\u0012\u00020J\u0018\u00010Y8F\u00a2\u0006\u0006\u001a\u0004\bv\u0010wR\u0014\u0010x\u001a\u00020y8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bz\u0010{R\u0016\u0010}\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b~\u0010\u000fR\u001e\u0010\u008b\u0001\u001a\t\u0012\u0004\u0012\u00020\r0\u008c\u00018BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001R\u0018\u0010\u0088\u0001\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0007\u001a\u0005\b\u008f\u0001\u0010\u000fR\u0018\u0010m\u001a\u0004\u0018\u00010G8BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001\u00a8\u0006\u009a\u0001"}, d2={"Lcom/intellij/execution/impl/RunConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/execution/impl/RunConfigurationCreator;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isDisposed", "", "root", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getRoot", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "treeModel", "Lcom/intellij/execution/impl/RunConfigurable$MyTreeModel;", "getTreeModel", "()Lcom/intellij/execution/impl/RunConfigurable$MyTreeModel;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "getTree", "()Lcom/intellij/ui/treeStructure/Tree;", "rightPanel", "Ljavax/swing/JPanel;", "splitter", "Lcom/intellij/ui/JBSplitter;", "wholePanel", "selectedConfigurable", "storedComponents", "Ljava/util/HashMap;", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "Lkotlin/collections/HashMap;", "toolbarDecorator", "Lcom/intellij/ui/ToolbarDecorator;", "getToolbarDecorator", "()Lcom/intellij/ui/ToolbarDecorator;", "setToolbarDecorator", "(Lcom/intellij/ui/ToolbarDecorator;)V", "isFolderCreating", "toolbarAddAction", "Lcom/intellij/execution/impl/RunConfigurable$MyToolbarAddAction;", "getToolbarAddAction", "()Lcom/intellij/execution/impl/RunConfigurable$MyToolbarAddAction;", "isModified", "changeRunConfigurationNodeAlarm", "Lcom/intellij/util/SingleAlarm;", "changeRunConfigurationListener", "Ljavax/swing/event/TreeSelectionListener;", "dialogUpdateCallback", "Ljava/lang/Runnable;", "getSelectedConfigurable", "setDialogUpdateCallback", "", "callback", "getDisplayName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "initTree", "initTreeSelectionListener", "parentDisposable", "selectRunConfiguration", "typeOrFactorySelected", "userObject", "", "addRunConfigurationsToModel", "model", "selectConfigurableOnShow", "getInitialSelectedConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "selectConfiguration", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "findNode", "showTemplateConfigurable", "factory", "showFolderField", "node", "folderName", "getSafeUserObject", "updateRightPanel", "configurable", "mayBeEditedInDumbMode", "sortTopLevelBranches", "update", "installUpdateListeners", "info", "Lcom/intellij/execution/impl/SingleConfigurationConfigurable;", "drawPressAddButtonMessage", "configurationType", "Lcom/intellij/execution/configurations/ConfigurationType;", "createTipPanelAboutAddingNewRunConfiguration", "Ljavax/swing/JComponent;", "createLeftPanel", "selectedConfigurationType", "getSelectedConfigurationType", "()Lcom/intellij/execution/configurations/ConfigurationType;", "createComponent", "reset", "apply", "applyTemplates", "updateActiveConfigurationFromSelected", "applyByType", "", "Lcom/intellij/execution/impl/RunConfigurationBean;", "typeNode", "type", "selectedSettings", "getConfigurationTypeNode", "applyConfiguration", "isConfigurableModified", "disposeUIResources", "dispose", "updateDialog", "setupDialogBounds", "selectedConfiguration", "getSelectedConfiguration", "()Lcom/intellij/execution/impl/SingleConfigurationConfigurable;", "runManager", "Lcom/intellij/execution/impl/RunManagerImpl;", "getRunManager", "()Lcom/intellij/execution/impl/RunManagerImpl;", "getHelpTopic", "selectedConfigurationTypeNode", "getSelectedConfigurationTypeNode", "getNode", "row", "", "getAvailableDropPosition", "Lcom/intellij/openapi/util/Trinity;", "Lcom/intellij/ui/RowsDnDSupport$RefinedDropSupport$Position;", "direction", "createNewConfiguration", "settings", "selectedNode", "suggestName", "adjustOrder", "selectedNodes", "", "getSelectedNodes", "()[Ljavax/swing/tree/DefaultMutableTreeNode;", "getSelectedNode", "getSelectedSettings", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "Companion", "MyToolbarAddAction", "MyRemoveAction", "MyCopyAction", "MySaveAction", "MyCreateFolderAction", "MySortFolderAction", "MyTreeModel", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurable.kt\ncom/intellij/execution/impl/RunConfigurable\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1552:1\n13225#2,2:1553\n777#3:1555\n873#3,2:1556\n1807#3,3:1558\n1915#3,2:1561\n1#4:1563\n*S KotlinDebug\n*F\n+ 1 RunConfigurable.kt\ncom/intellij/execution/impl/RunConfigurable\n*L\n225#1:1553,2\n700#1:1555\n700#1:1556,2\n736#1:1558,3\n744#1:1561,2\n*E\n"})
public class RunConfigurable
implements Configurable,
Disposable,
RunConfigurationCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private volatile boolean isDisposed;
    @NotNull
    private final DefaultMutableTreeNode root;
    @NotNull
    private final MyTreeModel treeModel;
    @NotNull
    private final Tree tree;
    @NotNull
    private final JPanel rightPanel;
    @NotNull
    private final JBSplitter splitter;
    @Nullable
    private JPanel wholePanel;
    @Nullable
    private Configurable selectedConfigurable;
    @NotNull
    private final HashMap<ConfigurationFactory, Configurable> storedComponents;
    @Nullable
    private ToolbarDecorator toolbarDecorator;
    private boolean isFolderCreating;
    @NotNull
    private final MyToolbarAddAction toolbarAddAction;
    private boolean isModified;
    private SingleAlarm changeRunConfigurationNodeAlarm;
    @NotNull
    private final TreeSelectionListener changeRunConfigurationListener;
    @Nullable
    private Runnable dialogUpdateCallback;

    public RunConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.root = new DefaultMutableTreeNode("Root");
        this.treeModel = new MyTreeModel(this.root);
        this.tree = new Tree((TreeModel)this.treeModel);
        this.rightPanel = new JPanel(new BorderLayout());
        this.splitter = new JBSplitter("RunConfigurable.dividerProportion", 0.3f);
        this.storedComponents = new HashMap();
        this.toolbarAddAction = new MyToolbarAddAction();
        this.changeRunConfigurationListener = arg_0 -> RunConfigurable.changeRunConfigurationListener$lambda$0(this, arg_0);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    @NotNull
    public final MyTreeModel getTreeModel() {
        return this.treeModel;
    }

    @NotNull
    public final Tree getTree() {
        return this.tree;
    }

    @Nullable
    protected final ToolbarDecorator getToolbarDecorator() {
        return this.toolbarDecorator;
    }

    protected final void setToolbarDecorator(@Nullable ToolbarDecorator toolbarDecorator) {
        this.toolbarDecorator = toolbarDecorator;
    }

    @NotNull
    protected final MyToolbarAddAction getToolbarAddAction() {
        return this.toolbarAddAction;
    }

    @Nullable
    public final Configurable getSelectedConfigurable() {
        return this.selectedConfigurable;
    }

    public final void setDialogUpdateCallback(@NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.dialogUpdateCallback = callback;
    }

    @NotNull
    public String getDisplayName() {
        String string = ExecutionBundle.message((String)"run.configurable.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected final void initTree() {
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setTransferHandler(new TransferHandler(){

            protected Transferable createTransferable(JComponent component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                JTree jTree = component instanceof JTree ? (JTree)component : null;
                if (jTree == null) {
                    return null;
                }
                JTree tree = jTree;
                TreePath[] treePathArray = tree.getSelectionPaths();
                if (treePathArray == null) {
                    return null;
                }
                TreePath[] selection = treePathArray;
                if (selection.length <= 1) {
                    return null;
                }
                Object[] objectArray = Arrays.copyOf(selection, selection.length);
                return (Transferable)new TransferableList<TreePath>(objectArray){

                    protected String toString(TreePath path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        return path.getLastPathComponent().toString();
                    }
                };
            }

            public int getSourceActions(JComponent c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                return 3;
            }
        });
        TreeUtil.installActions((JTree)((JTree)this.tree));
        TreeSpeedSearch.installOn((JTree)((JTree)this.tree), (boolean)false, arg_0 -> RunConfigurable.initTree$lambda$1(RunConfigurable::initTree$lambda$0, arg_0));
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new RunConfigurableTreeRenderer(this.getRunManager())));
        this.addRunConfigurationsToModel(this.root);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.tree.addTreeSelectionListener(arg_0 -> RunConfigurable.initTree$lambda$2(this, arg_0));
        }
        this.sortTopLevelBranches();
        this.tree.getEmptyText().appendText(ExecutionBundle.message((String)"status.text.no.run.configurations.added", (Object[])new Object[0])).appendLine(ExecutionBundle.message((String)"status.text.add.new", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> RunConfigurable.initTree$lambda$3(this, arg_0));
        String string = KeymapUtil.getShortcutsText((Shortcut[])this.toolbarAddAction.getShortcutSet().getShortcuts());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortcutsText(...)");
        String shortcut = string;
        if (((CharSequence)shortcut).length() > 0) {
            this.tree.getEmptyText().appendText(" " + shortcut);
        }
        this.tree.getAccessibleContext().setAccessibleName(ExecutionBundle.message((String)"run.configuration.tree.accessible.name", (Object[])new Object[0]));
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        ((DefaultTreeModel)treeModel).reload();
    }

    protected final void initTreeSelectionListener(@NotNull Disposable parentDisposable) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            TreeSelectionListener[] treeSelectionListenerArray = this.tree.getTreeSelectionListeners();
            Intrinsics.checkNotNullExpressionValue((Object)treeSelectionListenerArray, (String)"getTreeSelectionListeners(...)");
            Object[] $this$any$iv = treeSelectionListenerArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                TreeSelectionListener it = (TreeSelectionListener)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)this.changeRunConfigurationListener)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        ModalityState modalityState2 = modalityState;
        if (Intrinsics.areEqual((Object)modalityState2, (Object)ModalityState.nonModal())) {
            return;
        }
        this.changeRunConfigurationNodeAlarm = new SingleAlarm(this::selectRunConfiguration, 300, parentDisposable, modalityState2);
        this.tree.addTreeSelectionListener(this.changeRunConfigurationListener);
    }

    private final void selectRunConfiguration() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath != null) {
            Object object = selectionPath.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
            Object userObject = this.getSafeUserObject(node);
            if (userObject instanceof SingleConfigurationConfigurable) {
                this.updateRightPanel((Configurable)((SingleConfigurationConfigurable)((Object)userObject)));
            } else if (userObject instanceof String) {
                this.showFolderField(node, (String)userObject);
            } else if (userObject instanceof ConfigurationFactory || userObject instanceof ConfigurationType) {
                this.typeOrFactorySelected(userObject);
            }
        }
        this.updateDialog();
    }

    protected void typeOrFactorySelected(@NotNull Object userObject) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        if (userObject instanceof ConfigurationType && ((ConfigurationType)userObject).getConfigurationFactories().length == 1) {
            ConfigurationFactory[] configurationFactoryArray = ((ConfigurationType)userObject).getConfigurationFactories();
            Intrinsics.checkNotNullExpressionValue((Object)configurationFactoryArray, (String)"getConfigurationFactories(...)");
            Object object = ArraysKt.first((Object[])configurationFactoryArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            this.showTemplateConfigurable((ConfigurationFactory)object);
        } else if (userObject instanceof ConfigurationFactory) {
            this.showTemplateConfigurable((ConfigurationFactory)userObject);
        } else {
            this.updateRightPanel(null);
        }
    }

    protected void addRunConfigurationsToModel(@NotNull DefaultMutableTreeNode model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
    }

    public final void selectConfigurableOnShow() {
        Application application = ApplicationManager.getApplication();
        Runnable runnable = () -> RunConfigurable.selectConfigurableOnShow$lambda$0(this);
        JPanel jPanel = this.wholePanel;
        Intrinsics.checkNotNull((Object)jPanel);
        application.invokeLater(runnable, ModalityState.stateForComponent((Component)jPanel));
    }

    @Nullable
    protected RunnerAndConfigurationSettings getInitialSelectedConfiguration() {
        return this.getRunManager().getSelectedConfiguration();
    }

    private final boolean selectConfiguration(RunConfiguration configuration) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNode(configuration);
        if (defaultMutableTreeNode == null) {
            return false;
        }
        DefaultMutableTreeNode node = defaultMutableTreeNode;
        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)true, (JTree)((JTree)this.tree));
        return true;
    }

    private final DefaultMutableTreeNode findNode(RunConfiguration configuration) {
        DefaultMutableTreeNode firstNameMatch = null;
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            ConfigurationFactory configurationFactory;
            RunConfiguration cfg;
            TreeNode treeNode = enumeration.nextElement();
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeNode;
            Object userObject = node.getUserObject();
            Intrinsics.checkNotNull((Object)userObject);
            if (RunConfigurable.findNode$extractConfiguration(userObject) == null) continue;
            if (cfg == configuration) {
                return node;
            }
            ConfigurationFactory configurationFactory2 = cfg.getFactory();
            if (!Intrinsics.areEqual((Object)(configurationFactory2 != null && (configurationFactory2 = configurationFactory2.getType()) != null ? configurationFactory2.getId() : null), (configurationFactory = configuration.getFactory()) != null && (configurationFactory = configurationFactory.getType()) != null ? configurationFactory.getId() : null) || !Intrinsics.areEqual((Object)cfg.getName(), (Object)configuration.getName()) || firstNameMatch != null) continue;
            firstNameMatch = node;
        }
        return firstNameMatch;
    }

    private final void showTemplateConfigurable(ConfigurationFactory factory) {
        Configurable configurable = this.storedComponents.get(factory);
        if (configurable == null) {
            configurable = (Configurable)new TemplateConfigurable(this.getRunManager().getConfigurationTemplate(factory));
            ((Map)this.storedComponents).put(factory, configurable);
            ((TemplateConfigurable)configurable).reset();
        }
        this.updateRightPanel(configurable);
    }

    private final void showFolderField(DefaultMutableTreeNode node, @Nls String folderName) {
        this.rightPanel.removeAll();
        ToolbarDecorator toolbarDecorator = this.toolbarDecorator;
        Intrinsics.checkNotNull((Object)toolbarDecorator);
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins " + toolbarDecorator.getActionsPanel().getHeight() + "px 5 0 0, flowx"));
        JTextField textField = new JTextField(folderName);
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(node, textField, this){
            final /* synthetic */ DefaultMutableTreeNode $node;
            final /* synthetic */ JTextField $textField;
            final /* synthetic */ RunConfigurable this$0;
            {
                this.$node = $node;
                this.$textField = $textField;
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$node.setUserObject(this.$textField.getText());
                this.this$0.getTreeModel().reload(this.$node);
            }
        });
        textField.addActionListener(arg_0 -> RunConfigurable.showFolderField$lambda$0(this, arg_0));
        p.add((Component)new JLabel(ExecutionBundle.message((String)"run.configuration.folder.name", (Object[])new Object[0])), "gapright 5");
        p.add((Component)textField, "pushx, growx, wrap");
        p.add((Component)new JLabel(ExecutionBundle.message((String)"run.configuration.rename.folder.disclaimer", (Object[])new Object[0])), "gaptop 5, spanx 2");
        this.rightPanel.add(p);
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
        if (this.isFolderCreating) {
            textField.selectAll();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> RunConfigurable.showFolderField$lambda$1(textField));
        }
    }

    private final Object getSafeUserObject(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
            SingleConfigurationConfigurable<RunConfiguration> singleConfigurationConfigurable = SingleConfigurationConfigurable.editSettings((RunnerAndConfigurationSettings)userObject, null);
            Intrinsics.checkNotNullExpressionValue(singleConfigurationConfigurable, (String)"editSettings(...)");
            SingleConfigurationConfigurable<RunConfiguration> configurationConfigurable = singleConfigurationConfigurable;
            this.installUpdateListeners(configurationConfigurable);
            node.setUserObject(configurationConfigurable);
            return configurationConfigurable;
        }
        Intrinsics.checkNotNull((Object)userObject);
        return userObject;
    }

    public final void updateRightPanel(@Nullable Configurable configurable) {
        this.rightPanel.removeAll();
        this.selectedConfigurable = configurable;
        if (configurable == null) {
            this.rightPanel.repaint();
            return;
        }
        JComponent configurableComponent = !this.project.isDefault() && DumbService.Companion.getInstance(this.project).isDumb() && !this.mayBeEditedInDumbMode(configurable) ? (JComponent)new JBPanelWithEmptyText().withEmptyText(IdeBundle.message((String)"empty.text.this.view.is.not.available.until.indices.are.built", (Object[])new Object[0])) : configurable.createComponent();
        this.rightPanel.add("Center", configurableComponent);
        if (configurable instanceof SingleConfigurationConfigurable) {
            this.rightPanel.add((Component)((SingleConfigurationConfigurable)configurable).getValidationComponent(), "South");
            ApplicationManager.getApplication().invokeLater(() -> RunConfigurable.updateRightPanel$lambda$0(configurable), arg_0 -> RunConfigurable.updateRightPanel$lambda$1(this, arg_0));
        }
        this.setupDialogBounds();
    }

    private final boolean mayBeEditedInDumbMode(Configurable configurable) {
        boolean bl;
        Configurable configurable2 = configurable;
        if (configurable2 instanceof SingleConfigurationConfigurable) {
            Object Config = ((SingleConfigurationConfigurable)configurable).getConfiguration();
            Intrinsics.checkNotNullExpressionValue(Config, (String)"getConfiguration(...)");
            bl = ConfigurationTypeUtil.isEditableInDumbMode(Config);
        } else if (configurable2 instanceof TemplateConfigurable) {
            Object object = ((TemplateConfigurable)configurable).getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSettings(...)");
            bl = ConfigurationTypeUtil.isEditableInDumbMode((RunnerAndConfigurationSettings)((RunnerAndConfigurationSettings)object));
        } else {
            bl = false;
        }
        return bl;
    }

    private final void sortTopLevelBranches() {
        List list = TreeUtil.collectExpandedPaths((JTree)((JTree)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectExpandedPaths(...)");
        List expandedPaths = list;
        TreeUtil.sortRecursively((MutableTreeNode)this.root, (arg_0, arg_1) -> RunConfigurable.sortTopLevelBranches$lambda$1(RunConfigurable::sortTopLevelBranches$lambda$0, arg_0, arg_1));
        TreeUtil.restoreExpandedPaths((JTree)((JTree)this.tree), (List)expandedPaths);
    }

    private final void update() {
        this.updateDialog();
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath != null) {
            Object object = selectionPath.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
            this.treeModel.reload(node);
        }
    }

    private final void installUpdateListeners(SingleConfigurationConfigurable<RunConfiguration> info) {
        Ref.BooleanRef changed = new Ref.BooleanRef();
        info.getEditor().addSettingsEditorListener(arg_0 -> RunConfigurable.installUpdateListeners$lambda$0(this, info, changed, arg_0));
        info.addNameListener((DocumentListener)new DocumentAdapter(changed, this){
            final /* synthetic */ Ref.BooleanRef $changed;
            final /* synthetic */ RunConfigurable this$0;
            {
                this.$changed = $changed;
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$changed.element = true;
                RunConfigurable.access$update(this.this$0);
            }
        });
        info.addSharedListener(arg_0 -> RunConfigurable.installUpdateListeners$lambda$1(changed, this, arg_0));
        info.addValidationListener(arg_0 -> RunConfigurable.installUpdateListeners$lambda$2(this, info, arg_0));
    }

    protected final void drawPressAddButtonMessage(@Nullable ConfigurationType configurationType) {
        JPanel panel2 = new JPanel(new BorderLayout());
        if (!(configurationType instanceof UnknownConfigurationType)) {
            JComponent jComponent = this.createTipPanelAboutAddingNewRunConfiguration(configurationType);
            if (jComponent != null) {
                JComponent it = jComponent;
                boolean bl = false;
                panel2.add((Component)it, "Center");
            }
        }
        this.rightPanel.removeAll();
        this.rightPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)panel2, (boolean)true), "Center");
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
    }

    @Nullable
    protected JComponent createTipPanelAboutAddingNewRunConfiguration(@Nullable ConfigurationType configurationType) {
        return null;
    }

    @NotNull
    protected JComponent createLeftPanel() {
        this.initTree();
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        return jScrollPane;
    }

    @Nullable
    protected final ConfigurationType getSelectedConfigurationType() {
        ConfigurationType configurationType;
        DefaultMutableTreeNode configurationTypeNode;
        DefaultMutableTreeNode defaultMutableTreeNode = configurationTypeNode = this.getSelectedConfigurationTypeNode();
        if (defaultMutableTreeNode != null) {
            Object object = defaultMutableTreeNode.getUserObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.execution.configurations.ConfigurationType");
            configurationType = (ConfigurationType)object;
        } else {
            configurationType = null;
        }
        return configurationType;
    }

    @Nullable
    public JComponent createComponent() {
        BorderLayout borderLayout = new BorderLayout();
        this.wholePanel = (JPanel)new UiDataProvider(this, borderLayout){
            final /* synthetic */ RunConfigurable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                DataKey<RunConfigurationSelector> dataKey = RunConfigurationSelector.KEY;
                Intrinsics.checkNotNullExpressionValue(dataKey, (String)"KEY");
                sink.set(dataKey, arg_0 -> createComponent.1.uiDataSnapshot$lambda$0(this.this$0, arg_0));
                DataKey dataKey2 = CommonDataKeys.PROJECT;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
                sink.set(dataKey2, (Object)this.this$0.getProject());
                DataKey<RunConfigurationCreator> dataKey3 = RunConfigurationCreator.KEY;
                Intrinsics.checkNotNullExpressionValue(dataKey3, (String)"KEY");
                sink.set(dataKey3, (Object)this.this$0);
            }

            private static final void uiDataSnapshot$lambda$0(RunConfigurable this$0, RunConfiguration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RunConfigurable.access$selectConfiguration(this$0, it);
            }
        };
        if (SystemInfo.isMac) {
            AnAction[] anActionArray = new AnAction[]{this.toolbarAddAction};
            DefaultActionGroup touchbarActions = new DefaultActionGroup(anActionArray);
            TouchbarActionCustomizations.setShowText((AnAction)((AnAction)touchbarActions), (boolean)true);
            JPanel jPanel = this.wholePanel;
            Intrinsics.checkNotNull((Object)jPanel);
            Touchbar.setActions((JComponent)jPanel, (ActionGroup)((ActionGroup)touchbarActions));
        }
        JComponent leftPanel = this.createLeftPanel();
        leftPanel.setBorder(IdeBorderFactory.createBorder((int)4));
        this.splitter.setFirstComponent(leftPanel);
        this.splitter.setHonorComponentsMinimumSize(true);
        this.rightPanel.setBorder((Border)JBUI.Borders.empty((int)15, (int)5, (int)0, (int)15));
        this.splitter.setSecondComponent((JComponent)this.rightPanel);
        JPanel jPanel = this.wholePanel;
        Intrinsics.checkNotNull((Object)jPanel);
        jPanel.add((Component)this.splitter, "Center");
        this.updateDialog();
        JPanel jPanel2 = this.wholePanel;
        Intrinsics.checkNotNull((Object)jPanel2);
        Dimension d = jPanel2.getPreferredSize();
        d.width = Math.max(d.width, 800);
        d.height = Math.max(d.height, 600);
        JPanel jPanel3 = this.wholePanel;
        Intrinsics.checkNotNull((Object)jPanel3);
        jPanel3.setPreferredSize(d);
        return this.wholePanel;
    }

    public void reset() {
        this.isModified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        RunManagerImpl manager = this.getRunManager();
        manager.fireBeginUpdate();
        try {
            Object2IntOpenHashMap settingsToOrder = new Object2IntOpenHashMap();
            int order = 0;
            HashSet toDeleteSettings = new HashSet(manager.getAllSettings());
            RunnerAndConfigurationSettings selectedSettings = this.getSelectedSettings();
            int n = this.root.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeNode treeNode = this.root.getChildAt(i);
                Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeNode;
                Object userObject = node.getUserObject();
                if (!(userObject instanceof ConfigurationType)) continue;
                for (RunConfigurationBean bean : this.applyByType(node, (ConfigurationType)userObject, selectedSettings)) {
                    ((Map)settingsToOrder).put(bean.getSettings(), order++);
                    toDeleteSettings.remove(bean.getSettings());
                }
            }
            manager.removeConfigurations(toDeleteSettings);
            Comparator<RunnerAndConfigurationSettings> comparator = Comparator.comparingInt(arg_0 -> RunConfigurable.apply$lambda$0(settingsToOrder, arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparingInt(...)");
            manager.setOrder(comparator, false);
        }
        finally {
            manager.fireEndUpdate();
        }
        this.updateActiveConfigurationFromSelected();
        this.isModified = false;
        this.tree.repaint();
    }

    protected final void applyTemplates() {
        Iterator<Configurable> iterator = this.storedComponents.values().iterator();
        while (iterator.hasNext()) {
            Configurable configurable;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (!configurable.isModified()) continue;
            configurable.apply();
        }
    }

    public void updateActiveConfigurationFromSelected() {
        Configurable selectedConfigurable = this.selectedConfigurable;
        if (selectedConfigurable instanceof SingleConfigurationConfigurable) {
            this.getRunManager().setSelectedConfiguration((RunnerAndConfigurationSettings)((SingleConfigurationConfigurable)selectedConfigurable).getSettings());
        }
    }

    private final List<RunConfigurationBean> applyByType(DefaultMutableTreeNode typeNode, ConfigurationType type, RunnerAndConfigurationSettings selectedSettings) throws ConfigurationException {
        Object node;
        int indexToMove = -1;
        ArrayList<RunConfigurationBean> configurationBeans = new ArrayList<RunConfigurationBean>();
        HashSet<String> names = new HashSet<String>();
        ArrayList configurationNodes = new ArrayList();
        Object object = new RunConfigurableNodeKind[]{RunConfigurableNodeKind.CONFIGURATION, RunConfigurableNodeKind.TEMPORARY_CONFIGURATION};
        Companion.collectNodesRecursively(typeNode, configurationNodes, (RunConfigurableNodeKind[])object);
        Iterator iterator = configurationNodes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            String nameText;
            SingleConfigurationConfigurable<?> configurable;
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            node = (RunConfigurableNodeKind[])e;
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            RunConfigurationBean configurationBean = null;
            RunnerAndConfigurationSettings settings = null;
            if (userObject instanceof SingleConfigurationConfigurable) {
                settings = (RunnerAndConfigurationSettings)((SingleConfigurationConfigurable)((Object)userObject)).getSettings();
                this.applyConfiguration(typeNode, (SingleConfigurationConfigurable)((Object)userObject));
                configurationBean = new RunConfigurationBean((SingleConfigurationConfigurable)((Object)userObject));
            } else if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
                settings = (RunnerAndConfigurationSettings)userObject;
                configurationBean = new RunConfigurationBean(settings);
            }
            if (configurationBean == null) continue;
            SingleConfigurationConfigurable<?> singleConfigurationConfigurable = configurable = configurationBean.getConfigurable();
            String string = nameText = singleConfigurationConfigurable != null ? singleConfigurationConfigurable.getNameText() : configurationBean.getSettings().getName();
            if (!names.add(nameText)) {
                TreeUtil.selectNode((JTree)((JTree)this.tree), (TreeNode)((TreeNode)node));
                Object[] objectArray = new Object[]{type.getDisplayName(), nameText};
                throw new ConfigurationException(ExecutionBundle.message((String)"dialog.message.run.configuration.already.exists", (Object[])objectArray));
            }
            configurationBeans.add(configurationBean);
            if (settings != selectedSettings) continue;
            indexToMove = configurationBeans.size() - 1;
        }
        ArrayList folderNodes = new ArrayList();
        node = new RunConfigurableNodeKind[]{RunConfigurableNodeKind.FOLDER};
        Companion.collectNodesRecursively(typeNode, folderNodes, (RunConfigurableNodeKind[])node);
        names.clear();
        Iterator iterator2 = folderNodes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        node = iterator2;
        while (node.hasNext()) {
            Object e = node.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)e;
            Object object2 = node2.getUserObject();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            String folderName = (String)object2;
            if (((CharSequence)folderName).length() == 0) {
                TreeUtil.selectNode((JTree)((JTree)this.tree), (TreeNode)node2);
                throw new ConfigurationException(ExecutionBundle.message((String)"dialog.message.folder.name.should.not.be.empty", (Object[])new Object[0]));
            }
            if (names.add(folderName)) continue;
            TreeUtil.selectNode((JTree)((JTree)this.tree), (TreeNode)node2);
            Object[] objectArray = new Object[]{folderName};
            throw new ConfigurationException(ExecutionBundle.message((String)"dialog.message.folders.have.same.name", (Object[])objectArray));
        }
        Iterator iterator3 = configurationBeans.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        node = iterator3;
        while (node.hasNext()) {
            Object e = node.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            RunConfigurationBean bean = (RunConfigurationBean)e;
            this.applyConfiguration(typeNode, bean.getConfigurable());
        }
        int shift = 0;
        if (selectedSettings != null && selectedSettings.getType() == type) {
            shift = this.adjustOrder();
        }
        if (shift != 0 && indexToMove != -1) {
            configurationBeans.add(indexToMove - shift, (RunConfigurationBean)configurationBeans.remove(indexToMove));
        }
        return configurationBeans;
    }

    private final DefaultMutableTreeNode getConfigurationTypeNode(ConfigurationType type) {
        int n = this.root.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode = this.root.getChildAt(i);
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeNode;
            if (node.getUserObject() != type) continue;
            return node;
        }
        return null;
    }

    private final void applyConfiguration(DefaultMutableTreeNode typeNode, SingleConfigurationConfigurable<?> configurable) throws ConfigurationException {
        try {
            if (configurable != null && configurable.isModified()) {
                configurable.apply();
            }
        }
        catch (ConfigurationException e) {
            int n = typeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeNode treeNode = typeNode.getChildAt(i);
                Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeNode;
                if (!Intrinsics.areEqual(configurable, (Object)node.getUserObject())) continue;
                TreeUtil.selectNode((JTree)((JTree)this.tree), (TreeNode)node);
                break;
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isModified() {
        if (this.isModified) {
            return true;
        }
        RunManagerImpl runManager = this.getRunManager();
        List<RunnerAndConfigurationSettings> allSettings = runManager.getAllSettings();
        int currentSettingCount = 0;
        int n = this.root.getChildCount();
        for (int i = 0; i < n; ++i) {
            Iterator iterator;
            void $this$filterTo$iv$iv;
            ConfigurationType configurationType;
            TreeNode treeNode = this.root.getChildAt(i);
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode typeNode = (DefaultMutableTreeNode)treeNode;
            RunConfigurableNodeKind[] runConfigurableNodeKindArray = typeNode.getUserObject();
            if ((runConfigurableNodeKindArray instanceof ConfigurationType ? (ConfigurationType)runConfigurableNodeKindArray : null) == null) continue;
            configurationType = configurationType;
            ArrayList configurationNodes = new ArrayList();
            runConfigurableNodeKindArray = new RunConfigurableNodeKind[]{RunConfigurableNodeKind.CONFIGURATION, RunConfigurableNodeKind.TEMPORARY_CONFIGURATION};
            Companion.collectNodesRecursively(typeNode, configurationNodes, runConfigurableNodeKindArray);
            Iterable $this$filter$iv = allSettings;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)configurationType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allTypeSettings = (List)destination$iv$iv;
            if (allTypeSettings.size() != configurationNodes.size()) {
                return true;
            }
            int currentTypeSettingsCount = 0;
            Intrinsics.checkNotNullExpressionValue(configurationNodes.iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                DefaultMutableTreeNode configurationNode = (DefaultMutableTreeNode)e;
                Object userObject = configurationNode.getUserObject();
                RunnerAndConfigurationSettings settings = null;
                if (userObject instanceof SingleConfigurationConfigurable) {
                    if (((SingleConfigurationConfigurable)((Object)userObject)).isModified()) {
                        return true;
                    }
                    Object object = ((SingleConfigurationConfigurable)((Object)userObject)).getSettings();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSettings(...)");
                    settings = (RunnerAndConfigurationSettings)object;
                } else {
                    if (!(userObject instanceof RunnerAndConfigurationSettings)) continue;
                    settings = (RunnerAndConfigurationSettings)userObject;
                }
                ++currentSettingCount;
                int index = currentTypeSettingsCount++;
                if (allTypeSettings.size() > index && allTypeSettings.get(index) == settings) continue;
                return true;
            }
        }
        return allSettings.size() != currentSettingCount || this.isConfigurableModified();
    }

    protected final boolean isConfigurableModified() {
        boolean bl;
        block3: {
            Collection<Configurable> collection = this.storedComponents.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Configurable it = (Configurable)element$iv;
                    boolean bl2 = false;
                    if (!it.isModified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        this.isDisposed = true;
        Collection<Configurable> collection = this.storedComponents.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Configurable it = (Configurable)element$iv;
            boolean bl = false;
            it.disposeUIResources();
        }
        this.storedComponents.clear();
        TreeUtil.treeNodeTraverser((TreeNode)this.root).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(arg_0 -> RunConfigurable.dispose$lambda$2(RunConfigurable::dispose$lambda$1, arg_0));
        this.rightPanel.removeAll();
        this.splitter.dispose();
    }

    private final void updateDialog() {
        block0: {
            Runnable runnable = this.dialogUpdateCallback;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    private final void setupDialogBounds() {
        SwingUtilities.invokeLater(() -> RunConfigurable.setupDialogBounds$lambda$0(this));
    }

    @Nullable
    public final SingleConfigurationConfigurable<RunConfiguration> getSelectedConfiguration() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath != null) {
            Object object = selectionPath.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)object;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof SingleConfigurationConfigurable) {
                return (SingleConfigurationConfigurable)((Object)userObject);
            }
        }
        return null;
    }

    @NotNull
    public RunManagerImpl getRunManager() {
        return RunManagerImpl.Companion.getInstanceImpl(this.project);
    }

    @Nullable
    public String getHelpTopic() {
        Object object = this.getSelectedConfigurationType();
        if (object == null || (object = object.getHelpTopic()) == null) {
            object = "reference.dialogs.rundebug";
        }
        return object;
    }

    private final DefaultMutableTreeNode getSelectedConfigurationTypeNode() {
        DefaultMutableTreeNode node;
        TreePath selectionPath;
        TreePath treePath = selectionPath = this.tree.getSelectionPath();
        if (treePath != null) {
            Object object = treePath.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            v2 = (DefaultMutableTreeNode)object;
        } else {
            v2 = node = null;
        }
        while (node != null) {
            Object userObject = node.getUserObject();
            if (userObject instanceof ConfigurationType) {
                return node;
            }
            TreeNode treeNode = node.getParent();
            node = treeNode instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)treeNode : null;
        }
        return null;
    }

    private final DefaultMutableTreeNode getNode(int row) {
        Object object = this.tree.getPathForRow(row).getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        return (DefaultMutableTreeNode)object;
    }

    @Nullable
    public final Trinity<Integer, Integer, RowsDnDSupport.RefinedDropSupport.Position> getAvailableDropPosition(int direction) {
        int[] rows = this.tree.getSelectionRows();
        if (rows == null || rows.length != 1) {
            return null;
        }
        int oldIndex = rows[0];
        Object object = this.tree.getPathForRow(oldIndex).getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        if (!Companion.getKind((DefaultMutableTreeNode)object).supportsDnD()) {
            return null;
        }
        for (int newIndex = oldIndex + direction; newIndex > 0 && newIndex < this.tree.getRowCount(); newIndex += direction) {
            TreePath targetPath = this.tree.getPathForRow(newIndex);
            Object object2 = targetPath.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            boolean allowInto = Companion.getKind((DefaultMutableTreeNode)object2) == RunConfigurableNodeKind.FOLDER && !this.tree.isExpanded(targetPath);
            RowsDnDSupport.RefinedDropSupport.Position position = allowInto && this.treeModel.isDropInto((JComponent)this.tree, oldIndex, newIndex) ? RowsDnDSupport.RefinedDropSupport.Position.INTO : (direction > 0 ? RowsDnDSupport.RefinedDropSupport.Position.BELOW : RowsDnDSupport.RefinedDropSupport.Position.ABOVE);
            DefaultMutableTreeNode oldNode = this.getNode(oldIndex);
            DefaultMutableTreeNode newNode = this.getNode(newIndex);
            if (oldNode.getParent() != newNode.getParent() && Companion.getKind(newNode) != RunConfigurableNodeKind.FOLDER) {
                RowsDnDSupport.RefinedDropSupport.Position copy = position;
                if (position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                    copy = RowsDnDSupport.RefinedDropSupport.Position.ABOVE;
                } else if (position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                    copy = RowsDnDSupport.RefinedDropSupport.Position.BELOW;
                }
                if (this.treeModel.canDrop(oldIndex, newIndex, copy)) {
                    return Trinity.create((Object)oldIndex, (Object)newIndex, (Object)copy);
                }
            }
            if (this.treeModel.canDrop(oldIndex, newIndex, position)) {
                return Trinity.create((Object)oldIndex, (Object)newIndex, (Object)position);
            }
            if (position == RowsDnDSupport.RefinedDropSupport.Position.BELOW && newIndex < this.tree.getRowCount() - 1 && this.treeModel.canDrop(oldIndex, newIndex + 1, RowsDnDSupport.RefinedDropSupport.Position.ABOVE)) {
                return Trinity.create((Object)oldIndex, (Object)(newIndex + 1), (Object)RowsDnDSupport.RefinedDropSupport.Position.ABOVE);
            }
            if (position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE && newIndex > 1 && this.treeModel.canDrop(oldIndex, newIndex - 1, RowsDnDSupport.RefinedDropSupport.Position.BELOW)) {
                return Trinity.create((Object)oldIndex, (Object)(newIndex - 1), (Object)RowsDnDSupport.RefinedDropSupport.Position.BELOW);
            }
            if (position == RowsDnDSupport.RefinedDropSupport.Position.BELOW && this.treeModel.canDrop(oldIndex, newIndex, RowsDnDSupport.RefinedDropSupport.Position.ABOVE)) {
                return Trinity.create((Object)oldIndex, (Object)newIndex, (Object)RowsDnDSupport.RefinedDropSupport.Position.ABOVE);
            }
            if (position != RowsDnDSupport.RefinedDropSupport.Position.ABOVE || !this.treeModel.canDrop(oldIndex, newIndex, RowsDnDSupport.RefinedDropSupport.Position.BELOW)) continue;
            return Trinity.create((Object)oldIndex, (Object)newIndex, (Object)RowsDnDSupport.RefinedDropSupport.Position.BELOW);
        }
        return null;
    }

    private final SingleConfigurationConfigurable<RunConfiguration> createNewConfiguration(RunnerAndConfigurationSettings settings, DefaultMutableTreeNode node, DefaultMutableTreeNode selectedNode) {
        SingleConfigurationConfigurable<RunConfiguration> singleConfigurationConfigurable = SingleConfigurationConfigurable.editSettings(settings, null);
        Intrinsics.checkNotNullExpressionValue(singleConfigurationConfigurable, (String)"editSettings(...)");
        SingleConfigurationConfigurable<RunConfiguration> configurationConfigurable = singleConfigurationConfigurable;
        this.installUpdateListeners(configurationConfigurable);
        DefaultMutableTreeNode nodeToAdd = new DefaultMutableTreeNode(configurationConfigurable);
        MutableTreeNode mutableTreeNode = nodeToAdd;
        DefaultMutableTreeNode defaultMutableTreeNode = node;
        Intrinsics.checkNotNull((Object)defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = selectedNode;
        this.treeModel.insertNodeInto(mutableTreeNode, defaultMutableTreeNode, defaultMutableTreeNode2 != null ? node.getIndex(defaultMutableTreeNode2) + 1 : node.getChildCount());
        TreeUtil.selectNode((JTree)((JTree)this.tree), (TreeNode)nodeToAdd);
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)configurationConfigurable.getNameTextField(), true);
        configurationConfigurable.getNameTextField().setSelectionStart(0);
        configurationConfigurable.getNameTextField().setSelectionEnd(settings.getName().length());
        return configurationConfigurable;
    }

    @Override
    @NotNull
    public SingleConfigurationConfigurable<RunConfiguration> createNewConfiguration(@NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        ConfigurationType configurationType = factory.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"getType(...)");
        DefaultMutableTreeNode typeNode = this.getConfigurationTypeNode(configurationType);
        if (typeNode == null) {
            typeNode = new DefaultMutableTreeNode(factory.getType());
            this.root.add(typeNode);
            this.sortTopLevelBranches();
            TreeModel treeModel = this.tree.getModel();
            Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
            ((DefaultTreeModel)treeModel).reload();
        }
        TreePath treePath = this.tree.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        DefaultMutableTreeNode selectedNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        DefaultMutableTreeNode node = typeNode;
        if (selectedNode != null && typeNode.isNodeDescendant(selectedNode) && Companion.getKind(node = selectedNode).isConfiguration()) {
            TreeNode treeNode = node.getParent();
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            node = (DefaultMutableTreeNode)treeNode;
        }
        RunnerAndConfigurationSettings settings = this.getRunManager().createConfiguration("", factory);
        RunConfiguration runConfiguration = settings.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
        RunConfiguration configuration = runConfiguration;
        RunConfigurableNodeKind[] runConfigurableNodeKindArray = new RunConfigurableNodeKind[]{RunConfigurableNodeKind.CONFIGURATION, RunConfigurableNodeKind.TEMPORARY_CONFIGURATION};
        configuration.setName(RunConfigurableKt.access$createUniqueName(typeNode, this.suggestName(configuration), runConfigurableNodeKindArray));
        LocatableConfigurationBase locatableConfigurationBase = configuration instanceof LocatableConfigurationBase ? (LocatableConfigurationBase)configuration : null;
        if (locatableConfigurationBase != null) {
            locatableConfigurationBase.setNameChangedByUser(false);
        }
        RunManagerImplKt.callNewConfigurationCreated(factory, configuration);
        RunConfigurationOptionUsagesCollector.logAddNew(this.project, factory.getType().getId(), "RunConfigurationEditor");
        return this.createNewConfiguration(settings, node, selectedNode);
    }

    @Nls
    private final String suggestName(RunConfiguration configuration) {
        String name;
        CharSequence charSequence;
        if (configuration instanceof LocatableConfiguration && !((charSequence = (CharSequence)(name = ((LocatableConfiguration)configuration).suggestedName())) == null || charSequence.length() == 0)) {
            return name;
        }
        return null;
    }

    private final int adjustOrder() {
        RunnerAndConfigurationSettings settings;
        int initialPosition;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return 0;
        }
        TreePath selectionPath = treePath;
        Object object = selectionPath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)object;
        RunnerAndConfigurationSettings selectedSettings = RunConfigurableKt.access$getSettings(treeNode);
        if (selectedSettings == null || selectedSettings.isTemporary()) {
            return 0;
        }
        TreeNode treeNode2 = treeNode.getParent();
        Intrinsics.checkNotNull((Object)treeNode2, (String)"null cannot be cast to non-null type javax.swing.tree.MutableTreeNode");
        MutableTreeNode parent = (MutableTreeNode)treeNode2;
        int position = initialPosition = parent.getIndex(treeNode);
        for (DefaultMutableTreeNode node = treeNode.getPreviousSibling(); node != null && (settings = RunConfigurableKt.access$getSettings(node)) != null && settings.isTemporary(); node = node.getPreviousSibling()) {
            --position;
        }
        int n = initialPosition - position;
        for (int i = 0; i < n; ++i) {
            TreeUtil.moveSelectedRow((JTree)((JTree)this.tree), (int)-1);
        }
        return initialPosition - position;
    }

    private final DefaultMutableTreeNode[] getSelectedNodes() {
        Object[] objectArray = this.tree.getSelectedNodes(DefaultMutableTreeNode.class, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedNodes(...)");
        return (DefaultMutableTreeNode[])objectArray;
    }

    private final DefaultMutableTreeNode getSelectedNode() {
        Object[] objectArray = this.tree.getSelectedNodes(DefaultMutableTreeNode.class, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedNodes(...)");
        return (DefaultMutableTreeNode)ArraysKt.firstOrNull((Object[])objectArray);
    }

    private final RunnerAndConfigurationSettings getSelectedSettings() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        TreePath selectionPath = treePath;
        Object object = selectionPath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        return RunConfigurableKt.access$getSettings((DefaultMutableTreeNode)object);
    }

    private static final void changeRunConfigurationListener$lambda$0(RunConfigurable this$0, TreeSelectionEvent it) {
        SingleAlarm singleAlarm = this$0.changeRunConfigurationNodeAlarm;
        if (singleAlarm == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeRunConfigurationNodeAlarm");
            singleAlarm = null;
        }
        if (singleAlarm.isDisposed()) {
            return;
        }
        SingleAlarm singleAlarm2 = this$0.changeRunConfigurationNodeAlarm;
        if (singleAlarm2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeRunConfigurationNodeAlarm");
            singleAlarm2 = null;
        }
        SingleAlarm.cancelAndRequest$default((SingleAlarm)singleAlarm2, (boolean)false, (int)1, null);
    }

    private static final String initTree$lambda$0(TreePath o) {
        Object object = o.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
        Object userObject = node.getUserObject();
        if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
            return ((RunnerAndConfigurationSettingsImpl)userObject).getName();
        }
        if (userObject instanceof SingleConfigurationConfigurable) {
            return ((SingleConfigurationConfigurable)((Object)userObject)).getNameText();
        }
        if (userObject instanceof ConfigurationType) {
            return ((ConfigurationType)userObject).getDisplayName();
        }
        if (userObject instanceof String) {
            return (String)userObject;
        }
        return o.toString();
    }

    private static final String initTree$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void initTree$lambda$2(RunConfigurable this$0, TreeSelectionEvent it) {
        this$0.selectRunConfiguration();
    }

    private static final void initTree$lambda$3(RunConfigurable this$0, ActionEvent it) {
        MyToolbarAddAction myToolbarAddAction = this$0.toolbarAddAction;
        Object object = it.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.event.MouseEvent");
        myToolbarAddAction.showAddPopup(true, (MouseEvent)object);
    }

    private static final void selectConfigurableOnShow$lambda$0(RunConfigurable this$0) {
        if (this$0.isDisposed) {
            return;
        }
        this$0.tree.requestFocusInWindow();
        RunnerAndConfigurationSettings settings = this$0.getInitialSelectedConfiguration();
        if (settings != null) {
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            if (this$0.selectConfiguration(runConfiguration)) {
                return;
            }
        } else {
            this$0.selectedConfigurable = null;
        }
        this$0.drawPressAddButtonMessage(null);
    }

    private static final RunConfiguration findNode$extractConfiguration(Object $this$findNode_u24extractConfiguration) {
        Object object = $this$findNode_u24extractConfiguration;
        return object instanceof SingleConfigurationConfigurable ? ((SingleConfigurationConfigurable)((Object)$this$findNode_u24extractConfiguration)).getConfiguration() : (object instanceof RunnerAndConfigurationSettings ? ((RunnerAndConfigurationSettings)$this$findNode_u24extractConfiguration).getConfiguration() : null);
    }

    private static final void showFolderField$lambda$0$0(RunConfigurable this$0) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this$0.tree, true);
    }

    private static final void showFolderField$lambda$0(RunConfigurable this$0, ActionEvent it) {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> RunConfigurable.showFolderField$lambda$0$0(this$0));
    }

    private static final void showFolderField$lambda$1(JTextField $textField) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)$textField, true);
    }

    private static final void updateRightPanel$lambda$0(Configurable $configurable) {
        ((SingleConfigurationConfigurable)$configurable).requestToUpdateWarning();
    }

    private static final boolean updateRightPanel$lambda$1(RunConfigurable this$0, Object it) {
        return this$0.isDisposed;
    }

    private static final int sortTopLevelBranches$lambda$0(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
        int n;
        Object userObject1 = o1.getUserObject();
        Object userObject2 = o2.getUserObject();
        if (userObject1 instanceof ConfigurationType && userObject2 instanceof ConfigurationType) {
            String string = ((ConfigurationType)userObject1).getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            String string2 = ((ConfigurationType)userObject2).getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
            n = StringsKt.compareTo((String)string, (String)string2, (boolean)true);
        } else {
            n = 0;
        }
        return n;
    }

    private static final int sortTopLevelBranches$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void installUpdateListeners$lambda$0$0(RunConfigurable this$0, SingleConfigurationConfigurable $info, Ref.BooleanRef $changed, SettingsEditor $editor) {
        this$0.update();
        Object Config = $info.getConfiguration();
        Intrinsics.checkNotNullExpressionValue(Config, (String)"getConfiguration(...)");
        Object configuration = Config;
        if (configuration instanceof LocatableConfiguration && ((LocatableConfiguration)configuration).isGeneratedName() && !$changed.element) {
            try {
                RunConfiguration runConfiguration = ((RunnerAndConfigurationSettings)$editor.getSnapshot()).getConfiguration();
                Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.execution.configurations.LocatableConfiguration");
                LocatableConfiguration snapshot = (LocatableConfiguration)runConfiguration;
                String generatedName = snapshot.suggestedName();
                CharSequence charSequence = generatedName;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    String string;
                    DefaultMutableTreeNode typeNode;
                    DefaultMutableTreeNode currentNode;
                    Object Config2 = $info.getConfiguration();
                    Intrinsics.checkNotNullExpressionValue(Config2, (String)"getConfiguration(...)");
                    DefaultMutableTreeNode defaultMutableTreeNode = currentNode = this$0.findNode((RunConfiguration)Config2);
                    if (defaultMutableTreeNode != null) {
                        DefaultMutableTreeNode it = defaultMutableTreeNode;
                        boolean bl = false;
                        ConfigurationType configurationType = RunConfigurableKt.access$getType(it);
                        Intrinsics.checkNotNull((Object)configurationType);
                        v5 = this$0.getConfigurationTypeNode(configurationType);
                    } else {
                        v5 = typeNode = null;
                    }
                    if (currentNode != null && typeNode != null) {
                        RunConfigurableNodeKind[] runConfigurableNodeKindArray = new RunConfigurableNodeKind[]{RunConfigurableNodeKind.CONFIGURATION, RunConfigurableNodeKind.TEMPORARY_CONFIGURATION};
                        string = RunConfigurableKt.access$createUniqueName(typeNode, currentNode, generatedName, runConfigurableNodeKindArray);
                    } else {
                        string = RunManager.Companion.suggestUniqueName(generatedName, (Collection)CollectionsKt.emptyList());
                    }
                    $info.setNameText(string);
                    $changed.element = false;
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        this$0.setupDialogBounds();
    }

    private static final boolean installUpdateListeners$lambda$0$1(RunConfigurable this$0, Object it) {
        return this$0.isDisposed;
    }

    private static final void installUpdateListeners$lambda$0(RunConfigurable this$0, SingleConfigurationConfigurable $info, Ref.BooleanRef $changed, SettingsEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ApplicationManager.getApplication().invokeLater(() -> RunConfigurable.installUpdateListeners$lambda$0$0(this$0, $info, $changed, editor), arg_0 -> RunConfigurable.installUpdateListeners$lambda$0$1(this$0, arg_0));
    }

    private static final void installUpdateListeners$lambda$1(Ref.BooleanRef $changed, RunConfigurable this$0, ActionEvent it) {
        $changed.element = true;
        this$0.update();
    }

    private static final void installUpdateListeners$lambda$2(RunConfigurable this$0, SingleConfigurationConfigurable $info, ValidationResult it) {
        Object Config = $info.getConfiguration();
        Intrinsics.checkNotNullExpressionValue(Config, (String)"getConfiguration(...)");
        DefaultMutableTreeNode defaultMutableTreeNode = this$0.findNode((RunConfiguration)Config);
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode node = defaultMutableTreeNode;
        this$0.treeModel.nodeChanged(node);
    }

    private static final int apply$lambda$0(Object2IntOpenHashMap $settingsToOrder, RunnerAndConfigurationSettings it) {
        return $settingsToOrder.getInt((Object)it);
    }

    private static final boolean dispose$lambda$1(TreeNode node) {
        block0: {
            DefaultMutableTreeNode defaultMutableTreeNode = node instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)node : null;
            Object object = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
            SingleConfigurationConfigurable singleConfigurationConfigurable = object instanceof SingleConfigurationConfigurable ? (SingleConfigurationConfigurable)((Object)object) : null;
            if (singleConfigurationConfigurable == null) break block0;
            singleConfigurationConfigurable.disposeUIResources();
        }
        return true;
    }

    private static final boolean dispose$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void setupDialogBounds$lambda$0(RunConfigurable this$0) {
        JPanel jPanel = this$0.wholePanel;
        Intrinsics.checkNotNull((Object)jPanel);
        UIUtil.setupEnclosingDialogBounds((JComponent)jPanel);
    }

    public static final /* synthetic */ void access$update(RunConfigurable $this) {
        $this.update();
    }

    public static final /* synthetic */ boolean access$selectConfiguration(RunConfigurable $this, RunConfiguration configuration) {
        return $this.selectConfiguration(configuration);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007J4\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0011J4\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/impl/RunConfigurable$Companion;", "", "<init>", "()V", "collectNodesRecursively", "", "parentNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "nodes", "", "allowed", "", "Lcom/intellij/execution/impl/RunConfigurableNodeKind;", "(Ljavax/swing/tree/DefaultMutableTreeNode;Ljava/util/List;[Lcom/intellij/execution/impl/RunConfigurableNodeKind;)V", "getKind", "node", "isVirtualConfiguration", "", "configurationTypeSorted", "", "Lcom/intellij/execution/configurations/ConfigurationType;", "project", "Lcom/intellij/openapi/project/Project;", "showApplicableTypesOnly", "allTypes", "hideVirtualConfigurations", "getTypesToShow", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nRunConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurable.kt\ncom/intellij/execution/impl/RunConfigurable$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1552:1\n777#2:1553\n873#2,2:1554\n777#2:1556\n873#2:1557\n874#2:1560\n13225#3,2:1558\n*S KotlinDebug\n*F\n+ 1 RunConfigurable.kt\ncom/intellij/execution/impl/RunConfigurable$Companion\n*L\n153#1:1553\n153#1:1554,2\n155#1:1556\n155#1:1557\n155#1:1560\n155#1:1558,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        public final void collectNodesRecursively(@NotNull DefaultMutableTreeNode parentNode, @NotNull List<DefaultMutableTreeNode> nodes, RunConfigurableNodeKind ... allowed) {
            Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            Intrinsics.checkNotNullParameter((Object)allowed, (String)"allowed");
            int n = parentNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeNode treeNode = parentNode.getChildAt(i);
                Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode;
                if (ArrayUtilRt.find((Object[])allowed, (Object)((Object)this.getKind(child))) != -1) {
                    nodes.add(child);
                }
                this.collectNodesRecursively(child, nodes, Arrays.copyOf(allowed, allowed.length));
            }
        }

        @ApiStatus.Internal
        @NotNull
        public final RunConfigurableNodeKind getKind(@Nullable DefaultMutableTreeNode node) {
            RunConfigurableNodeKind runConfigurableNodeKind;
            if (node == null) {
                return RunConfigurableNodeKind.UNKNOWN;
            }
            Object userObject = node.getUserObject();
            if (userObject instanceof SingleConfigurationConfigurable || userObject instanceof RunnerAndConfigurationSettings) {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunConfigurableKt.access$getSettings(node);
                if (runnerAndConfigurationSettings == null) {
                    return RunConfigurableNodeKind.UNKNOWN;
                }
                RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
                runConfigurableNodeKind = settings.isTemporary() ? RunConfigurableNodeKind.TEMPORARY_CONFIGURATION : RunConfigurableNodeKind.CONFIGURATION;
            } else {
                runConfigurableNodeKind = userObject instanceof String ? RunConfigurableNodeKind.FOLDER : (userObject instanceof ConfigurationType ? RunConfigurableNodeKind.CONFIGURATION_TYPE : RunConfigurableNodeKind.UNKNOWN);
            }
            return runConfigurableNodeKind;
        }

        public final boolean isVirtualConfiguration(@Nullable DefaultMutableTreeNode node) {
            boolean bl;
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode = node;
            Object object2 = object = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
            if (object instanceof SingleConfigurationConfigurable || object instanceof RunnerAndConfigurationSettings) {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunConfigurableKt.access$getSettings(node);
                bl = (runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getType() : null) instanceof VirtualConfigurationType;
            } else {
                bl = object instanceof VirtualConfigurationType;
            }
            return bl;
        }

        @NotNull
        public final List<ConfigurationType> configurationTypeSorted(@NotNull Project project, boolean showApplicableTypesOnly, @NotNull List<? extends ConfigurationType> allTypes, boolean hideVirtualConfigurations) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(allTypes, (String)"allTypes");
            return CollectionsKt.sortedWith((Iterable)this.getTypesToShow(project, showApplicableTypesOnly, allTypes, hideVirtualConfigurations), Companion::configurationTypeSorted$lambda$0);
        }

        public static /* synthetic */ List configurationTypeSorted$default(Companion companion, Project project, boolean bl, List list, boolean bl2, int n, Object object) {
            if ((n & 8) != 0) {
                bl2 = false;
            }
            return companion.configurationTypeSorted(project, bl, list, bl2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ConfigurationType> getTypesToShow(@NotNull Project project, boolean showApplicableTypesOnly, @NotNull List<? extends ConfigurationType> allTypes, boolean hideVirtualConfigurations) {
            List allVisibleTypes;
            Iterable destination$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(allTypes, (String)"allTypes");
            if (hideVirtualConfigurations) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = allTypes;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ConfigurationType it = (ConfigurationType)element$iv$iv;
                    boolean bl = false;
                    if (!(!(it instanceof VirtualConfigurationType))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v0 = (List)destination$iv$iv;
            } else {
                v0 = allVisibleTypes = allTypes;
            }
            if (showApplicableTypesOnly) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = allVisibleTypes;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block7: {
                        ConfigurationType configurationType = (ConfigurationType)element$iv$iv;
                        boolean bl2 = false;
                        ConfigurationFactory[] configurationFactoryArray = configurationType.getConfigurationFactories();
                        Intrinsics.checkNotNullExpressionValue((Object)configurationFactoryArray, (String)"getConfigurationFactories(...)");
                        Object[] $this$any$iv = configurationFactoryArray;
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            ConfigurationFactory it = (ConfigurationFactory)element$iv;
                            boolean bl3 = false;
                            if (!it.isApplicable(project)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List applicableTypes = (List)destination$iv$iv2;
                if (!((Collection)applicableTypes).isEmpty() && applicableTypes.size() < allTypes.size() - 3) {
                    return applicableTypes;
                }
            }
            return allVisibleTypes;
        }

        public static /* synthetic */ List getTypesToShow$default(Companion companion, Project project, boolean bl, List list, boolean bl2, int n, Object object) {
            if ((n & 8) != 0) {
                bl2 = false;
            }
            return companion.getTypesToShow(project, bl, list, bl2);
        }

        private static final int configurationTypeSorted$lambda$0(ConfigurationType type1, ConfigurationType type2) {
            ConfigurationType configurationType = type1;
            Intrinsics.checkNotNull((Object)configurationType);
            ConfigurationType configurationType2 = type2;
            Intrinsics.checkNotNull((Object)configurationType2);
            return RunConfigurationListManagerHelperKt.compareTypesForUi(configurationType, configurationType2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/impl/RunConfigurable$MyCopyAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/PossiblyDumbAware;", "<init>", "(Lcom/intellij/execution/impl/RunConfigurable;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isDumbAware", "", "intellij.platform.execution.impl"})
    protected final class MyCopyAction
    extends AnAction
    implements PossiblyDumbAware {
        public MyCopyAction() {
            super(ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Copy));
            AnAction action = ActionManager.getInstance().getAction("EditorDuplicate");
            this.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)RunConfigurable.this.getTree());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            SingleConfigurationConfigurable<RunConfiguration> singleConfigurationConfigurable = RunConfigurable.this.getSelectedConfiguration();
            Intrinsics.checkNotNull(singleConfigurationConfigurable);
            SingleConfigurationConfigurable<RunConfiguration> configuration = singleConfigurationConfigurable;
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = RunConfigurable.this.getSelectedConfigurationTypeNode();
                Intrinsics.checkNotNull((Object)defaultMutableTreeNode);
                DefaultMutableTreeNode typeNode = defaultMutableTreeNode;
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = configuration.createSnapshot(true);
                Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"createSnapshot(...)");
                RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
                RunConfigurableNodeKind[] runConfigurableNodeKindArray = new RunConfigurableNodeKind[]{RunConfigurableNodeKind.CONFIGURATION, RunConfigurableNodeKind.TEMPORARY_CONFIGURATION};
                String copyName = RunConfigurableKt.access$createUniqueName(typeNode, configuration.getNameText(), runConfigurableNodeKindArray);
                RunConfiguration runConfiguration = settings.getConfiguration();
                LocatableConfigurationBase locatableConfigurationBase = runConfiguration instanceof LocatableConfigurationBase ? (LocatableConfigurationBase)runConfiguration : null;
                if (locatableConfigurationBase != null) {
                    locatableConfigurationBase.setNameChangedByUser(true);
                }
                settings.setName(copyName);
                ConfigurationFactory configurationFactory = settings.getFactory();
                Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"getFactory(...)");
                ConfigurationFactory factory = configurationFactory;
                ConfigurationFactoryEx configurationFactoryEx = factory instanceof ConfigurationFactoryEx ? (ConfigurationFactoryEx)factory : null;
                if (configurationFactoryEx != null) {
                    configurationFactoryEx.onConfigurationCopied(settings.getConfiguration());
                }
                RunConfiguration runConfiguration2 = settings.getConfiguration();
                ConfigurationCreationListener configurationCreationListener = runConfiguration2 instanceof ConfigurationCreationListener ? (ConfigurationCreationListener)runConfiguration2 : null;
                if (configurationCreationListener != null) {
                    configurationCreationListener.onConfigurationCopied();
                }
                DefaultMutableTreeNode defaultMutableTreeNode2 = RunConfigurable.this.getSelectedNode();
                TreeNode parentNode = defaultMutableTreeNode2 != null ? defaultMutableTreeNode2.getParent() : null;
                DefaultMutableTreeNode defaultMutableTreeNode3 = parentNode instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)parentNode : null;
                DefaultMutableTreeNode defaultMutableTreeNode4 = (defaultMutableTreeNode3 != null ? defaultMutableTreeNode3.getUserObject() : null) instanceof String ? (DefaultMutableTreeNode)parentNode : typeNode;
                Intrinsics.checkNotNull((Object)defaultMutableTreeNode4, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode node = defaultMutableTreeNode4;
                SingleConfigurationConfigurable configurable = RunConfigurable.this.createNewConfiguration(settings, node, RunConfigurable.this.getSelectedNode());
                configurable.getNameTextField().setSelectionStart(0);
                configurable.getNameTextField().setSelectionEnd(copyName.length());
                RunConfigurationOptionUsagesCollector.logCopy(RunConfigurable.this.getProject(), configurable.getConfiguration().getType().getId(), "RunConfigurationEditor");
            }
            catch (ConfigurationException e2) {
                ToolbarDecorator toolbarDecorator = RunConfigurable.this.getToolbarDecorator();
                Intrinsics.checkNotNull((Object)toolbarDecorator);
                Messages.showErrorDialog((Component)((Component)toolbarDecorator.getActionsPanel()), (String)e2.getMessage(), (String)e2.getTitle());
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            SingleConfigurationConfigurable<RunConfiguration> configuration = RunConfigurable.this.getSelectedConfiguration();
            e.getPresentation().setEnabled(configuration != null && configuration.getConfiguration().getType().isManaged());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isDumbAware() {
            SingleConfigurationConfigurable<RunConfiguration> configuration = RunConfigurable.this.getSelectedConfiguration();
            if (configuration == null) return false;
            RunConfiguration runConfiguration = configuration.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            if (!ConfigurationTypeUtil.isEditableInDumbMode((RunConfiguration)runConfiguration)) return false;
            return true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/impl/RunConfigurable$MyCreateFolderAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/execution/impl/RunConfigurable;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.execution.impl"})
    protected final class MyCreateFolderAction
    extends DumbAwareAction {
        public MyCreateFolderAction() {
            super(ExecutionBundle.message((String)"run.configuration.create.folder.text", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.create.folder.description", (Object[])new Object[0]), AllIcons.Actions.NewFolder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ConfigurationType configurationType = RunConfigurable.this.getSelectedConfigurationType();
            if (configurationType == null) {
                return;
            }
            ConfigurationType type = configurationType;
            DefaultMutableTreeNode[] selectedNodes = RunConfigurable.this.getSelectedNodes();
            DefaultMutableTreeNode defaultMutableTreeNode = RunConfigurable.this.getConfigurationTypeNode(type);
            if (defaultMutableTreeNode == null) {
                return;
            }
            DefaultMutableTreeNode typeNode = defaultMutableTreeNode;
            RunConfigurableNodeKind[] runConfigurableNodeKindArray = new RunConfigurableNodeKind[]{RunConfigurableNodeKind.FOLDER};
            String folderName = RunConfigurableKt.access$createUniqueName(typeNode, ExecutionBundle.message((String)"new.folder", (Object[])new Object[0]), runConfigurableNodeKindArray);
            ArrayList folders = new ArrayList();
            DefaultMutableTreeNode defaultMutableTreeNode2 = RunConfigurable.this.getConfigurationTypeNode(type);
            Intrinsics.checkNotNull((Object)defaultMutableTreeNode2);
            RunConfigurableNodeKind[] runConfigurableNodeKindArray2 = new RunConfigurableNodeKind[]{RunConfigurableNodeKind.FOLDER};
            Companion.collectNodesRecursively(defaultMutableTreeNode2, folders, runConfigurableNodeKindArray2);
            DefaultMutableTreeNode folderNode = new DefaultMutableTreeNode(folderName);
            RunConfigurable.this.getTreeModel().insertNodeInto(folderNode, typeNode, folders.size());
            RunConfigurable.this.isFolderCreating = true;
            try {
                for (DefaultMutableTreeNode node : selectedNodes) {
                    int folderRow = RunConfigurable.this.getTree().getRowForPath(new TreePath(folderNode.getPath()));
                    int rowForPath = RunConfigurable.this.getTree().getRowForPath(new TreePath(node.getPath()));
                    if (!Companion.getKind(node).isConfiguration() || !RunConfigurable.this.getTreeModel().canDrop(rowForPath, folderRow, RowsDnDSupport.RefinedDropSupport.Position.INTO)) continue;
                    RunConfigurable.this.getTreeModel().drop(rowForPath, folderRow, RowsDnDSupport.RefinedDropSupport.Position.INTO);
                }
                RunConfigurable.this.getTree().setSelectionPath(new TreePath(folderNode.getPath()));
            }
            finally {
                RunConfigurable.this.isFolderCreating = false;
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            boolean isEnabled = false;
            boolean toMove = false;
            DefaultMutableTreeNode[] selectedNodes = RunConfigurable.this.getSelectedNodes();
            ConfigurationType selectedType = null;
            for (DefaultMutableTreeNode node : selectedNodes) {
                ConfigurationType type = RunConfigurableKt.access$getType(node);
                if (selectedType == null) {
                    selectedType = type;
                } else if (!Intrinsics.areEqual((Object)type, (Object)selectedType)) {
                    isEnabled = false;
                    break;
                }
                RunConfigurableNodeKind kind = Companion.getKind(node);
                if (kind.isConfiguration() || kind == RunConfigurableNodeKind.CONFIGURATION_TYPE && node.getParent() == RunConfigurable.this.getRoot() || kind == RunConfigurableNodeKind.FOLDER) {
                    isEnabled = true;
                }
                if (!kind.isConfiguration()) continue;
                toMove = true;
            }
            e.getPresentation().setText(toMove ? ExecutionBundle.message((String)"run.configuration.create.folder.description.move", (Object[])new Object[0]) : ExecutionBundle.message((String)"run.configuration.create.folder.text", (Object[])new Object[0]));
            e.getPresentation().setEnabled(isEnabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/impl/RunConfigurable$MyRemoveAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "Lcom/intellij/ui/AnActionButtonUpdater;", "<init>", "(Lcom/intellij/execution/impl/RunConfigurable;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "run", "button", "Lcom/intellij/ui/AnActionButton;", "doRemove", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabled", "", "intellij.platform.execution.impl"})
    protected final class MyRemoveAction
    extends AnAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        public MyRemoveAction() {
            super(ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0]), AllIcons.General.Remove);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)RunConfigurable.this.getTree());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.doRemove();
        }

        public void run(@NotNull AnActionButton button) {
            Intrinsics.checkNotNullParameter((Object)button, (String)"button");
            this.doRemove();
        }

        private final void doRemove() {
            TreePath[] selections = RunConfigurable.this.getTree().getSelectionPaths();
            RunConfigurable.this.getTree().clearSelection();
            int nodeIndexToSelect = -1;
            DefaultMutableTreeNode parentToSelect = null;
            HashSet<DefaultMutableTreeNode> changedParents = new HashSet<DefaultMutableTreeNode>();
            boolean wasRootChanged = false;
            Intrinsics.checkNotNull((Object)selections);
            for (TreePath each : selections) {
                Object object = each.getLastPathComponent();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                TreeNode treeNode = node.getParent();
                Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode;
                RunConfigurableNodeKind kind = Companion.getKind(node);
                if (!kind.isConfiguration() && kind != RunConfigurableNodeKind.FOLDER || Companion.isVirtualConfiguration(node)) continue;
                if (node.getUserObject() instanceof SingleConfigurationConfigurable) {
                    Object object2 = node.getUserObject();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.execution.impl.SingleConfigurationConfigurable<*>");
                    SingleConfigurationConfigurable configurable = (SingleConfigurationConfigurable)((Object)object2);
                    RunConfigurationOptionUsagesCollector.logRemove(RunConfigurable.this.getProject(), configurable.getConfiguration().getType().getId(), "RunConfigurationEditor");
                    configurable.disposeUIResources();
                }
                nodeIndexToSelect = parent.getIndex(node);
                parentToSelect = parent;
                RunConfigurable.this.getTreeModel().removeNodeFromParent(node);
                changedParents.add(parent);
                if (kind == RunConfigurableNodeKind.FOLDER) {
                    Iterator iterator;
                    Iterator i3;
                    ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                    int n = node.getChildCount();
                    for (int i2 = 0; i2 < n; ++i2) {
                        TreeNode treeNode2 = node.getChildAt(i2);
                        Intrinsics.checkNotNull((Object)treeNode2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode2;
                        Object userObject = RunConfigurable.this.getSafeUserObject(child);
                        if (userObject instanceof SingleConfigurationConfigurable) {
                            ((SingleConfigurationConfigurable)((Object)userObject)).setFolderName(null);
                        }
                        children.add(0, child);
                    }
                    int confIndex = 0;
                    int child = parent.getChildCount();
                    for (int i3 = 0; i3 < child; ++i3) {
                        TreeNode treeNode3 = parent.getChildAt(i3);
                        Intrinsics.checkNotNull((Object)treeNode3, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                        if (!Companion.getKind((DefaultMutableTreeNode)treeNode3).isConfiguration()) continue;
                        confIndex = i3;
                        break;
                    }
                    Intrinsics.checkNotNullExpressionValue(children.iterator(), (String)"iterator(...)");
                    while (i3.hasNext()) {
                        Object e = i3.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)e;
                        if (Companion.getKind(child2) != RunConfigurableNodeKind.CONFIGURATION) continue;
                        RunConfigurable.this.getTreeModel().insertNodeInto(child2, parent, confIndex);
                    }
                    confIndex = parent.getChildCount();
                    int child2 = parent.getChildCount();
                    for (int i4 = 0; i4 < child2; ++i4) {
                        TreeNode treeNode4 = parent.getChildAt(i4);
                        Intrinsics.checkNotNull((Object)treeNode4, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                        if (Companion.getKind((DefaultMutableTreeNode)treeNode4) != RunConfigurableNodeKind.TEMPORARY_CONFIGURATION) continue;
                        confIndex = i4;
                        break;
                    }
                    Intrinsics.checkNotNullExpressionValue(children.iterator(), (String)"iterator(...)");
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        DefaultMutableTreeNode child3 = (DefaultMutableTreeNode)e;
                        if (Companion.getKind(child3) != RunConfigurableNodeKind.TEMPORARY_CONFIGURATION) continue;
                        RunConfigurable.this.getTreeModel().insertNodeInto(child3, parent, confIndex);
                    }
                }
                if (parent.getChildCount() != 0 || !(parent.getUserObject() instanceof ConfigurationType)) continue;
                changedParents.remove(parent);
                wasRootChanged = true;
                nodeIndexToSelect = RunConfigurable.this.getRoot().getIndex(parent);
                nodeIndexToSelect = Math.max(0, nodeIndexToSelect - 1);
                parentToSelect = RunConfigurable.this.getRoot();
                parent.removeFromParent();
            }
            if (wasRootChanged) {
                TreeModel treeModel = RunConfigurable.this.getTree().getModel();
                Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
                ((DefaultTreeModel)treeModel).reload();
            } else {
                Iterator iterator = changedParents.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    DefaultMutableTreeNode each = (DefaultMutableTreeNode)e;
                    RunConfigurable.this.getTreeModel().reload(each);
                    RunConfigurable.this.getTree().expandPath(new TreePath(each));
                }
            }
            RunConfigurable.this.selectedConfigurable = null;
            if (RunConfigurable.this.getRoot().getChildCount() == 0) {
                RunConfigurable.this.drawPressAddButtonMessage(null);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = parentToSelect;
                Intrinsics.checkNotNull(defaultMutableTreeNode);
                if (defaultMutableTreeNode.getChildCount() > 0) {
                    TreeNode nodeToSelect = nodeIndexToSelect < parentToSelect.getChildCount() ? parentToSelect.getChildAt(nodeIndexToSelect) : parentToSelect.getChildAt(nodeIndexToSelect - 1);
                    Intrinsics.checkNotNull((Object)nodeToSelect, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                    TreeUtil.selectInTree((DefaultMutableTreeNode)((DefaultMutableTreeNode)nodeToSelect), (boolean)true, (JTree)((JTree)RunConfigurable.this.getTree()));
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(this.isEnabled(e));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            boolean enabled = false;
            TreePath[] selections = RunConfigurable.this.getTree().getSelectionPaths();
            if (selections != null) {
                for (TreePath each : selections) {
                    Object object = each.getLastPathComponent();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                    RunConfigurableNodeKind kind = Companion.getKind(node);
                    if (!kind.isConfiguration() && kind != RunConfigurableNodeKind.FOLDER || Companion.isVirtualConfiguration(node)) continue;
                    enabled = true;
                    break;
                }
            }
            return enabled;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/impl/RunConfigurable$MySaveAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/execution/impl/RunConfigurable;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.execution.impl"})
    protected final class MySaveAction
    extends DumbAwareAction {
        public MySaveAction() {
            super(ExecutionBundle.message((String)"action.name.save.configuration", (Object[])new Object[0]), null, AllIcons.Actions.MenuSaveall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            SingleConfigurationConfigurable<RunConfiguration> configurationConfigurable = RunConfigurable.this.getSelectedConfiguration();
            RunConfigurableKt.access$getLOG$p().assertTrue(configurationConfigurable != null);
            SingleConfigurationConfigurable<RunConfiguration> singleConfigurationConfigurable = configurationConfigurable;
            Intrinsics.checkNotNull(singleConfigurationConfigurable);
            Object object = singleConfigurationConfigurable.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSettings(...)");
            RunnerAndConfigurationSettings originalConfiguration = (RunnerAndConfigurationSettings)object;
            if (originalConfiguration.isTemporary()) {
                RunConfigurable.this.getRunManager().makeStable(originalConfiguration);
                RunConfigurable.this.adjustOrder();
            }
            RunConfigurable.this.getTree().repaint();
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            SingleConfigurationConfigurable<RunConfiguration> configuration = RunConfigurable.this.getSelectedConfiguration();
            e.getPresentation().setEnabledAndVisible(configuration == null ? false : ((RunnerAndConfigurationSettings)configuration.getSettings()).isTemporary());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u00012\u0012\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u00020\u0003`\u00042\u00020\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/impl/RunConfigurable$MySortFolderAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Ljava/util/Comparator;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "Lkotlin/Comparator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "(Lcom/intellij/execution/impl/RunConfigurable;)V", "compare", "", "node1", "node2", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.execution.impl"})
    protected final class MySortFolderAction
    extends AnAction
    implements Comparator<DefaultMutableTreeNode>,
    DumbAware {
        public MySortFolderAction() {
            super(ExecutionBundle.message((String)"run.configuration.sort.folder.text", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.sort.folder.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        @Override
        public int compare(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2) {
            Intrinsics.checkNotNullParameter((Object)node1, (String)"node1");
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node2");
            RunConfigurableNodeKind kind1 = Companion.getKind(node1);
            RunConfigurableNodeKind kind2 = Companion.getKind(node2);
            if (kind1 == RunConfigurableNodeKind.FOLDER) {
                return kind2 == RunConfigurableNodeKind.FOLDER ? node1.getParent().getIndex(node1) - node2.getParent().getIndex(node2) : -1;
            }
            if (kind2 == RunConfigurableNodeKind.FOLDER) {
                return 1;
            }
            Object object = node1.getUserObject();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getUserObject(...)");
            String name1 = RunConfigurableKt.getUserObjectName(object);
            Object object2 = node2.getUserObject();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getUserObject(...)");
            String name2 = RunConfigurableKt.getUserObjectName(object2);
            return WhenMappings.$EnumSwitchMapping$0[kind1.ordinal()] == 1 ? (kind2 == RunConfigurableNodeKind.TEMPORARY_CONFIGURATION ? name1.compareTo(name2) : 1) : (kind2 == RunConfigurableNodeKind.TEMPORARY_CONFIGURATION ? -1 : name1.compareTo(name2));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DefaultMutableTreeNode[] selectedNodes = RunConfigurable.this.getSelectedNodes();
            ArrayList<DefaultMutableTreeNode> foldersToSort = new ArrayList<DefaultMutableTreeNode>();
            for (DefaultMutableTreeNode node : selectedNodes) {
                RunConfigurableNodeKind kind = Companion.getKind(node);
                if (kind != RunConfigurableNodeKind.CONFIGURATION_TYPE && kind != RunConfigurableNodeKind.FOLDER) continue;
                foldersToSort.add(node);
            }
            Iterator iterator = foldersToSort.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Iterator iterator3;
                Object e2 = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                DefaultMutableTreeNode folderNode = (DefaultMutableTreeNode)e2;
                ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                int n = folderNode.getChildCount();
                for (int i = 0; i < n; ++i) {
                    TreeNode treeNode = folderNode.getChildAt(i);
                    Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                    children.add((DefaultMutableTreeNode)treeNode);
                }
                CollectionsKt.sortWith((List)children, (Comparator)this);
                Intrinsics.checkNotNullExpressionValue(children.iterator(), (String)"iterator(...)");
                while (iterator3.hasNext()) {
                    Object e3 = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(e3, (String)"next(...)");
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)e3;
                    folderNode.add(child);
                }
                RunConfigurable.this.getTreeModel().nodeStructureChanged(folderNode);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            for (DefaultMutableTreeNode node : RunConfigurable.this.getSelectedNodes()) {
                RunConfigurableNodeKind kind = Companion.getKind(node);
                if (kind != RunConfigurableNodeKind.CONFIGURATION_TYPE && kind != RunConfigurableNodeKind.FOLDER) continue;
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RunConfigurableNodeKind.values().length];
                try {
                    nArray[RunConfigurableNodeKind.TEMPORARY_CONFIGURATION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/impl/RunConfigurable$MyToolbarAddAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/ui/AnActionButtonRunnable;", "<init>", "(Lcom/intellij/execution/impl/RunConfigurable;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "run", "button", "Lcom/intellij/ui/AnActionButton;", "showAddPopup", "showApplicableTypesOnly", "", "clickEvent", "Ljava/awt/event/MouseEvent;", "intellij.platform.execution.impl"})
    protected final class MyToolbarAddAction
    extends AnAction
    implements AnActionButtonRunnable {
        public MyToolbarAddAction() {
            super(ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]), ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]), AllIcons.General.Add);
            this.registerCustomShortcutSet(CommonShortcuts.getInsert(), (JComponent)RunConfigurable.this.getTree());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.showAddPopup(true, null);
        }

        public void run(@NotNull AnActionButton button) {
            Intrinsics.checkNotNullParameter((Object)button, (String)"button");
            this.showAddPopup(true, null);
        }

        public final void showAddPopup(boolean showApplicableTypesOnly, @Nullable MouseEvent clickEvent) {
            List allTypes = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
            List configurationTypes = CollectionsKt.toMutableList((Collection)Companion.configurationTypeSorted(RunConfigurable.this.getProject(), showApplicableTypesOnly, allTypes, true));
            int hiddenCount = allTypes.size() - configurationTypes.size();
            if (hiddenCount > 0) {
                configurationTypes.add(NewRunConfigurationPopup.HIDDEN_ITEMS_STUB);
            }
            Object[] objectArray = new Object[]{hiddenCount};
            JBPopup jBPopup = NewRunConfigurationPopup.createAddPopup(RunConfigurable.this.getProject(), configurationTypes, ExecutionBundle.message((String)"show.irrelevant.configurations.action.name", (Object[])objectArray), (Consumer<? super ConfigurationFactory>)((Consumer)arg_0 -> MyToolbarAddAction.showAddPopup$lambda$1(arg_0 -> MyToolbarAddAction.showAddPopup$lambda$0(RunConfigurable.this, arg_0), arg_0)), RunConfigurable.this.getSelectedConfigurationType(), () -> MyToolbarAddAction.showAddPopup$lambda$2(this), true);
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createAddPopup(...)");
            JBPopup popup = jBPopup;
            if (clickEvent == null) {
                ToolbarDecorator toolbarDecorator = RunConfigurable.this.getToolbarDecorator();
                Intrinsics.checkNotNull((Object)toolbarDecorator);
                AlignedPopup.showUnderneathWithoutAlignment((JBPopup)popup, (Component)((Component)toolbarDecorator.getActionsPanel()));
            } else {
                PopupUtil.setPopupToggleComponent((JBPopup)popup, (Component)clickEvent.getComponent());
                popup.show(new RelativePoint(clickEvent));
            }
        }

        private static final Unit showAddPopup$lambda$0(RunConfigurable this$0, ConfigurationFactory factory) {
            Intrinsics.checkNotNull((Object)factory);
            this$0.createNewConfiguration(factory);
            return Unit.INSTANCE;
        }

        private static final void showAddPopup$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void showAddPopup$lambda$2(MyToolbarAddAction this$0) {
            this$0.showAddPopup(false, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J \u0010\u001b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0016J\u0014\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/execution/impl/RunConfigurable$MyTreeModel;", "Ljavax/swing/tree/DefaultTreeModel;", "Lcom/intellij/util/ui/EditableModel;", "Lcom/intellij/ui/RowsDnDSupport$RefinedDropSupport;", "root", "Ljavax/swing/tree/TreeNode;", "<init>", "(Lcom/intellij/execution/impl/RunConfigurable;Ljavax/swing/tree/TreeNode;)V", "addRow", "", "removeRow", "index", "", "exchangeRows", "oldIndex", "newIndex", "canExchangeRows", "", "canDrop", "position", "Lcom/intellij/ui/RowsDnDSupport$RefinedDropSupport$Position;", "oldNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "newNode", "isDropInto", "component", "Ljavax/swing/JComponent;", "drop", "insertNodeInto", "newChild", "Ljavax/swing/tree/MutableTreeNode;", "parent", "reload", "node", "getType", "Lcom/intellij/execution/configurations/ConfigurationType;", "treeNode", "intellij.platform.execution.impl"})
    public final class MyTreeModel
    extends DefaultTreeModel
    implements EditableModel,
    RowsDnDSupport.RefinedDropSupport {
        public MyTreeModel(TreeNode root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            super(root);
        }

        public void addRow() {
        }

        public void removeRow(int index) {
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public boolean canDrop(int oldIndex, int newIndex, @NotNull RowsDnDSupport.RefinedDropSupport.Position position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            if (RunConfigurable.this.getTree().getRowCount() <= oldIndex || RunConfigurable.this.getTree().getRowCount() <= newIndex || oldIndex < 0 || newIndex < 0) {
                return false;
            }
            TreePath[] treePathArray = RunConfigurable.this.getTree().getSelectionPaths();
            if (treePathArray == null) {
                return false;
            }
            TreePath[] oldPaths = treePathArray;
            Object object = RunConfigurable.this.getTree().getPathForRow(newIndex).getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)object;
            for (TreePath oldPath : oldPaths) {
                Object object2 = oldPath.getLastPathComponent();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)object2;
                if (oldNode != newNode && this.canDrop(oldNode, newNode, newIndex, position)) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canDrop(@NotNull DefaultMutableTreeNode oldNode, @NotNull DefaultMutableTreeNode newNode, int newIndex, @NotNull RowsDnDSupport.RefinedDropSupport.Position position) {
            Intrinsics.checkNotNullParameter((Object)oldNode, (String)"oldNode");
            Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            TreeNode treeNode = oldNode.getParent();
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode oldParent = (DefaultMutableTreeNode)treeNode;
            TreeNode treeNode2 = newNode.getParent();
            Intrinsics.checkNotNull((Object)treeNode2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode newParent = (DefaultMutableTreeNode)treeNode2;
            RunConfigurableNodeKind oldKind = Companion.getKind(oldNode);
            RunConfigurableNodeKind newKind = Companion.getKind(newNode);
            ConfigurationType oldType = this.getType(oldNode);
            ConfigurationType newType = this.getType(newNode);
            if (oldParent == newParent) {
                if (oldNode.getPreviousSibling() == newNode && position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                    return false;
                }
                if (oldNode.getNextSibling() == newNode && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                    return false;
                }
            }
            if (oldType == null) {
                return false;
            }
            if (oldType != newType) {
                DefaultMutableTreeNode typeNode = RunConfigurable.this.getConfigurationTypeNode(oldType);
                if (Companion.getKind(oldParent) == RunConfigurableNodeKind.FOLDER && typeNode != null && typeNode.getNextSibling() == newNode && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                    return true;
                }
                if (Companion.getKind(oldParent) != RunConfigurableNodeKind.CONFIGURATION_TYPE) return false;
                if (oldKind != RunConfigurableNodeKind.FOLDER) return false;
                if (typeNode == null) return false;
                if (typeNode.getNextSibling() != newNode) return false;
                if (position != RowsDnDSupport.RefinedDropSupport.Position.ABOVE) return false;
                if (oldParent.getLastChild() == oldNode) return false;
                TreeNode treeNode3 = oldParent.getLastChild();
                Intrinsics.checkNotNull((Object)treeNode3, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                if (Companion.getKind((DefaultMutableTreeNode)treeNode3) != RunConfigurableNodeKind.FOLDER) return false;
                return true;
            }
            if (newParent == oldNode) return false;
            if (oldParent == newNode) {
                return false;
            }
            if (oldKind == RunConfigurableNodeKind.FOLDER && newKind != RunConfigurableNodeKind.FOLDER) {
                if (!newKind.isConfiguration()) return false;
                if (position != RowsDnDSupport.RefinedDropSupport.Position.ABOVE) return false;
                if (Companion.getKind(newParent) != RunConfigurableNodeKind.CONFIGURATION_TYPE) return false;
                if (newIndex <= 1) return false;
                Object object = RunConfigurable.this.getTree().getPathForRow(newIndex - 1).getParentPath().getLastPathComponent();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                if (Companion.getKind((DefaultMutableTreeNode)object) != RunConfigurableNodeKind.FOLDER) return false;
                return true;
            }
            if (!oldKind.supportsDnD()) return false;
            if (!newKind.supportsDnD()) {
                return false;
            }
            if (oldKind.isConfiguration() && newKind == RunConfigurableNodeKind.FOLDER && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                return false;
            }
            if (oldKind == RunConfigurableNodeKind.TEMPORARY_CONFIGURATION && newKind == RunConfigurableNodeKind.CONFIGURATION && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                return false;
            }
            if (oldKind == RunConfigurableNodeKind.CONFIGURATION && newKind == RunConfigurableNodeKind.TEMPORARY_CONFIGURATION && position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                return false;
            }
            if (oldKind == RunConfigurableNodeKind.CONFIGURATION && newKind == RunConfigurableNodeKind.TEMPORARY_CONFIGURATION && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                if (newNode.getPreviousSibling() == null) return true;
                if (Companion.getKind(newNode.getPreviousSibling()) == RunConfigurableNodeKind.CONFIGURATION) return true;
                if (Companion.getKind(newNode.getPreviousSibling()) != RunConfigurableNodeKind.FOLDER) return false;
                return true;
            }
            if (oldKind == RunConfigurableNodeKind.TEMPORARY_CONFIGURATION && newKind == RunConfigurableNodeKind.CONFIGURATION && position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                if (newNode.getNextSibling() == null) return true;
                if (Companion.getKind(newNode.getNextSibling()) != RunConfigurableNodeKind.TEMPORARY_CONFIGURATION) return false;
                return true;
            }
            if (oldParent != newParent) return true;
            if (oldKind.isConfiguration() && newKind.isConfiguration()) {
                if (oldKind != newKind) return false;
                return true;
            }
            if (oldKind != RunConfigurableNodeKind.FOLDER) return true;
            if (!RunConfigurable.this.getTree().isExpanded(newIndex)) return true;
            if (position != RowsDnDSupport.RefinedDropSupport.Position.ABOVE) return false;
            return true;
        }

        public boolean isDropInto(@NotNull JComponent component, int oldIndex, int newIndex) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            TreePath treePath = RunConfigurable.this.getTree().getPathForRow(oldIndex);
            if (treePath == null) {
                return false;
            }
            Object object = treePath.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)object;
            TreePath treePath2 = RunConfigurable.this.getTree().getPathForRow(newIndex);
            if (treePath2 == null) {
                return false;
            }
            Object object2 = treePath2.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)object2;
            return Companion.getKind(oldNode).isConfiguration() && Companion.getKind(newNode) == RunConfigurableNodeKind.FOLDER;
        }

        public void drop(int oldIndex, int newIndex, @NotNull RowsDnDSupport.RefinedDropSupport.Position position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            TreePath[] treePathArray = RunConfigurable.this.getTree().getSelectionPaths();
            if (treePathArray == null) {
                return;
            }
            TreePath[] oldPaths = treePathArray;
            Object object = RunConfigurable.this.getTree().getPathForRow(newIndex).getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)object;
            RunConfigurableNodeKind newKind = Companion.getKind(newNode);
            for (TreePath oldPath : oldPaths) {
                Object object2 = oldPath.getLastPathComponent();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)object2;
                TreeNode treeNode = newNode.getParent();
                Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                DefaultMutableTreeNode newParent = (DefaultMutableTreeNode)treeNode;
                RunConfigurableNodeKind oldKind = Companion.getKind(oldNode);
                boolean wasExpanded = RunConfigurable.this.getTree().isExpanded(new TreePath(oldNode.getPath()));
                if (oldKind.isConfiguration() && newKind == RunConfigurableNodeKind.FOLDER) {
                    this.removeNodeFromParent(oldNode);
                    int index = newNode.getChildCount();
                    if (oldKind.isConfiguration()) {
                        int middleIndex = newNode.getChildCount();
                        int n = newNode.getChildCount();
                        for (int i = 0; i < n; ++i) {
                            TreeNode treeNode2 = newNode.getChildAt(i);
                            Intrinsics.checkNotNull((Object)treeNode2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                            if (Companion.getKind((DefaultMutableTreeNode)treeNode2) != RunConfigurableNodeKind.TEMPORARY_CONFIGURATION) continue;
                            middleIndex = i;
                            break;
                        }
                        index = position != RowsDnDSupport.RefinedDropSupport.Position.INTO ? (oldIndex < newIndex ? (oldKind == RunConfigurableNodeKind.CONFIGURATION ? 0 : middleIndex) : (oldKind == RunConfigurableNodeKind.CONFIGURATION ? middleIndex : newNode.getChildCount())) : (oldKind == RunConfigurableNodeKind.TEMPORARY_CONFIGURATION ? newNode.getChildCount() : middleIndex);
                    }
                    this.insertNodeInto(oldNode, newNode, index);
                    RunConfigurable.this.getTree().expandPath(new TreePath(newNode.getPath()));
                } else {
                    ConfigurationType type;
                    Intrinsics.checkNotNull((Object)this.getType(oldNode));
                    this.removeNodeFromParent(oldNode);
                    int index = 0;
                    if (type != this.getType(newParent)) {
                        DefaultMutableTreeNode defaultMutableTreeNode = RunConfigurable.this.getConfigurationTypeNode(type);
                        Intrinsics.checkNotNull((Object)defaultMutableTreeNode);
                        newParent = defaultMutableTreeNode;
                        index = newParent.getChildCount();
                    } else {
                        index = newParent.getIndex(newNode);
                        if (position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                            ++index;
                        }
                    }
                    this.insertNodeInto(oldNode, newParent, index);
                }
                TreePath treePath = new TreePath(oldNode.getPath());
                RunConfigurable.this.getTree().setSelectionPath(treePath);
                if (!wasExpanded) continue;
                RunConfigurable.this.getTree().expandPath(treePath);
            }
        }

        @Override
        public void insertNodeInto(@NotNull MutableTreeNode newChild, @NotNull MutableTreeNode parent, int index) {
            String newFolderName;
            Intrinsics.checkNotNullParameter((Object)newChild, (String)"newChild");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super.insertNodeInto(newChild, parent, index);
            if (!Companion.getKind((DefaultMutableTreeNode)newChild).isConfiguration()) {
                return;
            }
            Object userObject = RunConfigurable.this.getSafeUserObject((DefaultMutableTreeNode)newChild);
            if (Companion.getKind((DefaultMutableTreeNode)parent) == RunConfigurableNodeKind.FOLDER) {
                Object object = ((DefaultMutableTreeNode)parent).getUserObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                v1 = (String)object;
            } else {
                v1 = newFolderName = null;
            }
            if (userObject instanceof SingleConfigurationConfigurable) {
                ((SingleConfigurationConfigurable)((Object)userObject)).setFolderName(newFolderName);
            }
        }

        @Override
        public void reload(@Nullable TreeNode node) {
            super.reload(node);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            if (userObject instanceof String) {
                int n = ((DefaultMutableTreeNode)node).getChildCount();
                for (int i = 0; i < n; ++i) {
                    TreeNode treeNode = ((DefaultMutableTreeNode)node).getChildAt(i);
                    Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                    Object safeUserObject = RunConfigurable.this.getSafeUserObject((DefaultMutableTreeNode)treeNode);
                    if (!(safeUserObject instanceof SingleConfigurationConfigurable)) continue;
                    ((SingleConfigurationConfigurable)((Object)safeUserObject)).setFolderName((String)userObject);
                }
            }
        }

        private final ConfigurationType getType(DefaultMutableTreeNode treeNode) {
            ConfigurationType configurationType;
            Object object = treeNode;
            if (object == null || (object = ((DefaultMutableTreeNode)object).getUserObject()) == null) {
                return null;
            }
            Object userObject = object;
            Object object2 = userObject;
            if (object2 instanceof SingleConfigurationConfigurable) {
                configurationType = ((SingleConfigurationConfigurable)((Object)userObject)).getConfiguration().getType();
            } else if (object2 instanceof RunnerAndConfigurationSettings) {
                configurationType = ((RunnerAndConfigurationSettings)userObject).getType();
            } else if (object2 instanceof ConfigurationType) {
                configurationType = (ConfigurationType)userObject;
            } else if (treeNode.getParent() instanceof DefaultMutableTreeNode) {
                TreeNode treeNode2 = treeNode.getParent();
                Intrinsics.checkNotNull((Object)treeNode2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                configurationType = this.getType((DefaultMutableTreeNode)treeNode2);
            } else {
                configurationType = null;
            }
            return configurationType;
        }
    }
}

