/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.ProjectRunConfigurationConfigurable;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunConfigurableNodeKind;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a5\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a?\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getUserObjectName", "", "userObject", "", "createRunConfigurationConfigurable", "Lcom/intellij/execution/impl/RunConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "createUniqueName", "typeNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "baseName", "kinds", "", "Lcom/intellij/execution/impl/RunConfigurableNodeKind;", "(Ljavax/swing/tree/DefaultMutableTreeNode;Ljava/lang/String;[Lcom/intellij/execution/impl/RunConfigurableNodeKind;)Ljava/lang/String;", "excludeNode", "(Ljavax/swing/tree/DefaultMutableTreeNode;Ljavax/swing/tree/DefaultMutableTreeNode;Ljava/lang/String;[Lcom/intellij/execution/impl/RunConfigurableNodeKind;)Ljava/lang/String;", "getType", "Lcom/intellij/execution/configurations/ConfigurationType;", "_node", "getSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "treeNode", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurable.kt\ncom/intellij/execution/impl/RunConfigurableKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1552:1\n1642#2,10:1553\n1915#2:1563\n1916#2:1565\n1652#2:1566\n1#3:1564\n13#4:1567\n*S KotlinDebug\n*F\n+ 1 RunConfigurable.kt\ncom/intellij/execution/impl/RunConfigurableKt\n*L\n1517#1:1553,10\n1517#1:1563\n1517#1:1565\n1517#1:1566\n1517#1:1564\n63#1:1567\n*E\n"})
public final class RunConfigurableKt {
    @NotNull
    private static final Logger LOG;

    @Nls
    @NotNull
    public static final String getUserObjectName(@NotNull Object userObject) {
        String string;
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        Object object = userObject;
        if (object instanceof ConfigurationType) {
            String string2 = ((ConfigurationType)userObject).getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        } else if (object instanceof ConfigurationFactory) {
            String string3 = ((ConfigurationFactory)userObject).getName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        } else if (object instanceof SingleConfigurationConfigurable) {
            String string4 = ((SingleConfigurationConfigurable)((Object)userObject)).getNameText();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNameText(...)");
        } else {
            string = object instanceof RunnerAndConfigurationSettingsImpl ? ((RunnerAndConfigurationSettingsImpl)userObject).getName() : (object instanceof String ? (String)userObject : userObject.toString());
        }
        return string;
    }

    @NotNull
    public static final RunConfigurable createRunConfigurationConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.isDefault() ? new RunConfigurable(project) : (RunConfigurable)new ProjectRunConfigurationConfigurable(project);
    }

    private static final String createUniqueName(DefaultMutableTreeNode typeNode, @Nls String baseName, RunConfigurableNodeKind ... kinds) {
        return RunConfigurableKt.createUniqueName(typeNode, null, baseName, Arrays.copyOf(kinds, kinds.length));
    }

    /*
     * WARNING - void declaration
     */
    private static final String createUniqueName(DefaultMutableTreeNode typeNode, DefaultMutableTreeNode excludeNode, @Nls String baseName, RunConfigurableNodeKind ... kinds) {
        void $this$mapNotNullTo$iv$iv;
        String string = baseName;
        if (string == null) {
            String string2 = ExecutionBundle.message((String)"run.configuration.unnamed.name.prefix", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        String str = string;
        ArrayList configurationNodes = new ArrayList();
        RunConfigurable.Companion.collectNodesRecursively(typeNode, configurationNodes, Arrays.copyOf(kinds, kinds.length));
        Iterable $this$mapNotNull$iv = configurationNodes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)element$iv$iv;
            boolean bl2 = false;
            Object userObject = node.getUserObject();
            if ((node == excludeNode ? null : (userObject instanceof SingleConfigurationConfigurable ? ((SingleConfigurationConfigurable)((Object)userObject)).getNameText() : (userObject instanceof RunnerAndConfigurationSettingsImpl ? ((RunnerAndConfigurationSettingsImpl)userObject).getName() : (userObject instanceof String ? (String)userObject : null)))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List currentNames = (List)destination$iv$iv;
        return RunManager.Companion.suggestUniqueName(str, (Collection)currentNames);
    }

    private static final ConfigurationType getType(DefaultMutableTreeNode _node) {
        DefaultMutableTreeNode node = _node;
        while (node != null) {
            Object object;
            Object object2 = node.getUserObject();
            ConfigurationType configurationType = object = object2 instanceof ConfigurationType ? (ConfigurationType)object2 : null;
            if (object != null) {
                ConfigurationType it = object;
                boolean bl = false;
                return it;
            }
            object = node.getParent();
            node = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        }
        return null;
    }

    private static final RunnerAndConfigurationSettings getSettings(DefaultMutableTreeNode treeNode) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings;
        if (treeNode == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = null;
        Object object = treeNode.getUserObject();
        if (object instanceof SingleConfigurationConfigurable) {
            Object object2 = treeNode.getUserObject();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.execution.impl.SingleConfigurationConfigurable<*>");
            runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)((SingleConfigurationConfigurable)((Object)object2)).getSettings();
        } else if (object instanceof RunnerAndConfigurationSettings) {
            Object object3 = treeNode.getUserObject();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.execution.RunnerAndConfigurationSettings");
            runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)object3;
        } else {
            runnerAndConfigurationSettings = settings;
        }
        return runnerAndConfigurationSettings;
    }

    public static final /* synthetic */ RunnerAndConfigurationSettings access$getSettings(DefaultMutableTreeNode treeNode) {
        return RunConfigurableKt.getSettings(treeNode);
    }

    public static final /* synthetic */ String access$createUniqueName(DefaultMutableTreeNode typeNode, String baseName, RunConfigurableNodeKind ... kinds) {
        return RunConfigurableKt.createUniqueName(typeNode, baseName, kinds);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ ConfigurationType access$getType(DefaultMutableTreeNode _node) {
        return RunConfigurableKt.getType(_node);
    }

    public static final /* synthetic */ String access$createUniqueName(DefaultMutableTreeNode typeNode, DefaultMutableTreeNode excludeNode, String baseName, RunConfigurableNodeKind ... kinds) {
        return RunConfigurableKt.createUniqueName(typeNode, excludeNode, baseName, kinds);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RunConfigurable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

