/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunConfigurationListManagerHelperKt;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.util.text.NaturalComparator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0017j\b\u0012\u0004\u0012\u00020\t`\u00182\u0006\u0010\u0019\u001a\u00020\u000eJ@\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0017j\b\u0012\u0004\u0012\u00020\t`\u00182\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00132\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0017j\b\u0012\u0004\u0012\u00020\t`\u0018H\u0002J\u0016\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\u0015J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\"J\b\u0010%\u001a\u00020\u0015H\u0002J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\u0013J\b\u0010'\u001a\u00020\u0015H\u0002J\u0006\u0010(\u001a\u00020\u0015J\u001c\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/execution/impl/RunConfigurationListManagerHelper;", "", "manager", "Lcom/intellij/execution/impl/RunManagerImpl;", "<init>", "(Lcom/intellij/execution/impl/RunManagerImpl;)V", "idToSettings", "Ljava/util/LinkedHashMap;", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "Lkotlin/collections/LinkedHashMap;", "customOrder", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "value", "", "isSorted", "setSorted", "(Z)V", "immutableSortedSettingsList", "", "setOrder", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "isApplyAdditionalSortByTypeAndGroup", "compareByTypeAndFolderAndCustomComparator", "folderNames", "updateConfigurationId", "oldId", "newId", "requestSort", "writeOrder", "parent", "Lorg/jdom/Element;", "readCustomOrder", "element", "sortAlphabetically", "buildImmutableSortedSettingsList", "doCustomSort", "afterMakeStable", "checkIfDependenciesAreStable", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "list", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationListManagerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationListManagerHelper.kt\ncom/intellij/execution/impl/RunConfigurationListManagerHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n37#2,2:275\n37#2,2:284\n11795#3:277\n11908#3,4:278\n1342#4,2:282\n1807#5,3:286\n*S KotlinDebug\n*F\n+ 1 RunConfigurationListManagerHelper.kt\ncom/intellij/execution/impl/RunConfigurationListManagerHelper\n*L\n42#1:275,2\n172#1:284,2\n51#1:277\n51#1:278,4\n108#1:282,2\n224#1:286,3\n*E\n"})
public final class RunConfigurationListManagerHelper {
    @NotNull
    private final RunManagerImpl manager;
    @JvmField
    @NotNull
    public final LinkedHashMap<String, RunnerAndConfigurationSettings> idToSettings;
    @NotNull
    private final Object2IntOpenHashMap<String> customOrder;
    private boolean isSorted;
    @JvmField
    @Nullable
    public volatile List<? extends RunnerAndConfigurationSettings> immutableSortedSettingsList;

    public RunConfigurationListManagerHelper(@NotNull RunManagerImpl manager) {
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        this.manager = manager;
        this.idToSettings = new LinkedHashMap();
        this.customOrder = new Object2IntOpenHashMap();
        this.customOrder.defaultReturnValue(-1);
        this.immutableSortedSettingsList = CollectionsKt.emptyList();
    }

    private final void setSorted(boolean value) {
        if (this.isSorted != value) {
            this.isSorted = value;
            if (!value) {
                this.immutableSortedSettingsList = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setOrder(@NotNull Comparator<RunnerAndConfigurationSettings> comparator, boolean isApplyAdditionalSortByTypeAndGroup) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        Object[] objectArray = this.idToSettings.values();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"<get-values>(...)");
        Object[] $this$toTypedArray$iv = objectArray;
        boolean $i$f$toTypedArray = false;
        Object[] thisCollection$iv = $this$toTypedArray$iv;
        Object[] sorted = thisCollection$iv.toArray(new RunnerAndConfigurationSettings[0]);
        if (isApplyAdditionalSortByTypeAndGroup) {
            Collection<RunnerAndConfigurationSettings> collection = this.idToSettings.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            List folderNames = RunConfigurationListManagerHelperKt.access$getSortedFolderNames(collection);
            ArraysKt.sortWith((Object[])sorted, this.compareByTypeAndFolderAndCustomComparator(folderNames, comparator));
        } else {
            ArraysKt.sortWith((Object[])sorted, comparator);
        }
        this.customOrder.clear();
        Object[] $this$mapIndexed$iv = sorted;
        boolean $i$f$mapIndexed = false;
        thisCollection$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void settings;
            int n = index$iv$iv++;
            void var13_14 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.customOrder.put((Object)settings.getUniqueID(), (int)index));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.immutableSortedSettingsList = null;
        this.setSorted(true);
        this.idToSettings.clear();
        for (Object object : sorted) {
            Intrinsics.checkNotNull((Object)object);
            Object settings = object;
            this.idToSettings.put(settings.getUniqueID(), (RunnerAndConfigurationSettings)settings);
        }
    }

    private final Comparator<RunnerAndConfigurationSettings> compareByTypeAndFolderAndCustomComparator(List<String> folderNames, Comparator<RunnerAndConfigurationSettings> comparator) {
        return (arg_0, arg_1) -> RunConfigurationListManagerHelper.compareByTypeAndFolderAndCustomComparator$lambda$0(folderNames, comparator, arg_0, arg_1);
    }

    public final void updateConfigurationId(@NotNull String oldId, @NotNull String newId) {
        Intrinsics.checkNotNullParameter((Object)oldId, (String)"oldId");
        Intrinsics.checkNotNullParameter((Object)newId, (String)"newId");
        if (this.customOrder.containsKey((Object)oldId)) {
            this.customOrder.put((Object)newId, this.customOrder.removeInt((Object)oldId));
        }
    }

    public final void requestSort() {
        this.setSorted(false);
        this.immutableSortedSettingsList = null;
    }

    public final void writeOrder(@NotNull Element parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (this.customOrder.isEmpty()) {
            return;
        }
        Element listElement = new Element("list");
        Collection<RunnerAndConfigurationSettings> collection = this.idToSettings.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Sequence<RunnerAndConfigurationSettings> $this$forEach$iv = RunConfigurationListManagerHelperKt.managedOnly(collection);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
            boolean bl = false;
            listElement.addContent(new Element("item").setAttribute("itemvalue", it.getUniqueID()));
        }
        if (!listElement.isEmpty()) {
            parent.addContent(listElement);
        }
    }

    public final void readCustomOrder(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Element element2 = element.getChild("list");
        if (element2 != null) {
            Element listElement = element2;
            boolean bl = false;
            int order = 0;
            this.customOrder.clear();
            for (Element child : listElement.getChildren("item")) {
                String it;
                if (child.getAttributeValue("itemvalue") == null) continue;
                boolean bl2 = false;
                int n = order;
                order = n + 1;
                this.customOrder.put((Object)it, n);
            }
        }
        this.requestSort();
    }

    private final void sortAlphabetically() {
        if (this.idToSettings.isEmpty()) {
            return;
        }
        Collection<RunnerAndConfigurationSettings> collection = this.idToSettings.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        List folderNames = RunConfigurationListManagerHelperKt.access$getSortedFolderNames(collection);
        Collection<RunnerAndConfigurationSettings> collection2 = this.idToSettings.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        List list = CollectionsKt.sortedWith((Iterable)collection2, this.compareByTypeAndFolderAndCustomComparator(folderNames, RunConfigurationListManagerHelper::sortAlphabetically$lambda$0));
        this.idToSettings.clear();
        for (Object e : list) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)e;
            this.idToSettings.put(settings.getUniqueID(), settings);
        }
    }

    @NotNull
    public final List<RunnerAndConfigurationSettings> buildImmutableSortedSettingsList() {
        List<RunnerAndConfigurationSettings> list = this.immutableSortedSettingsList;
        if (list != null) {
            List<RunnerAndConfigurationSettings> it = list;
            boolean bl = false;
            return it;
        }
        if (this.idToSettings.isEmpty()) {
            this.immutableSortedSettingsList = CollectionsKt.emptyList();
            List<RunnerAndConfigurationSettings> list2 = this.immutableSortedSettingsList;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        if (!this.isSorted) {
            if (this.customOrder.isEmpty()) {
                this.sortAlphabetically();
            } else {
                this.doCustomSort();
            }
        }
        List<RunnerAndConfigurationSettings> result2 = List.copyOf(this.idToSettings.values());
        this.immutableSortedSettingsList = result2;
        Intrinsics.checkNotNull(result2);
        return result2;
    }

    private final void doCustomSort() {
        Collection<RunnerAndConfigurationSettings> collection = this.idToSettings.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<RunnerAndConfigurationSettings> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<RunnerAndConfigurationSettings> thisCollection$iv = $this$toTypedArray$iv;
        Object[] list = thisCollection$iv.toArray(new RunnerAndConfigurationSettings[0]);
        Collection<RunnerAndConfigurationSettings> collection2 = this.idToSettings.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        List folderNames = RunConfigurationListManagerHelperKt.access$getCustomOrderedFolderNames(collection2, (Object2IntMap)this.customOrder);
        ArraysKt.sortWith((Object[])list, this.compareByTypeAndFolderAndCustomComparator(folderNames, (arg_0, arg_1) -> RunConfigurationListManagerHelper.doCustomSort$lambda$0(this, arg_0, arg_1)));
        this.setSorted(true);
        this.idToSettings.clear();
        for (Object object : list) {
            Intrinsics.checkNotNull((Object)object);
            Object settings = object;
            this.idToSettings.put(settings.getUniqueID(), (RunnerAndConfigurationSettings)settings);
        }
    }

    public final void afterMakeStable() {
        this.immutableSortedSettingsList = null;
        if (!this.customOrder.isEmpty()) {
            this.setSorted(false);
        }
    }

    public final void checkIfDependenciesAreStable(@NotNull RunConfiguration configuration, @NotNull List<? extends RunnerAndConfigurationSettings> list) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        for (BeforeRunTask runTask : configuration.getBeforeRunTasks()) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings;
            RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runConfigurableBeforeRunTask = runTask instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask ? (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)runTask : null;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings = runConfigurableBeforeRunTask != null ? runConfigurableBeforeRunTask.getSettings(this.manager) : null;
            boolean bl = runnerAndConfigurationSettings2 != null ? runnerAndConfigurationSettings2.isTemporary() : false;
            if (!bl) continue;
            this.manager.makeStable(runnerAndConfigurationSettings);
            RunConfiguration runConfiguration = runnerAndConfigurationSettings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            this.checkIfDependenciesAreStable(runConfiguration, list);
        }
        if (!(configuration instanceof CompoundRunConfiguration)) {
            return;
        }
        Map<RunConfiguration, ExecutionTarget> children = ((CompoundRunConfiguration)configuration).getConfigurationsWithTargets(this.manager);
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : list) {
            boolean bl;
            RunConfiguration otherConfiguration;
            block6: {
                if (!runnerAndConfigurationSettings.isTemporary()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings.getConfiguration(), (String)"getConfiguration(...)");
                if (otherConfiguration == configuration) continue;
                Iterable $this$any$iv = children.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RunConfiguration it = (RunConfiguration)element$iv;
                        boolean bl2 = false;
                        if (!(it == otherConfiguration)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl || !runnerAndConfigurationSettings.isTemporary()) continue;
            this.manager.makeStable(runnerAndConfigurationSettings);
            this.checkIfDependenciesAreStable(otherConfiguration, list);
        }
    }

    private static final int compareByTypeAndFolderAndCustomComparator$lambda$0(List $folderNames, Comparator $comparator, RunnerAndConfigurationSettings o1, RunnerAndConfigurationSettings o2) {
        int i2;
        int i1;
        ConfigurationType configurationType = o1.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"getType(...)");
        ConfigurationType type1 = configurationType;
        ConfigurationType configurationType2 = o2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType2, (String)"getType(...)");
        ConfigurationType type2 = configurationType2;
        if (type1 != type2) {
            return RunConfigurationListManagerHelperKt.compareTypesForUi(type1, type2);
        }
        if (!Intrinsics.areEqual((Object)o1.getFolderName(), (Object)o2.getFolderName()) && (i1 = $folderNames.indexOf(o1.getFolderName())) != (i2 = $folderNames.indexOf(o2.getFolderName()))) {
            return i1 - i2;
        }
        boolean temporary1 = o1.isTemporary();
        boolean temporary2 = o2.isTemporary();
        return temporary1 == temporary2 ? $comparator.compare(o1, o2) : (temporary1 ? 1 : -1);
    }

    private static final int sortAlphabetically$lambda$0(RunnerAndConfigurationSettings o1, RunnerAndConfigurationSettings o2) {
        return NaturalComparator.INSTANCE.compare(o1.getName(), o2.getName());
    }

    private static final int doCustomSort$lambda$0(RunConfigurationListManagerHelper this$0, RunnerAndConfigurationSettings o1, RunnerAndConfigurationSettings o2) {
        int n;
        int index1 = this$0.customOrder.getInt((Object)o1.getUniqueID());
        int index2 = this$0.customOrder.getInt((Object)o2.getUniqueID());
        if (index1 == -1 && index2 == -1) {
            String string = o1.getName();
            String string2 = o2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            n = string.compareTo(string2);
        } else {
            n = index1 - index2;
        }
        return n;
    }
}

