/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeContentChangedHandler;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.execution.RunConfigurationConverter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.impl.RunConfigurationSchemeManagerKt;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.TemplateDifferenceHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J<\u0010\u0010\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0002J(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/execution/impl/RunConfigurationSchemeManager;", "Lcom/intellij/configurationStore/LazySchemeProcessor;", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "Lcom/intellij/configurationStore/SchemeContentChangedHandler;", "manager", "Lcom/intellij/execution/impl/RunManagerImpl;", "templateDifferenceHelper", "Lcom/intellij/execution/impl/TemplateDifferenceHelper;", "isShared", "", "isWrapSchemeIntoComponentElement", "<init>", "(Lcom/intellij/execution/impl/RunManagerImpl;Lcom/intellij/execution/impl/TemplateDifferenceHelper;ZZ)V", "getSchemeKey", "", "scheme", "createScheme", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "name", "attributeProvider", "Lkotlin/Function1;", "isBundled", "readData", "Lorg/jdom/Element;", "settings", "Ljava/util/function/Function;", "fileNameWithoutExtension", "isExternalizable", "schemeContentChanged", "", "onSchemeAdded", "onSchemeDeleted", "writeScheme", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationSchemeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationSchemeManager.kt\ncom/intellij/execution/impl/RunConfigurationSchemeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,159:1\n812#2,12:160\n1807#2,2:172\n1809#2:177\n82#3,3:174\n*S KotlinDebug\n*F\n+ 1 RunConfigurationSchemeManager.kt\ncom/intellij/execution/impl/RunConfigurationSchemeManager\n*L\n64#1:160,12\n64#1:172,2\n64#1:177\n65#1:174,3\n*E\n"})
public final class RunConfigurationSchemeManager
extends LazySchemeProcessor<RunnerAndConfigurationSettingsImpl, RunnerAndConfigurationSettingsImpl>
implements SchemeContentChangedHandler<RunnerAndConfigurationSettingsImpl> {
    @NotNull
    private final RunManagerImpl manager;
    @NotNull
    private final TemplateDifferenceHelper templateDifferenceHelper;
    private final boolean isShared;
    private final boolean isWrapSchemeIntoComponentElement;

    public RunConfigurationSchemeManager(@NotNull RunManagerImpl manager, @NotNull TemplateDifferenceHelper templateDifferenceHelper, boolean isShared, boolean isWrapSchemeIntoComponentElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        Intrinsics.checkNotNullParameter((Object)templateDifferenceHelper, (String)"templateDifferenceHelper");
        super(null, 1, null);
        this.manager = manager;
        this.templateDifferenceHelper = templateDifferenceHelper;
        this.isShared = isShared;
        this.isWrapSchemeIntoComponentElement = isWrapSchemeIntoComponentElement;
    }

    @NotNull
    public String getSchemeKey(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return this.isShared ? (scheme.getType().isManaged() ? scheme.getName() : scheme.getUniqueID()) : scheme.getType().getId() + "-" + scheme.getName();
    }

    @NotNull
    public RunnerAndConfigurationSettingsImpl createScheme(@NotNull SchemeDataHolder<? super RunnerAndConfigurationSettingsImpl> dataHolder, @NotNull String name, @NotNull Function1<? super String, String> attributeProvider, boolean isBundled) {
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this.manager, null, false, null, 14, null);
        Element element = this.readData(settings, dataHolder);
        this.manager.addConfiguration$intellij_platform_execution_impl(element, settings, false);
        return settings;
    }

    /*
     * WARNING - void declaration
     */
    private final Element readData(RunnerAndConfigurationSettingsImpl settings, SchemeDataHolder<? super RunnerAndConfigurationSettingsImpl> dataHolder) {
        void $this$any$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Element element = null;
        element = dataHolder.read();
        if (this.isShared && Intrinsics.areEqual((Object)element.getName(), (Object)"component")) {
            Element element2 = element.getChild("configuration");
            if (element2 == null) {
                throw new RuntimeException("Unexpected element: " + JDOMUtil.write((Element)element));
            }
            element = element2;
        }
        Iterable $this$filterIsInstance$iv = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RunConfigurationConverter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$any = false;
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            for (Object element$iv : $this$any$iv) {
                Object object;
                RunConfigurationConverter it = (RunConfigurationConverter)element$iv;
                boolean bl = false;
                Logger $this$runAndLogException$iv = RunConfigurationSchemeManagerKt.access$getLOG$p();
                boolean $i$f$runAndLogException = false;
                Logger logger = $this$runAndLogException$iv;
                try {
                    Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)it.convertRunConfigurationOnDemand(element));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Boolean bl4 = (Boolean)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
                if (!(bl4 != null ? bl4 : false)) continue;
                break;
            }
        }
        try {
            RunnerAndConfigurationSettingsImpl.readExternal$default(settings, element, this.isShared, null, 4, null);
        }
        catch (InvalidDataException e) {
            RunConfigurationSchemeManagerKt.access$getLOG$p().error((Throwable)e);
        }
        Element elementAfterStateLoaded = element;
        if (!settings.needsToBeMigrated()) {
            try {
                elementAfterStateLoaded = this.writeScheme(settings);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                RunConfigurationSchemeManagerKt.access$getLOG$p().error("Cannot compute digest for RC using state after load", e);
            }
        }
        dataHolder.updateDigest(elementAfterStateLoaded);
        return element;
    }

    @Nullable
    public String getSchemeKey(@NotNull Function<String, String> attributeProvider, @NotNull String fileNameWithoutExtension) {
        Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        Object name = null;
        name = attributeProvider.apply("name");
        if (Intrinsics.areEqual((Object)name, (Object)"<template>") || name == null) {
            String string = attributeProvider.apply("type");
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (name == null) {
                    name = "<template>";
                }
                name = name + " of type " + it;
            }
        } else if (!this.isShared) {
            String typeId = attributeProvider.apply("type");
            RunConfigurationSchemeManagerKt.access$getLOG$p().assertTrue(typeId != null);
            return typeId + "-" + name;
        }
        return name;
    }

    public boolean isExternalizable(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return true;
    }

    public void schemeContentChanged(@NotNull RunnerAndConfigurationSettingsImpl scheme, @NotNull String name, @NotNull SchemeDataHolder<? super RunnerAndConfigurationSettingsImpl> dataHolder) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        this.readData(scheme, dataHolder);
        this.manager.getEventPublisher$intellij_platform_execution_impl().runConfigurationChanged((RunnerAndConfigurationSettings)scheme);
    }

    public void onSchemeAdded(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
    }

    public void onSchemeDeleted(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        RunManagerImpl.removeConfigurations$default(this.manager, CollectionsKt.listOf((Object)scheme), false, true, 2, null);
    }

    @Nullable
    public Element writeScheme(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        ConfigurationFactory factory;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Element element = super.writeScheme((Scheme)scheme);
        if (element == null) {
            return null;
        }
        Element result2 = element;
        if (this.isShared && this.isWrapSchemeIntoComponentElement) {
            return new Element("component").setAttribute("name", "ProjectRunConfigurationManager").addContent(result2);
        }
        if (scheme.isTemplate() && !Intrinsics.areEqual((Object)(factory = scheme.getFactory()), (Object)UnknownConfigurationType.getInstance()) && !this.templateDifferenceHelper.isTemplateModified(result2, factory)) {
            return null;
        }
        return result2;
    }
}

