/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.multilaunch.design;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.multilaunch.MultiLaunchConfiguration;
import com.intellij.execution.multilaunch.design.ExecutableRow;
import com.intellij.execution.multilaunch.execution.conditions.Condition;
import com.intellij.execution.multilaunch.execution.conditions.ConditionFactory;
import com.intellij.execution.multilaunch.execution.executables.Executable;
import com.intellij.execution.multilaunch.execution.executables.ExecutableFactory;
import com.intellij.execution.multilaunch.state.ConditionSnapshot;
import com.intellij.execution.multilaunch.state.ExecutableRowSnapshot;
import com.intellij.execution.multilaunch.state.ExecutableSnapshot;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/multilaunch/design/ExecutableRowFactory;", "", "<init>", "()V", "create", "Lcom/intellij/execution/multilaunch/design/ExecutableRow;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/intellij/execution/multilaunch/MultiLaunchConfiguration;", "snapshot", "Lcom/intellij/execution/multilaunch/state/ExecutableRowSnapshot;", "intellij.platform.execution.impl"})
public final class ExecutableRowFactory {
    @NotNull
    public static final ExecutableRowFactory INSTANCE = new ExecutableRowFactory();

    private ExecutableRowFactory() {
    }

    @NotNull
    public final ExecutableRow create(@NotNull Project project, @NotNull MultiLaunchConfiguration configuration, @NotNull ExecutableRowSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)snapshot), (String)"snapshot");
        ExecutableSnapshot executableSnapshot = snapshot.getExecutable();
        if (executableSnapshot == null) {
            throw new CantRunException(ExecutionBundle.message((String)"run.configurations.multilaunch.error.missing.stored.executable", (Object[])new Object[0]));
        }
        Executable executable = ExecutableFactory.Companion.getInstance(project).create(configuration, executableSnapshot);
        ConditionSnapshot conditionSnapshot = snapshot.getCondition();
        if (conditionSnapshot == null) {
            throw new CantRunException(ExecutionBundle.message((String)"run.configurations.multilaunch.error.missing.stored.condition", (Object[])new Object[0]));
        }
        Condition condition = ConditionFactory.Companion.getInstance(project).create(conditionSnapshot);
        boolean disableDebugging = snapshot.getDisableDebugging();
        return new ExecutableRow(executable, condition, disableDebugging);
    }
}

