/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.execution.runToolbar.UpdateWidth;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001f\u00a8\u0006$"}, d2={"Lcom/intellij/execution/runToolbar/RunWidgetWidthHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "listeners", "", "Lcom/intellij/execution/runToolbar/UpdateWidth;", "addListener", "", "listener", "removeListener", "value", "", "runConfig", "getRunConfig", "()I", "setRunConfig", "(I)V", "runTarget", "getRunTarget", "arrow", "getArrow", "configWithArrow", "getConfigWithArrow", "runConfigWidth", "Lcom/intellij/util/ui/JBValue$Float;", "getRunConfigWidth", "()Lcom/intellij/util/ui/JBValue$Float;", "setRunConfigWidth", "(Lcom/intellij/util/ui/JBValue$Float;)V", "rightSideWidth", "getRightSideWidth", "setRightSideWidth", "Companion", "intellij.platform.execution.impl"})
@SourceDebugExtension(value={"SMAP\nRunWidgetWidthHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunWidgetWidthHelper.kt\ncom/intellij/execution/runToolbar/RunWidgetWidthHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1915#2,2:72\n*S KotlinDebug\n*F\n+ 1 RunWidgetWidthHelper.kt\ncom/intellij/execution/runToolbar/RunWidgetWidthHelper\n*L\n44#1:72,2\n*E\n"})
public final class RunWidgetWidthHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Project project;
    @NotNull
    private final List<UpdateWidth> listeners;
    private int runConfig;
    @Nullable
    private JBValue.Float runConfigWidth;
    @Nullable
    private JBValue.Float rightSideWidth;
    public static final int RUN_CONFIG_WIDTH_UNSCALED_MIN = 200;
    private static final int RUN_CONFIG_WIDTH_UNSCALED_MAX = 1200;
    private static final int ARROW_WIDTH_UNSCALED = 28;

    public RunWidgetWidthHelper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.listeners = new ArrayList();
        this.runConfig = JBUI.scale((int)200);
    }

    public final void addListener(@NotNull UpdateWidth listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull UpdateWidth listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public final int getRunConfig() {
        return this.runConfig;
    }

    public final void setRunConfig(int value) {
        if (this.runConfig == value) {
            return;
        }
        int min = JBUI.scale((int)200);
        int max = JBUI.scale((int)1200);
        this.runConfig = value > max ? max : (value < min ? min : value);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UpdateWidth it = (UpdateWidth)element$iv;
            boolean bl = false;
            it.updated();
        }
    }

    public final int getRunTarget() {
        return MathKt.roundToInt((double)((double)this.runConfig / 2.5));
    }

    public final int getArrow() {
        return JBUI.scale((int)28);
    }

    public final int getConfigWithArrow() {
        return JBUI.scale((int)28) + this.runConfig;
    }

    @Nullable
    public final JBValue.Float getRunConfigWidth() {
        return this.runConfigWidth;
    }

    public final void setRunConfigWidth(@Nullable JBValue.Float float_) {
        this.runConfigWidth = float_;
    }

    @Nullable
    public final JBValue.Float getRightSideWidth() {
        return this.rightSideWidth;
    }

    public final void setRightSideWidth(@Nullable JBValue.Float float_) {
        this.rightSideWidth = float_;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/runToolbar/RunWidgetWidthHelper$Companion;", "", "<init>", "()V", "RUN_CONFIG_WIDTH_UNSCALED_MIN", "", "RUN_CONFIG_WIDTH_UNSCALED_MAX", "ARROW_WIDTH_UNSCALED", "getInstance", "Lcom/intellij/execution/runToolbar/RunWidgetWidthHelper;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.execution.impl"})
    @SourceDebugExtension(value={"SMAP\nRunWidgetWidthHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunWidgetWidthHelper.kt\ncom/intellij/execution/runToolbar/RunWidgetWidthHelper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,71:1\n30#2,2:72\n*S KotlinDebug\n*F\n+ 1 RunWidgetWidthHelper.kt\ncom/intellij/execution/runToolbar/RunWidgetWidthHelper$Companion\n*L\n19#1:72,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RunWidgetWidthHelper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RunWidgetWidthHelper> serviceClass$iv = RunWidgetWidthHelper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RunWidgetWidthHelper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

